/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.inventory.container.ContainerCrucible;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.tileentity.machine.TileEntityCrucible;
import com.hbm.util.I18nUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class GUICrucible
extends GuiInfoContainer {
    private static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/processing/gui_crucible.png");
    private TileEntityCrucible crucible;

    public GUICrucible(InventoryPlayer invPlayer, TileEntityCrucible tedf) {
        super(new ContainerCrucible(invPlayer, tedf));
        this.crucible = tedf;
        this.field_146999_f = 176;
        this.field_147000_g = 214;
    }

    public void func_73863_a(int x, int y, float interp) {
        super.func_73863_a(x, y, interp);
        super.func_191948_b(x, y);
        this.drawCustomInfoStat(x, y, this.field_147003_i + 125, this.field_147009_r + 80, 34, 7, x, y, new String[]{String.format(Locale.US, "%,d", this.crucible.progress) + " / " + String.format(Locale.US, "%,d", TileEntityCrucible.processTime) + "TU"});
        this.drawCustomInfoStat(x, y, this.field_147003_i + 125, this.field_147009_r + 89, 34, 7, x, y, new String[]{String.format(Locale.US, "%,d", this.crucible.heat) + " / " + String.format(Locale.US, "%,d", TileEntityCrucible.maxHeat) + "TU"});
        this.drawStackInfo(this.crucible.wasteStack, x, y, 16, 16, "gui.crucible.side.smelt");
        this.drawStackInfo(this.crucible.recipeStack, x, y, 61, 16, "gui.crucible.side.alloy");
    }

    protected void func_146979_b(int i, int j) {
        String name = this.crucible.hasCustomInventoryName() ? this.crucible.getInventoryName() : I18n.func_135052_a((String)this.crucible.getInventoryName(), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 6, 0xFFFFFF);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        int hGauge;
        super.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int pGauge = this.crucible.progress * 33 / TileEntityCrucible.processTime;
        if (pGauge > 0) {
            this.func_73729_b(this.field_147003_i + 126, this.field_147009_r + 82, 176, 0, pGauge, 5);
        }
        if ((hGauge = this.crucible.heat * 33 / TileEntityCrucible.maxHeat) > 0) {
            this.func_73729_b(this.field_147003_i + 126, this.field_147009_r + 91, 176, 5, hGauge, 5);
        }
        if (!this.crucible.recipeStack.isEmpty()) {
            this.drawStack(this.crucible.recipeStack, TileEntityCrucible.recipeZCapacity, 62, 97);
        }
        if (!this.crucible.wasteStack.isEmpty()) {
            this.drawStack(this.crucible.wasteStack, TileEntityCrucible.wasteZCapacity, 17, 97);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawStackInfo(List<Mats.MaterialStack> stack, int mouseX, int mouseY, int x, int y, String side) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("\u00a76" + I18nUtil.resolveKey(side, new Object[0]));
        if (stack.isEmpty()) {
            list.add("\u00a7cEmpty");
        } else {
            for (int i = stack.size() - 1; i >= 0; --i) {
                Mats.MaterialStack sta = stack.get(i);
                list.add("\u00a7e" + I18nUtil.resolveKey(sta.material.getTranslationKey(), new Object[0]) + ": " + Mats.formatAmount(sta.amount, Keyboard.isKeyDown((int)42)));
            }
        }
        String[] texts = list.toArray(new String[0]);
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + x, this.field_147009_r + y, 36, 81, mouseX, mouseY, texts);
    }

    protected void drawStack(List<Mats.MaterialStack> stack, int capacity, int x, int y) {
        if (stack.isEmpty()) {
            return;
        }
        int lastHeight = 0;
        int lastQuant = 0;
        for (Mats.MaterialStack sta : stack) {
            int targetHeight = (lastQuant + sta.amount) * 79 / capacity;
            if (lastHeight == targetHeight) continue;
            int offset2 = sta.material.smeltable == NTMMaterial.SmeltingBehavior.ADDITIVE ? 34 : 0;
            int hex = sta.material.moltenColor;
            Color color = new Color(hex);
            GlStateManager.func_179124_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
            this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y - targetHeight, 176 + offset2, 89 - targetHeight, 34, targetHeight - lastHeight);
            lastQuant += sta.amount;
            lastHeight = targetHeight;
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }
}

