/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.gear;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.hbm.blocks.ModBlocks;
import com.hbm.items.armor.ItemArmorMod;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.util.I18nUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")})
public class ItemGasSensor
extends ItemArmorMod
implements IBauble {
    public ItemGasSensor(String s) {
        super(7, true, true, true, true, s);
    }

    @Override
    public void addDesc(List<String> list, ItemStack stack, ItemStack armor) {
        list.add(TextFormatting.YELLOW + "  " + stack.func_82833_r() + " (" + I18nUtil.resolveKey("item.gas_sensor.mod", new Object[0]) + ")");
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (entityIn instanceof EntityLivingBase) {
            EntityLivingBase b = (EntityLivingBase)entityIn;
            this.modUpdate(b, null);
        }
    }

    public static int getGas(World world, int x, int y, int z) {
        for (int i = -2; i < 3; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int k = -2; k < 3; ++k) {
                    Block b = world.func_180495_p(new BlockPos(x + i, y + j, z + k)).func_177230_c();
                    if (b == ModBlocks.gas_radon || b == ModBlocks.gas_radon_dense || b == ModBlocks.gas_radon_tomb) {
                        return 1;
                    }
                    if (b == ModBlocks.gas_explosive) {
                        return 2;
                    }
                    if (b == ModBlocks.gas_flammable) {
                        return 3;
                    }
                    if (b == ModBlocks.gas_monoxide) {
                        return 4;
                    }
                    if (b == ModBlocks.gas_asbestos) {
                        return 5;
                    }
                    if (b != ModBlocks.gas_coal) continue;
                    return 6;
                }
            }
        }
        return -1;
    }

    @Override
    public void modUpdate(EntityLivingBase entity, ItemStack armor) {
        int z;
        int y;
        if (entity.field_70170_p.field_72995_K || entity.field_70170_p.func_82737_E() % 20L != 0L) {
            return;
        }
        int x = (int)Math.floor(entity.field_70165_t);
        int gasType = ItemGasSensor.getGas(entity.field_70170_p, x, y = (int)Math.floor(entity.field_70163_u + (double)entity.func_70047_e() - entity.func_70033_W()), z = (int)Math.floor(entity.field_70161_v));
        if (gasType > 0) {
            switch (gasType) {
                case 1: {
                    Library.warnEntity(entity, HBMSoundHandler.buttonNo, "\u00a72\u00a7l", "chat.gas_sensor.rad", 2.0f, 0.5f);
                    break;
                }
                case 2: {
                    Library.warnEntity(entity, HBMSoundHandler.follyAquired, "\u00a7c\u00a7l", "chat.gas_sensor.explosive", 1.25f, 1.0f);
                    break;
                }
                case 3: {
                    Library.warnEntity(entity, HBMSoundHandler.follyAquired, "\u00a76\u00a7l", "chat.gas_sensor.flammable", 1.0f, 0.5f);
                    break;
                }
                case 4: {
                    Library.warnEntity(entity, HBMSoundHandler.techBoop, "\u00a77\u00a7l", "chat.gas_sensor.mono", 1.5f, 1.5f);
                    break;
                }
                case 5: {
                    Library.warnEntity(entity, HBMSoundHandler.techBoop, "\u00a7f\u00a7l", "chat.gas_sensor.asbestos", 1.25f, 1.25f);
                    break;
                }
                case 6: {
                    Library.warnEntity(entity, HBMSoundHandler.techBoop, "\u00a70\u00a7l", "chat.gas_sensor.coal", 1.0f, 1.0f);
                }
            }
        }
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.TRINKET;
    }

    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        this.func_77663_a(itemstack, player.field_70170_p, (Entity)player, 0, true);
    }
}

