/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.machine;

import com.hbm.inventory.AssemblerRecipes;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import com.hbm.util.I18nUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemAssemblyTemplate
extends Item {
    public static final ModelResourceLocation location = new ModelResourceLocation("hbm:assembly_template", "inventory");

    public ItemAssemblyTemplate(String s) {
        this.func_77655_b(s);
        this.setRegistryName(s);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(MainRegistry.templateTab);
        ModItems.ALL_ITEMS.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        String s1;
        String s = ("" + I18n.func_135052_a((String)(this.func_77658_a() + ".name"), (Object[])new Object[0])).trim();
        int damage = ItemAssemblyTemplate.getTagWithRecipeNumber(stack).func_74762_e("type");
        ItemStack out = damage < AssemblerRecipes.recipeList.size() ? AssemblerRecipes.recipeList.get(damage).toStack() : ItemStack.field_190927_a;
        String string = s1 = out != null ? out.func_82833_r() : "ERROR";
        if (s1 != null) {
            s = s + " " + s1;
        }
        return s;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == this.func_77640_w() || tab == CreativeTabs.field_78027_g) {
            int count = AssemblerRecipes.recipeList.size();
            for (int i = 0; i < count; ++i) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("type", i);
                ItemStack stack = new ItemStack((Item)this, 1, 0);
                stack.func_77982_d(tag);
                list.add((Object)stack);
            }
        }
    }

    public static ItemStack getTemplate(int id) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("type", id);
        ItemStack stack = new ItemStack(ModItems.assembly_template, 1, 0);
        stack.func_77982_d(tag);
        return stack;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        if (!(stack.func_77973_b() instanceof ItemAssemblyTemplate)) {
            return;
        }
        list.add("\u00a76" + I18nUtil.resolveKey("info.templatefolder", new Object[0]));
        list.add("");
        int i = ItemAssemblyTemplate.getTagWithRecipeNumber(stack).func_74762_e("type");
        if (i < 0 || i >= AssemblerRecipes.recipeList.size()) {
            list.add("I AM ERROR");
            return;
        }
        RecipesCommon.ComparableStack out = AssemblerRecipes.recipeList.get(i);
        if (out == null) {
            list.add("I AM ERROR");
            return;
        }
        Object[] in = AssemblerRecipes.recipes.get(out);
        if (in == null) {
            list.add("I AM ERROR");
            return;
        }
        ItemStack output = out.toStack();
        list.add("\u00a7l" + I18nUtil.resolveKey("info.template_out", new Object[0]));
        list.add(" \u00a7a" + output.func_190916_E() + "x " + output.func_82833_r());
        list.add("\u00a7l" + I18nUtil.resolveKey("info.template_in_p", new Object[0]));
        for (Object o : in) {
            Object input;
            if (o instanceof RecipesCommon.ComparableStack) {
                input = ((RecipesCommon.ComparableStack)o).toStack();
                list.add(" \u00a7c" + input.func_190916_E() + "x " + input.func_82833_r());
                continue;
            }
            if (!(o instanceof RecipesCommon.OreDictStack)) continue;
            input = (RecipesCommon.OreDictStack)o;
            NonNullList ores = OreDictionary.getOres((String)((RecipesCommon.OreDictStack)input).name);
            if (!ores.isEmpty()) {
                ItemStack inStack = (ItemStack)ores.get((int)(Math.abs(System.currentTimeMillis() / 1000L) % (long)ores.size()));
                list.add(" \u00a7c" + ((RecipesCommon.AStack)input).count() + "x " + inStack.func_82833_r());
                continue;
            }
            list.add("I AM ERROR - No OrdDict match found for " + o);
        }
        list.add("\u00a7l" + I18nUtil.resolveKey("info.template_time", new Object[0]));
        list.add(" \u00a73" + Math.floor((float)ItemAssemblyTemplate.getProcessTime(stack) / 20.0f * 100.0f) / 100.0 + " " + I18nUtil.resolveKey("info.template_seconds", new Object[0]));
    }

    public static int getProcessTime(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemAssemblyTemplate)) {
            return 100;
        }
        int i = ItemAssemblyTemplate.getTagWithRecipeNumber(stack).func_74762_e("type");
        if (i < 0 || i >= AssemblerRecipes.recipeList.size()) {
            return 100;
        }
        RecipesCommon.ComparableStack out = AssemblerRecipes.recipeList.get(i);
        Integer time = AssemblerRecipes.time.get(out);
        if (time != null) {
            return time;
        }
        return 100;
    }

    public static int getRecipeIndex(ItemStack stack) {
        return ItemAssemblyTemplate.getTagWithRecipeNumber(stack).func_74762_e("type");
    }

    public static NBTTagCompound getTagWithRecipeNumber(@Nonnull ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74768_a("type", 0);
        }
        return stack.func_77978_p();
    }
}

