/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.machine;

import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemRBMKPellet;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.machine.rbmk.IRBMKFluxReceiver;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.util.I18nUtil;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemRBMKRod
extends Item {
    public static final double xe135HalflifeMulPerTick = 0.9999241662036941;
    public ItemRBMKPellet pellet;
    public String fullName = "";
    public double reactivity;
    public double selfRate;
    public double archLength = 1000.0;
    public EnumBurnFunc function = EnumBurnFunc.LOG_TEN;
    public EnumDepleteFunc depFunc = EnumDepleteFunc.GENTLE_SLOPE;
    public double xGen = 0.5;
    public double xBurn = 50.0;
    public double heat = 1.0;
    public double yield;
    public double meltingPoint = 1000.0;
    public double diffusion = 0.02;
    public IRBMKFluxReceiver.NType nType = IRBMKFluxReceiver.NType.SLOW;
    public IRBMKFluxReceiver.NType rType = IRBMKFluxReceiver.NType.FAST;
    public float fuelR = 0.105f;
    public float fuelG = 0.247f;
    public float fuelB = 0.015f;
    public float cherenkovR = 0.4f;
    public float cherenkovG = 0.9f;
    public float cherenkovB = 1.0f;

    public ItemRBMKRod(ItemRBMKPellet pellet, String s) {
        this(pellet.fullName, s);
        this.pellet = pellet;
    }

    public ItemRBMKRod(String fullName, String s) {
        this.func_77655_b(s);
        this.setRegistryName(s);
        this.fullName = fullName;
        this.func_77642_a(ModItems.rbmk_fuel_empty);
        this.func_77625_d(1);
        this.func_77637_a(MainRegistry.controlTab);
        ModItems.ALL_ITEMS.add(this);
    }

    public ItemRBMKRod setYield(double yield) {
        this.yield = yield;
        return this;
    }

    public ItemRBMKRod setStats(double funcEnd) {
        return this.setStats(funcEnd, 0.0);
    }

    public ItemRBMKRod setStats(double funcEnd, double selfRate) {
        this.reactivity = funcEnd;
        this.selfRate = selfRate;
        return this;
    }

    public ItemRBMKRod setStats(double funcEnd, double selfRate, double archLength) {
        this.reactivity = funcEnd;
        this.selfRate = selfRate;
        this.archLength = archLength;
        return this;
    }

    public ItemRBMKRod setFunction(EnumBurnFunc func) {
        this.function = func;
        return this;
    }

    public ItemRBMKRod setDepletionFunction(EnumDepleteFunc func) {
        this.depFunc = func;
        return this;
    }

    public ItemRBMKRod setXenon(double gen, double burn) {
        this.xGen = gen;
        this.xBurn = burn;
        return this;
    }

    public ItemRBMKRod setHeat(double heat) {
        this.heat = heat;
        return this;
    }

    public ItemRBMKRod setDiffusion(double diffusion) {
        this.diffusion = diffusion;
        return this;
    }

    public ItemRBMKRod setMeltingPoint(double meltingPoint) {
        this.meltingPoint = meltingPoint;
        return this;
    }

    public ItemRBMKRod setNeutronTypes(IRBMKFluxReceiver.NType nType, IRBMKFluxReceiver.NType rType) {
        this.nType = nType;
        this.rType = rType;
        return this;
    }

    public ItemRBMKRod setFuelColor(float R, float G, float B) {
        this.fuelR = R;
        this.fuelG = G;
        this.fuelB = B;
        return this;
    }

    public ItemRBMKRod setCherenkovColor(float R, float G, float B) {
        this.cherenkovR = R;
        this.cherenkovG = G;
        this.cherenkovB = B;
        return this;
    }

    public double burn(World world, ItemStack stack, double inFlux) {
        double xenon = ItemRBMKRod.getPoison(stack) * 0.9999241662036941;
        xenon -= this.xenonBurnFunc(inFlux += this.selfRate);
        if ((xenon += this.xenonGenFunc(inFlux *= 1.0 - ItemRBMKRod.getPoisonLevel(stack))) < 0.0) {
            xenon = 0.0;
        }
        if (xenon > 100.0) {
            xenon = 100.0;
        }
        ItemRBMKRod.setPoison(stack, xenon);
        double outFlux = this.reactivityFunc(inFlux, ItemRBMKRod.getEnrichment(stack)) * RBMKDials.getReactivityMod(world);
        double y = ItemRBMKRod.getYield(stack);
        y -= inFlux;
        if (y < 0.0) {
            y = 0.0;
        }
        ItemRBMKRod.setYield(stack, y);
        double coreHeat = ItemRBMKRod.getCoreHeat(stack);
        ItemRBMKRod.setCoreHeat(stack, coreHeat += outFlux * this.heat);
        return outFlux;
    }

    public static double getMeltdownFactor(double meltdownPercent) {
        if (meltdownPercent == 0.0) {
            return 1.0;
        }
        return 1.0 - 0.3 * (meltdownPercent / 100.0);
    }

    public void updateHeat(World world, ItemStack stack, double mod) {
        double coreHeat = ItemRBMKRod.getCoreHeat(stack);
        double hullHeat = ItemRBMKRod.getHullHeat(stack);
        double meltdownPercent = ItemRBMKRod.getMeltdownPercent(stack);
        if (hullHeat > this.meltingPoint) {
            ItemRBMKRod.setMeltdownPercent(stack, meltdownPercent += 0.05 * hullHeat / this.meltingPoint);
        }
        if (coreHeat > hullHeat) {
            double mid = (coreHeat - hullHeat) / 2.0;
            double heatTransfer = mid * this.diffusion * RBMKDials.getFuelDiffusionMod(world) * mod;
            ItemRBMKRod.setCoreHeat(stack, coreHeat -= heatTransfer * ItemRBMKRod.getMeltdownFactor(meltdownPercent));
            ItemRBMKRod.setHullHeat(stack, hullHeat += heatTransfer);
        }
    }

    public double provideHeat(World world, ItemStack stack, double heat, double mod) {
        double hullHeat = ItemRBMKRod.getHullHeat(stack);
        if (ItemRBMKRod.getMeltdownPercent(stack) >= 100.0) {
            ItemRBMKRod.setMeltdownPercent(stack, 100.0);
            double coreHeat = ItemRBMKRod.getCoreHeat(stack);
            double avg = (heat + hullHeat + coreHeat) / 3.0;
            ItemRBMKRod.setCoreHeat(stack, avg);
            ItemRBMKRod.setHullHeat(stack, avg);
            return avg;
        }
        if (hullHeat <= heat) {
            return 0.0;
        }
        double ret = (hullHeat - heat) / 2.0;
        ItemRBMKRod.setHullHeat(stack, hullHeat -= (ret *= RBMKDials.getFuelHeatProvision(world) * mod));
        return ret;
    }

    public double reactivityFunc(double in, double enrichment) {
        double flux = in * this.reactivityModByEnrichment(enrichment);
        switch (this.function) {
            case PASSIVE: {
                return this.selfRate * enrichment;
            }
            case LOG_TEN: {
                return Math.log10(flux + 1.0) * this.reactivity;
            }
            case PLATEU: {
                return (1.0 - Math.pow(Math.E, -flux / 25.0)) * this.reactivity;
            }
            case ARCH: {
                return Math.max((flux - flux * flux / this.archLength) * this.reactivity, 0.0);
            }
            case SIGMOID: {
                return this.reactivity / (1.0 + Math.pow(Math.E, -0.1 * flux + 5.0));
            }
            case SQUARE_ROOT: {
                return Math.sqrt(flux) * this.reactivity;
            }
            case LINEAR: {
                return flux * this.reactivity;
            }
            case QUADRATIC: {
                return flux * flux * this.reactivity;
            }
            case EXPERIMENTAL: {
                return flux * (Math.sin(flux) + 1.0) * this.reactivity;
            }
        }
        return 0.0;
    }

    public String getFuncDescription(ItemStack stack) {
        String string;
        switch (this.function) {
            case PASSIVE: {
                string = TextFormatting.RED + "" + this.selfRate;
                break;
            }
            case LOG_TEN: {
                string = "log10(%1$s + 1) * %2$s";
                break;
            }
            case PLATEU: {
                string = "(1 - e^(-%1$s / 25)) * %2$s";
                break;
            }
            case ARCH: {
                string = "(%1$s - %1$s\u00b2 / " + this.archLength + ") * %2$s";
                break;
            }
            case SIGMOID: {
                string = "%2$s / (1 + e^(-0.1 * %1$s + 5)";
                break;
            }
            case SQUARE_ROOT: {
                string = "sqrt(%1$s) * %2$s";
                break;
            }
            case LINEAR: {
                string = "%1$s * %2$s";
                break;
            }
            case QUADRATIC: {
                string = "%1$s\u00b2 * %2$s";
                break;
            }
            case EXPERIMENTAL: {
                string = "%1$s * (sin(%1$s) + 1) * %2$s";
                break;
            }
            default: {
                string = "ERROR";
            }
        }
        String function = string;
        double enrichment = ItemRBMKRod.getEnrichment(stack);
        if (enrichment < 1.0) {
            enrichment = this.reactivityModByEnrichment(enrichment);
            String reactivity = TextFormatting.YELLOW + "" + (double)((int)(this.reactivity * enrichment * 1000.0)) / 1000.0 + TextFormatting.WHITE;
            String enrichmentPer = TextFormatting.GOLD + " (" + (double)((int)(enrichment * 1000.0)) / 10.0 + "%)";
            return String.format(function, this.selfRate > 0.0 ? "(x" + TextFormatting.RED + " + " + this.selfRate + TextFormatting.WHITE + ")" : "x", reactivity).concat(enrichmentPer);
        }
        return String.format(function, this.selfRate > 0.0 ? "(x" + TextFormatting.RED + " + " + this.selfRate + TextFormatting.WHITE + ")" : "x", this.reactivity);
    }

    public double reactivityModByEnrichment(double enrichment) {
        switch (this.depFunc) {
            default: {
                return enrichment;
            }
            case STATIC: {
                return 1.0;
            }
            case BOOSTED_SLOPE: {
                return enrichment + Math.sin((enrichment - 1.0) * (enrichment - 1.0) * Math.PI);
            }
            case RAISING_SLOPE: {
                return enrichment + Math.sin(enrichment * Math.PI) / 2.0;
            }
            case GENTLE_SLOPE: 
        }
        return enrichment + Math.sin(enrichment * Math.PI) / 3.0;
    }

    public double xenonGenFunc(double flux) {
        return flux * this.xGen;
    }

    public double xenonBurnFunc(double flux) {
        return flux * flux / this.xBurn;
    }

    public static double getEnrichment(ItemStack stack) {
        return ItemRBMKRod.getYield(stack) / ((ItemRBMKRod)stack.func_77973_b()).yield;
    }

    public static double getPoisonLevel(ItemStack stack) {
        return ItemRBMKRod.getPoison(stack) / 100.0;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flag) {
        list.add(TextFormatting.ITALIC + this.fullName);
        if (this == ModItems.rbmk_fuel_drx) {
            if (this.selfRate > 0.0 || this.function == EnumBurnFunc.SIGMOID) {
                list.add(TextFormatting.RED + I18nUtil.resolveKey("trait.rbmx.source", new Object[0]));
            }
            list.add(TextFormatting.GREEN + I18nUtil.resolveKey("trait.rbmx.depletion", (double)((int)((this.yield - ItemRBMKRod.getYield(stack)) / this.yield * 100000.0)) / 1000.0 + "%"));
            list.add(TextFormatting.DARK_PURPLE + I18nUtil.resolveKey("trait.rbmx.xenon", (double)((int)(ItemRBMKRod.getPoison(stack) * 1000.0)) / 1000.0 + "%"));
            list.add(TextFormatting.BLUE + I18nUtil.resolveKey("trait.rbmx.splitsWith", I18nUtil.resolveKey(this.nType.unlocalized + ".x", new Object[0])));
            list.add(TextFormatting.BLUE + I18nUtil.resolveKey("trait.rbmx.splitsInto", I18nUtil.resolveKey(this.rType.unlocalized + ".x", new Object[0])));
            list.add(TextFormatting.YELLOW + I18nUtil.resolveKey("trait.rbmx.fluxFunc", TextFormatting.WHITE + this.getFuncDescription(stack)));
            list.add(TextFormatting.YELLOW + I18nUtil.resolveKey("trait.rbmx.funcType", I18nUtil.resolveKey(this.function.title, new Object[0])));
            list.add(TextFormatting.LIGHT_PURPLE + I18nUtil.resolveKey("trait.rbmx.xenonGen", TextFormatting.WHITE + "x * " + this.xGen));
            list.add(TextFormatting.LIGHT_PURPLE + I18nUtil.resolveKey("trait.rbmx.xenonBurn", TextFormatting.WHITE + "x\u00b2 / " + this.xBurn));
            list.add(TextFormatting.GOLD + I18nUtil.resolveKey("trait.rbmx.heat", this.heat + "\u00b0C"));
            list.add(TextFormatting.GOLD + I18nUtil.resolveKey("trait.rbmx.diffusion", this.diffusion + "\u00b9/\u00b2"));
            list.add(TextFormatting.RED + I18nUtil.resolveKey("trait.rbmx.skinTemp", (double)((int)(ItemRBMKRod.getHullHeat(stack) * 10.0)) / 10.0 + "m"));
            list.add(TextFormatting.RED + I18nUtil.resolveKey("trait.rbmx.coreTemp", (double)((int)(ItemRBMKRod.getCoreHeat(stack) * 10.0)) / 10.0 + "m"));
            list.add(TextFormatting.DARK_RED + I18nUtil.resolveKey("trait.rbmx.melt", this.meltingPoint + "m"));
            list.add(TextFormatting.DARK_RED + I18nUtil.resolveKey("trait.rbmx.meltdown", (double)((int)(ItemRBMKRod.getMeltdownPercent(stack) * 1000.0)) / 1000.0 + "%"));
        } else {
            if (this.selfRate > 0.0 || this.function == EnumBurnFunc.SIGMOID) {
                list.add(TextFormatting.RED + I18nUtil.resolveKey("trait.rbmk.source", new Object[0]));
            }
            list.add(TextFormatting.GREEN + I18nUtil.resolveKey("trait.rbmk.depletion", (double)((int)((this.yield - ItemRBMKRod.getYield(stack)) / this.yield * 100000.0)) / 1000.0 + "%"));
            list.add(TextFormatting.DARK_PURPLE + I18nUtil.resolveKey("trait.rbmk.xenon", (double)((int)(ItemRBMKRod.getPoison(stack) * 1000.0)) / 1000.0 + "%"));
            list.add(TextFormatting.BLUE + I18nUtil.resolveKey("trait.rbmk.splitsWith", I18nUtil.resolveKey(this.nType.unlocalized, new Object[0])));
            list.add(TextFormatting.BLUE + I18nUtil.resolveKey("trait.rbmk.splitsInto", I18nUtil.resolveKey(this.rType.unlocalized, new Object[0])));
            list.add(TextFormatting.YELLOW + I18nUtil.resolveKey("trait.rbmk.fluxFunc", TextFormatting.WHITE + this.getFuncDescription(stack)));
            list.add(TextFormatting.YELLOW + I18nUtil.resolveKey("trait.rbmk.funcType", I18nUtil.resolveKey(this.function.title, new Object[0])));
            list.add(TextFormatting.YELLOW + I18nUtil.resolveKey("trait.rbmk.xenonGen", TextFormatting.WHITE + "x * " + this.xGen));
            list.add(TextFormatting.YELLOW + I18nUtil.resolveKey("trait.rbmk.xenonBurn", TextFormatting.WHITE + "x\u00b2 / " + this.xBurn));
            list.add(TextFormatting.GOLD + I18nUtil.resolveKey("trait.rbmk.heat", this.heat + "\u00b0C"));
            list.add(TextFormatting.GOLD + I18nUtil.resolveKey("trait.rbmk.diffusion", this.diffusion + "\u00b9/\u00b2"));
            list.add(TextFormatting.RED + I18nUtil.resolveKey("trait.rbmk.skinTemp", (double)((int)(ItemRBMKRod.getHullHeat(stack) * 10.0)) / 10.0 + "\u00b0C"));
            list.add(TextFormatting.RED + I18nUtil.resolveKey("trait.rbmk.coreTemp", (double)((int)(ItemRBMKRod.getCoreHeat(stack) * 10.0)) / 10.0 + "\u00b0C"));
            list.add(TextFormatting.DARK_RED + I18nUtil.resolveKey("trait.rbmk.melt", this.meltingPoint + "\u00b0C"));
            list.add(TextFormatting.DARK_RED + I18nUtil.resolveKey("trait.rbmk.meltdown", (double)((int)(ItemRBMKRod.getMeltdownPercent(stack) * 1000.0)) / 1000.0 + "%"));
        }
        super.func_77624_a(stack, worldIn, list, flag);
    }

    public static void setYield(ItemStack stack, double yield) {
        ItemRBMKRod.setDouble(stack, "yield", yield);
    }

    public static double getYield(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemRBMKRod) {
            return ItemRBMKRod.getDouble(stack, "yield");
        }
        return 0.0;
    }

    public static void setMeltdownPercent(ItemStack stack, double meltdownPercent) {
        ItemRBMKRod.setDouble(stack, "meltdown", meltdownPercent);
    }

    public static double getMeltdownPercent(ItemStack stack) {
        return ItemRBMKRod.getDouble(stack, "meltdown");
    }

    public static void setPoison(ItemStack stack, double xenon) {
        ItemRBMKRod.setDouble(stack, "xenon", xenon);
    }

    public static double getPoison(ItemStack stack) {
        return ItemRBMKRod.getDouble(stack, "xenon");
    }

    public static void setCoreHeat(ItemStack stack, double heat) {
        ItemRBMKRod.setDouble(stack, "core", heat);
    }

    public static double getCoreHeat(ItemStack stack) {
        return ItemRBMKRod.getDouble(stack, "core");
    }

    public static void setHullHeat(ItemStack stack, double heat) {
        ItemRBMKRod.setDouble(stack, "hull", heat);
    }

    public static double getHullHeat(ItemStack stack) {
        return ItemRBMKRod.getDouble(stack, "hull");
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getDurabilityForDisplay(stack) > 0.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ItemRBMKRod.getEnrichment(stack);
    }

    public static void setDouble(ItemStack stack, String key, double yield) {
        if (!stack.func_77942_o()) {
            ItemRBMKRod.setNBTDefaults(stack);
        }
        stack.func_77978_p().func_74780_a(key, yield);
    }

    public static double getDouble(ItemStack stack, String key) {
        if (!stack.func_77942_o()) {
            ItemRBMKRod.setNBTDefaults(stack);
        }
        return stack.func_77978_p().func_74769_h(key);
    }

    private static void setNBTDefaults(ItemStack stack) {
        stack.func_77982_d(new NBTTagCompound());
        ItemRBMKRod.setYield(stack, ((ItemRBMKRod)stack.func_77973_b()).yield);
        ItemRBMKRod.setCoreHeat(stack, 20.0);
        ItemRBMKRod.setHullHeat(stack, 20.0);
        ItemRBMKRod.setMeltdownPercent(stack, 0.0);
    }

    public static enum EnumBurnFunc {
        PASSIVE("trait.rbmx.flux.passive"),
        PLATEU("trait.rbmx.flux.euler"),
        SIGMOID("trait.rbmx.flux.sigmoid"),
        LOG_TEN("trait.rbmx.flux.logten"),
        SQUARE_ROOT("trait.rbmx.flux.squrt"),
        ARCH("trait.rbmx.flux.arch"),
        LINEAR("trait.rbmx.flux.linear"),
        QUADRATIC("trait.rbmx.flux.quadratic"),
        EXPERIMENTAL("trait.rbmx.flux.experimental");

        public String title = "";

        private EnumBurnFunc(String title) {
            this.title = title;
        }
    }

    public static enum EnumDepleteFunc {
        LINEAR,
        RAISING_SLOPE,
        BOOSTED_SLOPE,
        GENTLE_SLOPE,
        STATIC;

    }
}

