/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.special;

import com.hbm.config.BombConfig;
import com.hbm.config.WeaponConfig;
import com.hbm.entity.effect.EntityCloudFleija;
import com.hbm.entity.logic.EntityNukeExplosionMK3;
import com.hbm.forgefluid.HbmFluidHandlerCell;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.forgefluid.SpecialContainerFillLists;
import com.hbm.items.ModItems;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class ItemCell
extends Item {
    public ItemCell(String s) {
        this.func_77655_b(s);
        this.setRegistryName(s);
        this.func_77656_e(1000);
        this.func_77642_a(this);
        ModItems.ALL_ITEMS.add(this);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.field_70122_E || entityItem.func_70027_ad()) {
            if (ItemCell.hasFluid(entityItem.func_92059_d(), ModForgeFluids.ASCHRAB) && WeaponConfig.dropCell) {
                if (!entityItem.field_70170_p.field_72995_K) {
                    entityItem.func_70106_y();
                    entityItem.field_70170_p.func_184148_a(null, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.AMBIENT, 100.0f, entityItem.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
                    EntityNukeExplosionMK3 entity = new EntityNukeExplosionMK3(entityItem.field_70170_p);
                    entity.field_70165_t = entityItem.field_70165_t;
                    entity.field_70163_u = entityItem.field_70163_u;
                    entity.field_70161_v = entityItem.field_70161_v;
                    if (!EntityNukeExplosionMK3.isJammed(entityItem.field_70170_p, entity)) {
                        entity.destructionRange = (int)((float)BombConfig.aSchrabRadius * ((float)FluidUtil.getFluidContained((ItemStack)entityItem.func_92059_d()).amount / 1000.0f));
                        entity.speed = 25;
                        entity.coefficient = 1.0f;
                        entity.waste = false;
                        entityItem.field_70170_p.func_72838_d((Entity)entity);
                        EntityCloudFleija cloud = new EntityCloudFleija(entityItem.field_70170_p, (int)((float)BombConfig.aSchrabRadius * ((float)FluidUtil.getFluidContained((ItemStack)entityItem.func_92059_d()).amount / 1000.0f)));
                        cloud.field_70165_t = entityItem.field_70165_t;
                        cloud.field_70163_u = entityItem.field_70163_u;
                        cloud.field_70161_v = entityItem.field_70161_v;
                        entityItem.field_70170_p.func_72838_d((Entity)cloud);
                    }
                }
                return true;
            }
            if (ItemCell.hasFluid(entityItem.func_92059_d(), ModForgeFluids.AMAT) && WeaponConfig.dropCell) {
                if (!entityItem.field_70170_p.field_72995_K) {
                    entityItem.func_70106_y();
                    entityItem.field_70170_p.func_72876_a((Entity)entityItem, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, 10.0f * ((float)FluidUtil.getFluidContained((ItemStack)entityItem.func_92059_d()).amount / 1000.0f), true);
                }
                return true;
            }
        }
        return false;
    }

    @NotNull
    public ItemStack getContainerItem(@NotNull ItemStack itemStack) {
        if (ItemCell.isEmptyCell(itemStack)) {
            return ItemStack.field_190927_a;
        }
        return super.getContainerItem(itemStack);
    }

    public int getItemStackLimit(ItemStack stack) {
        return ItemCell.isFullOrEmpty(stack) ? 64 : 1;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        FluidStack f = FluidUtil.getFluidContained((ItemStack)stack);
        if (f != null) {
            try {
                return I18n.func_135052_a((String)SpecialContainerFillLists.EnumCell.getEnumFromFluid(f.getFluid()).getTranslateKey(), (Object[])new Object[0]);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return I18n.func_135052_a((String)"item.cell_empty.name", (Object[])new Object[0]);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == this.func_77640_w() || tab == CreativeTabs.field_78027_g) {
            for (Fluid f : SpecialContainerFillLists.EnumCell.getFluids()) {
                ItemStack stack = new ItemStack((Item)this, 1, 0);
                if (f != null) {
                    stack.func_77982_d(new NBTTagCompound());
                    stack.func_77978_p().func_74782_a("HbmFluidKey", (NBTBase)new FluidStack(f, 1000).writeToNBT(new NBTTagCompound()));
                }
                items.add((Object)stack);
            }
        }
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (ItemCell.hasFluid(stack, ModForgeFluids.AMAT)) {
            tooltip.add("\u00a7eExposure to matter will lead to violent annihilation!\u00a7r");
            tooltip.add("\u00a7c[Dangerous Drop]\u00a7r");
        } else if (ItemCell.hasFluid(stack, ModForgeFluids.ASCHRAB)) {
            tooltip.add("\u00a7eExposure to matter will create a f\u00f3lkvangr field!\u00a7r");
            tooltip.add("\u00a7c[Dangerous Drop]\u00a7r");
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new HbmFluidHandlerCell(stack, 1000);
    }

    public static boolean isFullCell(ItemStack stack, Fluid fluid) {
        if (stack != null) {
            return stack.func_77973_b() instanceof ItemCell && FluidUtil.getFluidContained((ItemStack)stack) != null && FluidUtil.getFluidContained((ItemStack)stack).getFluid() == fluid && FluidUtil.getFluidContained((ItemStack)stack).amount == 1000;
        }
        return false;
    }

    public static boolean isEmptyCell(ItemStack stack) {
        if (stack != null) {
            if (stack.func_77973_b() == ModItems.cell && stack.func_77978_p() != null) {
                FluidStack s = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("HbmFluidKey"));
                return s == null || s.amount <= 0;
            }
            return stack.func_77973_b() == ModItems.cell && stack.func_77978_p() == null;
        }
        return false;
    }

    public static boolean hasFluid(ItemStack stack, Fluid f) {
        if (stack != null) {
            return stack.func_77973_b() == ModItems.cell && FluidUtil.getFluidContained((ItemStack)stack) != null && FluidUtil.getFluidContained((ItemStack)stack).getFluid() == f;
        }
        return false;
    }

    public static ItemStack getFullCell(Fluid fluid, int amount) {
        if (SpecialContainerFillLists.EnumCell.contains(fluid)) {
            ItemStack stack = new ItemStack(ModItems.cell, amount, 0);
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74782_a("HbmFluidKey", (NBTBase)new FluidStack(fluid, 1000).writeToNBT(new NBTTagCompound()));
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getFullCell(Fluid fluid) {
        return ItemCell.getFullCell(fluid, 1);
    }

    public static boolean isFullOrEmpty(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77973_b() == ModItems.cell) {
            FluidStack f = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("HbmFluidKey"));
            if (f == null) {
                return true;
            }
            return f.amount == 1000 || f.amount == 0;
        }
        return stack.func_77973_b() == ModItems.cell;
    }

    public static boolean hasEmptyCell(EntityPlayer player) {
        InventoryPlayer inv = player.field_71071_by;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (!ItemCell.isEmptyCell(inv.func_70301_a(i))) continue;
            return true;
        }
        return false;
    }

    public static void consumeEmptyCell(EntityPlayer player) {
        InventoryPlayer inv = player.field_71071_by;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (!ItemCell.isEmptyCell(inv.func_70301_a(i))) continue;
            inv.func_70301_a(i).func_190918_g(1);
            return;
        }
    }
}

