/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.lib;

import api.hbm.energy.IBatteryItem;
import api.hbm.energy.IEnergyConnector;
import api.hbm.energy.IEnergyConnectorBlock;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.IBaublesItemHandler;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import com.hbm.blocks.ModBlocks;
import com.hbm.capability.HbmLivingCapability;
import com.hbm.entity.mob.EntityHunterChopper;
import com.hbm.entity.projectile.EntityChopperMine;
import com.hbm.handler.WeightedRandomChestContentFrom1710;
import com.hbm.interfaces.Spaghetti;
import com.hbm.items.ModItems;
import com.hbm.lib.ForgeDirection;
import com.hbm.main.MainRegistry;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.util.BobMathUtil;
import com.hbm.util.I18nUtil;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;

@Spaghetti(value="this whole class")
public class Library {
    static Random rand = new Random();
    public static String HbMinecraft = "192af5d7-ed0f-48d8-bd89-9d41af8524f8";
    public static String TacoRedneck = "5aee1e3d-3767-4987-a222-e7ce1fbdf88e";
    public static String LPkukin = "937c9804-e11f-4ad2-a5b1-42e62ac73077";
    public static String Dafnik = "3af1c262-61c0-4b12-a4cb-424cc3a9c8c0";
    public static String a20 = "4729b498-a81c-42fd-8acd-20d6d9f759e0";
    public static String rodolphito = "c3f5e449-6d8c-4fe3-acc9-47ef50e7e7ae";
    public static String LordVertice = "a41df45e-13d8-4677-9398-090d3882b74f";
    public static String CodeRed_ = "912ec334-e920-4dd7-8338-4d9b2d42e0a1";
    public static String dxmaster769 = "62c168b2-d11d-4dbf-9168-c6cea3dcb20e";
    public static String Dr_Nostalgia = "e82684a7-30f1-44d2-ab37-41b342be1bbd";
    public static String Samino2 = "87c3960a-4332-46a0-a929-ef2a488d1cda";
    public static String Hoboy03new = "d7f29d9c-5103-4f6f-88e1-2632ff95973f";
    public static String Dragon59MC = "dc23a304-0f84-4e2d-b47d-84c8d3bfbcdb";
    public static String SteelCourage = "ac49720b-4a9a-4459-a26f-bee92160287a";
    public static String Ducxkskiziko = "122fe98f-be19-49ca-a96b-d4dee4f0b22e";
    public static String SweatySwiggs = "5544aa30-b305-4362-b2c1-67349bb499d5";
    public static String Drillgon = "41ebd03f-7a12-42f3-b037-0caa4d6f235b";
    public static String Alcater = "0b399a4a-8545-45a1-be3d-ece70d7d48e9";
    public static String ege444 = "42ee978c-442a-4cd8-95b6-29e469b6df10";
    public static String Doctor17 = "e4ab1199-1c22-4f82-a516-c3238bc2d0d1";
    public static String Doctor17PH = "4d0477d7-58da-41a9-a945-e93df8601c5a";
    public static String ShimmeringBlaze = "061bc566-ec74-4307-9614-ac3a70d2ef38";
    public static String FifeMiner = "37e5eb63-b9a2-4735-9007-1c77d703daa3";
    public static String lag_add = "259785a0-20e9-4c63-9286-ac2f93ff528f";
    public static String Pu_238 = "c95fdfd3-bea7-4255-a44b-d21bc3df95e3";
    public static String Golem = "058b52a6-05b7-4d11-8cfa-2db665d9a521";
    public static Set<String> contributors = Sets.newHashSet((Object[])new String[]{"06ab7c03-55ce-43f8-9d3c-2850e3c652de", "5bf069bc-5b46-4179-aafe-35c0a07dee8b"});
    public static final ForgeDirection POS_X = ForgeDirection.EAST;
    public static final ForgeDirection NEG_X = ForgeDirection.WEST;
    public static final ForgeDirection POS_Y = ForgeDirection.UP;
    public static final ForgeDirection NEG_Y = ForgeDirection.DOWN;
    public static final ForgeDirection POS_Z = ForgeDirection.SOUTH;
    public static final ForgeDirection NEG_Z = ForgeDirection.NORTH;
    public static final int[] powersOfTen = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    public static DecimalFormat numberformat = new DecimalFormat("0.00");
    public static List<String> superuser = new ArrayList<String>();
    static boolean hasBaubleInstalled = true;
    public static Map<Integer, String> numbersMap = null;

    public static void initSuperusers() {
        superuser.add(HbMinecraft);
        superuser.add(TacoRedneck);
        superuser.add(LPkukin);
        superuser.add(Dafnik);
        superuser.add(a20);
        superuser.add(rodolphito);
        superuser.add(Ducxkskiziko);
        superuser.add(Drillgon);
        superuser.add(Alcater);
    }

    public static boolean isCreative(Entity e) {
        if (e instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e;
            return player.field_71075_bZ.field_75098_d;
        }
        return false;
    }

    public static void setFinalStatic(Class c, String variable, String variableObf, Object newValue) {
        Library.setFinal(c, variable, variableObf, newValue, false);
    }

    public static void setPrivateFinalStatic(Class c, String variable, String variableObf, Object newValue) {
        Library.setFinal(c, variable, variableObf, newValue, true);
    }

    public static void setFinal(Class c, String variable, String variableObf, Object newValue, boolean isHidden) {
        try {
            Field f = ReflectionHelper.findField((Class)c, (String)variable, (String)variableObf);
            if (isHidden) {
                f.setAccessible(true);
            }
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(f, f.getModifiers() & 0xFFFFFFEF);
            f.set(null, newValue);
        }
        catch (Throwable ignored) {
            ignored.printStackTrace();
        }
    }

    public static void warnEntity(EntityLivingBase entity, SoundEvent s, String color, String text, float vol, float pitch) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            player.func_146105_b((ITextComponent)new TextComponentString(color + I18nUtil.resolveKey(text, new Object[0])), true);
        }
        entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, s, SoundCategory.PLAYERS, vol, pitch);
    }

    public static int getStatisticalInt(Random rand, float v) {
        return (int)v + (rand.nextFloat() < v - (float)((int)v) ? 1 : 0);
    }

    public static String getColor(double val) {
        if (val > 1.0) {
            return "\u00a7a+";
        }
        return "\u00a7c";
    }

    public static String getColor(long a, long b) {
        float fraction = 100.0f * (float)a / (float)b;
        if (fraction > 75.0f) {
            return "\u00a7a";
        }
        if (fraction > 25.0f) {
            return "\u00a7e";
        }
        return "\u00a7c";
    }

    public static String getColoredMbPercent(long a, long b) {
        String color = Library.getColor(a, b);
        return color + a + " \u00a72/ " + b + " mB " + color + "(" + Library.getPercentage((double)a / (double)b) + "%)";
    }

    public static String getColoredDurabilityPercent(long a, long b) {
        String color = Library.getColor(a, b);
        return "Durability: " + color + a + " \u00a72/ " + b + " " + color + "(" + Library.getPercentage((double)a / (double)b) + "%)";
    }

    public static boolean checkForHeld(EntityPlayer player, Item item) {
        if (player == null || item == null) {
            return false;
        }
        return player.func_184614_ca().func_77973_b() == item || player.func_184592_cb().func_77973_b() == item;
    }

    public static boolean checkForBauble(EntityPlayer player, Item item) {
        if (!hasBaubleInstalled || player == null || item == null) {
            return false;
        }
        try {
            if (item instanceof IBauble) {
                IBauble bau = (IBauble)item;
                IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
                for (int i : bau.getBaubleType(new ItemStack(item)).getValidSlots()) {
                    ItemStack stack = baubles.getStackInSlot(i);
                    if (stack.func_77973_b() != item) continue;
                    return true;
                }
            }
        }
        catch (NoClassDefFoundError e) {
            hasBaubleInstalled = false;
        }
        return false;
    }

    public static boolean isObstructed(World world, double x, double y, double z, double a, double b, double c) {
        RayTraceResult pos = world.func_147447_a(new Vec3d(x, y, z), new Vec3d(a, b, c), false, true, true);
        return pos != null && pos.field_72313_a != RayTraceResult.Type.MISS;
    }

    public static int getColorProgress(double fraction) {
        int r = (int)(255.0 * Math.min(1.0, fraction * -2.0 + 2.0));
        int g = (int)(255.0 * Math.min(1.0, fraction * 2.0));
        return 65536 * r + 256 * g;
    }

    public static String getPercentage(double fraction) {
        return numberformat.format(Library.roundFloat(fraction * 100.0, 2));
    }

    public static String getShortNumber(long l) {
        return Library.getShortNumber(new BigDecimal(l));
    }

    public static long getMagnitude(int mag) {
        return new BigDecimal(10).pow(mag).longValue();
    }

    public static void initNumbers() {
        numbersMap = new TreeMap<Integer, String>();
        numbersMap.put(3, "k");
        numbersMap.put(6, "M");
        numbersMap.put(9, "G");
        numbersMap.put(12, "T");
        numbersMap.put(15, "P");
        numbersMap.put(18, "E");
        numbersMap.put(21, "Z");
        numbersMap.put(24, "Y");
        numbersMap.put(27, "R");
        numbersMap.put(30, "Q");
    }

    public static String getShortNumber(BigDecimal l) {
        boolean negative;
        if (numbersMap == null) {
            Library.initNumbers();
        }
        boolean bl = negative = l.signum() < 0;
        if (negative) {
            l = l.negate();
        }
        String result = l.toPlainString();
        BigDecimal c = null;
        for (Map.Entry<Integer, String> num : numbersMap.entrySet()) {
            c = new BigDecimal("1E" + num.getKey());
            if (l.compareTo(c) < 0) break;
            double res = l.divide(c).doubleValue();
            result = numberformat.format(Library.roundFloat(res, 2)) + num.getValue();
        }
        if (negative) {
            result = "-" + result;
        }
        return result;
    }

    public static float roundFloat(float number, int decimal) {
        return (float)Math.round(number * (float)powersOfTen[decimal]) / (float)powersOfTen[decimal];
    }

    public static float roundFloat(double number, int decimal) {
        return (float)Math.round(number * (double)powersOfTen[decimal]) / (float)powersOfTen[decimal];
    }

    public static int getColorFromItemStack(ItemStack stack) {
        ResourceLocation path = null;
        ResourceLocation actualPath = null;
        boolean color = false;
        try {
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178087_a(stack.func_77973_b(), stack.func_77960_j());
            path = new ResourceLocation(sprite.func_94215_i() + ".png");
            actualPath = new ResourceLocation(path.func_110624_b(), "textures/" + path.func_110623_a());
            return Library.getColorFromResourceLocation(actualPath);
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    public static int getColorFromResourceLocation(ResourceLocation r) {
        if (r == null) {
            return 0;
        }
        try {
            BufferedImage image = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(r).func_110527_b());
            return Library.getRGBfromARGB(image.getRGB(image.getWidth() >> 1, image.getHeight() >> 1));
        }
        catch (Exception e) {
            MainRegistry.logger.log(Level.INFO, "[NTM] Fluid Texture not found for " + e.getMessage());
            return 0xFFFFFF;
        }
    }

    public static int getRGBfromARGB(int pixel) {
        return pixel & 0xFFFFFF;
    }

    public static int getGroundHeight(World world, int x, int z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, 255, z);
        for (int y = 255; y > 1; --y) {
            pos.func_185336_p(y);
            IBlockState state = world.func_180495_p((BlockPos)pos);
            Block b = state.func_177230_c();
            if (b.func_176200_f((IBlockAccess)world, (BlockPos)pos) || !b.func_149662_c(state) || b.func_149688_o(state) == Material.field_151575_d) continue;
            return y;
        }
        return 1;
    }

    public static long chargeTEFromItems(IItemHandlerModifiable inventory, int index, long power, long maxPower) {
        if (inventory.getStackInSlot(index).func_77973_b() == ModItems.battery_creative) {
            return maxPower;
        }
        if (inventory.getStackInSlot(index).func_77973_b() == ModItems.fusion_core_infinite) {
            return maxPower;
        }
        if (inventory.getStackInSlot(index).func_77973_b() instanceof IBatteryItem) {
            IBatteryItem battery = (IBatteryItem)inventory.getStackInSlot(index).func_77973_b();
            long batCharge = battery.getCharge(inventory.getStackInSlot(index));
            long batRate = battery.getDischargeRate();
            long toDischarge = Math.min(Math.min(maxPower - power, batRate), batCharge);
            battery.dischargeBattery(inventory.getStackInSlot(index), toDischarge);
            power += toDischarge;
        }
        return power;
    }

    public static long chargeItemsFromTE(IItemHandlerModifiable inventory, int index, long power, long maxPower) {
        if (inventory.getStackInSlot(index).func_77973_b() instanceof IBatteryItem) {
            IBatteryItem battery = (IBatteryItem)inventory.getStackInSlot(index).func_77973_b();
            ItemStack stack = inventory.getStackInSlot(index);
            long batMax = battery.getMaxCharge(stack);
            long batCharge = battery.getCharge(stack);
            long batRate = battery.getChargeRate();
            long toCharge = Math.min(Math.min(power, batRate), batMax - batCharge);
            power -= toCharge;
            battery.chargeBattery(stack, toCharge);
        }
        return power;
    }

    public static boolean isArrayEmpty(Object[] array) {
        if (array == null) {
            return true;
        }
        if (array.length == 0) {
            return true;
        }
        boolean flag = true;
        for (Object o : array) {
            if (o == null) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public static ItemStack carefulCopy(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return stack.func_77946_l();
    }

    public static EntityPlayer getClosestPlayerForSound(World world, double x, double y, double z, double radius) {
        double d4 = -1.0;
        EntityPlayer entity = null;
        if (world == null) {
            return null;
        }
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entityplayer1 = (Entity)world.field_72996_f.get(i);
            if (!entityplayer1.func_70089_S() || !(entityplayer1 instanceof EntityPlayer)) continue;
            double d5 = entityplayer1.func_70092_e(x, y, z);
            if (!(radius < 0.0) && !(d5 < radius * radius) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            entity = (EntityPlayer)entityplayer1;
        }
        return entity;
    }

    public static EntityHunterChopper getClosestChopperForSound(World world, double x, double y, double z, double radius) {
        double d4 = -1.0;
        EntityHunterChopper entity = null;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entityplayer1 = (Entity)world.field_72996_f.get(i);
            if (!entityplayer1.func_70089_S() || !(entityplayer1 instanceof EntityHunterChopper)) continue;
            double d5 = entityplayer1.func_70092_e(x, y, z);
            if (!(radius < 0.0) && !(d5 < radius * radius) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            entity = (EntityHunterChopper)entityplayer1;
        }
        return entity;
    }

    public static EntityChopperMine getClosestMineForSound(World world, double x, double y, double z, double radius) {
        double d4 = -1.0;
        EntityChopperMine entity = null;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entityplayer1 = (Entity)world.field_72996_f.get(i);
            if (!entityplayer1.func_70089_S() || !(entityplayer1 instanceof EntityChopperMine)) continue;
            double d5 = entityplayer1.func_70092_e(x, y, z);
            if (!(radius < 0.0) && !(d5 < radius * radius) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            entity = (EntityChopperMine)entityplayer1;
        }
        return entity;
    }

    public static RayTraceResult rayTrace(EntityPlayer player, double length, float interpolation) {
        Vec3d vec3 = Library.getPosition(interpolation, player);
        vec3 = vec3.func_72441_c(0.0, (double)player.eyeHeight, 0.0);
        Vec3d vec31 = player.func_70676_i(interpolation);
        Vec3d vec32 = vec3.func_72441_c(vec31.field_72450_a * length, vec31.field_72448_b * length, vec31.field_72449_c * length);
        return player.field_70170_p.func_147447_a(vec3, vec32, false, false, true);
    }

    public static RayTraceResult rayTrace(EntityPlayer player, double length, float interpolation, boolean b1, boolean b2, boolean b3) {
        Vec3d vec3 = Library.getPosition(interpolation, player);
        vec3 = vec3.func_72441_c(0.0, (double)player.eyeHeight, 0.0);
        Vec3d vec31 = player.func_70676_i(interpolation);
        Vec3d vec32 = vec3.func_72441_c(vec31.field_72450_a * length, vec31.field_72448_b * length, vec31.field_72449_c * length);
        return player.field_70170_p.func_147447_a(vec3, vec32, b1, b2, b3);
    }

    public static AxisAlignedBB rotateAABB(AxisAlignedBB box, EnumFacing facing) {
        AxisAlignedBB axisAlignedBB;
        switch (facing) {
            case NORTH: {
                axisAlignedBB = new AxisAlignedBB(box.field_72340_a, box.field_72338_b, 1.0 - box.field_72339_c, box.field_72336_d, box.field_72337_e, 1.0 - box.field_72334_f);
                break;
            }
            case SOUTH: {
                axisAlignedBB = box;
                break;
            }
            case EAST: {
                axisAlignedBB = new AxisAlignedBB(box.field_72339_c, box.field_72338_b, box.field_72340_a, box.field_72334_f, box.field_72337_e, box.field_72336_d);
                break;
            }
            case WEST: {
                axisAlignedBB = new AxisAlignedBB(1.0 - box.field_72339_c, box.field_72338_b, box.field_72340_a, 1.0 - box.field_72334_f, box.field_72337_e, box.field_72336_d);
                break;
            }
            default: {
                axisAlignedBB = box;
            }
        }
        return axisAlignedBB;
    }

    public static RayTraceResult rayTraceIncludeEntities(EntityPlayer player, double d, float f) {
        Vec3d vec3 = Library.getPosition(f, player);
        vec3 = vec3.func_72441_c(0.0, (double)player.eyeHeight, 0.0);
        Vec3d vec31 = player.func_70676_i(f);
        Vec3d vec32 = vec3.func_72441_c(vec31.field_72450_a * d, vec31.field_72448_b * d, vec31.field_72449_c * d);
        return Library.rayTraceIncludeEntities(player.field_70170_p, vec3, vec32, (Entity)player);
    }

    public static RayTraceResult rayTraceIncludeEntitiesCustomDirection(EntityPlayer player, Vec3d look, double d, float f) {
        Vec3d vec3 = Library.getPosition(f, player);
        vec3 = vec3.func_72441_c(0.0, (double)player.eyeHeight, 0.0);
        Vec3d vec32 = vec3.func_72441_c(look.field_72450_a * d, look.field_72448_b * d, look.field_72449_c * d);
        return Library.rayTraceIncludeEntities(player.field_70170_p, vec3, vec32, (Entity)player);
    }

    public static Vec3d changeByAngle(Vec3d oldDir, float yaw, float pitch) {
        Vec3d dir = new Vec3d(0.0, 0.0, 1.0);
        dir = dir.func_178789_a((float)Math.toRadians(pitch)).func_178785_b((float)Math.toRadians(yaw));
        Vec3d angles = BobMathUtil.getEulerAngles(oldDir);
        return dir.func_178789_a((float)Math.toRadians(angles.field_72448_b + 90.0)).func_178785_b((float)Math.toRadians(angles.field_72450_a));
    }

    public static RayTraceResult rayTraceIncludeEntities(World w, Vec3d vec3, Vec3d vec32, @Nullable Entity excluded) {
        RayTraceResult result = w.func_147447_a(vec3, vec32, false, true, true);
        if (result != null) {
            vec32 = result.field_72307_f;
        }
        AxisAlignedBB box = new AxisAlignedBB(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, vec32.field_72450_a, vec32.field_72448_b, vec32.field_72449_c).func_186662_g(1.0);
        List ents = w.func_175674_a(excluded, box, Predicates.and((Predicate)EntitySelectors.field_94557_a, entity -> entity instanceof EntityLivingBase));
        for (Entity ent : ents) {
            RayTraceResult test = ent.func_174813_aQ().func_186662_g(0.3).func_72327_a(vec3, vec32);
            if (test == null || result != null && !(vec3.func_72436_e(result.field_72307_f) > vec3.func_72436_e(test.field_72307_f))) continue;
            test.field_72313_a = RayTraceResult.Type.ENTITY;
            test.field_72308_g = ent;
            result = test;
        }
        return result;
    }

    public static Pair<RayTraceResult, List<Entity>> rayTraceEntitiesOnLine(EntityPlayer player, double d, float f) {
        Vec3d vec3 = Library.getPosition(f, player);
        vec3 = vec3.func_72441_c(0.0, (double)player.eyeHeight, 0.0);
        Vec3d vec31 = player.func_70676_i(f);
        Vec3d vec32 = vec3.func_72441_c(vec31.field_72450_a * d, vec31.field_72448_b * d, vec31.field_72449_c * d);
        RayTraceResult result = player.field_70170_p.func_147447_a(vec3, vec32, false, true, true);
        if (result != null) {
            vec32 = result.field_72307_f;
        }
        AxisAlignedBB box = new AxisAlignedBB(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, vec32.field_72450_a, vec32.field_72448_b, vec32.field_72449_c).func_186662_g(1.0);
        List ents = player.field_70170_p.func_175674_a((Entity)player, box, Predicates.and((Predicate)EntitySelectors.field_94557_a, entity -> entity instanceof EntityLiving));
        Iterator itr = ents.iterator();
        while (itr.hasNext()) {
            Entity ent = (Entity)itr.next();
            AxisAlignedBB entityBox = ent.func_174813_aQ().func_186662_g(0.1);
            RayTraceResult entTrace = entityBox.func_72327_a(vec3, vec32);
            if (entTrace != null && entTrace.field_72313_a != RayTraceResult.Type.MISS) continue;
            itr.remove();
        }
        return Pair.of((Object)Library.rayTraceIncludeEntities(player, d, f), (Object)ents);
    }

    public static RayTraceResult rayTraceEntitiesInCone(EntityPlayer player, double d, float f, float degrees) {
        double cosDegrees = Math.cos(Math.toRadians(degrees));
        Vec3d vec3 = Library.getPosition(f, player);
        vec3 = vec3.func_72441_c(0.0, (double)player.eyeHeight, 0.0);
        Vec3d vec31 = player.func_70676_i(f);
        Vec3d vec32 = vec3.func_72441_c(vec31.field_72450_a * d, vec31.field_72448_b * d, vec31.field_72449_c * d);
        RayTraceResult result = player.field_70170_p.func_147447_a(vec3, vec32, false, true, true);
        double runningDot = Double.MIN_VALUE;
        AxisAlignedBB box = new AxisAlignedBB(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c).func_186662_g(1.0 + d);
        List ents = player.field_70170_p.func_175674_a((Entity)player, box, Predicates.and((Predicate)EntitySelectors.field_94557_a, entity -> entity instanceof EntityLiving));
        for (Entity ent : ents) {
            Vec3d entPos = Library.closestPointOnBB(ent.func_174813_aQ(), vec3, vec32);
            Vec3d relativeEntPos = entPos.func_178788_d(vec3).func_72432_b();
            double dot = relativeEntPos.func_72430_b(vec31);
            if (!(dot > cosDegrees) || !(dot > runningDot) || Library.isObstructed(player.field_70170_p, vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, ent.field_70165_t, ent.field_70163_u + (double)ent.func_70047_e() * 0.75, ent.field_70161_v)) continue;
            runningDot = dot;
            result = new RayTraceResult(ent);
            result.field_72307_f = new Vec3d(ent.field_70165_t, ent.field_70163_u + (double)(ent.func_70047_e() / 2.0f), ent.field_70161_v);
        }
        return result;
    }

    public static boolean isBoxCollidingCone(AxisAlignedBB box, Vec3d coneStart, Vec3d coneEnd, float degrees) {
        Vec3d center = box.func_189972_c();
        double radius = center.func_72438_d(new Vec3d(box.field_72336_d, box.field_72337_e, box.field_72334_f));
        Vec3d V = center.func_178788_d(coneStart);
        double VlenSq = V.func_189985_c();
        Vec3d direction = coneEnd.func_178788_d(coneStart);
        double size = direction.func_72433_c();
        double V1len = V.func_72430_b(direction.func_72432_b());
        double angRad = Math.toRadians(degrees);
        double distanceClosestPoint = Math.cos(angRad) * Math.sqrt(VlenSq - V1len * V1len) - V1len * Math.sin(angRad);
        boolean angleCull = distanceClosestPoint > radius;
        boolean frontCull = V1len > radius + size;
        boolean backCull = V1len < -radius;
        return !angleCull && !frontCull && !backCull;
    }

    public static Vec3d closestPointOnBB(AxisAlignedBB box, Vec3d vecA, Vec3d vecB) {
        Vec3d vec3d = Library.collideWithXPlane(box, box.field_72340_a, vecA, vecB);
        Vec3d vec3d1 = Library.collideWithXPlane(box, box.field_72336_d, vecA, vecB);
        if (vec3d1 != null && Library.isClosest(vecA, vecB, vec3d, vec3d1)) {
            vec3d = vec3d1;
        }
        if ((vec3d1 = Library.collideWithYPlane(box, box.field_72338_b, vecA, vecB)) != null && Library.isClosest(vecA, vecB, vec3d, vec3d1)) {
            vec3d = vec3d1;
        }
        if ((vec3d1 = Library.collideWithYPlane(box, box.field_72337_e, vecA, vecB)) != null && Library.isClosest(vecA, vecB, vec3d, vec3d1)) {
            vec3d = vec3d1;
        }
        if ((vec3d1 = Library.collideWithZPlane(box, box.field_72339_c, vecA, vecB)) != null && Library.isClosest(vecA, vecB, vec3d, vec3d1)) {
            vec3d = vec3d1;
        }
        if ((vec3d1 = Library.collideWithZPlane(box, box.field_72334_f, vecA, vecB)) != null && Library.isClosest(vecA, vecB, vec3d, vec3d1)) {
            vec3d = vec3d1;
        }
        return vec3d;
    }

    protected static Vec3d collideWithXPlane(AxisAlignedBB box, double p_186671_1_, Vec3d p_186671_3_, Vec3d p_186671_4_) {
        Vec3d vec3d = Library.getIntermediateWithXValue(p_186671_3_, p_186671_4_, p_186671_1_);
        return Library.clampToBox(box, vec3d);
    }

    protected static Vec3d collideWithYPlane(AxisAlignedBB box, double p_186663_1_, Vec3d p_186663_3_, Vec3d p_186663_4_) {
        Vec3d vec3d = Library.getIntermediateWithYValue(p_186663_3_, p_186663_4_, p_186663_1_);
        return Library.clampToBox(box, vec3d);
    }

    protected static Vec3d collideWithZPlane(AxisAlignedBB box, double p_186665_1_, Vec3d p_186665_3_, Vec3d p_186665_4_) {
        Vec3d vec3d = Library.getIntermediateWithZValue(p_186665_3_, p_186665_4_, p_186665_1_);
        return Library.clampToBox(box, vec3d);
    }

    protected static Vec3d clampToBox(AxisAlignedBB box, Vec3d vec) {
        return new Vec3d(MathHelper.func_151237_a((double)vec.field_72450_a, (double)box.field_72340_a, (double)box.field_72336_d), MathHelper.func_151237_a((double)vec.field_72448_b, (double)box.field_72338_b, (double)box.field_72337_e), MathHelper.func_151237_a((double)vec.field_72449_c, (double)box.field_72339_c, (double)box.field_72334_f));
    }

    protected static boolean isClosest(Vec3d line1, Vec3d line2, @Nullable Vec3d p_186661_2_, Vec3d p_186661_3_) {
        double d2;
        if (p_186661_2_ == null) {
            return true;
        }
        double d1 = Library.dist_to_segment_squared(p_186661_3_, line1, line2);
        if (Math.abs(d1 - (d2 = Library.dist_to_segment_squared(p_186661_2_, line1, line2))) < 0.01) {
            return line1.func_72436_e(p_186661_3_) < line1.func_72436_e(p_186661_2_);
        }
        return d1 < d2;
    }

    protected static double dist_to_segment_squared(Vec3d point, Vec3d linePoint1, Vec3d linePoint2) {
        double line_dist = linePoint1.func_72436_e(linePoint2);
        if (line_dist == 0.0) {
            return point.func_72436_e(linePoint1);
        }
        double t = ((point.field_72450_a - linePoint1.field_72450_a) * (linePoint2.field_72450_a - linePoint1.field_72450_a) + (point.field_72448_b - linePoint1.field_72448_b) * (linePoint2.field_72448_b - linePoint1.field_72448_b) + (point.field_72449_c - linePoint1.field_72449_c) * (linePoint2.field_72449_c - linePoint1.field_72449_c)) / line_dist;
        t = MathHelper.func_151237_a((double)t, (double)0.0, (double)1.0);
        Vec3d pointOnLine = new Vec3d(linePoint1.field_72450_a + t * (linePoint2.field_72450_a - linePoint1.field_72450_a), linePoint1.field_72448_b + t * (linePoint2.field_72448_b - linePoint1.field_72448_b), linePoint1.field_72449_c + t * (linePoint2.field_72449_c - linePoint1.field_72449_c));
        return point.func_72436_e(pointOnLine);
    }

    @Nullable
    public static Vec3d getIntermediateWithXValue(Vec3d vec1, Vec3d vec, double x) {
        double d0 = vec.field_72450_a - vec1.field_72450_a;
        double d1 = vec.field_72448_b - vec1.field_72448_b;
        double d2 = vec.field_72449_c - vec1.field_72449_c;
        if (d0 * d0 < (double)1.0E-7f) {
            return vec;
        }
        double d3 = (x - vec1.field_72450_a) / d0;
        if (d3 < 0.0) {
            return new Vec3d(x, vec.field_72448_b, vec.field_72449_c);
        }
        if (d3 > 1.0) {
            return new Vec3d(x, vec1.field_72448_b, vec1.field_72449_c);
        }
        return new Vec3d(vec1.field_72450_a + d0 * d3, vec1.field_72448_b + d1 * d3, vec1.field_72449_c + d2 * d3);
    }

    @Nullable
    public static Vec3d getIntermediateWithYValue(Vec3d vec1, Vec3d vec, double y) {
        double d0 = vec.field_72450_a - vec1.field_72450_a;
        double d1 = vec.field_72448_b - vec1.field_72448_b;
        double d2 = vec.field_72449_c - vec1.field_72449_c;
        if (d1 * d1 < (double)1.0E-7f) {
            return vec;
        }
        double d3 = (y - vec1.field_72448_b) / d1;
        if (d3 < 0.0) {
            return new Vec3d(vec.field_72450_a, y, vec.field_72449_c);
        }
        if (d3 > 1.0) {
            return new Vec3d(vec1.field_72450_a, y, vec1.field_72449_c);
        }
        return new Vec3d(vec1.field_72450_a + d0 * d3, vec1.field_72448_b + d1 * d3, vec1.field_72449_c + d2 * d3);
    }

    @Nullable
    public static Vec3d getIntermediateWithZValue(Vec3d vec1, Vec3d vec, double z) {
        double d0 = vec.field_72450_a - vec1.field_72450_a;
        double d1 = vec.field_72448_b - vec1.field_72448_b;
        double d2 = vec.field_72449_c - vec1.field_72449_c;
        if (d2 * d2 < (double)1.0E-7f) {
            return vec;
        }
        double d3 = (z - vec1.field_72449_c) / d2;
        if (d3 < 0.0) {
            return new Vec3d(vec.field_72450_a, vec.field_72448_b, z);
        }
        if (d3 > 1.0) {
            return new Vec3d(vec1.field_72450_a, vec1.field_72448_b, z);
        }
        return new Vec3d(vec1.field_72450_a + d0 * d3, vec1.field_72448_b + d1 * d3, vec1.field_72449_c + d2 * d3);
    }

    public static Vec3d getEuler(Vec3d vec) {
        double yaw = Math.toDegrees(Math.atan2(vec.field_72450_a, vec.field_72449_c));
        double sqrt = MathHelper.func_76133_a((double)(vec.field_72450_a * vec.field_72450_a + vec.field_72449_c * vec.field_72449_c));
        double pitch = Math.toDegrees(Math.atan2(vec.field_72448_b, sqrt));
        return new Vec3d(yaw, pitch, 0.0);
    }

    public static double smoothstep(double t, double edge0, double edge1) {
        t = MathHelper.func_151237_a((double)((t - edge0) / (edge1 - edge0)), (double)0.0, (double)1.0);
        return t * t * (3.0 - 2.0 * t);
    }

    public static float smoothstep(float t, float edge0, float edge1) {
        t = MathHelper.func_76131_a((float)((t - edge0) / (edge1 - edge0)), (float)0.0f, (float)1.0f);
        return t * t * (3.0f - 2.0f * t);
    }

    public static Vec3d getPosition(float interpolation, EntityPlayer player) {
        if (interpolation == 1.0f) {
            return new Vec3d(player.field_70165_t, player.field_70163_u + (double)(player.func_70047_e() - player.getDefaultEyeHeight()), player.field_70161_v);
        }
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)interpolation;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)interpolation + (double)(player.func_70047_e() - player.getDefaultEyeHeight());
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)interpolation;
        return new Vec3d(d0, d1, d2);
    }

    public static boolean canConnect(IBlockAccess world, BlockPos pos, ForgeDirection dir) {
        IEnergyConnectorBlock con;
        if (world instanceof World ? ((World)world).func_189509_E(pos) : pos.func_177956_o() < 0 || pos.func_177956_o() > 255) {
            return false;
        }
        Block b = world.func_180495_p(pos).func_177230_c();
        if (b instanceof IEnergyConnectorBlock && (con = (IEnergyConnectorBlock)b).canConnect(world, pos, dir.getOpposite())) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEnergyConnector) {
            IEnergyConnector con2 = (IEnergyConnector)te;
            return con2.canConnect(dir.getOpposite());
        }
        return false;
    }

    public static boolean areItemsEqual(ItemStack stackA, ItemStack stackB) {
        if (stackA == null & stackB == null) {
            return true;
        }
        if (stackA == null && stackB != null || stackA != null && stackB == null) {
            return false;
        }
        return stackA.func_77960_j() == stackB.func_77960_j() && stackA.func_77973_b() == stackB.func_77973_b();
    }

    public static boolean hasInventoryItem(InventoryPlayer inventory, Item ammo) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_77973_b() != ammo) continue;
            return true;
        }
        return false;
    }

    public static boolean hasInventoryOreDict(InventoryPlayer inventory, String name) {
        int oreId = OreDictionary.getOreID((String)name);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            int[] ids;
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
                if (id != oreId) continue;
                return true;
            }
        }
        return false;
    }

    public static int countInventoryItem(InventoryPlayer inventory, Item ammo) {
        int count = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_77973_b() != ammo) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    public static void consumeInventoryItem(InventoryPlayer inventory, Item ammo) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_77973_b() != ammo || stack.func_190926_b()) continue;
            stack.func_190918_g(1);
            inventory.func_70299_a(i, stack.func_77946_l());
            return;
        }
    }

    public static void consumeInventoryOreDict(InventoryPlayer inventory, String name) {
        int oreId = OreDictionary.getOreID((String)name);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            int[] ids;
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
                if (id != oreId) continue;
                stack.func_190918_g(1);
                inventory.func_70299_a(i, stack.func_77946_l());
                return;
            }
        }
    }

    public static EntityLivingBase getClosestEntityForChopper(World world, double x, double y, double z, double radius) {
        double d4 = -1.0;
        EntityLivingBase entityplayer = null;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            EntityLivingBase entityplayer1;
            if (!(world.field_72996_f.get(i) instanceof EntityLivingBase) || world.field_72996_f.get(i) instanceof EntityHunterChopper || !(entityplayer1 = (EntityLivingBase)world.field_72996_f.get(i)).func_70089_S() || entityplayer1 instanceof EntityPlayer && ((EntityPlayer)entityplayer1).field_71075_bZ.field_75102_a) continue;
            double d5 = entityplayer1.func_70092_e(x, y, z);
            double d6 = radius;
            if (entityplayer1.func_70093_af()) {
                d6 = radius * (double)0.8f;
            }
            if (!(radius < 0.0) && !(d5 < d6 * d6) || d4 != -1.0 && !(d4 > d5)) continue;
            d4 = d5;
            entityplayer = entityplayer1;
        }
        return entityplayer;
    }

    public static void generateChestContents(Random p_76293_0_, WeightedRandomChestContentFrom1710[] p_76293_1_, ICapabilityProvider p_76293_2_, int p_76293_3_) {
        IItemHandler test;
        if (p_76293_2_.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (test = (IItemHandler)p_76293_2_.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable inventory = (IItemHandlerModifiable)test;
            for (int j = 0; j < p_76293_3_; ++j) {
                ItemStack[] stacks;
                WeightedRandomChestContentFrom1710 weightedrandomchestcontent = (WeightedRandomChestContentFrom1710)WeightedRandom.func_76271_a((Random)p_76293_0_, Arrays.asList(p_76293_1_));
                for (ItemStack item : stacks = weightedrandomchestcontent.generateChestContent(p_76293_0_, inventory)) {
                    inventory.setStackInSlot(p_76293_0_.nextInt(inventory.getSlots()), item);
                }
            }
        }
    }

    public static Block getRandomConcrete() {
        int i = rand.nextInt(100);
        if (i < 5) {
            return ModBlocks.brick_concrete_broken;
        }
        if (i < 20) {
            return ModBlocks.brick_concrete_cracked;
        }
        if (i < 50) {
            return ModBlocks.brick_concrete_mossy;
        }
        return ModBlocks.brick_concrete;
    }

    public static void placeDoorWithoutCheck(World worldIn, BlockPos pos, EnumFacing facing, Block door, boolean isRightHinge) {
        BlockPos blockpos2 = pos.func_177984_a();
        boolean flag2 = worldIn.func_175640_z(pos) || worldIn.func_175640_z(blockpos2);
        IBlockState iblockstate = door.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)facing).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)(isRightHinge ? BlockDoor.EnumHingePosition.RIGHT : BlockDoor.EnumHingePosition.LEFT)).func_177226_a((IProperty)BlockDoor.field_176522_N, (Comparable)Boolean.valueOf(flag2)).func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf(flag2));
        worldIn.func_180501_a(pos, iblockstate.func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER), 2);
        worldIn.func_180501_a(blockpos2, iblockstate.func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER), 2);
        worldIn.func_175685_c(pos, door, false);
        worldIn.func_175685_c(blockpos2, door, false);
    }

    public static boolean areItemStacksEqualIgnoreCount(ItemStack a, ItemStack b) {
        if (a.func_190926_b() && b.func_190926_b()) {
            return true;
        }
        if (!a.func_190926_b() && !b.func_190926_b()) {
            if (a.func_77973_b() != b.func_77973_b()) {
                return false;
            }
            if (a.func_77960_j() != b.func_77960_j()) {
                return false;
            }
            return (a.func_77978_p() == null || a.func_77978_p().equals((Object)b.func_77978_p())) && a.areCapsCompatible(b);
        }
        return false;
    }

    public static boolean areItemStacksCompatible(ItemStack base, ItemStack toTest, boolean shouldCompareSize) {
        if (base.func_190926_b() && toTest.func_190926_b()) {
            return true;
        }
        if (!base.func_190926_b() && !toTest.func_190926_b()) {
            if (shouldCompareSize && base.func_190916_E() != toTest.func_190916_E()) {
                return false;
            }
            if (base.func_77973_b() != toTest.func_77973_b()) {
                return false;
            }
            if (base.func_77960_j() != toTest.func_77960_j() && base.func_77960_j() != Short.MAX_VALUE) {
                return false;
            }
            if (base.func_77978_p() == null && toTest.func_77978_p() != null) {
                return false;
            }
            return (base.func_77978_p() == null || Library.tagContainsOther(base.func_77978_p(), toTest.func_77978_p())) && base.areCapsCompatible(toTest);
        }
        return false;
    }

    public static boolean areItemStacksCompatible(ItemStack base, ItemStack toTest) {
        return Library.areItemStacksCompatible(base, toTest, true);
    }

    public static boolean tagContainsOther(NBTTagCompound tester, NBTTagCompound container) {
        if (tester == null && container == null) {
            return true;
        }
        if (tester == null && container != null) {
            return true;
        }
        if (tester == null || container != null) {
            for (String s : tester.func_150296_c()) {
                if (!container.func_74764_b(s)) {
                    return false;
                }
                NBTBase nbt1 = tester.func_74781_a(s);
                NBTBase nbt2 = container.func_74781_a(s);
                if (!(nbt1 instanceof NBTTagCompound && nbt2 instanceof NBTTagCompound ? !Library.tagContainsOther((NBTTagCompound)nbt1, (NBTTagCompound)nbt2) : !nbt1.equals((Object)nbt2))) continue;
                return false;
            }
        }
        return true;
    }

    public static List<int[]> getBlockPosInPath(BlockPos pos, int length, Vec3 vec0) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        int i = 0;
        while (i <= length) {
            list.add(new int[]{(int)((double)pos.func_177958_n() + vec0.xCoord * (double)i), pos.func_177956_o(), (int)((double)pos.func_177952_p() + vec0.zCoord * (double)i), i++});
        }
        return list;
    }

    public static List<ItemStack> copyItemStackList(List<ItemStack> inputs) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        inputs.forEach(stack -> list.add(stack.func_77946_l()));
        return list;
    }

    public static List<List<ItemStack>> copyItemStackListList(List<List<ItemStack>> inputs) {
        ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>(inputs.size());
        inputs.forEach(list2 -> {
            ArrayList newList = new ArrayList(list2.size());
            list2.forEach(stack -> newList.add(stack.func_77946_l()));
            list.add(newList);
        });
        return list;
    }

    public static HbmLivingCapability.IEntityHbmProps getEntRadCap(Entity e) {
        if (e.hasCapability(HbmLivingCapability.EntityHbmPropsProvider.ENT_HBM_PROPS_CAP, null)) {
            return (HbmLivingCapability.IEntityHbmProps)e.getCapability(HbmLivingCapability.EntityHbmPropsProvider.ENT_HBM_PROPS_CAP, null);
        }
        return HbmLivingCapability.EntityHbmPropsProvider.DUMMY;
    }

    public static void addToInventoryOrDrop(EntityPlayer player, ItemStack stack) {
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, false);
        }
    }

    public static Vec3d normalFromRayTrace(RayTraceResult r) {
        Vec3i n = r.field_178784_b.func_176730_m();
        return new Vec3d((double)n.func_177958_n(), (double)n.func_177956_o(), (double)n.func_177952_p());
    }

    public static Explosion explosionDummy(World w, double x, double y, double z) {
        return new Explosion(w, null, x, y, z, 1000.0f, false, false);
    }
}

