/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.main;

import com.google.common.collect.Multimap;
import com.hbm.blocks.ModBlocks;
import com.hbm.capability.HbmCapability;
import com.hbm.capability.HbmLivingCapability;
import com.hbm.capability.HbmLivingProps;
import com.hbm.config.CompatibilityConfig;
import com.hbm.config.GeneralConfig;
import com.hbm.crafting.handlers.MKUCraftingHandler;
import com.hbm.entity.logic.IChunkLoader;
import com.hbm.entity.mob.EntityCyberCrab;
import com.hbm.entity.mob.EntityTaintedCreeper;
import com.hbm.entity.projectile.EntityBurningFOEQ;
import com.hbm.handler.ArmorModHandler;
import com.hbm.handler.ArmorUtil;
import com.hbm.handler.BossSpawnHandler;
import com.hbm.handler.EntityEffectHandler;
import com.hbm.handler.HTTPHandler;
import com.hbm.handler.HbmKeybinds;
import com.hbm.handler.JetpackHandler;
import com.hbm.handler.MissileStruct;
import com.hbm.handler.WeightedRandomChestContentFrom1710;
import com.hbm.hazard.HazardSystem;
import com.hbm.inventory.AssemblerRecipes;
import com.hbm.items.IEquipReceiver;
import com.hbm.items.ModItems;
import com.hbm.items.armor.ItemArmorMod;
import com.hbm.items.armor.ItemModRevive;
import com.hbm.items.armor.ItemModShackles;
import com.hbm.items.gear.ArmorFSB;
import com.hbm.items.gear.ModShield;
import com.hbm.items.special.ItemHot;
import com.hbm.items.tool.ItemDigammaDiagnostic;
import com.hbm.items.weapon.ItemGunBase;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.AdvancementManager;
import com.hbm.main.CraftingManager;
import com.hbm.packet.AssemblerRecipeSyncPacket;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.KeybindPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.PlayerInformPacket;
import com.hbm.packet.SurveyPacket;
import com.hbm.particle.bullet_hit.EntityHitDataHandler;
import com.hbm.potion.HbmDetox;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.tileentity.network.RTTYSystem;
import com.hbm.util.ArmorRegistry;
import com.hbm.util.EnchantmentUtil;
import com.hbm.util.EntityDamageUtil;
import com.hbm.world.generator.TimedGenerator;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChanceWithLooting;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.DataSerializerEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.math.NumberUtils;

public class ModEventHandler {
    public static final ResourceLocation ENT_HBM_PROP_ID = new ResourceLocation("hbm", "HBMLIVINGPROPS");
    public static final ResourceLocation DATA_LOC = new ResourceLocation("hbm", "HBMDATA");
    public static boolean showMessage = true;
    public static Random rand = new Random();
    private static final Set<String> hashes = new HashSet<String>();
    public static Field r_handInventory;
    public static Field r_armorArray;

    @SubscribeEvent
    public void soundRegistering(RegistryEvent.Register<SoundEvent> evt) {
        for (SoundEvent e : HBMSoundHandler.ALL_SOUNDS) {
            evt.getRegistry().register((IForgeRegistryEntry)e);
        }
    }

    @SubscribeEvent
    public void attachRadCap(AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof EntityLivingBase) {
            e.addCapability(ENT_HBM_PROP_ID, (ICapabilityProvider)new HbmLivingCapability.EntityHbmPropsProvider());
        }
        if (e.getObject() instanceof EntityPlayer) {
            e.addCapability(DATA_LOC, (ICapabilityProvider)new HbmCapability.HBMDataProvider());
        }
    }

    @SubscribeEvent
    public void potionCheck(PotionEvent.PotionApplicableEvent e) {
        if (HbmDetox.isBlacklisted(e.getPotionEffect().func_188419_a()) && ArmorUtil.checkForHazmat(e.getEntityLiving()) && ArmorRegistry.hasProtection(e.getEntityLiving(), EntityEquipmentSlot.HEAD, ArmorRegistry.HazardClass.BACTERIA)) {
            e.setResult(Event.Result.DENY);
            ArmorUtil.damageGasMaskFilter(e.getEntityLiving(), 10);
        }
    }

    @SubscribeEvent
    public void enteringChunk(EntityEvent.EnteringChunk evt) {
        Entity entity = evt.getEntity();
        if (entity instanceof IChunkLoader) {
            IChunkLoader ech = (IChunkLoader)entity;
            ech.loadNeighboringChunks(evt.getNewChunkX(), evt.getNewChunkZ(), evt.getOldChunkX(), evt.getOldChunkZ());
        }
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        ItemStack[] mods;
        ItemStack cladding;
        ItemStack yeet = event.getEntityItem().func_92059_d();
        if (yeet.func_77973_b() instanceof ItemArmor && ArmorModHandler.hasMods(yeet) && (cladding = (mods = ArmorModHandler.pryMods(yeet))[5]) != null && cladding.func_77973_b() == ModItems.cladding_obsidian) {
            event.getEntity().func_184224_h(true);
        }
        if (yeet.func_77973_b() == ModItems.bismuth_tool) {
            event.getEntity().func_184224_h(true);
        }
    }

    @SubscribeEvent
    public void lootTableLoad(LootTableLoadEvent e) {
        if (CompatibilityConfig.modLoot) {
            this.addWeightedRandomToLootTable(e, LootTableList.field_186423_e, new WeightedRandomChestContentFrom1710(new ItemStack(ModItems.armor_polish), 1, 1, 3));
            this.addWeightedRandomToLootTable(e, LootTableList.field_186423_e, new WeightedRandomChestContentFrom1710(new ItemStack(ModItems.bathwater), 1, 1, 1));
            this.addWeightedRandomToLootTable(e, LootTableList.field_186424_f, new WeightedRandomChestContentFrom1710(new ItemStack(ModItems.bathwater), 1, 1, 1));
            this.addWeightedRandomToLootTable(e, LootTableList.field_186424_f, new WeightedRandomChestContentFrom1710(new ItemStack(ModItems.serum), 1, 1, 5));
            this.addWeightedRandomToLootTable(e, LootTableList.field_186422_d, new WeightedRandomChestContentFrom1710(new ItemStack(ModItems.heart_piece), 1, 1, 1));
            this.addWeightedRandomToLootTable(e, LootTableList.field_186429_k, new WeightedRandomChestContentFrom1710(new ItemStack(ModItems.heart_piece), 1, 1, 1));
            this.addWeightedRandomToLootTable(e, LootTableList.field_186430_l, new WeightedRandomChestContentFrom1710(new ItemStack(ModItems.heart_piece), 1, 1, 1));
            this.addWeightedRandomToLootTable(e, LootTableList.field_186422_d, new WeightedRandomChestContentFrom1710(new ItemStack(ModItems.scrumpy), 1, 1, 1));
            this.addWeightedRandomToLootTable(e, LootTableList.field_186429_k, new WeightedRandomChestContentFrom1710(new ItemStack(ModItems.scrumpy), 1, 1, 1));
        }
    }

    private void addWeightedRandomToLootTable(LootTableLoadEvent e, ResourceLocation loc, final WeightedRandomChestContentFrom1710 content) {
        if (e.getName().equals((Object)loc)) {
            LootCondition[] conds = new LootCondition[]{};
            LootFunction[] funcs = new LootFunction[]{new LootFunction(conds){

                public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
                    ItemStack sta = content.theItemId.func_77946_l();
                    sta.func_190920_e(content.theMinimumChanceToGenerateItem + rand.nextInt(content.theMaximumChanceToGenerateItem - content.theMinimumChanceToGenerateItem + 1));
                    return sta;
                }
            }};
            LootEntryItem entry = new LootEntryItem(content.theItemId.func_77973_b(), content.field_76292_a, 1, funcs, conds, content.theItemId.func_77977_a() + "_loot");
            LootPool pool = new LootPool(new LootEntry[]{entry}, new LootCondition[]{new RandomChanceWithLooting(0.25f, 0.1f)}, new RandomValueRange(1.0f), new RandomValueRange(0.0f), content.theItemId.func_77977_a() + "_loot");
            e.getTable().addPool(pool);
        }
    }

    @SubscribeEvent
    public void itemSmelted(PlayerEvent.ItemSmeltedEvent e) {
        if (!e.player.field_70170_p.field_72995_K && e.smelting.func_77973_b() == Items.field_151042_j && e.player.func_70681_au().nextInt(64) == 0) {
            if (!e.player.field_71071_by.func_70441_a(new ItemStack(ModItems.lodestone))) {
                e.player.func_71019_a(new ItemStack(ModItems.lodestone), false);
            } else {
                e.player.field_71069_bz.func_75142_b();
            }
        }
        if (!e.player.field_70170_p.field_72995_K && e.smelting.func_77973_b() == ModItems.ingot_uranium && e.player.func_70681_au().nextInt(64) == 0) {
            if (!e.player.field_71071_by.func_70441_a(new ItemStack(ModItems.quartz_plutonium))) {
                e.player.func_71019_a(new ItemStack(ModItems.quartz_plutonium), false);
            } else {
                e.player.field_71069_bz.func_75142_b();
            }
        }
    }

    public boolean canWear(Entity entity) {
        return entity instanceof EntityZombie || entity instanceof EntitySkeleton || entity instanceof EntityVillager || entity instanceof EntityIronGolem;
    }

    @SubscribeEvent
    public void mobSpawn(LivingSpawnEvent.SpecialSpawn event) {
        if (CompatibilityConfig.mobGear) {
            EntityLivingBase entity = event.getEntityLiving();
            World world = event.getWorld();
            if (entity instanceof EntityLiving && this.canWear((Entity)entity)) {
                boolean hasFeet;
                int randomArmorNumber = rand.nextInt(131072);
                int randomHandNumber = rand.nextInt(256);
                EntityLiving mob = (EntityLiving)entity;
                boolean hasMainHand = !mob.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b();
                boolean hasOffHand = !mob.func_184582_a(EntityEquipmentSlot.OFFHAND).func_190926_b();
                boolean hasHat = !mob.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b();
                boolean hasChest = !mob.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b();
                boolean hasLegs = !mob.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b();
                boolean bl = hasFeet = !mob.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b();
                if (!hasHat) {
                    if (rand.nextInt(64) == 0) {
                        entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ModItems.gas_mask_m65, 1, world.field_73012_v.nextInt(100)));
                    }
                    if (rand.nextInt(128) == 0) {
                        entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ModItems.gas_mask, 1, world.field_73012_v.nextInt(100)));
                    }
                    if (rand.nextInt(256) == 0) {
                        entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ModItems.mask_of_infamy, 1, world.field_73012_v.nextInt(100)));
                    }
                }
                if (!(hasHat || hasChest || hasLegs || hasFeet)) {
                    if (randomArmorNumber < 2) {
                        entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ModItems.dns_helmet, 1));
                        entity.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(ModItems.dns_plate, 1));
                        entity.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(ModItems.dns_legs, 1));
                        entity.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(ModItems.dns_boots, 1));
                    } else if (randomArmorNumber < 128) {
                        entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ModItems.rpa_helmet, 1));
                        entity.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(ModItems.rpa_plate, 1));
                        entity.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(ModItems.rpa_legs, 1));
                        entity.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(ModItems.rpa_boots, 1));
                    } else if (randomArmorNumber < 512) {
                        entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ModItems.ajr_helmet, 1));
                        entity.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(ModItems.ajr_plate, 1));
                        entity.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(ModItems.ajr_legs, 1));
                        entity.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(ModItems.ajr_boots, 1));
                    } else if (randomArmorNumber < 2048) {
                        entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ModItems.t45_helmet, 1));
                        entity.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(ModItems.t45_plate, 1));
                        entity.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(ModItems.t45_legs, 1));
                        entity.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(ModItems.t45_boots, 1));
                    } else if (randomArmorNumber < 4096) {
                        entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ModItems.hazmat_helmet, 1, world.field_73012_v.nextInt(ModItems.hazmat_helmet.getMaxDamage(ItemStack.field_190927_a))));
                        entity.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(ModItems.hazmat_plate, 1, world.field_73012_v.nextInt(ModItems.hazmat_helmet.getMaxDamage(ItemStack.field_190927_a))));
                        entity.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(ModItems.hazmat_legs, 1, world.field_73012_v.nextInt(ModItems.hazmat_helmet.getMaxDamage(ItemStack.field_190927_a))));
                        entity.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(ModItems.hazmat_boots, 1, world.field_73012_v.nextInt(ModItems.hazmat_helmet.getMaxDamage(ItemStack.field_190927_a))));
                    } else if (randomArmorNumber < 8192) {
                        entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ModItems.titanium_helmet, 1, world.field_73012_v.nextInt(ModItems.titanium_helmet.getMaxDamage(ItemStack.field_190927_a))));
                        entity.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(ModItems.titanium_plate, 1, world.field_73012_v.nextInt(ModItems.titanium_plate.getMaxDamage(ItemStack.field_190927_a))));
                        entity.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(ModItems.titanium_legs, 1, world.field_73012_v.nextInt(ModItems.titanium_legs.getMaxDamage(ItemStack.field_190927_a))));
                        entity.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(ModItems.titanium_boots, 1, world.field_73012_v.nextInt(ModItems.titanium_boots.getMaxDamage(ItemStack.field_190927_a))));
                    } else if (randomArmorNumber < 16384) {
                        entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ModItems.steel_helmet, 1, world.field_73012_v.nextInt(ModItems.steel_helmet.getMaxDamage(ItemStack.field_190927_a))));
                        entity.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(ModItems.steel_plate, 1, world.field_73012_v.nextInt(ModItems.steel_plate.getMaxDamage(ItemStack.field_190927_a))));
                        entity.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(ModItems.steel_legs, 1, world.field_73012_v.nextInt(ModItems.steel_legs.getMaxDamage(ItemStack.field_190927_a))));
                        entity.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(ModItems.steel_boots, 1, world.field_73012_v.nextInt(ModItems.steel_boots.getMaxDamage(ItemStack.field_190927_a))));
                    }
                }
                if (!hasMainHand) {
                    if (randomHandNumber == 0) {
                        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModItems.pipe_lead, 1, world.field_73012_v.nextInt(100)));
                    } else if (randomHandNumber == 1) {
                        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModItems.reer_graar, 1, world.field_73012_v.nextInt(100)));
                    } else if (randomHandNumber == 2) {
                        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModItems.pipe_rusty, 1, world.field_73012_v.nextInt(100)));
                    } else if (randomHandNumber == 3) {
                        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModItems.crowbar, 1, world.field_73012_v.nextInt(100)));
                    } else if (randomHandNumber == 4) {
                        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModItems.steel_pickaxe, 1, world.field_73012_v.nextInt(300)));
                    } else if (randomHandNumber == 5) {
                        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModItems.bat, 1, world.field_73012_v.nextInt(300)));
                    } else if (randomHandNumber == 6) {
                        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModItems.bat_nail, 1, world.field_73012_v.nextInt(300)));
                    } else if (randomHandNumber == 7) {
                        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModItems.golf_club, 1, world.field_73012_v.nextInt(300)));
                    } else if (randomHandNumber == 8) {
                        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModItems.titanium_sword, 1, world.field_73012_v.nextInt(300)));
                    } else if (randomHandNumber == 9) {
                        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModItems.steel_sword, 1, world.field_73012_v.nextInt(300)));
                    } else if (randomHandNumber == 10) {
                        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModItems.stopsign));
                    } else if (randomHandNumber == 11) {
                        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModItems.sopsign));
                    } else if (randomHandNumber == 12) {
                        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModItems.chernobylsign));
                    }
                }
                if (!hasOffHand && rand.nextInt(128) == 0) {
                    entity.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(ModItems.geiger_counter, 1));
                }
            }
        }
    }

    @SubscribeEvent
    public void onClickSign(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = event.getPos();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)tileEntity;
            String result = this.smoosh(sign.field_145915_a[0].func_150260_c(), sign.field_145915_a[1].func_150260_c(), sign.field_145915_a[2].func_150260_c(), sign.field_145915_a[3].func_150260_c());
            if (hashes.contains(result)) {
                world.func_175655_b(pos, false);
                EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack(ModItems.bobmazon_hidden));
                entityitem.func_174867_a(10);
                world.func_72838_d((Entity)entityitem);
            }
        }
    }

    private String smoosh(String s1, String s2, String s3, String s4) {
        Random rand = new Random();
        String s = "";
        byte[] b1 = s1.getBytes();
        byte[] b2 = s2.getBytes();
        byte[] b3 = s3.getBytes();
        byte[] b4 = s4.getBytes();
        if (b1.length == 0 || b2.length == 0 || b3.length == 0 || b4.length == 0) {
            return "";
        }
        s = s + s1;
        rand.setSeed(b1[0]);
        s = s + rand.nextInt(0xFFFFFF);
        s = s + s2;
        rand.setSeed(rand.nextInt(0xFFFFFF) + b2[0]);
        rand.setSeed(b2[0]);
        s = s + rand.nextInt(0xFFFFFF);
        s = s + s3;
        rand.setSeed(rand.nextInt(0xFFFFFF) + b3[0]);
        rand.setSeed(b3[0]);
        s = s + rand.nextInt(0xFFFFFF);
        s = s + s4;
        rand.setSeed(rand.nextInt(0xFFFFFF) + b4[0]);
        rand.setSeed(b4[0]);
        s = s + rand.nextInt(0xFFFFFF);
        return this.getHash(s);
    }

    private String getHash(String inp) {
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            byte[] bytes = sha256.digest(inp.getBytes());
            StringBuilder str = new StringBuilder();
            for (byte b : bytes) {
                str.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
            }
            return str.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "";
        }
    }

    @SubscribeEvent
    public void chatEvent(ServerChatEvent event) {
        EntityPlayerMP player = event.getPlayer();
        String message = event.getMessage();
        if (GeneralConfig.enableDebugMode && player.func_110124_au().toString().equals(Library.HbMinecraft) && message.startsWith("!")) {
            String[] msg = message.split(" ");
            String m = msg[0].substring(1, msg[0].length()).toLowerCase();
            if ("gv".equals(m)) {
                Item item;
                int id = 0;
                int size = 1;
                int meta = 0;
                if (msg.length > 1 && NumberUtils.isCreatable((String)msg[1])) {
                    id = (int)NumberUtils.createDouble((String)msg[1]).doubleValue();
                }
                if (msg.length > 2 && NumberUtils.isCreatable((String)msg[2])) {
                    size = (int)NumberUtils.createDouble((String)msg[2]).doubleValue();
                }
                if (msg.length > 3 && NumberUtils.isCreatable((String)msg[3])) {
                    meta = (int)NumberUtils.createDouble((String)msg[3]).doubleValue();
                }
                if ((item = Item.func_150899_d((int)id)) != null && size > 0 && meta >= 0) {
                    player.field_71071_by.func_70441_a(new ItemStack(item, size, meta));
                }
            }
            player.field_71069_bz.func_75142_b();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (event.world != null && !event.world.field_72995_K && event.world.func_82737_E() % 100L == 97L) {
            PacketDispatcher.wrapper.sendToAll((IMessage)new SurveyPacket(RBMKDials.getColumnHeight(event.world)));
        }
        if (event.phase == TickEvent.Phase.START) {
            BossSpawnHandler.rollTheDice(event.world);
            TimedGenerator.automaton(event.world, 100);
        }
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            JetpackHandler.serverTick();
            RTTYSystem.updateBroadcastQueue();
        } else {
            EntityHitDataHandler.updateSystem();
        }
    }

    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent e) {
        EntityLivingBase ent = e.getEntityLiving();
        if (e.getEntityLiving() instanceof EntityPlayer && ArmorUtil.checkArmor((EntityLivingBase)((EntityPlayer)e.getEntityLiving()), ModItems.euphemium_helmet, ModItems.euphemium_plate, ModItems.euphemium_legs, ModItems.euphemium_boots)) {
            e.setCanceled(true);
        }
        ArmorFSB.handleHurt(e);
        if (EntityDamageUtil.wasAttackedByV1(e.getSource())) {
            EntityPlayer attacker = (EntityPlayer)e.getSource().func_76364_f();
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "vanillaburst");
            data.func_74768_a("count", (int)Math.min(ent.func_110138_aP() / 2.0f, 250.0f));
            data.func_74780_a("motion", 0.1);
            data.func_74778_a("mode", "blockdust");
            data.func_74768_a("block", Block.func_149682_b((Block)Blocks.field_150451_bX));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, ent.field_70165_t, ent.field_70163_u + (double)ent.field_70131_O * 0.5, ent.field_70161_v), new NetworkRegistry.TargetPoint(ent.field_71093_bK, ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, 50.0));
            if (attacker.func_70068_e((Entity)ent) < 25.0) {
                attacker.func_70691_i(e.getAmount() * 0.5f);
            }
        }
        for (int i = 2; i < 6; ++i) {
            ItemStack armor = ent.func_184582_a(EntityEquipmentSlot.values()[i]);
            if (!ArmorModHandler.hasMods(armor)) continue;
            for (ItemStack mod : ArmorModHandler.pryMods(armor)) {
                if (mod == null || !(mod.func_77973_b() instanceof ItemArmorMod)) continue;
                ((ItemArmorMod)mod.func_77973_b()).modDamage(e, armor);
            }
        }
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingAttackEvent event) {
        EntityPlayer player;
        EntityLivingBase e = event.getEntityLiving();
        if (e instanceof EntityPlayer && ArmorUtil.checkArmor(e, ModItems.euphemium_helmet, ModItems.euphemium_plate, ModItems.euphemium_legs, ModItems.euphemium_boots) && event.getSource() != ModDamageSource.digamma) {
            e.field_70170_p.func_184148_a(null, e.field_70165_t, e.field_70163_u, e.field_70161_v, SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 5.0f, 1.0f + e.func_70681_au().nextFloat() * 0.5f);
            event.setCanceled(true);
        }
        if (e instanceof EntityPlayer && (player = (EntityPlayer)e).func_184585_cz()) {
            Item item;
            ItemStack mainHand = player.func_184614_ca();
            ItemStack offHand = player.func_184592_cb();
            Entity cause = event.getSource().func_76364_f();
            if (!mainHand.func_190926_b() && (item = mainHand.func_77973_b()) instanceof ModShield) {
                ModShield shield = (ModShield)item;
                shield.handleImpact((Item)shield, cause, event.getAmount());
            } else if (!offHand.func_190926_b() && (item = offHand.func_77973_b()) instanceof ModShield) {
                ModShield shield = (ModShield)item;
                shield.handleImpact((Item)shield, cause, event.getAmount());
            }
        }
        ArmorFSB.handleAttack(event);
    }

    @SubscribeEvent
    public void onPlayerFall(PlayerFlyableFallEvent event) {
        ArmorFSB.handleFall((EntityLivingBase)event.getEntityPlayer());
    }

    @SubscribeEvent
    public void onEntityFall(LivingFallEvent event) {
        ArmorFSB.handleFall(event.getEntityLiving());
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (!player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.START) {
            if (!Float.isFinite(player.func_110143_aJ()) || !Float.isFinite(player.func_110139_bj())) {
                player.func_145747_a((ITextComponent)new TextComponentString("Your health has been restored!"));
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.syringeUse, SoundCategory.PLAYERS, 1.0f, 1.0f);
                player.func_70606_j(player.func_110138_aP());
                player.func_110149_m(0.0f);
            }
            if (Library.hasInventoryItem(player.field_71071_by, ModItems.beta)) {
                if (player.func_71024_bL().func_75116_a() < 10) {
                    player.func_71024_bL().func_75114_a(10);
                }
                if (player.func_71024_bL().func_75116_a() > 10) {
                    player.func_70691_i((float)(player.func_71024_bL().func_75116_a() - 10));
                    player.func_71024_bL().func_75114_a(10);
                }
            }
            HazardSystem.updatePlayerInventory(player);
        }
        if (!player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.START) {
            ItemDigammaDiagnostic.playVoices(player.field_70170_p, player);
        }
        if (player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.START && !player.func_82150_aj() && !player.func_70093_af() && player.func_110124_au().toString().equals(Library.HbMinecraft)) {
            int i = player.field_70173_aa * 3;
            Vec3 vec = Vec3.createVectorHelper(3.0, 0.0, 0.0);
            vec.rotateAroundY((float)((double)i * Math.PI / 180.0));
            for (int k = 0; k < 5; ++k) {
                vec.rotateAroundY((float)Math.PI / 180);
                player.field_70170_p.func_175688_a(EnumParticleTypes.TOWN_AURA, player.field_70165_t + vec.xCoord, player.field_70163_u + 1.0 + player.field_70170_p.field_73012_v.nextDouble() * 0.05, player.field_70161_v + vec.zCoord, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (event.phase == TickEvent.Phase.END) {
            JetpackHandler.postPlayerTick(event.player);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        HbmLivingProps.setRadiation(event.getEntityLiving(), 0.0f);
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer && ArmorUtil.checkArmor((EntityLivingBase)((EntityPlayer)event.getEntityLiving()), ModItems.euphemium_helmet, ModItems.euphemium_plate, ModItems.euphemium_legs, ModItems.euphemium_boots) && event.getSource() != ModDamageSource.digamma) {
            event.setCanceled(true);
            event.getEntityLiving().func_70606_j(event.getEntityLiving().func_110138_aP());
        }
        if (event.isCancelable() && event.isCanceled()) {
            return;
        }
        if (GeneralConfig.enableCataclysm) {
            EntityBurningFOEQ foeq = new EntityBurningFOEQ(event.getEntity().field_70170_p);
            foeq.func_70080_a(event.getEntity().field_70165_t, 500.0, event.getEntity().field_70161_v, 0.0f, 0.0f);
            event.getEntity().field_70170_p.func_72838_d((Entity)foeq);
        }
        if (event.getEntity().func_110124_au().toString().equals(Library.HbMinecraft)) {
            event.getEntity().func_145779_a(ModItems.book_of_, 1);
        }
        if (event.getEntity().func_110124_au().toString().equals(Library.Alcater)) {
            event.getEntity().func_70099_a(new ItemStack(ModItems.bottle_rad).func_151001_c("\u00a7aAlcater's \u00a72Neo \u00a7aNuka\u00a7r"), 0.5f);
        }
        if (event.getEntity() instanceof EntityTaintedCreeper && event.getSource() == ModDamageSource.boxcar) {
            for (EntityPlayer player : event.getEntity().func_130014_f_().func_72872_a(EntityPlayer.class, event.getEntity().func_174813_aQ().func_72314_b(50.0, 50.0, 50.0))) {
                AdvancementManager.grantAchievement(player, AdvancementManager.bobHidden);
            }
        }
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getSource() instanceof EntityDamageSource && ((EntityDamageSource)event.getSource()).func_76346_g() instanceof EntityPlayer && !(((EntityDamageSource)event.getSource()).func_76346_g() instanceof FakePlayer)) {
            if (event.getEntityLiving() instanceof EntitySpider && event.getEntityLiving().func_70681_au().nextInt(500) == 0) {
                event.getEntityLiving().func_145779_a(ModItems.spider_milk, 1);
            }
            if (event.getEntityLiving() instanceof EntityCaveSpider && event.getEntityLiving().func_70681_au().nextInt(100) == 0) {
                event.getEntityLiving().func_145779_a(ModItems.serum, 1);
            }
            if (event.getEntityLiving() instanceof EntityAnimal && event.getEntityLiving().func_70681_au().nextInt(500) == 0) {
                event.getEntityLiving().func_145779_a(ModItems.bandaid, 1);
            }
            if (event.getEntityLiving() instanceof IMob && event.getEntityLiving().func_70681_au().nextInt(1000) == 0) {
                event.getEntityLiving().func_145779_a(ModItems.heart_piece, 1);
            }
            if (event.getEntityLiving() instanceof EntityCyberCrab && event.getEntityLiving().func_70681_au().nextInt(500) == 0) {
                event.getEntityLiving().func_145779_a(ModItems.wd40, 1);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityDeathFirst(LivingDeathEvent event) {
        for (int i = 2; i < 6; ++i) {
            ItemStack revive;
            ItemStack stack = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.values()[i]);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemArmor) || !ArmorModHandler.hasMods(stack) || (revive = ArmorModHandler.pryMods(stack)[7]) == null) continue;
            if (revive.func_77973_b() instanceof ItemModRevive) {
                revive.func_77964_b(revive.func_77952_i() + 1);
                if (revive.func_77952_i() >= revive.func_77958_k()) {
                    ArmorModHandler.removeMod(stack, 7);
                } else {
                    ArmorModHandler.applyMod(stack, revive);
                }
                event.getEntityLiving().func_70606_j(event.getEntityLiving().func_110138_aP());
                event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76429_m, 60, 99));
                event.setCanceled(true);
                return;
            }
            if (!(revive.func_77973_b() instanceof ItemModShackles) || !(HbmLivingProps.getRadiation(event.getEntityLiving()) < 1000.0f)) continue;
            revive.func_77964_b(revive.func_77952_i() + 1);
            int dmg = revive.func_77952_i();
            ArmorModHandler.applyMod(stack, revive);
            event.getEntityLiving().func_70606_j(event.getEntityLiving().func_110138_aP());
            HbmLivingProps.incrementRadiation(event.getEntityLiving(), dmg * dmg);
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityDeathLast(LivingDeathEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (EntityDamageUtil.wasAttackedByV1(event.getSource())) {
            NBTTagCompound vdat = new NBTTagCompound();
            vdat.func_74778_a("type", "giblets");
            vdat.func_74768_a("ent", entity.func_145782_y());
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(vdat, entity.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O * 0.5, entity.field_70161_v), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O * 0.5, entity.field_70161_v, 150.0));
            entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187929_hc, SoundCategory.HOSTILE, 2.0f, 0.95f + entity.field_70170_p.field_73012_v.nextFloat() * 0.2f);
            EntityPlayer attacker = (EntityPlayer)event.getSource().func_76364_f();
            assert (attacker != null);
            if (attacker.func_70068_e((Entity)entity) < 100.0) {
                attacker.func_70691_i(entity.func_110138_aP() * 0.25f);
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.isCancelable() && event.isCanceled()) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityArmorStand) {
            return;
        }
        ArmorFSB.handleTick(event.getEntityLiving());
        if (r_handInventory == null) {
            r_handInventory = ReflectionHelper.findField(EntityLivingBase.class, (String)"handInventory", (String)"field_184630_bs");
            r_armorArray = ReflectionHelper.findField(EntityLivingBase.class, (String)"armorArray", (String)"field_184631_bt");
        }
        NonNullList armorArray = null;
        try {
            NonNullList handInventory = (NonNullList)r_handInventory.get(event.getEntityLiving());
            armorArray = (NonNullList)r_armorArray.get(event.getEntityLiving());
            if (event.getEntityLiving() instanceof EntityPlayer && event.getEntityLiving().func_184614_ca().func_77973_b() instanceof IEquipReceiver && !ItemStack.func_179545_c((ItemStack)((ItemStack)handInventory.get(0)), (ItemStack)event.getEntityLiving().func_184614_ca())) {
                ((IEquipReceiver)event.getEntityLiving().func_184614_ca().func_77973_b()).onEquip((EntityPlayer)event.getEntityLiving(), EnumHand.MAIN_HAND);
            }
            if (event.getEntityLiving() instanceof EntityPlayer && event.getEntityLiving().func_184592_cb().func_77973_b() instanceof IEquipReceiver && !ItemStack.func_179545_c((ItemStack)((ItemStack)handInventory.get(0)), (ItemStack)event.getEntityLiving().func_184592_cb())) {
                ((IEquipReceiver)event.getEntityLiving().func_184592_cb().func_77973_b()).onEquip((EntityPlayer)event.getEntityLiving(), EnumHand.OFF_HAND);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 2; i < 6; ++i) {
            Multimap<String, AttributeModifier> map;
            boolean reapply;
            ItemStack prev = armorArray != null ? (ItemStack)armorArray.get(i - 2) : null;
            ItemStack armor = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.values()[i]);
            boolean bl = reapply = armorArray != null && !ItemStack.func_77989_b((ItemStack)prev, (ItemStack)armor);
            if (reapply && ArmorModHandler.hasMods(prev)) {
                for (ItemStack mod : ArmorModHandler.pryMods(prev)) {
                    if (mod == null || !(mod.func_77973_b() instanceof ItemArmorMod) || (map = ((ItemArmorMod)mod.func_77973_b()).getModifiers(EntityEquipmentSlot.values()[i], prev)) == null) continue;
                    event.getEntityLiving().func_110140_aT().func_111148_a(map);
                }
            }
            if (!ArmorModHandler.hasMods(armor)) continue;
            for (ItemStack mod : ArmorModHandler.pryMods(armor)) {
                if (mod == null || !(mod.func_77973_b() instanceof ItemArmorMod)) continue;
                ((ItemArmorMod)mod.func_77973_b()).modUpdate(event.getEntityLiving(), armor);
                HazardSystem.applyHazards(mod, event.getEntityLiving());
                if (!reapply || (map = ((ItemArmorMod)mod.func_77973_b()).getModifiers(EntityEquipmentSlot.values()[i], armor)) == null) continue;
                event.getEntityLiving().func_110140_aT().func_111147_b(map);
            }
        }
        EntityEffectHandler.onUpdate(event.getEntityLiving());
        if (!event.getEntityLiving().field_70170_p.field_72995_K && !(event.getEntityLiving() instanceof EntityPlayer)) {
            HazardSystem.updateLivingInventory(event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void onEntityJump(LivingEvent.LivingJumpEvent event) {
        if (event.isCancelable() && event.isCanceled()) {
            return;
        }
        ArmorFSB.handleJump(event.getEntityLiving());
    }

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent event) {
        if (event.isCancelable() && event.isCanceled()) {
            return;
        }
        if (!(event.getPlayer() instanceof EntityPlayerMP)) {
            return;
        }
        Block block = event.getState().func_177230_c();
        if (block == Blocks.field_150365_q || block == Blocks.field_150402_ci || block == ModBlocks.ore_lignite) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                int x = event.getPos().func_177958_n() + dir.offsetX;
                int y = event.getPos().func_177956_o() + dir.offsetY;
                int z = event.getPos().func_177952_p() + dir.offsetZ;
                if (event.getWorld().field_73012_v.nextInt(2) != 0 || event.getWorld().func_180495_p(new BlockPos(x, y, z)).func_177230_c() != Blocks.field_150350_a) continue;
                event.getWorld().func_175656_a(new BlockPos(x, y, z), ModBlocks.gas_coal.func_176223_P());
            }
        }
    }

    @SubscribeEvent
    public void clientJoinServer(PlayerEvent.PlayerLoggedInEvent e) {
        EntityPlayer entityPlayer = e.player;
        if (entityPlayer instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)entityPlayer;
            PacketDispatcher.sendTo(new AssemblerRecipeSyncPacket(AssemblerRecipes.recipeList, AssemblerRecipes.hidden), playerMP);
            JetpackHandler.playerLoggedIn(e);
            HbmCapability.IHBMData props = HbmCapability.getData((Entity)e.player);
            PacketDispatcher.sendTo(new KeybindPacket(HbmKeybinds.EnumKeybind.TOGGLE_JETPACK, props.getEnableBackpack()), playerMP);
            PacketDispatcher.sendTo(new KeybindPacket(HbmKeybinds.EnumKeybind.TOGGLE_HEAD, props.getEnableHUD()), playerMP);
            if (GeneralConfig.enableWelcomeMessage) {
                e.player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.welcome", new Object[0]));
            }
            if (HTTPHandler.newVersion && GeneralConfig.changelog) {
                e.player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.newver", new Object[]{HTTPHandler.versionNumber}));
                e.player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.curver", new Object[]{"NTM-Extended-1.12.2-3.0.3"}));
                if (!Objects.equals(HTTPHandler.changes, "")) {
                    String[] lines = HTTPHandler.changes.split("\\$");
                    e.player.func_145747_a((ITextComponent)new TextComponentString("\u00a76[Some of the new Features]\u00a7r"));
                    for (String w : lines) {
                        e.player.func_145747_a((ITextComponent)new TextComponentString(w));
                    }
                }
            }
            if (HTTPHandler.optifine) {
                e.player.func_145747_a((ITextComponent)new TextComponentString("Optifine detected, may cause compatibility issues. Check log for details."));
            }
            if (GeneralConfig.duckButton && e.player instanceof EntityPlayerMP && !e.player.getEntityData().func_74775_l("PlayerPersisted").func_74767_n("hasDucked")) {
                PacketDispatcher.sendTo(new PlayerInformPacket("chat.duck"), (EntityPlayerMP)e.player);
            }
        }
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load e) {
        JetpackHandler.worldLoad(e);
        MKUCraftingHandler.initMKU(e.getWorld());
    }

    @SubscribeEvent
    public void worldSave(WorldEvent.Save e) {
        JetpackHandler.worldSave(e);
    }

    @SubscribeEvent
    public void onDataSerializerRegister(RegistryEvent.Register<DataSerializerEntry> evt) {
        evt.getRegistry().register((IForgeRegistryEntry)((DataSerializerEntry)new DataSerializerEntry(MissileStruct.SERIALIZER).setRegistryName(new ResourceLocation("hbm", "missile_struct"))));
    }

    @SubscribeEvent
    public void anvilUpdateEvent(AnvilUpdateEvent event) {
        double h2;
        if (event.getLeft().func_77973_b() instanceof ItemGunBase && event.getRight().func_77973_b() == Items.field_151134_bR) {
            event.setOutput(event.getLeft().func_77946_l());
            Map mapright = EnchantmentHelper.func_82781_a((ItemStack)event.getRight());
            for (Map.Entry entry : mapright.entrySet()) {
                Enchantment e = (Enchantment)entry.getKey();
                int j = (Integer)entry.getValue();
                EnchantmentUtil.removeEnchantment(event.getOutput(), e);
                EnchantmentUtil.addEnchantment(event.getOutput(), e, j);
            }
            event.setCost(10);
        }
        if (event.getLeft().func_77973_b() == ModItems.ingot_meteorite && event.getRight().func_77973_b() == ModItems.ingot_meteorite && event.getLeft().func_190916_E() == 1 && event.getRight().func_190916_E() == 1) {
            double h1 = ItemHot.getHeat(event.getLeft());
            double h22 = ItemHot.getHeat(event.getRight());
            if (h1 >= 0.5 && h22 >= 0.5) {
                ItemStack out = new ItemStack(ModItems.ingot_meteorite_forged);
                ItemHot.heatUp(out, (h1 + h22) / 2.0);
                event.setOutput(out);
                event.setCost(10);
            }
        }
        if (event.getLeft().func_77973_b() == ModItems.ingot_meteorite_forged && event.getRight().func_77973_b() == ModItems.ingot_meteorite_forged && event.getLeft().func_190916_E() == 1 && event.getRight().func_190916_E() == 1) {
            double h1 = ItemHot.getHeat(event.getLeft());
            double h23 = ItemHot.getHeat(event.getRight());
            if (h1 >= 0.5 && h23 >= 0.5) {
                ItemStack out = new ItemStack(ModItems.blade_meteorite);
                ItemHot.heatUp(out, (h1 + h23) / 2.0);
                event.setOutput(out);
                event.setCost(30);
            }
        }
        if (event.getLeft().func_77973_b() == ModItems.meteorite_sword_seared && event.getRight().func_77973_b() == ModItems.ingot_meteorite_forged && event.getLeft().func_190916_E() == 1 && event.getRight().func_190916_E() == 1 && (h2 = ItemHot.getHeat(event.getRight())) >= 0.5) {
            ItemStack out = new ItemStack(ModItems.meteorite_sword_reforged);
            event.setOutput(out);
            event.setCost(50);
        }
        if (event.getLeft().func_77973_b() == ModItems.ingot_steel_dusted && event.getRight().func_77973_b() == ModItems.ingot_steel_dusted && event.getLeft().func_190916_E() == event.getRight().func_190916_E()) {
            double h1 = ItemHot.getHeat(event.getLeft());
            double h24 = ItemHot.getHeat(event.getRight());
            if (h24 >= 0.5) {
                int i2;
                int i1 = event.getLeft().func_77952_i();
                int i3 = Math.min(i1, i2 = event.getRight().func_77952_i()) + 1;
                boolean done = i3 >= 10;
                ItemStack out = done ? new ItemStack(ModItems.ingot_chainsteel, event.getLeft().func_190916_E(), 0) : new ItemStack(ModItems.ingot_steel_dusted, event.getLeft().func_190916_E(), i3);
                ItemHot.heatUp(out, done ? 1.0 : (h1 + h24) / 2.0);
                event.setOutput(out);
                event.setCost(event.getLeft().func_190916_E());
            }
        }
    }

    @SubscribeEvent
    public void onFoodEaten(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack = event.getItem();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemFood && stack.func_77942_o() && stack.func_77978_p().func_74767_n("ntmCyanide")) {
            for (int i = 0; i < 10; ++i) {
                event.getEntityLiving().func_70097_a(rand.nextBoolean() ? ModDamageSource.euthanizedSelf : ModDamageSource.euthanizedSelf2, 1000.0f);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer player = event.player;
        if (player.func_145748_c_().func_150260_c().equals("Dr_Nostalgia") && !player.field_70170_p.field_72995_K) {
            if (!Library.hasInventoryItem(player.field_71071_by, ModItems.hat)) {
                player.field_71071_by.func_70441_a(new ItemStack(ModItems.hat));
            }
            if (!Library.hasInventoryItem(player.field_71071_by, ModItems.beta)) {
                player.field_71071_by.func_70441_a(new ItemStack(ModItems.beta));
            }
        }
    }

    @SubscribeEvent
    public void craftingRegister(RegistryEvent.Register<IRecipe> e) {
        long mem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        System.out.println("Memory usage before: " + mem);
        CraftingManager.hack = e;
        CraftingManager.init();
        CraftingManager.hack = null;
        mem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        System.out.println("Memory usage after: " + mem);
    }

    @SubscribeEvent
    public void onItemRegister(RegistryEvent.Register<Item> evt) {
    }

    @SubscribeEvent
    public void onBlockRegister(RegistryEvent.Register<Block> evt) {
    }

    @SubscribeEvent
    public void onRecipeRegister(RegistryEvent.Register<IRecipe> evt) {
        Object[] recipes = new IRecipe[12];
        Object recipe = null;
        ModEventHandler.doesArrayContain(recipes, recipe);
    }

    public static boolean doesArrayContain(Object[] array, Object objectCheck) {
        System.out.println("On Recipe Register");
        return false;
    }

    static {
        hashes.add("41de5c372b0589bbdb80571e87efa95ea9e34b0d74c6005b8eab495b7afd9994");
        hashes.add("31da6223a100ed348ceb3254ceab67c9cc102cb2a04ac24de0df3ef3479b1036");
        r_handInventory = null;
        r_armorArray = null;
    }
}

