/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.physics;

import com.hbm.physics.Collider;
import com.hbm.render.amlfrom1710.Vec3;
import javax.vecmath.Matrix3f;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.util.math.AxisAlignedBB;

public class AABBCollider
extends Collider {
    public AxisAlignedBB box;
    public float density = -1.0f;

    public AABBCollider(AxisAlignedBB box) {
        this.box = box;
        this.localCentroid = new Vec3(box.func_189972_c());
    }

    public AABBCollider(AxisAlignedBB box, float density) {
        this.box = box;
        float w = (float)(box.field_72336_d - box.field_72340_a);
        float h = (float)(box.field_72337_e - box.field_72338_b);
        float d = (float)(box.field_72334_f - box.field_72339_c);
        float vol = w * h * d;
        this.mass = density * vol;
        this.localCentroid = new Vec3(box.func_189972_c());
        float i_mass = this.mass / 12.0f;
        this.localInertiaTensor = new Matrix3f(i_mass * (h * h + d * d), 0.0f, 0.0f, 0.0f, i_mass * (w * w + d * d), 0.0f, 0.0f, 0.0f, i_mass * (w * w + h * h));
    }

    @Override
    public Vec3 support(Vec3 direction) {
        return new Vec3(direction.xCoord > 0.0 ? this.box.field_72336_d : this.box.field_72340_a, direction.yCoord > 0.0 ? this.box.field_72337_e : this.box.field_72338_b, direction.zCoord > 0.0 ? this.box.field_72334_f : this.box.field_72339_c);
    }

    @Override
    public Collider copy() {
        if (this.density == -1.0f) {
            return new AABBCollider(this.box);
        }
        return new AABBCollider(this.box, this.density);
    }

    @Override
    public void debugRender() {
        RenderGlobal.func_189697_a((AxisAlignedBB)this.box, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
    }
}

