/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render;

import com.hbm.render.GLCompat;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.GLAllocation;
import org.lwjgl.opengl.GL11;

public class Vbo {
    public static final int BYTES_PER_VERTEX = 27;
    int drawMode;
    int numVertices;
    int vboId;

    public Vbo(int vboId, int drawMode, int numVertices) {
        this.vboId = vboId;
        this.drawMode = drawMode;
        this.numVertices = numVertices;
    }

    private void preDraw() {
        GL11.glVertexPointer((int)3, (int)5126, (int)27, (long)0L);
        GL11.glEnableClientState((int)32884);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)27, (long)12L);
        GL11.glEnableClientState((int)32888);
        GL11.glNormalPointer((int)5120, (int)27, (long)20L);
        GL11.glEnableClientState((int)32885);
        GL11.glColorPointer((int)4, (int)5121, (int)27, (long)23L);
        GL11.glEnableClientState((int)32886);
    }

    public void draw() {
        GLCompat.bindBuffer(GLCompat.GL_ARRAY_BUFFER, this.vboId);
        this.preDraw();
        GL11.glDrawArrays((int)this.drawMode, (int)0, (int)this.numVertices);
        this.postDraw();
        GLCompat.bindBuffer(GLCompat.GL_ARRAY_BUFFER, 0);
    }

    private void postDraw() {
        GL11.glDisableClientState((int)32884);
        GL11.glDisableClientState((int)32888);
        GL11.glDisableClientState((int)32885);
        GL11.glDisableClientState((int)32886);
    }

    public static Vbo setupTestVbo() {
        Vertex bottomLeft = new Vertex(-0.5f, -0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        Vertex bottomRight = new Vertex(0.5f, -0.5f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        Vertex topLeft = new Vertex(-0.5f, 0.5f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        Vertex topRight = new Vertex(0.5f, 0.5f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        Vertex[] vertices = new Vertex[]{bottomLeft, bottomRight, topRight, topLeft};
        int vboId = GLCompat.genBuffers();
        ByteBuffer data = GLAllocation.func_74524_c((int)(vertices.length * 27));
        for (Vertex v : vertices) {
            data.putFloat(v.x);
            data.putFloat(v.y);
            data.putFloat(v.z);
            data.putFloat(v.u);
            data.putFloat(v.v);
            data.put((byte)((int)(v.normalX * 127.0f) & 0xFF));
            data.put((byte)((int)(v.normalY * 127.0f) & 0xFF));
            data.put((byte)((int)(v.normalZ * 127.0f) & 0xFF));
            data.put((byte)(v.r * 255.0f));
            data.put((byte)(v.g * 255.0f));
            data.put((byte)(v.b * 255.0f));
            data.put((byte)(v.a * 255.0f));
        }
        data.rewind();
        GLCompat.bindBuffer(GLCompat.GL_ARRAY_BUFFER, vboId);
        GLCompat.bufferData(GLCompat.GL_ARRAY_BUFFER, data, GLCompat.GL_STATIC_DRAW);
        GLCompat.bindBuffer(GLCompat.GL_ARRAY_BUFFER, 0);
        return new Vbo(vboId, 7, vertices.length);
    }

    public static class Vertex {
        public float x;
        public float y;
        public float z;
        public float u;
        public float v;
        public float normalX;
        public float normalY;
        public float normalZ;
        public float r;
        public float g;
        public float b;
        public float a;

        public Vertex(float x, float y, float z, float u, float v, float nX, float nY, float nZ, float r, float g, float b, float a) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.u = u;
            this.v = v;
            this.normalX = nX;
            this.normalY = nY;
            this.normalZ = nZ;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }
    }
}

