/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.entity;

import com.hbm.entity.effect.EntityBlackHole;
import com.hbm.entity.effect.EntityQuasar;
import com.hbm.entity.effect.EntityRagingVortex;
import com.hbm.entity.effect.EntityVortex;
import com.hbm.main.ClientProxy;
import com.hbm.render.RenderHelper;
import com.hbm.render.amlfrom1710.AdvancedModelLoader;
import com.hbm.render.amlfrom1710.IModelCustom;
import com.hbm.render.amlfrom1710.Vec3;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import org.lwjgl.opengl.GL11;

public class RenderBlackHole
extends Render<EntityBlackHole> {
    public static final IRenderFactory<EntityBlackHole> FACTORY = RenderBlackHole::new;
    protected static final ResourceLocation objTesterModelRL = new ResourceLocation("hbm", "models/Sphere.obj");
    protected IModelCustom blastModel;
    protected ResourceLocation hole = new ResourceLocation("hbm", "textures/models/explosion/BlackHole.png");
    protected ResourceLocation swirl = new ResourceLocation("hbm", "textures/entity/bhole.png");
    protected ResourceLocation disc = new ResourceLocation("hbm", "textures/entity/bholeDisc.png");

    protected RenderBlackHole(RenderManager renderManager) {
        super(renderManager);
        this.blastModel = AdvancedModelLoader.loadModel(objTesterModelRL);
    }

    public void doRender(EntityBlackHole entity, double x, double y, double z, float entityYaw, float partialTicks) {
        int type;
        if (entity instanceof EntityVortex) {
            EntityVortex vor = (EntityVortex)entity;
            type = vor.getType();
        } else {
            type = entity instanceof EntityRagingVortex ? 5 : (entity instanceof EntityQuasar ? 6 : 4);
        }
        this.doRender(type, entity.func_145782_y(), entity.field_70173_aa, ((Float)entity.func_184212_Q().func_187225_a(EntityBlackHole.SIZE)).floatValue(), x, y, z, partialTicks);
    }

    public void doRender(int type, int rand, int age, float size, double x, double y, double z, float partialTicks) {
        if (!ClientProxy.renderingConstant) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GL11.glScalef((float)size, (float)size, (float)size);
        this.func_110776_a(this.hole);
        this.blastModel.renderAll();
        if (type == 4 || type == 6) {
            this.renderDisc(rand, age, partialTicks);
            this.renderJets(rand);
        } else if (type == 5) {
            this.renderSwirl(5, rand, age, partialTicks);
            this.renderJets(rand);
        } else {
            this.renderSwirl(type, rand, age, partialTicks);
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179145_e();
        GL11.glPopMatrix();
    }

    protected ResourceLocation discTex() {
        return this.disc;
    }

    protected void renderDisc(int rand, int age, float interp) {
        float glow = 0.75f;
        this.func_110776_a(this.discTex());
        GL11.glPushMatrix();
        GL11.glRotatef((float)(rand % 90 - 45), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(rand % 360), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179092_a((int)518, (float)0.0f);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        int count = 16;
        Vec3 vec = Vec3.createVectorHelper(1.0, 0.0, 0.0);
        float[] color = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        for (int k = 0; k < this.steps(); ++k) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)(((float)age + interp % 360.0f) * -((float)Math.pow(k + 1, 1.25))), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            double s = 3.0 - (double)k * 0.175;
            for (int j = 0; j < 2; ++j) {
                buf.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                for (int i = 0; i < count; ++i) {
                    if (j == 0) {
                        this.setColorFromIteration(k, 1.0f, color);
                    } else {
                        color[0] = 1.0f;
                        color[1] = 1.0f;
                        color[2] = 1.0f;
                        color[3] = glow;
                    }
                    buf.func_181662_b(vec.xCoord * s, 0.0, vec.zCoord * s).func_187315_a(0.5 + vec.xCoord * 0.25, 0.5 + vec.zCoord * 0.25).func_181666_a(color[0], color[1], color[2], color[3]).func_181675_d();
                    this.setColorFromIteration(k, 0.0f, color);
                    buf.func_181662_b(vec.xCoord * s * 2.0, 0.0, vec.zCoord * s * 2.0).func_187315_a(0.5 + vec.xCoord * 0.5, 0.5 + vec.zCoord * 0.5).func_181666_a(color[0], color[1], color[2], color[3]).func_181675_d();
                    vec.rotateAroundY((float)(Math.PI * 2 / (double)count));
                    this.setColorFromIteration(k, 0.0f, color);
                    buf.func_181662_b(vec.xCoord * s * 2.0, 0.0, vec.zCoord * s * 2.0).func_187315_a(0.5 + vec.xCoord * 0.5, 0.5 + vec.zCoord * 0.5).func_181666_a(color[0], color[1], color[2], color[3]).func_181675_d();
                    if (j == 0) {
                        this.setColorFromIteration(k, 1.0f, color);
                    } else {
                        color[0] = 1.0f;
                        color[1] = 1.0f;
                        color[2] = 1.0f;
                        color[3] = glow;
                    }
                    buf.func_181662_b(vec.xCoord * s, 0.0, vec.zCoord * s).func_187315_a(0.5 + vec.xCoord * 0.25, 0.5 + vec.zCoord * 0.25).func_181666_a(color[0], color[1], color[2], color[3]).func_181675_d();
                }
                tes.func_78381_a();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            }
            GL11.glPopMatrix();
        }
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179141_d();
        GL11.glPopMatrix();
    }

    protected int steps() {
        return 15;
    }

    protected void setColorFromIteration(int iteration, float alpha, float[] col) {
        if (iteration < 5) {
            float g = 0.125f + (float)iteration * 0.1f;
            col[0] = 1.0f;
            col[1] = g;
            col[2] = 0.0f;
            col[3] = alpha;
            return;
        }
        if (iteration == 5) {
            col[0] = 1.0f;
            col[1] = 1.0f;
            col[2] = 1.0f;
            col[3] = alpha;
            return;
        }
        int i = iteration - 6;
        float r = 1.0f - (float)i * 0.11111111f;
        float g = 1.0f - (float)i * 0.11111111f;
        float b = (float)i * 0.2f;
        col[0] = r;
        col[1] = g;
        col[2] = b;
        col[3] = alpha;
    }

    protected void renderSwirl(int type, int rand, int age, float interp) {
        int i;
        int j;
        float glow = 0.75f;
        if (type == 6) {
            glow = 0.25f;
        }
        this.func_110776_a(this.swirl);
        GL11.glPushMatrix();
        GL11.glRotatef((float)(rand % 90 - 45), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(rand % 360), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(((float)age + interp % 360.0f) * -5.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179092_a((int)518, (float)0.0f);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Vec3 vec = Vec3.createVectorHelper(1.0, 0.0, 0.0);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        double s = 3.0;
        int count = 16;
        float[] color = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        for (j = 0; j < 2; ++j) {
            buf.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            for (i = 0; i < count; ++i) {
                color[0] = 0.0f;
                color[1] = 0.0f;
                color[2] = 0.0f;
                color[3] = 1.0f;
                buf.func_181662_b(vec.xCoord * 0.9, 0.0, vec.zCoord * 0.9).func_187315_a(0.5 + vec.xCoord * 0.25 / s * 0.9, 0.5 + vec.zCoord * 0.25 / s * 0.9).func_181666_a(color[0], color[1], color[2], color[3]).func_181675_d();
                if (j == 0) {
                    this.setColorFull(type, color);
                } else {
                    color[0] = 1.0f;
                    color[1] = 1.0f;
                    color[2] = 1.0f;
                    color[3] = glow;
                }
                buf.func_181662_b(vec.xCoord * s, 0.0, vec.zCoord * s).func_187315_a(0.5 + vec.xCoord * 0.25, 0.5 + vec.zCoord * 0.25).func_181666_a(color[0], color[1], color[2], color[3]).func_181675_d();
                vec.rotateAroundY((float)(Math.PI * 2 / (double)count));
                if (j == 0) {
                    this.setColorFull(type, color);
                } else {
                    color[0] = 1.0f;
                    color[1] = 1.0f;
                    color[2] = 1.0f;
                    color[3] = glow;
                }
                buf.func_181662_b(vec.xCoord * s, 0.0, vec.zCoord * s).func_187315_a(0.5 + vec.xCoord * 0.25, 0.5 + vec.zCoord * 0.25).func_181666_a(color[0], color[1], color[2], color[3]).func_181675_d();
                color[0] = 0.0f;
                color[1] = 0.0f;
                color[2] = 0.0f;
                color[3] = 1.0f;
                buf.func_181662_b(vec.xCoord * 0.9, 0.0, vec.zCoord * 0.9).func_187315_a(0.5 + vec.xCoord * 0.25 / s * 0.9, 0.5 + vec.zCoord * 0.25 / s * 0.9).func_181666_a(color[0], color[1], color[2], color[3]).func_181675_d();
            }
            tes.func_78381_a();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        }
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        for (j = 0; j < 2; ++j) {
            buf.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            for (i = 0; i < count; ++i) {
                if (j == 0) {
                    this.setColorFull(type, color);
                } else {
                    color[0] = 1.0f;
                    color[1] = 1.0f;
                    color[2] = 1.0f;
                    color[3] = glow;
                }
                buf.func_181662_b(vec.xCoord * s, 0.0, vec.zCoord * s).func_187315_a(0.5 + vec.xCoord * 0.25, 0.5 + vec.zCoord * 0.25).func_181666_a(color[0], color[1], color[2], color[3]).func_181675_d();
                this.setColorNone(type, color);
                buf.func_181662_b(vec.xCoord * s * 2.0, 0.0, vec.zCoord * s * 2.0).func_187315_a(0.5 + vec.xCoord * 0.5, 0.5 + vec.zCoord * 0.5).func_181666_a(color[0], color[1], color[2], color[3]).func_181675_d();
                vec.rotateAroundY((float)(Math.PI * 2 / (double)count));
                this.setColorNone(type, color);
                buf.func_181662_b(vec.xCoord * s * 2.0, 0.0, vec.zCoord * s * 2.0).func_187315_a(0.5 + vec.xCoord * 0.5, 0.5 + vec.zCoord * 0.5).func_181666_a(color[0], color[1], color[2], color[3]).func_181675_d();
                if (j == 0) {
                    this.setColorFull(type, color);
                } else {
                    color[0] = 1.0f;
                    color[1] = 1.0f;
                    color[2] = 1.0f;
                    color[3] = glow;
                }
                buf.func_181662_b(vec.xCoord * s, 0.0, vec.zCoord * s).func_187315_a(0.5 + vec.xCoord * 0.25, 0.5 + vec.zCoord * 0.25).func_181666_a(color[0], color[1], color[2], color[3]).func_181675_d();
            }
            tes.func_78381_a();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        }
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179141_d();
        GL11.glPopMatrix();
    }

    protected void renderJets(int rand) {
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        GL11.glPushMatrix();
        GL11.glRotatef((float)(rand % 90 - 45), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(rand % 360), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179092_a((int)518, (float)0.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179090_x();
        for (int j = -1; j <= 1; j += 2) {
            buf.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            buf.func_181662_b(0.0, 0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.35f).func_181675_d();
            Vec3 jet = Vec3.createVectorHelper(0.5, 0.0, 0.0);
            for (int i = 0; i <= 12; ++i) {
                buf.func_181662_b(jet.xCoord, (double)(10 * j), jet.zCoord).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
                jet.rotateAroundY((float)(0.5235987755982988 * (double)(-j)));
            }
            tes.func_78381_a();
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179141_d();
        GL11.glPopMatrix();
    }

    protected void setColorFull(int type, float[] color) {
        if (type == 4) {
            RenderHelper.unpackColor(16759040, color);
        } else if (type == 5) {
            RenderHelper.unpackColor(13304063, color);
        } else if (type == 3) {
            RenderHelper.unpackColor(0xFF5000, color);
        } else if (type == 1) {
            RenderHelper.unpackColor(26111, color);
        } else {
            RenderHelper.unpackColor(16745577, color);
        }
        color[3] = 1.0f;
    }

    protected void setColorNone(int type, float[] color) {
        if (type == 4) {
            RenderHelper.unpackColor(16759040, color);
        } else if (type == 5) {
            RenderHelper.unpackColor(13304063, color);
        } else if (type == 3) {
            RenderHelper.unpackColor(0xFF5000, color);
        } else if (type == 1) {
            RenderHelper.unpackColor(26111, color);
        } else {
            RenderHelper.unpackColor(16745577, color);
        }
        color[3] = 0.0f;
    }

    protected ResourceLocation getEntityTexture(EntityBlackHole entity) {
        return this.hole;
    }
}

