/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.model;

import com.hbm.render.loader.ModelRendererObj;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;

public abstract class ModelArmorBase
extends ModelBiped {
    private static final float DEG_TO_RAD = (float)Math.PI / 180;
    int type;
    ModelRendererObj head;
    ModelRendererObj body;
    ModelRendererObj leftArm;
    ModelRendererObj rightArm;
    ModelRendererObj leftLeg;
    ModelRendererObj rightLeg;
    ModelRendererObj leftFoot;
    ModelRendererObj rightFoot;

    public ModelArmorBase(int type) {
        this.type = type;
        this.head = new ModelRendererObj(null, new String[0]);
        this.body = new ModelRendererObj(null, new String[0]);
        this.leftArm = new ModelRendererObj(null, new String[0]).setRotationPoint(-5.0f, 2.0f, 0.0f);
        this.rightArm = new ModelRendererObj(null, new String[0]).setRotationPoint(5.0f, 2.0f, 0.0f);
        this.leftLeg = new ModelRendererObj(null, new String[0]).setRotationPoint(1.9f, 12.0f, 0.0f);
        this.rightLeg = new ModelRendererObj(null, new String[0]).setRotationPoint(-1.9f, 12.0f, 0.0f);
        this.leftFoot = new ModelRendererObj(null, new String[0]).setRotationPoint(1.9f, 12.0f, 0.0f);
        this.rightFoot = new ModelRendererObj(null, new String[0]).setRotationPoint(-1.9f, 12.0f, 0.0f);
    }

    private static void copyModelAngles(ModelRenderer source, ModelRendererObj dest) {
        dest.rotateAngleX = source.field_78795_f;
        dest.rotateAngleY = source.field_78796_g;
        dest.rotateAngleZ = source.field_78808_h;
        dest.rotationPointX = source.field_78800_c;
        dest.rotationPointY = source.field_78797_d;
        dest.rotationPointZ = source.field_78798_e;
    }

    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.func_178719_a(false);
        this.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, entityIn);
        GlStateManager.func_179094_E();
        GlStateManager.func_179103_j((int)7425);
        if (this.field_78091_s) {
            GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
            GlStateManager.func_179109_b((float)0.0f, (float)(16.0f * scale), (float)0.0f);
        }
        this.renderArmor(entityIn, scale);
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179121_F();
    }

    public void func_78087_a(float walkCycle, float walkAmplitude, float idleCycle, float headYaw, float headPitch, float scale, Entity entity) {
        if (entity instanceof EntityArmorStand) {
            EntityArmorStand armorStand = (EntityArmorStand)entity;
            this.applyArmorStand(armorStand);
        } else {
            super.func_78087_a(walkCycle, walkAmplitude, idleCycle, headYaw, headPitch, scale, entity);
            boolean bl = this.field_78117_n = entity instanceof EntityPlayer && entity.func_70093_af();
            if (entity instanceof EntityZombie) {
                float armYaw;
                EntityZombie zombie = (EntityZombie)entity;
                boolean armsRaised = zombie.func_184734_db();
                this.field_178724_i.field_78796_g = armYaw = 0.13962634f;
                this.field_178723_h.field_78796_g = -armYaw;
                if (armsRaised) {
                    float raisedAngle;
                    this.field_178724_i.field_78795_f = raisedAngle = -2.0943952f;
                    this.field_178723_h.field_78795_f = raisedAngle;
                } else {
                    float notRaisedAngle;
                    this.field_178724_i.field_78795_f = notRaisedAngle = -1.3962634f;
                    this.field_178723_h.field_78795_f = notRaisedAngle;
                }
            }
        }
        ModelArmorBase.copyModelAngles(this.field_78116_c, this.head);
        ModelArmorBase.copyModelAngles(this.field_78115_e, this.body);
        ModelArmorBase.copyModelAngles(this.field_178724_i, this.leftArm);
        ModelArmorBase.copyModelAngles(this.field_178723_h, this.rightArm);
        ModelArmorBase.copyModelAngles(this.field_178722_k, this.leftLeg);
        ModelArmorBase.copyModelAngles(this.field_178721_j, this.rightLeg);
        ModelArmorBase.copyModelAngles(this.field_178722_k, this.leftFoot);
        ModelArmorBase.copyModelAngles(this.field_178721_j, this.rightFoot);
        if (this.field_78117_n) {
            this.applySneakOffset();
        } else {
            this.resetOffsets();
        }
    }

    private void applySneakOffset() {
        this.head.offsetY = 4.24f;
        this.head.rotationPointY -= 1.045f;
        this.body.offsetY = 3.425f;
        this.rightArm.offsetY = 3.425f;
        this.leftArm.offsetY = 3.25f;
        this.rightLeg.offsetZ = 4.0f;
        this.rightFoot.offsetZ = 4.0f;
        this.leftLeg.offsetZ = 4.0f;
        this.leftFoot.offsetZ = 4.0f;
        this.rightLeg.rotationPointY = 12.0f;
        this.rightFoot.rotationPointY = 12.0f;
        this.leftLeg.rotationPointY = 12.0f;
        this.leftFoot.rotationPointY = 12.0f;
        this.rightLeg.rotationPointZ = -1.0f;
        this.rightFoot.rotationPointZ = -1.0f;
        this.leftLeg.rotationPointZ = -1.0f;
        this.leftFoot.rotationPointZ = -1.0f;
    }

    private void resetOffsets() {
        this.head.offsetY = 0.0f;
        this.body.offsetY = 0.0f;
        this.rightArm.offsetY = 0.0f;
        this.leftArm.offsetY = 0.0f;
        this.rightLeg.offsetZ = 0.0f;
        this.rightFoot.offsetZ = 0.0f;
        this.leftLeg.offsetZ = 0.0f;
        this.leftFoot.offsetZ = 0.0f;
    }

    private void applyArmorStand(EntityArmorStand armorStand) {
        this.field_78116_c.field_78795_f = armorStand.func_175418_s().func_179415_b() * ((float)Math.PI / 180);
        this.field_78116_c.field_78796_g = armorStand.func_175418_s().func_179416_c() * ((float)Math.PI / 180);
        this.field_78116_c.field_78808_h = armorStand.func_175418_s().func_179413_d() * ((float)Math.PI / 180);
        this.field_78116_c.func_78793_a(0.0f, 1.0f, 0.0f);
        this.field_78115_e.field_78795_f = armorStand.func_175408_t().func_179415_b() * ((float)Math.PI / 180);
        this.field_78115_e.field_78796_g = armorStand.func_175408_t().func_179416_c() * ((float)Math.PI / 180);
        this.field_78115_e.field_78808_h = armorStand.func_175408_t().func_179413_d() * ((float)Math.PI / 180);
        this.field_178724_i.field_78795_f = armorStand.func_175404_u().func_179415_b() * ((float)Math.PI / 180);
        this.field_178724_i.field_78796_g = armorStand.func_175404_u().func_179416_c() * ((float)Math.PI / 180);
        this.field_178724_i.field_78808_h = armorStand.func_175404_u().func_179413_d() * ((float)Math.PI / 180);
        this.field_178723_h.field_78795_f = armorStand.func_175411_v().func_179415_b() * ((float)Math.PI / 180);
        this.field_178723_h.field_78796_g = armorStand.func_175411_v().func_179416_c() * ((float)Math.PI / 180);
        this.field_178723_h.field_78808_h = armorStand.func_175411_v().func_179413_d() * ((float)Math.PI / 180);
        this.field_178722_k.field_78795_f = armorStand.func_175403_w().func_179415_b() * ((float)Math.PI / 180);
        this.field_178722_k.field_78796_g = armorStand.func_175403_w().func_179416_c() * ((float)Math.PI / 180);
        this.field_178722_k.field_78808_h = armorStand.func_175403_w().func_179413_d() * ((float)Math.PI / 180);
        this.field_178722_k.func_78793_a(1.9f, 11.0f, 0.0f);
        this.field_178721_j.field_78795_f = armorStand.func_175407_x().func_179415_b() * ((float)Math.PI / 180);
        this.field_178721_j.field_78796_g = armorStand.func_175407_x().func_179416_c() * ((float)Math.PI / 180);
        this.field_178721_j.field_78808_h = armorStand.func_175407_x().func_179413_d() * ((float)Math.PI / 180);
        this.field_178721_j.func_78793_a(-1.9f, 11.0f, 0.0f);
        this.field_78117_n = false;
    }

    protected abstract void renderArmor(Entity var1, float var2);
}

