/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.util;

import com.hbm.main.ClientProxy;
import com.hbm.main.MainRegistry;
import com.hbm.main.ResourceManager;
import com.hbm.particle.ParticleSlicedMob;
import com.hbm.physics.Collider;
import com.hbm.physics.ConvexMeshCollider;
import com.hbm.physics.GJK;
import com.hbm.physics.RigidBody;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.render.util.BakedModelUtil;
import com.hbm.render.util.Triangle;
import com.hbm.util.BobMathUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.vecmath.Matrix3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;

public class ModelRendererUtil {
    public static Method rPrepareScale;
    public static Method rGetEntityTexture;
    public static Method rHandleRotationFloat;
    public static Method rApplyRotations;
    public static Field rQuadList;
    public static Field rCompiled;

    public static ResourceLocation getEntityTexture(Entity e) {
        Render eRenderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a(e);
        if (rGetEntityTexture == null) {
            rGetEntityTexture = ReflectionHelper.findMethod(Render.class, (String)"getEntityTexture", (String)"func_110775_a", (Class[])new Class[]{Entity.class});
        }
        ResourceLocation r = null;
        try {
            r = (ResourceLocation)rGetEntityTexture.invoke((Object)eRenderer, e);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e1) {
            e1.printStackTrace();
        }
        return r == null ? ResourceManager.turbofan_blades_tex : r;
    }

    public static List<Pair<Matrix4f, ModelRenderer>> getBoxesFromMob(Entity e) {
        Render eRenderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a(e);
        if (eRenderer instanceof RenderLivingBase && e instanceof EntityLivingBase) {
            return ModelRendererUtil.getBoxesFromMob((EntityLivingBase)e, (RenderLivingBase)eRenderer, MainRegistry.proxy.partialTicks());
        }
        return Collections.emptyList();
    }

    private static List<Pair<Matrix4f, ModelRenderer>> getBoxesFromMob(EntityLivingBase e, RenderLivingBase<?> render, float partialTicks) {
        boolean shouldSit;
        ModelBase model = render.func_177087_b();
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GlStateManager.func_179129_p();
        GlStateManager.func_179091_B();
        model.field_78095_p = e.func_70678_g(partialTicks);
        model.field_78093_q = shouldSit = e.func_184218_aH() && e.func_184187_bx() != null && e.func_184187_bx().shouldRiderSit();
        model.field_78091_s = e.func_70631_g_();
        float f = ModelRendererUtil.interpolateRotation(e.field_70760_ar, e.field_70761_aq, partialTicks);
        float f1 = ModelRendererUtil.interpolateRotation(e.field_70758_at, e.field_70759_as, partialTicks);
        float f2 = f1 - f;
        if (shouldSit && e.func_184187_bx() instanceof EntityLivingBase) {
            EntityLivingBase elivingbase = (EntityLivingBase)e.func_184187_bx();
            f = ModelRendererUtil.interpolateRotation(elivingbase.field_70760_ar, elivingbase.field_70761_aq, partialTicks);
            f2 = f1 - f;
            float f3 = MathHelper.func_76142_g((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f7 = e.field_70127_C + (e.field_70125_A - e.field_70127_C) * partialTicks;
        if (rPrepareScale == null) {
            rPrepareScale = ReflectionHelper.findMethod(RenderLivingBase.class, (String)"prepareScale", (String)"func_188322_c", (Class[])new Class[]{EntityLivingBase.class, Float.TYPE});
        }
        if (rHandleRotationFloat == null) {
            rHandleRotationFloat = ReflectionHelper.findMethod(RenderLivingBase.class, (String)"handleRotationFloat", (String)"func_77044_a", (Class[])new Class[]{EntityLivingBase.class, Float.TYPE});
            rApplyRotations = ReflectionHelper.findMethod(RenderLivingBase.class, (String)"applyRotations", (String)"func_77043_a", (Class[])new Class[]{EntityLivingBase.class, Float.TYPE, Float.TYPE, Float.TYPE});
        }
        float f8 = 0.0f;
        try {
            f8 = ((Float)rHandleRotationFloat.invoke(render, e, Float.valueOf(partialTicks))).floatValue();
            rApplyRotations.invoke(render, e, Float.valueOf(f8), Float.valueOf(f), Float.valueOf(partialTicks));
        }
        catch (Exception exception) {
            // empty catch block
        }
        float f4 = 0.0625f;
        try {
            f4 = ((Float)rPrepareScale.invoke(render, e, Float.valueOf(partialTicks))).floatValue();
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e2) {
            e2.printStackTrace();
        }
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (!e.func_184218_aH()) {
            f5 = e.field_184618_aE + (e.field_70721_aZ - e.field_184618_aE) * partialTicks;
            f6 = e.field_184619_aG - e.field_70721_aZ * (1.0f - partialTicks);
            if (e.func_70631_g_()) {
                f6 *= 3.0f;
            }
            if (f5 > 1.0f) {
                f5 = 1.0f;
            }
            f2 = f1 - f;
        }
        model.func_78086_a(e, f6, f5, partialTicks);
        model.func_78087_a(f6, f5, f8, f2, f7, f4, (Entity)e);
        if (rGetEntityTexture == null) {
            rGetEntityTexture = ReflectionHelper.findMethod(Render.class, (String)"getEntityTexture", (String)"func_110775_a", (Class[])new Class[]{Entity.class});
        }
        ResourceLocation r = ResourceManager.turbofan_blades_tex;
        try {
            r = (ResourceLocation)rGetEntityTexture.invoke(render, e);
            if (r == null) {
                r = ResourceManager.turbofan_blades_tex;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e1) {
            e1.printStackTrace();
        }
        if (rCompiled == null) {
            rCompiled = ReflectionHelper.findField(ModelRenderer.class, (String)"compiled", (String)"field_78812_q");
        }
        ArrayList<Pair<Matrix4f, ModelRenderer>> list = new ArrayList<Pair<Matrix4f, ModelRenderer>>();
        for (ModelRenderer renderer : model.field_78092_r) {
            if (ModelRendererUtil.isChild(renderer, model.field_78092_r)) continue;
            ModelRendererUtil.generateList(e.field_70170_p, e, f4, list, renderer, r);
        }
        GlStateManager.func_179101_C();
        GlStateManager.func_179089_o();
        GL11.glPopMatrix();
        return list;
    }

    public static boolean isChild(ModelRenderer r, List<ModelRenderer> list) {
        for (ModelRenderer r2 : list) {
            if (r2.field_78805_m == null || !r2.field_78805_m.contains(r)) continue;
            return true;
        }
        return false;
    }

    protected static void generateList(World world, EntityLivingBase ent, float scale, List<Pair<Matrix4f, ModelRenderer>> list, ModelRenderer render, ResourceLocation tex) {
        boolean compiled = false;
        try {
            compiled = rCompiled.getBoolean(render);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (render.field_78807_k || !render.field_78806_j || !compiled) {
            return;
        }
        GL11.glPushMatrix();
        ModelRendererUtil.doTransforms(render, scale);
        if (render.field_78805_m != null) {
            for (ModelRenderer renderer : render.field_78805_m) {
                ModelRendererUtil.generateList(world, ent, scale, list, renderer, tex);
            }
        }
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glGetFloat((int)2982, (FloatBuffer)ClientProxy.AUX_GL_BUFFER);
        Matrix4f mat = new Matrix4f();
        mat.load(ClientProxy.AUX_GL_BUFFER);
        ClientProxy.AUX_GL_BUFFER.rewind();
        list.add((Pair<Matrix4f, ModelRenderer>)Pair.of((Object)mat, (Object)render));
        GL11.glPopMatrix();
    }

    public static void doTransforms(ModelRenderer m, float scale) {
        GlStateManager.func_179109_b((float)m.field_82906_o, (float)m.field_82908_p, (float)m.field_82907_q);
        if (m.field_78795_f == 0.0f && m.field_78796_g == 0.0f && m.field_78808_h == 0.0f) {
            if (m.field_78800_c != 0.0f || m.field_78797_d != 0.0f || m.field_78798_e != 0.0f) {
                GlStateManager.func_179109_b((float)(m.field_78800_c * scale), (float)(m.field_78797_d * scale), (float)(m.field_78798_e * scale));
            }
        } else {
            GlStateManager.func_179109_b((float)(m.field_78800_c * scale), (float)(m.field_78797_d * scale), (float)(m.field_78798_e * scale));
            if (m.field_78808_h != 0.0f) {
                GlStateManager.func_179114_b((float)(m.field_78808_h * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (m.field_78796_g != 0.0f) {
                GlStateManager.func_179114_b((float)(m.field_78796_g * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (m.field_78795_f != 0.0f) {
                GlStateManager.func_179114_b((float)(m.field_78795_f * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
    }

    protected static float interpolateRotation(float prevYawOffset, float yawOffset, float partialTicks) {
        float f;
        for (f = yawOffset - prevYawOffset; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prevYawOffset + partialTicks * f;
    }

    public static Triangle[] decompress(VertexData vertices) {
        Triangle[] tris = new Triangle[vertices.positionIndices.length / 3];
        for (int i = 0; i < vertices.positionIndices.length; i += 3) {
            int i0 = vertices.positionIndices[i];
            int i1 = vertices.positionIndices[i + 1];
            int i2 = vertices.positionIndices[i + 2];
            float[] tex = new float[]{vertices.texCoords[(i + 0) * 2], vertices.texCoords[(i + 0) * 2 + 1], vertices.texCoords[(i + 1) * 2], vertices.texCoords[(i + 1) * 2 + 1], vertices.texCoords[(i + 2) * 2], vertices.texCoords[(i + 2) * 2 + 1]};
            tris[i / 3] = new Triangle(vertices.positions[i0], vertices.positions[i1], vertices.positions[i2], tex);
        }
        return tris;
    }

    public static VertexData compress(Triangle[] tris) {
        ArrayList<Vec3d> vertices = new ArrayList<Vec3d>(tris.length * 3);
        int[] indices = new int[tris.length * 3];
        float[] texCoords = new float[tris.length * 6];
        for (int i = 0; i < tris.length; ++i) {
            Triangle tri = tris[i];
            double eps = 1.0E-5;
            int idx = ModelRendererUtil.epsIndexOf(vertices, tri.p1.pos, eps);
            if (idx != -1) {
                indices[i * 3] = idx;
            } else {
                indices[i * 3] = vertices.size();
                vertices.add(tri.p1.pos);
            }
            idx = ModelRendererUtil.epsIndexOf(vertices, tri.p2.pos, eps);
            if (idx != -1) {
                indices[i * 3 + 1] = idx;
            } else {
                indices[i * 3 + 1] = vertices.size();
                vertices.add(tri.p2.pos);
            }
            idx = ModelRendererUtil.epsIndexOf(vertices, tri.p3.pos, eps);
            if (idx != -1) {
                indices[i * 3 + 2] = idx;
            } else {
                indices[i * 3 + 2] = vertices.size();
                vertices.add(tri.p3.pos);
            }
            texCoords[i * 6 + 0] = tri.p1.texX;
            texCoords[i * 6 + 1] = tri.p1.texY;
            texCoords[i * 6 + 2] = tri.p2.texX;
            texCoords[i * 6 + 3] = tri.p2.texY;
            texCoords[i * 6 + 4] = tri.p3.texX;
            texCoords[i * 6 + 5] = tri.p3.texY;
        }
        VertexData data = new VertexData();
        data.positions = vertices.toArray(new Vec3d[0]);
        data.positionIndices = indices;
        data.texCoords = texCoords;
        return data;
    }

    private static int epsIndexOf(List<Vec3d> l, Vec3d vec, double eps) {
        for (int i = 0; i < l.size(); ++i) {
            if (!BobMathUtil.epsilonEquals(vec, l.get(i), eps)) continue;
            return i;
        }
        return -1;
    }

    public static VertexData[] cutAndCapModelBox(ModelBox b, float[] plane, @Nullable Matrix4f transform) {
        return ModelRendererUtil.cutAndCapConvex(ModelRendererUtil.triangulate(b, transform), plane);
    }

    public static VertexData[] cutAndCapConvex(Triangle[] tris, float[] plane) {
        VertexData[] returnData = new VertexData[]{null, null, new VertexData()};
        ArrayList<Triangle> side1 = new ArrayList<Triangle>();
        ArrayList<Triangle> side2 = new ArrayList<Triangle>();
        ArrayList<Vec3d[]> clippedEdges = new ArrayList<Vec3d[]>();
        for (Triangle t : tris) {
            float[] deTex;
            Vec3d e;
            Vec3d d;
            float interceptAC;
            float interceptAB;
            Vec3d rAC;
            Vec3d rAB;
            Triangle.TexVertex c;
            Triangle.TexVertex b;
            Triangle.TexVertex a;
            boolean p3;
            boolean p1 = t.p1.pos.field_72450_a * (double)plane[0] + t.p1.pos.field_72448_b * (double)plane[1] + t.p1.pos.field_72449_c * (double)plane[2] + (double)plane[3] > 0.0;
            boolean p2 = t.p2.pos.field_72450_a * (double)plane[0] + t.p2.pos.field_72448_b * (double)plane[1] + t.p2.pos.field_72449_c * (double)plane[2] + (double)plane[3] > 0.0;
            boolean bl = p3 = t.p3.pos.field_72450_a * (double)plane[0] + t.p3.pos.field_72448_b * (double)plane[1] + t.p3.pos.field_72449_c * (double)plane[2] + (double)plane[3] > 0.0;
            if (p1 && p2 && p3) {
                side1.add(t);
                continue;
            }
            if (!(p1 || p2 || p3)) {
                side2.add(t);
                continue;
            }
            if (p1 ^ p2 ^ p3) {
                if (p1) {
                    a = t.p1;
                    b = t.p2;
                    c = t.p3;
                } else if (p2) {
                    a = t.p2;
                    b = t.p3;
                    c = t.p1;
                } else {
                    a = t.p3;
                    b = t.p1;
                    c = t.p2;
                }
                rAB = b.pos.func_178788_d(a.pos);
                rAC = c.pos.func_178788_d(a.pos);
                interceptAB = (float)ModelRendererUtil.rayPlaneIntercept(a.pos, rAB, plane);
                interceptAC = (float)ModelRendererUtil.rayPlaneIntercept(a.pos, rAC, plane);
                d = a.pos.func_178787_e(rAB.func_186678_a((double)interceptAB));
                e = a.pos.func_178787_e(rAC.func_186678_a((double)interceptAC));
                deTex = new float[]{a.texX + (b.texX - a.texX) * interceptAB, a.texY + (b.texY - a.texY) * interceptAB, a.texX + (c.texX - a.texX) * interceptAC, a.texY + (c.texY - a.texY) * interceptAC};
                side2.add(new Triangle(d, b.pos, e, new float[]{deTex[0], deTex[1], b.texX, b.texY, deTex[2], deTex[3]}));
                side2.add(new Triangle(b.pos, c.pos, e, new float[]{b.texX, b.texY, c.texX, c.texY, deTex[2], deTex[3]}));
                side1.add(new Triangle(a.pos, d, e, new float[]{a.texX, a.texY, deTex[0], deTex[1], deTex[2], deTex[3]}));
                clippedEdges.add(new Vec3d[]{d, e});
                continue;
            }
            if (!p1) {
                a = t.p1;
                b = t.p2;
                c = t.p3;
            } else if (!p2) {
                a = t.p2;
                b = t.p3;
                c = t.p1;
            } else {
                a = t.p3;
                b = t.p1;
                c = t.p2;
            }
            rAB = b.pos.func_178788_d(a.pos);
            rAC = c.pos.func_178788_d(a.pos);
            interceptAB = (float)ModelRendererUtil.rayPlaneIntercept(a.pos, rAB, plane);
            interceptAC = (float)ModelRendererUtil.rayPlaneIntercept(a.pos, rAC, plane);
            d = a.pos.func_178787_e(rAB.func_186678_a((double)interceptAB));
            e = a.pos.func_178787_e(rAC.func_186678_a((double)interceptAC));
            deTex = new float[]{a.texX + (b.texX - a.texX) * interceptAB, a.texY + (b.texY - a.texY) * interceptAB, a.texX + (c.texX - a.texX) * interceptAC, a.texY + (c.texY - a.texY) * interceptAC};
            side1.add(new Triangle(d, b.pos, e, new float[]{deTex[0], deTex[1], b.texX, b.texY, deTex[2], deTex[3]}));
            side1.add(new Triangle(b.pos, c.pos, e, new float[]{b.texX, b.texY, c.texX, c.texY, deTex[2], deTex[3]}));
            side2.add(new Triangle(a.pos, d, e, new float[]{a.texX, a.texY, deTex[0], deTex[1], deTex[2], deTex[3]}));
            clippedEdges.add(new Vec3d[]{e, d});
        }
        if (!clippedEdges.isEmpty()) {
            Matrix3f mat = BakedModelUtil.normalToMat(new Vec3d((double)plane[0], (double)plane[1], (double)plane[2]), 0.0f);
            ArrayList<Vec3d> orderedClipVertices = new ArrayList<Vec3d>();
            orderedClipVertices.add(((Vec3d[])clippedEdges.get(0))[0]);
            while (!clippedEdges.isEmpty()) {
                orderedClipVertices.add(ModelRendererUtil.getNext(clippedEdges, (Vec3d)orderedClipVertices.get(orderedClipVertices.size() - 1)));
            }
            Vector3f uv1 = new Vector3f((float)((Vec3d)orderedClipVertices.get((int)0)).field_72450_a, (float)((Vec3d)orderedClipVertices.get((int)0)).field_72448_b, (float)((Vec3d)orderedClipVertices.get((int)0)).field_72449_c);
            mat.transform((Tuple3f)uv1);
            Triangle[] cap = new Triangle[orderedClipVertices.size() - 2];
            for (int i = 0; i < cap.length; ++i) {
                Vector3f uv2 = new Vector3f((float)((Vec3d)orderedClipVertices.get((int)(i + 2))).field_72450_a, (float)((Vec3d)orderedClipVertices.get((int)(i + 2))).field_72448_b, (float)((Vec3d)orderedClipVertices.get((int)(i + 2))).field_72449_c);
                mat.transform((Tuple3f)uv2);
                Vector3f uv3 = new Vector3f((float)((Vec3d)orderedClipVertices.get((int)(i + 1))).field_72450_a, (float)((Vec3d)orderedClipVertices.get((int)(i + 1))).field_72448_b, (float)((Vec3d)orderedClipVertices.get((int)(i + 1))).field_72449_c);
                mat.transform((Tuple3f)uv3);
                cap[i] = new Triangle((Vec3d)orderedClipVertices.get(0), (Vec3d)orderedClipVertices.get(i + 2), (Vec3d)orderedClipVertices.get(i + 1), new float[]{uv1.x, uv1.y, uv2.x, uv2.y, uv3.x, uv3.y});
                side1.add(new Triangle((Vec3d)orderedClipVertices.get(0), (Vec3d)orderedClipVertices.get(i + 2), (Vec3d)orderedClipVertices.get(i + 1), new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}));
                side2.add(new Triangle((Vec3d)orderedClipVertices.get(0), (Vec3d)orderedClipVertices.get(i + 1), (Vec3d)orderedClipVertices.get(i + 2), new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}));
            }
            returnData[2] = ModelRendererUtil.compress(cap);
        }
        returnData[0] = ModelRendererUtil.compress(side1.toArray(new Triangle[0]));
        returnData[1] = ModelRendererUtil.compress(side2.toArray(new Triangle[0]));
        return returnData;
    }

    private static Vec3d getNext(List<Vec3d[]> edges, Vec3d first) {
        Iterator<Vec3d[]> itr = edges.iterator();
        while (itr.hasNext()) {
            double eps;
            Vec3d[] v = itr.next();
            if (BobMathUtil.epsilonEquals(v[0], first, eps = 1.0E-5)) {
                itr.remove();
                return v[1];
            }
            if (!BobMathUtil.epsilonEquals(v[1], first, eps)) continue;
            itr.remove();
            return v[0];
        }
        throw new RuntimeException("Didn't find next in loop!");
    }

    public static double rayPlaneIntercept(Vec3d start, Vec3d ray, float[] plane) {
        double num = -((double)plane[0] * start.field_72450_a + (double)plane[1] * start.field_72448_b + (double)plane[2] * start.field_72449_c + (double)plane[3]);
        double denom = (double)plane[0] * ray.field_72450_a + (double)plane[1] * ray.field_72448_b + (double)plane[2] * ray.field_72449_c;
        return num / denom;
    }

    public static Triangle[] triangulate(ModelBox b, @Nullable Matrix4f transform) {
        if (rQuadList == null) {
            rQuadList = ReflectionHelper.findField(ModelBox.class, (String)"quadList", (String)"field_78254_i");
        }
        Triangle[] tris = new Triangle[12];
        try {
            TexturedQuad[] quadList = (TexturedQuad[])rQuadList.get(b);
            int i = 0;
            for (TexturedQuad t : quadList) {
                Vec3d v0 = BobMathUtil.mat4Transform(t.field_78239_a[0].field_78243_a, transform);
                Vec3d v1 = BobMathUtil.mat4Transform(t.field_78239_a[1].field_78243_a, transform);
                Vec3d v2 = BobMathUtil.mat4Transform(t.field_78239_a[2].field_78243_a, transform);
                Vec3d v3 = BobMathUtil.mat4Transform(t.field_78239_a[3].field_78243_a, transform);
                float[] tex = new float[]{t.field_78239_a[0].field_78241_b, t.field_78239_a[0].field_78242_c, t.field_78239_a[1].field_78241_b, t.field_78239_a[1].field_78242_c, t.field_78239_a[2].field_78241_b, t.field_78239_a[2].field_78242_c};
                tris[i++] = new Triangle(v0, v1, v2, tex);
                tex = new float[]{t.field_78239_a[2].field_78241_b, t.field_78239_a[2].field_78242_c, t.field_78239_a[3].field_78241_b, t.field_78239_a[3].field_78242_c, t.field_78239_a[0].field_78241_b, t.field_78239_a[0].field_78242_c};
                tris[i++] = new Triangle(v2, v3, v0, tex);
            }
            return tris;
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            throw new RuntimeException("Failed to get quads!");
        }
    }

    public static ParticleSlicedMob[] generateCutParticles(Entity ent, float[] plane, ResourceLocation capTex, float capBloom) {
        return ModelRendererUtil.generateCutParticles(ent, plane, capTex, capBloom, null);
    }

    public static ParticleSlicedMob[] generateCutParticles(Entity ent, float[] plane, ResourceLocation capTex, float capBloom, Consumer<List<Triangle>> capConsumer) {
        List<Pair<Matrix4f, ModelRenderer>> boxes = ModelRendererUtil.getBoxesFromMob(ent);
        ArrayList<CutModelData> top = new ArrayList<CutModelData>();
        ArrayList<CutModelData> bottom = new ArrayList<CutModelData>();
        for (Pair<Matrix4f, ModelRenderer> pair : boxes) {
            for (ModelBox b : ((ModelRenderer)pair.getRight()).field_78804_l) {
                VertexData[] dat = ModelRendererUtil.cutAndCapModelBox(b, plane, (Matrix4f)pair.getLeft());
                CutModelData tp = null;
                Object var14_18 = null;
                if (dat[0].positionIndices != null && dat[0].positionIndices.length > 0) {
                    tp = new CutModelData(dat[0], null, false, new ConvexMeshCollider(dat[0].positionIndices, dat[0].vertexArray(), 1.0f));
                    top.add(tp);
                }
                if (dat[1].positionIndices != null && dat[1].positionIndices.length > 0) {
                    CutModelData cutModelData = new CutModelData(dat[1], null, true, new ConvexMeshCollider(dat[1].positionIndices, dat[1].vertexArray(), 1.0f));
                    bottom.add(cutModelData);
                }
                if (dat[2].positionIndices == null || dat[2].positionIndices.length <= 0) continue;
                tp.cap = dat[2];
                var14_17.cap = dat[2];
            }
        }
        if (capConsumer != null) {
            ArrayList<Triangle> tris = new ArrayList<Triangle>();
            for (CutModelData d : top) {
                if (d.cap == null) continue;
                tris.addAll(Arrays.asList(ModelRendererUtil.decompress(d.cap)));
            }
            capConsumer.accept(tris);
        }
        ArrayList<List<CutModelData>> particleChunks = new ArrayList<List<CutModelData>>();
        ModelRendererUtil.generateChunks(particleChunks, top);
        ModelRendererUtil.generateChunks(particleChunks, bottom);
        ArrayList<ParticleSlicedMob> arrayList = new ArrayList<ParticleSlicedMob>(2);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        ResourceLocation tex = ModelRendererUtil.getEntityTexture(ent);
        for (List list : particleChunks) {
            float scale = 3.5f;
            if (((CutModelData)list.get((int)0)).flip) {
                scale = -scale;
            }
            RigidBody body = new RigidBody(ent.field_70170_p, ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
            Collider[] colliders = new Collider[list.size()];
            int i = 0;
            for (CutModelData dat : list) {
                colliders[i++] = dat.collider;
            }
            body.addColliders(colliders);
            body.impulseVelocityDirect(new Vec3(plane[0] * scale, plane[1] * scale, plane[2] * scale), body.globalCentroid.add(0.0, 0.0, 0.0));
            int bodyDL = GL11.glGenLists((int)1);
            int capDL = GL11.glGenLists((int)1);
            GL11.glNewList((int)bodyDL, (int)4864);
            buf.func_181668_a(4, DefaultVertexFormats.field_181710_j);
            for (CutModelData dat : list) {
                dat.data.tessellate(buf, true);
            }
            tes.func_78381_a();
            GL11.glEndList();
            GL11.glNewList((int)capDL, (int)4864);
            buf.func_181668_a(4, DefaultVertexFormats.field_181710_j);
            for (CutModelData dat : list) {
                if (dat.cap == null) continue;
                dat.cap.tessellate(buf, dat.flip, true);
            }
            tes.func_78381_a();
            GL11.glEndList();
            arrayList.add(new ParticleSlicedMob(ent.field_70170_p, body, bodyDL, capDL, tex, capTex, capBloom));
        }
        return arrayList.toArray(new ParticleSlicedMob[0]);
    }

    public static RigidBody[] generateRigidBodiesFromBoxes(Entity ent, List<Pair<Matrix4f, ModelRenderer>> boxes) {
        RigidBody[] arr = new RigidBody[boxes.size()];
        int i = 0;
        for (Pair<Matrix4f, ModelRenderer> p : boxes) {
            RigidBody body = new RigidBody(ent.field_70170_p, ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
            Collider[] colliders = new Collider[((ModelRenderer)p.getRight()).field_78804_l.size()];
            int j = 0;
            for (ModelBox b : ((ModelRenderer)p.getRight()).field_78804_l) {
                Triangle[] data = ModelRendererUtil.triangulate(b, (Matrix4f)p.getLeft());
                VertexData dat = ModelRendererUtil.compress(data);
                colliders[j] = new ConvexMeshCollider(dat.positionIndices, dat.vertexArray(), 1.0f);
                ++j;
            }
            body.addColliders(colliders);
            arr[i] = body;
            ++i;
        }
        return arr;
    }

    public static int[] generateDisplayListsFromBoxes(List<Pair<Matrix4f, ModelRenderer>> boxes) {
        int[] lists = new int[boxes.size()];
        int i = 0;
        for (Pair<Matrix4f, ModelRenderer> p : boxes) {
            int list = GL11.glGenLists((int)1);
            GL11.glNewList((int)list, (int)4864);
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder buf = tes.func_178180_c();
            buf.func_181668_a(4, DefaultVertexFormats.field_181710_j);
            for (ModelBox b : ((ModelRenderer)p.getRight()).field_78804_l) {
                Triangle[] data = ModelRendererUtil.triangulate(b, (Matrix4f)p.getLeft());
                VertexData dat = ModelRendererUtil.compress(data);
                dat.tessellate(buf, true);
            }
            tes.func_78381_a();
            GL11.glEndList();
            lists[i] = list;
            ++i;
        }
        return lists;
    }

    private static void generateChunks(List<List<CutModelData>> chunks, List<CutModelData> toSort) {
        GJK.margin = 0.01f;
        ArrayList chunk = new ArrayList();
        boolean removed = false;
        while (!toSort.isEmpty()) {
            removed = false;
            ArrayList<CutModelData> toAdd = new ArrayList<CutModelData>(2);
            for (CutModelData c : chunk) {
                Iterator<CutModelData> itr = toSort.iterator();
                while (itr.hasNext()) {
                    CutModelData d = itr.next();
                    if (!d.collider.localBox.func_186662_g((double)0.01f).func_72326_a(c.collider.localBox) || !GJK.collidesAny(null, null, c.collider, d.collider)) continue;
                    removed = true;
                    toAdd.add(d);
                    itr.remove();
                }
            }
            chunk.addAll(toAdd);
            if (removed) continue;
            if (!chunk.isEmpty()) {
                chunks.add(chunk);
                chunk = new ArrayList();
            }
            chunk.add(toSort.remove(0));
        }
        if (!chunk.isEmpty()) {
            chunks.add(chunk);
        }
        GJK.margin = 0.0f;
    }

    public static class VertexData {
        public Vec3d[] positions;
        public int[] positionIndices;
        public float[] texCoords;

        public void tessellate(BufferBuilder buf, boolean normal) {
            this.tessellate(buf, false, normal);
        }

        public void tessellate(BufferBuilder buf, boolean flip, boolean normal) {
            if (this.positionIndices != null) {
                for (int i = 0; i < this.positionIndices.length; i += 3) {
                    Vec3d a = this.positions[this.positionIndices[i]];
                    Vec3d b = this.positions[this.positionIndices[i + 1]];
                    Vec3d c = this.positions[this.positionIndices[i + 2]];
                    int tOB = 1;
                    int tOC = 2;
                    if (flip) {
                        Vec3d tmp = b;
                        b = c;
                        c = tmp;
                        tOB = 2;
                        tOC = 1;
                    }
                    if (normal) {
                        Vec3d norm = b.func_178788_d(a).func_72431_c(c.func_178788_d(a)).func_72432_b();
                        buf.func_181662_b(a.field_72450_a, a.field_72448_b, a.field_72449_c).func_187315_a((double)this.texCoords[i * 2 + 0], (double)this.texCoords[i * 2 + 1]).func_181663_c((float)norm.field_72450_a, (float)norm.field_72448_b, (float)norm.field_72449_c).func_181675_d();
                        buf.func_181662_b(b.field_72450_a, b.field_72448_b, b.field_72449_c).func_187315_a((double)this.texCoords[(i + tOB) * 2 + 0], (double)this.texCoords[(i + tOB) * 2 + 1]).func_181663_c((float)norm.field_72450_a, (float)norm.field_72448_b, (float)norm.field_72449_c).func_181675_d();
                        buf.func_181662_b(c.field_72450_a, c.field_72448_b, c.field_72449_c).func_187315_a((double)this.texCoords[(i + tOC) * 2 + 0], (double)this.texCoords[(i + tOC) * 2 + 1]).func_181663_c((float)norm.field_72450_a, (float)norm.field_72448_b, (float)norm.field_72449_c).func_181675_d();
                        continue;
                    }
                    buf.func_181662_b(a.field_72450_a, a.field_72448_b, a.field_72449_c).func_187315_a((double)this.texCoords[i * 2 + 0], (double)this.texCoords[i * 2 + 1]).func_181675_d();
                    buf.func_181662_b(b.field_72450_a, b.field_72448_b, b.field_72449_c).func_187315_a((double)this.texCoords[(i + tOB) * 2 + 0], (double)this.texCoords[(i + tOB) * 2 + 1]).func_181675_d();
                    buf.func_181662_b(c.field_72450_a, c.field_72448_b, c.field_72449_c).func_187315_a((double)this.texCoords[(i + tOC) * 2 + 0], (double)this.texCoords[(i + tOC) * 2 + 1]).func_181675_d();
                }
            }
        }

        public float[] vertexArray() {
            float[] verts = new float[this.positions.length * 3];
            for (int i = 0; i < this.positions.length; ++i) {
                Vec3d pos = this.positions[i];
                verts[i * 3] = (float)pos.field_72450_a;
                verts[i * 3 + 1] = (float)pos.field_72448_b;
                verts[i * 3 + 2] = (float)pos.field_72449_c;
            }
            return verts;
        }
    }

    public static class CutModelData {
        public VertexData data;
        public VertexData cap;
        public boolean flip;
        public ConvexMeshCollider collider;

        public CutModelData(VertexData data, VertexData cap, boolean flip, ConvexMeshCollider collider) {
            this.data = data;
            this.cap = cap;
            this.flip = flip;
            this.collider = collider;
        }
    }
}

