/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyGenerator;
import com.hbm.entity.effect.EntityBlackHole;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.SAFERecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFWatzCore;
import com.hbm.lib.Library;
import com.hbm.lib.ModDamageSource;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.world.FWatz;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityFWatzCore
extends TileEntityMachineBase
implements IControlReceiver,
ITickable,
IEnergyGenerator,
IFluidHandler,
ITankPacketAcceptor {
    public long power;
    public static final long maxPower = 1000000000000L;
    public boolean cooldown = false;
    public FluidTank[] tanks = new FluidTank[3];
    public Fluid[] tankTypes = new Fluid[3];
    public boolean needsUpdate = true;
    public boolean isOn = false;
    public boolean isOk = true;
    public boolean isDoingSomething = false;
    AxisAlignedBB bb = null;

    public TileEntityFWatzCore() {
        super(7);
        this.tanks[0] = new FluidTank(128000);
        this.tankTypes[0] = ModForgeFluids.COOLANT;
        this.tanks[1] = new FluidTank(64000);
        this.tankTypes[1] = ModForgeFluids.AMAT;
        this.tanks[2] = new FluidTank(64000);
        this.tankTypes[2] = ModForgeFluids.ASCHRAB;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return true;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        this.isOn = !this.isOn;
        this.func_70296_d();
    }

    @Override
    public String getName() {
        return "container.fusionaryWatzPlant";
    }

    public int getSingularityType() {
        Item item = this.inventory.getStackInSlot(2).func_77973_b();
        if (item instanceof ItemFWatzCore) {
            ItemFWatzCore core = (ItemFWatzCore)item;
            return core.type;
        }
        return 0;
    }

    public int getType() {
        Item item = this.inventory.getStackInSlot(2).func_77973_b();
        if (item instanceof ItemFWatzCore) {
            ItemFWatzCore core = (ItemFWatzCore)item;
            return core.type * (core.isBaby ? -1 : 1);
        }
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("power");
        this.isOn = compound.func_74767_n("isOn");
        this.tankTypes[0] = ModForgeFluids.COOLANT;
        this.tankTypes[1] = ModForgeFluids.AMAT;
        this.tankTypes[2] = ModForgeFluids.ASCHRAB;
        if (compound.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(compound.func_150295_c("tanks", 10), this.tanks);
        }
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("power", this.power);
        compound.func_74757_a("isOn", this.isOn);
        compound.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        return super.func_189515_b(compound);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_73660_a() {
        NBTTagCompound data;
        block14: {
            block16: {
                block15: {
                    Item item = this.inventory.getStackInSlot(2).func_77973_b();
                    if (item instanceof ItemFWatzCore) {
                        ItemFWatzCore core = (ItemFWatzCore)item;
                        TileEntityFWatzCore.doGravityStuff(this.field_145850_b, this.isOk ? 6.0f : 30.0f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 2.5f, (float)this.field_174879_c.func_177952_p() + 0.5f, ((double)core.type / 2.0 + 2.0) * (core.isBaby ? 0.2 : 1.0));
                    }
                    if (this.field_145850_b.field_72995_K) return;
                    if (!this.isStructureValid(this.field_145850_b)) break block14;
                    this.isOk = true;
                    this.sendSAFEPower();
                    if (this.isDoingSomething) {
                        this.doElse();
                    }
                    if (!((item = this.inventory.getStackInSlot(2).func_77973_b()) instanceof ItemFWatzCore)) break block15;
                    ItemFWatzCore itemCore = (ItemFWatzCore)item;
                    if (!this.isOn) break block15;
                    if (this.cooldown) {
                        this.tanks[0].fill(new FluidStack(this.tankTypes[0], itemCore.coolantRefill), true);
                        if (this.tanks[0].getFluidAmount() >= this.tanks[0].getCapacity()) {
                            this.cooldown = false;
                        }
                        this.isDoingSomething = false;
                        break block16;
                    } else {
                        if (this.tanks[1].getFluidAmount() > itemCore.amatDrain && this.tanks[2].getFluidAmount() > itemCore.aschrabDrain) {
                            this.tanks[0].drain(itemCore.coolantDrain, true);
                            this.tanks[1].drain(itemCore.amatDrain, true);
                            this.tanks[2].drain(itemCore.aschrabDrain, true);
                            this.needsUpdate = true;
                            this.power += itemCore.powerOutput;
                            this.isDoingSomething = true;
                            if (this.field_145850_b.field_73012_v.nextInt(2048) == 0) {
                                this.tryGrowCore();
                            }
                        }
                        if (this.power > 1000000000000L) {
                            this.power = 1000000000000L;
                        }
                        if (this.tanks[0].getFluidAmount() <= 0) {
                            this.cooldown = true;
                        }
                    }
                    break block16;
                }
                this.isDoingSomething = false;
            }
            if (this.power > 1000000000000L) {
                this.power = 1000000000000L;
            }
            this.power = Library.chargeItemsFromTE((IItemHandlerModifiable)this.inventory, 0, this.power, 1000000000000L);
            if (this.inputValidForTank(1, 3) && FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[1], 3, 5)) {
                this.needsUpdate = true;
            }
            if (this.inputValidForTank(2, 4) && FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[2], 4, 6)) {
                this.needsUpdate = true;
            }
            data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
            data.func_74757_a("isOn", this.isOn);
            data.func_74757_a("isOk", true);
            data.func_74757_a("isDo", this.isDoingSomething);
            if (this.needsUpdate) {
                data.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
            }
            this.networkPack(data, 50);
            if (!this.needsUpdate) return;
            this.needsUpdate = false;
            this.func_70296_d();
            return;
        }
        if (this.isOk) {
            data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
            data.func_74757_a("isOn", this.isOn);
            data.func_74757_a("isOk", false);
            data.func_74757_a("isDo", this.isDoingSomething);
            INBTPacketReceiver.networkPack(this, data, 50);
        }
        this.isOk = false;
    }

    public void doElse() {
        ItemStack stack = this.inventory.getStackInSlot(2);
        if (stack.func_77973_b() == ModItems.meteorite_sword_baleful) {
            this.inventory.setStackInSlot(2, new ItemStack(ModItems.meteorite_sword_warped));
        } else if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt.func_74767_n("ntmContagion")) {
                nbt.func_82580_o("ntmContagion");
            }
            if (nbt.func_82582_d()) {
                stack.func_77982_d(null);
            }
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.isOn = data.func_74767_n("isOn");
        this.isOk = data.func_74767_n("isOk");
        this.isDoingSomething = data.func_74767_n("isDo");
        if (data.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(data.func_74775_l("inventory"));
        }
        if (data.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(data.func_150295_c("tanks", 10), this.tanks);
        }
    }

    private void sendSAFEPower() {
        this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(7, 1, 0), Library.POS_X);
        this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(-7, 1, 0), Library.NEG_X);
        this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(0, 1, 7), Library.POS_Z);
        this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(0, 1, -7), Library.NEG_Z);
        this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(7, -3, 0), Library.POS_X);
        this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(-7, -3, 0), Library.NEG_X);
        this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(0, -3, 7), Library.POS_Z);
        this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(0, -3, -7), Library.NEG_Z);
    }

    private void tryGrowCore() {
        ItemStack output = SAFERecipes.getOutput(this.inventory.getStackInSlot(2));
        if (output != null) {
            this.inventory.setStackInSlot(2, output.func_77946_l());
        }
    }

    public boolean isStructureValid(World world) {
        return FWatz.checkHull(world, this.field_174879_c);
    }

    public long getPowerScaled(long i) {
        return this.power / 100L * i / 10000000000L;
    }

    protected boolean inputValidForTank(int tank, int slot) {
        if (this.tanks[tank] != null) {
            return this.inventory.getStackInSlot(slot).func_77973_b() == ModItems.fluid_barrel_infinite || this.isValidFluidForTank(tank, FluidUtil.getFluidContained((ItemStack)this.inventory.getStackInSlot(slot)));
        }
        return false;
    }

    private boolean isValidFluidForTank(int tank, FluidStack stack) {
        if (stack == null || this.tanks[tank] == null) {
            return false;
        }
        return stack.getFluid() == this.tankTypes[tank];
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0], this.tanks[2].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (resource.getFluid() == this.tankTypes[0]) {
            this.needsUpdate = true;
            return this.tanks[0].fill(resource, doFill);
        }
        if (resource.getFluid() == this.tankTypes[1]) {
            this.needsUpdate = true;
            return this.tanks[1].fill(resource, doFill);
        }
        if (resource.getFluid() == this.tankTypes[2]) {
            this.needsUpdate = true;
            return this.tanks[2].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 3) {
            this.tanks[0].readFromNBT(tags[0]);
            this.tanks[1].readFromNBT(tags[1]);
            this.tanks[2].readFromNBT(tags[2]);
        }
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[]{0, 2, 3, 4, 5, 6};
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemFWatzCore) {
            return i == 2;
        }
        return true;
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        Item item;
        if (slot == 2 && (item = itemStack.func_77973_b()) instanceof ItemFWatzCore) {
            ItemFWatzCore core = (ItemFWatzCore)item;
            if (!core.isBaby) {
                return true;
            }
        }
        return slot == 5 || slot == 6;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this) : super.getCapability(capability, facing));
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getMaxPower() {
        return 1000000000000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)this.field_174879_c.func_177958_n() + 0.5 - 8.0, (double)this.field_174879_c.func_177956_o() + 0.5 - 3.0, (double)this.field_174879_c.func_177952_p() + 0.5 - 8.0, (double)this.field_174879_c.func_177958_n() + 0.5 + 8.0, (double)this.field_174879_c.func_177956_o() + 0.5 + 3.0, (double)this.field_174879_c.func_177952_p() + 0.5 + 8.0);
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public static void doGravityStuff(World world, float range, float deathRadius, float posX, float posY, float posZ, double strength) {
        List entities = world.func_72839_b(null, new AxisAlignedBB((double)(posX - range), (double)(posY - range), (double)(posZ - range), (double)(posX + range), (double)(posY + range), (double)(posZ + range)));
        for (Entity e : entities) {
            Vec3 vec;
            double dist;
            if (Library.isCreative(e) || (dist = (vec = Vec3.createVectorHelper((double)posX - e.field_70165_t, (double)posY - e.field_70163_u, (double)posZ - e.field_70161_v)).length()) > (double)range) continue;
            vec = vec.normalize();
            if (!(e instanceof EntityItem)) {
                vec.rotateAroundY((float)Math.toRadians(15.0));
            }
            double r2 = Math.max(dist * dist, 1.0);
            e.field_70159_w += vec.xCoord * strength / r2;
            e.field_70181_x += vec.yCoord * strength * 2.0 / r2;
            e.field_70179_y += vec.zCoord * strength / r2;
            if (e instanceof EntityBlackHole || !(dist < (double)deathRadius)) continue;
            e.func_70097_a(ModDamageSource.blackhole, 1000.0f);
            if (e instanceof EntityLivingBase) continue;
            e.func_70106_y();
        }
    }
}

