/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import api.hbm.energy.IEnergyUser;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.SolidificationRecipes;
import com.hbm.inventory.UpgradeManager;
import com.hbm.inventory.container.ContainerSolidifier;
import com.hbm.inventory.gui.GUISolidifier;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.DirPos;
import com.hbm.lib.Library;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.Tuple;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class TileEntityMachineSolidifier
extends TileEntityMachineBase
implements ITickable,
IGUIProvider,
IEnergyUser,
IFluidHandler,
ITankPacketAcceptor {
    public long power;
    public static final long maxPower = 100000L;
    public static final int usageBase = 500;
    public int usage;
    public int progress;
    public static final int processTimeBase = 100;
    public int processTime;
    public FluidTank tank;
    public UpgradeManager manager = new UpgradeManager();
    AxisAlignedBB bb = null;

    public TileEntityMachineSolidifier() {
        super(4);
        this.tank = new FluidTank(24000);
    }

    @Override
    public String getName() {
        return "container.machineSolidifier";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.manager.eval((IItemHandler)this.inventory, 2, 3);
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 1, this.power, 100000L);
            this.updateConnections();
            int speed = Math.min(this.manager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 3);
            int power = Math.min(this.manager.getLevel(ItemMachineUpgrade.UpgradeType.POWER), 3);
            this.processTime = 100 - 25 * speed;
            this.usage = (500 + 500 * speed) / (power + 1);
            if (this.canProcess()) {
                this.process();
            } else {
                this.progress = 0;
            }
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new FluidTankPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), new FluidTank[]{this.tank}), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74768_a("progress", this.progress);
            data.func_74768_a("usage", this.usage);
            data.func_74768_a("processTime", this.processTime);
            this.tank.writeToNBT(data);
            this.networkPack(data, 50);
        }
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getPos(), pos.getDir());
        }
    }

    private DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 4, this.field_174879_c.func_177952_p(), Library.POS_Y), new DirPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p(), Library.NEG_Y), new DirPos(this.field_174879_c.func_177958_n() + 2, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p(), Library.POS_X), new DirPos(this.field_174879_c.func_177958_n() - 2, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p(), Library.NEG_X), new DirPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + 2, Library.POS_Z), new DirPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() - 2, Library.NEG_Z)};
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return slot == 0;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[]{0};
    }

    public boolean canProcess() {
        if (this.power < (long)this.usage || this.tank.getFluid() == null) {
            return false;
        }
        Tuple.Pair<Integer, ItemStack> out = SolidificationRecipes.getOutput(this.tank.getFluid().getFluid());
        if (out == null) {
            return false;
        }
        int req = out.getKey();
        ItemStack stack = out.getValue();
        if (req > this.tank.getFluidAmount()) {
            return false;
        }
        if (!this.inventory.getStackInSlot(0).func_190926_b()) {
            if (this.inventory.getStackInSlot(0).func_77973_b() != stack.func_77973_b()) {
                return false;
            }
            if (this.inventory.getStackInSlot(0).func_77952_i() != stack.func_77952_i()) {
                return false;
            }
            return this.inventory.getStackInSlot(0).func_190916_E() + stack.func_190916_E() <= this.inventory.getStackInSlot(0).func_77976_d();
        }
        return true;
    }

    public void process() {
        this.power -= (long)this.usage;
        ++this.progress;
        if (this.progress >= this.processTime && this.tank.getFluid() != null) {
            Tuple.Pair<Integer, ItemStack> out = SolidificationRecipes.getOutput(this.tank.getFluid().getFluid());
            int req = out.getKey();
            ItemStack stack = out.getValue();
            this.tank.drain(req, true);
            if (this.inventory.getStackInSlot(0).func_190926_b()) {
                this.inventory.setStackInSlot(0, stack.func_77946_l());
            } else {
                this.inventory.getStackInSlot(0).func_190917_f(stack.func_190916_E());
            }
            this.progress = 0;
            this.func_70296_d();
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74762_e("progress");
        this.usage = nbt.func_74762_e("usage");
        this.processTime = nbt.func_74762_e("processTime");
        this.tank.readFromNBT(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt);
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        this.tank.writeToNBT(nbt);
        return super.func_189515_b(nbt);
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 4), (double)(this.field_174879_c.func_177952_p() + 2));
        }
        return this.bb;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 1) {
            return;
        }
        this.tank.readFromNBT(tags[0]);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tank.getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && resource.amount > 0 && (this.tank.getFluid() == null || this.tank.getFluid().getFluid() == resource.getFluid()) && SolidificationRecipes.hasRecipe(resource.getFluid())) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerSolidifier(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUISolidifier(player.field_71071_by, this);
    }
}

