/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.generator.room;

import com.hbm.blocks.ModBlocks;
import com.hbm.world.generator.CellularDungeon;
import com.hbm.world.generator.CellularDungeonRoom;
import com.hbm.world.generator.DungeonToolbox;
import com.hbm.world.generator.TimedGenerator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class VaultDungeonRoom
extends CellularDungeonRoom {
    public static IBlockState shielding = Blocks.field_150357_h.func_176223_P();
    public static IBlockState tunnel = ModBlocks.ducrete_smooth.func_176223_P();
    public static IBlockState air = Blocks.field_150350_a.func_176223_P();
    public int lineColor;
    public IBlockState line;
    public static IBlockState light = ModBlocks.reinforced_light.func_176223_P();
    public static IBlockState cableLine = ModBlocks.ducrete_reinforced.func_176223_P();

    public VaultDungeonRoom(CellularDungeon parent, int lineColor) {
        super(parent);
        this.line = Blocks.field_192443_dR.func_176203_a(lineColor);
        this.lineColor = lineColor;
    }

    public void resetLine() {
        this.line = Blocks.field_192443_dR.func_176203_a(this.lineColor);
    }

    public void generateMain(World world, int x, int y, int z, int w, int h) {
        DungeonToolbox.generateBox(world, x, y, z, w, h, w, shielding);
        DungeonToolbox.generateBox(world, x + 1, y + 1, z + 1, w - 2, 1, w - 2, this.parent.floor);
        DungeonToolbox.generateBox(world, x + 1, y + h - 2, z + 1, w - 2, 1, w - 2, this.parent.ceiling);
        DungeonToolbox.generateBox(world, x + 1, y + 2, z + 1, w - 2, h - 4, w - 2, air);
    }

    @Override
    public void generateMain(World world, int x, int y, int z) {
        TimedGenerator.ITimedJob job = () -> {
            this.generateMain(world, x, y, z, this.getW(), this.getH());
            for (int dx = -4; dx < 5; dx += 2) {
                for (int dz = -4; dz < 5; dz += 2) {
                    world.func_175656_a(new BlockPos(x + this.getW() / 2 + dx, y + this.getH() - 2, z + this.getW() / 2 + dz), light);
                }
            }
        };
        TimedGenerator.addOp(world, job);
    }

    public int getW() {
        return this.parent.width;
    }

    public int getH() {
        return this.parent.height;
    }

    public IBlockState getLine(int x, int z) {
        return this.line;
    }

    @Override
    public void generateWall(World world, int x, int y, int z, EnumFacing wall, boolean door) {
        TimedGenerator.ITimedJob job = () -> {
            if (wall == EnumFacing.NORTH) {
                DungeonToolbox.generateBox(world, x + 1, y + 2, z + 1, this.getW() - 2, this.getH() - 4, 1, this.parent.wall);
                DungeonToolbox.generateBox(world, x + 1, y + 3, z + 1, this.getW() - 2, 1, 1, this.getLine(x, z));
                if (door) {
                    DungeonToolbox.generateBox(world, x + this.getW() / 2 - 2, y + 2, z, 5, 4, 1, tunnel);
                    DungeonToolbox.generateBox(world, x + this.getW() / 2 - 2, y + 1, z, 5, 1, 1, this.parent.floor);
                    DungeonToolbox.generateBox(world, x + this.getW() / 2 - 1, y + 2, z - 1, 3, 3, 3, air);
                    DungeonToolbox.generateBox(world, x + 1, y + this.getH() - 2, z, this.getW() - 2, 1, 1, cableLine);
                }
            } else if (wall == EnumFacing.SOUTH) {
                DungeonToolbox.generateBox(world, x + 1, y + 2, z + this.getW() - 2, this.getW() - 2, this.getH() - 4, 1, this.parent.wall);
                DungeonToolbox.generateBox(world, x + 1, y + 3, z + this.getW() - 2, this.getW() - 2, 1, 1, this.getLine(x, z));
                if (door) {
                    DungeonToolbox.generateBox(world, x + this.getW() / 2 - 2, y + 2, z + this.getW() - 1, 5, 4, 1, tunnel);
                    DungeonToolbox.generateBox(world, x + this.getW() / 2 - 2, y + 1, z + this.getW() - 1, 5, 1, 1, this.parent.floor);
                    DungeonToolbox.generateBox(world, x + this.getW() / 2 - 1, y + 2, z + this.getW() - 2, 3, 3, 3, air);
                    DungeonToolbox.generateBox(world, x + 1, y + this.getH() - 2, z + this.getW() - 1, this.getW() - 2, 1, 1, cableLine);
                }
            } else if (wall == EnumFacing.WEST) {
                DungeonToolbox.generateBox(world, x + 1, y + 2, z + 1, 1, this.getH() - 4, this.getW() - 2, this.parent.wall);
                DungeonToolbox.generateBox(world, x + 1, y + 3, z + 1, 1, 1, this.getW() - 2, this.getLine(x, z));
                if (door) {
                    DungeonToolbox.generateBox(world, x, y + 2, z + this.getW() / 2 - 2, 1, 4, 5, tunnel);
                    DungeonToolbox.generateBox(world, x, y + 1, z + this.getW() / 2 - 2, 1, 1, 5, this.parent.floor);
                    DungeonToolbox.generateBox(world, x - 1, y + 2, z + this.getW() / 2 - 1, 3, 3, 3, air);
                    DungeonToolbox.generateBox(world, x, y + this.getH() - 2, z + 1, 1, 1, this.getW() - 2, cableLine);
                }
            } else if (wall == EnumFacing.EAST) {
                DungeonToolbox.generateBox(world, x + this.getW() - 2, y + 2, z + 1, 1, this.getH() - 4, this.getW() - 2, this.parent.wall);
                DungeonToolbox.generateBox(world, x + this.getW() - 2, y + 3, z + 1, 1, 1, this.getW() - 2, this.getLine(x, z));
                if (door) {
                    DungeonToolbox.generateBox(world, x + this.getW() - 1, y + 2, z + this.getW() / 2 - 2, 1, 4, 5, tunnel);
                    DungeonToolbox.generateBox(world, x + this.getW() - 1, y + 1, z + this.getW() / 2 - 2, 1, 1, 5, this.parent.floor);
                    DungeonToolbox.generateBox(world, x + this.getW() - 2, y + 2, z + this.getW() / 2 - 1, 3, 3, 3, air);
                    DungeonToolbox.generateBox(world, x + this.getW() - 1, y + this.getH() - 2, z + 1, 1, 1, this.getW() - 2, cableLine);
                }
            }
        };
        TimedGenerator.addOp(world, job);
    }
}

