/*
 * Decompiled with CFR 0.152.
 */
package rctoys.entity;

import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_10584;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_8710;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import rctoys.RCToysMod;
import rctoys.item.RemoteItem;
import rctoys.item.RemoteLinkComponent;
import rctoys.network.c2s.MotorSoundS2CPacket;
import rctoys.network.c2s.RemoteControlC2SPacket;

public abstract class AbstractRCEntity
extends class_1297 {
    private static final class_2940<Integer> COLOR = class_2945.method_12791(AbstractRCEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> ENABLED = class_2945.method_12791(AbstractRCEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Float> QX = class_2945.method_12791(AbstractRCEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> QY = class_2945.method_12791(AbstractRCEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> QZ = class_2945.method_12791(AbstractRCEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> QW = class_2945.method_12791(AbstractRCEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> THROTTLE = class_2945.method_12791(AbstractRCEntity.class, (class_2941)class_2943.field_13320);
    private final class_10584 interpolator = new class_10584((class_1297)this, 3);
    public Quaternionf clientQuaternion;
    public Quaternionf clientQuaternionPrevious;

    public AbstractRCEntity(class_1299<?> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(COLOR, (Object)this.getDefaultColor());
        builder.method_56912(ENABLED, (Object)false);
        builder.method_56912(QX, (Object)Float.valueOf(0.0f));
        builder.method_56912(QY, (Object)Float.valueOf(0.0f));
        builder.method_56912(QZ, (Object)Float.valueOf(0.0f));
        builder.method_56912(QW, (Object)Float.valueOf(1.0f));
        builder.method_56912(THROTTLE, (Object)Float.valueOf(0.0f));
    }

    public void setColor(int color) {
        this.field_6011.method_12778(COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.field_6011.method_12789(COLOR);
    }

    public abstract int getDefaultColor();

    public void setEnabled(boolean enabled) {
        if (enabled && !this.isEnabled()) {
            this.method_5783(RCToysMod.REMOTE_LINK_SOUND, 2.0f, 0.7f);
        }
        this.field_6011.method_12778(ENABLED, (Object)enabled);
    }

    public boolean isEnabled() {
        return (Boolean)this.field_6011.method_12789(ENABLED);
    }

    public void setQuaternion(Quaternionf quaternion) {
        this.field_6011.method_12778(QX, (Object)Float.valueOf(quaternion.x()));
        this.field_6011.method_12778(QY, (Object)Float.valueOf(quaternion.y()));
        this.field_6011.method_12778(QZ, (Object)Float.valueOf(quaternion.z()));
        this.field_6011.method_12778(QW, (Object)Float.valueOf(quaternion.w()));
    }

    public Quaternionf getQuaternion() {
        return new Quaternionf(((Float)this.field_6011.method_12789(QX)).floatValue(), ((Float)this.field_6011.method_12789(QY)).floatValue(), ((Float)this.field_6011.method_12789(QZ)).floatValue(), ((Float)this.field_6011.method_12789(QW)).floatValue());
    }

    public Quaternionf getLerpedQuaternion(float tickProgress) {
        if (this.clientQuaternion == null) {
            return new Quaternionf();
        }
        if (tickProgress == 1.0f || this.clientQuaternionPrevious == null) {
            return this.clientQuaternion;
        }
        return new Quaternionf((Quaternionfc)this.clientQuaternionPrevious).slerp((Quaternionfc)this.clientQuaternion, tickProgress);
    }

    public void setThrottle(float throttle) {
        this.field_6011.method_12778(THROTTLE, (Object)Float.valueOf(throttle));
    }

    public float getThrottle() {
        return ((Float)this.field_6011.method_12789(THROTTLE)).floatValue();
    }

    public class_10584 method_66233() {
        return this.interpolator;
    }

    public void method_5773() {
        super.method_5773();
        this.interpolator.method_66271();
        class_1937 world = this.method_73183();
        if (world.method_8608()) {
            if (this.clientQuaternion != null) {
                this.clientQuaternionPrevious = new Quaternionf((Quaternionfc)this.clientQuaternion);
                this.clientQuaternion = new Quaternionf((Quaternionfc)this.clientQuaternion).slerp((Quaternionfc)this.getQuaternion(), 0.4f);
            } else {
                this.clientQuaternion = this.getQuaternion();
            }
        } else {
            this.tickPhysics();
            this.setQuaternion(this.updateQuaternion());
            for (class_1297 other : this.method_73183().method_8335((class_1297)this, this.method_5829())) {
                this.method_5697(other);
            }
            this.field_6037 = true;
            this.field_6007 = true;
        }
    }

    public abstract void tickPhysics();

    public abstract Quaternionf updateQuaternion();

    public abstract void remoteControlInput(boolean[] var1);

    public abstract class_1792 asItem();

    protected double method_7490() {
        return 0.08;
    }

    public boolean method_5810() {
        return true;
    }

    public float method_49476() {
        return 0.5f;
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!stack.method_31574(RCToysMod.REMOTE)) {
            if ((double)player.method_55693() <= 0.31) {
                player.method_5804((class_1297)this);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        class_1937 world = this.method_73183();
        if (!world.method_8608()) {
            AbstractRCEntity previousRCEntity = RemoteItem.getRCEntity(stack, (class_1937)((class_3218)world));
            if (previousRCEntity != null) {
                this.cleanRemoteLinks(previousRCEntity.method_5667());
                previousRCEntity.setEnabled(false);
            }
            this.cleanRemoteLinks(this.method_5667());
            this.setEnabled(true);
            stack.method_57379(RCToysMod.REMOTE_LINK, (Object)new RemoteLinkComponent(this.method_5667(), this.method_5477().getString()));
            player.method_7353((class_2561)class_2561.method_43471((String)"entity.rctoys.remote_linked"), false);
        }
        return class_1269.field_5812;
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        this.method_5768(world);
        if (world.method_64395().method_8355(class_1928.field_19393)) {
            class_1799 itemStack = new class_1799((class_1935)this.asItem());
            itemStack.method_57379(class_9334.field_49631, (Object)this.method_5797());
            if (this.getColor() != this.getDefaultColor()) {
                itemStack.method_57379(class_9334.field_49644, (Object)new class_9282(this.getColor()));
            }
            this.method_5775(world, itemStack);
        }
        return true;
    }

    public void method_64615(class_1297.class_5529 reason) {
        class_1937 world = this.method_73183();
        if (world.method_8608()) {
            return;
        }
        this.cleanRemoteLinks(this.method_5667());
    }

    public class_3414 getSoundLoop() {
        return RCToysMod.CAR_LOOP_SOUND;
    }

    public void method_5837(class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new MotorSoundS2CPacket(this.method_5628(), true, this.getSoundLoop().comp_3319()));
    }

    public void method_5742(class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new MotorSoundS2CPacket(this.method_5628(), false, this.getSoundLoop().comp_3319()));
    }

    private void cleanRemoteLinks(UUID rcUUID) {
        for (class_3222 player : ((class_3218)this.method_73183()).method_18456()) {
            for (class_1799 stack : player.method_31548()) {
                UUID foundUUID;
                if (!stack.method_57826(RCToysMod.REMOTE_LINK) || !rcUUID.equals(foundUUID = ((RemoteLinkComponent)stack.method_58694(RCToysMod.REMOTE_LINK)).uuid())) continue;
                stack.method_57379(RCToysMod.REMOTE_LINK, null);
            }
        }
    }

    protected void method_5749(class_11368 view) {
        this.setColor(view.method_71424("color", -1));
        this.setQuaternion(new Quaternionf(view.method_71423("qx", 0.0f), view.method_71423("qy", 0.0f), view.method_71423("qz", 0.0f), view.method_71423("qw", 0.0f)).normalize());
    }

    protected void method_5652(class_11372 view) {
        view.method_71465("color", ((Integer)this.field_6011.method_12789(COLOR)).intValue());
        view.method_71464("qx", ((Float)this.field_6011.method_12789(QX)).floatValue());
        view.method_71464("qy", ((Float)this.field_6011.method_12789(QY)).floatValue());
        view.method_71464("qz", ((Float)this.field_6011.method_12789(QZ)).floatValue());
        view.method_71464("qw", ((Float)this.field_6011.method_12789(QW)).floatValue());
    }

    public static void receiveControl(RemoteControlC2SPacket payload, ServerPlayNetworking.Context context) {
        int input = payload.input();
        context.server().execute(() -> {
            class_3222 player = context.player();
            class_1799 stack = player.method_6047();
            if (stack.method_31574(RCToysMod.REMOTE) && stack.method_57826(RCToysMod.REMOTE_LINK)) {
                UUID rcUUID = ((RemoteLinkComponent)stack.method_58694(RCToysMod.REMOTE_LINK)).uuid();
                class_1297 entity = player.method_51469().method_66347(rcUUID);
                if (entity != null && entity instanceof AbstractRCEntity) {
                    ((AbstractRCEntity)entity).remoteControlInput(AbstractRCEntity.unpackInput(input));
                }
            }
        });
    }

    public static boolean[] unpackInput(int input) {
        boolean[] inputArray = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            inputArray[i] = (input >> i & 1) == 1;
        }
        return inputArray;
    }
}

