/*
 * Decompiled with CFR 0.152.
 */
package rctoys.entity;

import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import rctoys.RCToysMod;
import rctoys.entity.AbstractRCEntity;

public class PlaneEntity
extends AbstractRCEntity {
    private int pitch;
    private int roll;
    private int throttleControl;
    private float throttle;

    public PlaneEntity(class_1299<?> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    public class_1792 asItem() {
        return RCToysMod.PLANE_ITEM;
    }

    @Override
    public int getDefaultColor() {
        return -16201290;
    }

    @Override
    public class_3414 getSoundLoop() {
        return RCToysMod.PLANE_LOOP_SOUND;
    }

    public float getMaximumThrust() {
        return 0.05f;
    }

    @Override
    protected double method_7490() {
        return 0.05;
    }

    @Override
    public void tickPhysics() {
        if (!this.isEnabled()) {
            this.pitch = 0;
            this.roll = 0;
            this.throttleControl = 0;
            this.throttle = 0.0f;
        }
        this.throttle = Math.clamp(this.throttle + (float)this.throttleControl * 0.1f, 0.0f, 1.0f);
        this.setThrottle(this.throttle);
        Quaternionf quaternion = this.getQuaternion();
        Quaternionf invQuaternion = this.getQuaternion().invert();
        Vector3f acc = new Vector3f(0.0f, 0.0f, -1.0f).rotate((Quaternionfc)quaternion).mul(this.getMaximumThrust() * this.throttle);
        Vector3f right = new Vector3f(-1.0f, 0.0f, 0.0f).rotate((Quaternionfc)quaternion);
        float wingSpan = 0.8f;
        float wingArea = 0.5f;
        float aspectRatio = wingSpan * wingSpan / wingArea;
        Vector3f velocity = this.method_18798().method_46409();
        Vector3f localVelocity = this.method_18798().method_46409().rotate((Quaternionfc)invQuaternion);
        float stallAngle = 0.25f;
        float angleOfAttack = (float)(-Math.atan2(localVelocity.y(), -localVelocity.z()));
        float inducedLift = angleOfAttack * (aspectRatio / (aspectRatio + 2.0f)) * (float)Math.PI * 2.0f;
        if (Math.abs(angleOfAttack) > stallAngle) {
            inducedLift *= (float)Math.cos((Math.abs(angleOfAttack) - stallAngle) * 0.7853982f);
        }
        float inducedDrag = inducedLift * inducedLift / (aspectRatio * (float)Math.PI);
        if (Math.abs(angleOfAttack) > stallAngle) {
            inducedDrag += (Math.abs(angleOfAttack) - stallAngle) * 0.5f;
        }
        if (velocity.lengthSquared() > 1.0E-8f) {
            float dynamicPressure = velocity.lengthSquared() * wingArea * 1.225f * 0.5f;
            Vector3f lift = new Vector3f((Vector3fc)velocity).normalize().cross((Vector3fc)right).mul(Math.clamp(inducedLift * dynamicPressure, 0.0f, 16.0f));
            Vector3f drag = new Vector3f((Vector3fc)velocity).normalize((inducedDrag + 0.1f) * dynamicPressure);
            if (lift.isFinite()) {
                acc.add((Vector3fc)lift);
            }
            if (drag.isFinite()) {
                acc.sub((Vector3fc)drag);
            }
        }
        this.method_5762(acc.x(), acc.y(), acc.z());
        this.method_56990();
        if (this.method_5799() || this.method_24828() && this.throttle == 0.0f) {
            this.method_18799(this.method_18798().method_18805((double)0.8f, 0.5, (double)0.8f));
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
    }

    @Override
    public Quaternionf updateQuaternion() {
        Quaternionf quaternion = this.getQuaternion();
        Vector3f velocity = this.method_18798().method_46409();
        if (velocity.lengthSquared() > 1.0E-8f) {
            Quaternionf invQuaternion = this.getQuaternion().invert();
            Vector3f localVelocity = new Vector3f((Vector3fc)velocity).rotate((Quaternionfc)invQuaternion).normalize();
            quaternion.rotateX(localVelocity.y() * 0.5f);
            quaternion.rotateY(localVelocity.x() * -0.5f);
            if (!this.method_24828()) {
                quaternion.rotateZ((float)this.roll * Math.clamp(velocity.length() * 0.1f, 0.0f, 0.1f));
            }
            quaternion.rotateX((float)this.pitch * Math.clamp(velocity.length() * 0.1f, 0.0f, 0.1f));
        }
        if (this.method_24828()) {
            quaternion.rotateY((float)this.roll * 0.1f);
        }
        return quaternion.normalize();
    }

    @Override
    public void remoteControlInput(boolean[] inputArray) {
        this.pitch = 0;
        this.roll = 0;
        this.throttleControl = 0;
        if (inputArray[0]) {
            --this.pitch;
        }
        if (inputArray[1]) {
            ++this.pitch;
        }
        if (inputArray[2]) {
            ++this.roll;
        }
        if (inputArray[3]) {
            --this.roll;
        }
        if (inputArray[4]) {
            ++this.throttleControl;
        }
        if (inputArray[5]) {
            --this.throttleControl;
        }
    }

    public boolean method_27298() {
        return this.method_18798().method_1033() > 0.25;
    }
}

