/*
 * Decompiled with CFR 0.152.
 */
package rctoys.client.sound;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_7923;
import rctoys.client.sound.RCMotorSound;
import rctoys.entity.AbstractRCEntity;
import rctoys.network.c2s.MotorSoundS2CPacket;

@Environment(value=EnvType.CLIENT)
public class DynamicSoundManager {
    private static DynamicSoundManager instance;
    private final List<RCMotorSound> activeSounds = new ArrayList<RCMotorSound>();

    private DynamicSoundManager() {
    }

    public static DynamicSoundManager getInstance() {
        if (instance == null) {
            instance = new DynamicSoundManager();
        }
        return instance;
    }

    public <T extends RCMotorSound> void play(T soundInstance) {
        if (this.activeSounds.contains(soundInstance)) {
            return;
        }
        class_310 client = class_310.method_1551();
        client.method_1483().method_4873(soundInstance);
        this.activeSounds.add(soundInstance);
    }

    public Optional<RCMotorSound> getPlayingSoundInstance(class_3414 soundEvent) {
        for (RCMotorSound activeSound : this.activeSounds) {
            if (!activeSound.method_4775().equals((Object)soundEvent.comp_3319())) continue;
            return Optional.of(activeSound);
        }
        return Optional.empty();
    }

    public static void receiveSoundPacket(MotorSoundS2CPacket payload, ClientPlayNetworking.Context context) {
        int entityID = payload.entityID();
        boolean enable = payload.enable();
        class_2960 soundID = payload.sound();
        class_310 client = context.client();
        client.execute(() -> {
            class_1297 entity = client.field_1687.method_8469(entityID);
            class_3414 sound = (class_3414)class_7923.field_41172.method_63535(soundID);
            if (entity != null && entity instanceof AbstractRCEntity) {
                DynamicSoundManager instance = DynamicSoundManager.getInstance();
                if (enable) {
                    instance.play(new RCMotorSound((AbstractRCEntity)entity, sound));
                } else {
                    instance.getPlayingSoundInstance(sound).ifPresent(s -> client.method_1483().method_4870((class_1113)s));
                }
            }
        });
    }
}

