/*
 * Decompiled with CFR 0.152.
 */
package rctoys.entity;

import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import rctoys.RCToysMod;
import rctoys.entity.AbstractRCEntity;

public class CarEntity
extends AbstractRCEntity {
    private int throttle;
    private int steering;

    public CarEntity(class_1299<?> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    public class_1792 asItem() {
        return RCToysMod.CAR_ITEM;
    }

    @Override
    public int getDefaultColor() {
        return -48340;
    }

    @Override
    public void tickPhysics() {
        if (!this.isEnabled()) {
            this.throttle = 0;
            this.steering = 0;
        }
        if (this.method_24828()) {
            this.method_18799(this.method_18798().method_1021(this.throttle == 0 ? 0.9 : 0.99));
            Vector3f velocity = this.method_18798().method_46409();
            Vector3f horizontalVelocity = new Vector3f(velocity.x(), 0.0f, velocity.z());
            Vector3f forward = new Vector3f(0.0f, 0.0f, -1.0f).rotateY(this.method_36454() * ((float)(-Math.PI) / 180) + (float)Math.PI);
            float forwardMagnitude = horizontalVelocity.dot((Vector3fc)forward);
            Vector3f forwardVelocity = new Vector3f((Vector3fc)forward).mul(forwardMagnitude);
            Vector3f lateralVelocity = new Vector3f((Vector3fc)horizontalVelocity).sub((Vector3fc)forwardVelocity);
            float acc = (float)this.throttle * 0.02f;
            forwardVelocity.add((Vector3fc)new Vector3f((Vector3fc)forward).mul(acc));
            float lateralFriction = 0.6f;
            lateralVelocity.mul(lateralFriction);
            Vector3f newVelocity = new Vector3f((Vector3fc)forwardVelocity).add((Vector3fc)lateralVelocity);
            this.method_18800(newVelocity.x(), velocity.y(), newVelocity.z());
            float turnSpeed = -12.0f / (1.0f + forwardMagnitude * 2.0f);
            this.method_36456(this.method_36454() + (float)this.steering * turnSpeed);
        } else {
            this.method_36457((float)(-this.method_18798().method_10214() * 100.0));
            this.method_56990();
        }
        if (this.method_5799()) {
            this.method_18799(this.method_18798().method_18805((double)0.8f, 0.5, (double)0.8f));
        }
        double previousY = this.method_23318();
        this.method_5784(class_1313.field_6308, this.method_18798());
        double deltaY = this.method_23318() - previousY;
        if (deltaY > 0.1 && this.field_5992) {
            double speed = Math.hypot(this.method_18798().method_10216(), this.method_18798().method_10215());
            double jump = 0.1 + Math.min(speed, 1.0);
            this.method_5762(0.0, jump, 0.0);
        }
    }

    @Override
    public Quaternionf updateQuaternion() {
        Quaternionf quaternion = new Quaternionf();
        quaternion.rotateY(this.method_36454() * ((float)(-Math.PI) / 180) + (float)Math.PI);
        quaternion.rotateX(this.method_36455() * ((float)(-Math.PI) / 180));
        return quaternion;
    }

    @Override
    public void remoteControlInput(boolean[] inputArray) {
        this.throttle = 0;
        this.steering = 0;
        if (inputArray[0]) {
            ++this.throttle;
        }
        if (inputArray[1]) {
            --this.throttle;
        }
        if (inputArray[2]) {
            ++this.steering;
        }
        if (inputArray[3]) {
            --this.steering;
        }
        if (inputArray[4]) {
            this.throttle *= 2;
        }
        this.setThrottle(this.throttle);
    }

    public boolean method_27298() {
        return this.method_18798().method_1033() > 0.25;
    }
}

