/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.strawberrylib.api.module;

import moriyashiine.strawberrylib.api.objects.enums.PacketTarget;
import moriyashiine.strawberrylib.api.objects.enums.ParticleAnchor;
import moriyashiine.strawberrylib.api.objects.enums.SubmersionGate;
import moriyashiine.strawberrylib.api.objects.records.ParticleVelocity;
import moriyashiine.strawberrylib.impl.client.payload.AddAnchoredParticlePayload;
import moriyashiine.strawberrylib.impl.client.payload.AddEmitterParticlePayload;
import moriyashiine.strawberrylib.impl.client.payload.AddParticlesPayload;
import moriyashiine.strawberrylib.impl.client.payload.PlayAnchoredSoundPayload;
import moriyashiine.strawberrylib.impl.common.StrawberryLib;
import moriyashiine.strawberrylib.impl.common.component.entity.ModelReplacementComponent;
import moriyashiine.strawberrylib.impl.common.init.ModEntityComponents;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalFluidTags;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1321;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_239;
import net.minecraft.class_2396;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public final class SLibUtils {
    @Nullable
    public static class_1309 getModelReplacement(class_1657 player) {
        return ((ModelReplacementComponent)ModEntityComponents.MODEL_REPLACEMENT.get((Object)player)).getReplacement();
    }

    public static void setModelReplacement(class_1657 player, @Nullable class_1299<?> entityType) {
        ModelReplacementComponent modelReplacementComponent = (ModelReplacementComponent)ModEntityComponents.MODEL_REPLACEMENT.get((Object)player);
        modelReplacementComponent.setReplacementType(entityType);
        if (!player.method_73183().method_8608()) {
            modelReplacementComponent.sync();
        }
    }

    public static boolean conditionallyApplyAttributeModifier(class_1309 entity, class_6880<class_1320> attribute, class_1322 modifier, boolean shouldHave) {
        class_1324 instance = entity.method_5996(attribute);
        if (instance == null || entity.method_73183().method_8608()) {
            return false;
        }
        if (shouldHave) {
            if (!instance.method_6196(modifier.comp_2447())) {
                instance.method_26837(modifier);
                return true;
            }
        } else if (instance.method_6196(modifier.comp_2447())) {
            instance.method_6202(modifier);
            return true;
        }
        return false;
    }

    public static boolean canSee(class_1297 host, class_1297 target, int range) {
        if (target.method_73183() == host.method_73183() && host.method_73189().method_1022(target.method_73189()) <= 32.0) {
            for (int i = -range; i <= range; ++i) {
                if (host.method_73183().method_17742(new class_3959(host.method_73189().method_1031(0.0, (double)i, 0.0), target.method_73189().method_1031(0.0, (double)i, 0.0), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, host)).method_17783() != class_239.class_240.field_1333) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAttackingPlayerCooldownWithinThreshold(float threshold) {
        return StrawberryLib.currentAttackCooldown == -1.0f || StrawberryLib.currentAttackCooldown >= threshold;
    }

    public static boolean isGroundedOrAirborne(class_1309 living, boolean allowWater) {
        if (living instanceof class_1657) {
            class_1657 player = (class_1657)living;
            if (player.method_31549().field_7479) {
                return false;
            }
        }
        if (!allowWater && (living.method_5799() || living.method_5681())) {
            return false;
        }
        return !living.method_5765() && !living.method_6123() && !living.method_6128() && !living.method_6101();
    }

    public static boolean isGroundedOrAirborne(class_1309 living) {
        return SLibUtils.isGroundedOrAirborne(living, false);
    }

    public static boolean isCrouching(class_1297 entity, boolean checkSneaking) {
        class_1657 player;
        class_1309 class_13092;
        class_1321 tameable;
        if (checkSneaking && entity.method_5715()) {
            return true;
        }
        if (entity instanceof class_1321 && (tameable = (class_1321)entity).method_24345()) {
            return true;
        }
        return entity instanceof class_1308 && (class_13092 = entity.method_5642()) instanceof class_1657 && (player = (class_1657)class_13092).method_5715();
    }

    public static boolean isSubmerged(class_1297 entity, SubmersionGate gate) {
        for (int i = 0; i < class_3532.method_15386((float)entity.method_17682()); ++i) {
            class_2680 blockState = entity.method_73183().method_8320(entity.method_24515().method_10086(i));
            if (gate.allowsWater() && !blockState.method_27852(class_2246.field_10422) && blockState.method_26227().method_15767(ConventionalFluidTags.WATER)) {
                return true;
            }
            if (gate.allowsLava() && blockState.method_26227().method_15767(ConventionalFluidTags.LAVA)) {
                return true;
            }
            if (!gate.allowsPowderSnow() || !blockState.method_27852(class_2246.field_27879)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSufficientlyHigh(class_1297 entity, double distanceFromGround) {
        return entity.method_73183().method_17742(new class_3959(entity.method_73189(), entity.method_73189().method_1031(0.0, -distanceFromGround, 0.0), class_3959.class_3960.field_17558, class_3959.class_242.field_1347, entity)).method_17783() == class_239.class_240.field_1333;
    }

    public static boolean shouldHurt(class_1297 attacker, class_1297 target) {
        if (attacker == null || target == null) {
            return true;
        }
        if (attacker == target || attacker.method_5626(target) || target.method_5626(attacker)) {
            return false;
        }
        if (attacker.method_5722(target) || target.method_5722(attacker)) {
            return false;
        }
        if (attacker instanceof class_1657) {
            class_1657 attackingPlayer = (class_1657)attacker;
            if (target instanceof class_1657) {
                class_1657 targetPlayer = (class_1657)target;
                return attackingPlayer.method_7256(targetPlayer);
            }
        }
        return true;
    }

    public static boolean insertOrDrop(class_3218 world, class_1297 entity, class_1799 stack) {
        class_1657 player;
        int emptySlot;
        if (entity instanceof class_1657 && (emptySlot = SLibUtils.findEmptySlot((player = (class_1657)entity).method_31548())) != -1 && player.method_31548().method_7367(emptySlot, stack)) {
            return true;
        }
        entity.method_5775(world, stack);
        return false;
    }

    public static int findEmptySlot(class_1661 inventory) {
        for (int i = 9; i < inventory.method_67533().size(); ++i) {
            if (!((class_1799)inventory.method_67533().get(i)).method_7960()) continue;
            return i;
        }
        return -1;
    }

    public static void addAnchoredParticle(class_1297 entity, class_2396<?> particleType, double yOffset, double speed, double intensity, PacketTarget packetTarget) {
        if (packetTarget.sendsToOthers()) {
            PlayerLookup.tracking((class_1297)entity).forEach(receiver -> AddAnchoredParticlePayload.send(receiver, entity, particleType, yOffset, speed, intensity));
        }
        if (packetTarget.sendsToSelf() && entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            AddAnchoredParticlePayload.send(player, (class_1297)player, particleType, yOffset, speed, intensity);
        }
    }

    public static void addAnchoredParticle(class_1297 entity, class_2396<?> particleType, double yOffset, double speed, double intensity) {
        SLibUtils.addAnchoredParticle(entity, particleType, yOffset, speed, intensity, PacketTarget.ALL);
    }

    public static void addEmitterParticle(class_1297 entity, class_2396<?> particleType, PacketTarget packetTarget) {
        if (packetTarget.sendsToOthers()) {
            PlayerLookup.tracking((class_1297)entity).forEach(receiver -> AddEmitterParticlePayload.send(receiver, entity, particleType));
        }
        if (packetTarget.sendsToSelf() && entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            AddEmitterParticlePayload.send(player, (class_1297)player, particleType);
        }
    }

    public static void addEmitterParticle(class_1297 entity, class_2396<?> particleType) {
        SLibUtils.addEmitterParticle(entity, particleType, PacketTarget.ALL);
    }

    public static void addParticles(class_1297 entity, class_2396<?> particleType, int count, ParticleAnchor anchor, PacketTarget packetTarget, ParticleVelocity velocity) {
        if (packetTarget.sendsToOthers()) {
            PlayerLookup.tracking((class_1297)entity).forEach(receiver -> AddParticlesPayload.send(receiver, entity, particleType, count, anchor, velocity));
        }
        if (packetTarget.sendsToSelf() && entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            AddParticlesPayload.send(player, (class_1297)player, particleType, count, anchor, velocity);
        }
    }

    public static void addParticles(class_1297 entity, class_2396<?> particleType, int count, ParticleAnchor anchor, ParticleVelocity velocity) {
        SLibUtils.addParticles(entity, particleType, count, anchor, PacketTarget.ALL, velocity);
    }

    public static void addParticles(class_1297 entity, class_2396<?> particleType, int count, ParticleAnchor anchor) {
        SLibUtils.addParticles(entity, particleType, count, anchor, ParticleVelocity.ZERO);
    }

    public static void playSound(class_1297 entity, class_3414 soundEvent, float volume, float pitch) {
        entity.method_73183().method_8396(null, entity.method_24515(), soundEvent, entity.method_5634(), volume, pitch);
    }

    public static void playSound(class_1297 entity, class_3414 soundEvent) {
        SLibUtils.playSound(entity, soundEvent, 1.0f, 1.0f);
    }

    public static void playAnchoredSound(class_1297 entity, class_3414 soundEvent, PacketTarget packetTarget) {
        if (packetTarget.sendsToOthers()) {
            PlayerLookup.tracking((class_1297)entity).forEach(receiver -> PlayAnchoredSoundPayload.send(receiver, entity, soundEvent));
        }
        if (packetTarget.sendsToSelf() && entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            PlayAnchoredSoundPayload.send(player, (class_1297)player, soundEvent);
        }
    }

    public static void playAnchoredSound(class_1297 entity, class_3414 soundEvent) {
        SLibUtils.playAnchoredSound(entity, soundEvent, PacketTarget.ALL);
    }
}

