/*
 * Decompiled with CFR 0.152.
 */
package dev.bypixel.redivelocity;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.ProxyServer;
import dev.bypixel.redivelocity.RediVelocityCoroutineScope;
import dev.bypixel.redivelocity.cache.PlayerCache;
import dev.bypixel.redivelocity.cache.ProxyCache;
import dev.bypixel.redivelocity.command.FindCommand;
import dev.bypixel.redivelocity.command.RediVelocityCommand;
import dev.bypixel.redivelocity.election.ElectionScheduler;
import dev.bypixel.redivelocity.event.DisconnectListener;
import dev.bypixel.redivelocity.event.PostLoginListener;
import dev.bypixel.redivelocity.event.ProxyPingListener;
import dev.bypixel.redivelocity.event.ServerSwitchListener;
import dev.bypixel.redivelocity.feature.globalPlayercount.PlayercountScheduler;
import dev.bypixel.redivelocity.heartbeat.HeartbeatScheduler;
import dev.bypixel.redivelocity.libs.boostedyaml.YamlDocument;
import dev.bypixel.redivelocity.libs.boostedyaml.dvs.versioning.BasicVersioning;
import dev.bypixel.redivelocity.libs.boostedyaml.route.Route;
import dev.bypixel.redivelocity.libs.boostedyaml.settings.Settings;
import dev.bypixel.redivelocity.libs.boostedyaml.settings.dumper.DumperSettings;
import dev.bypixel.redivelocity.libs.boostedyaml.settings.general.GeneralSettings;
import dev.bypixel.redivelocity.libs.boostedyaml.settings.loader.LoaderSettings;
import dev.bypixel.redivelocity.libs.boostedyaml.settings.updater.UpdaterSettings;
import dev.bypixel.redivelocity.libs.commandapi.CommandAPI;
import dev.bypixel.redivelocity.libs.commandapi.CommandAPIVelocityConfig;
import dev.bypixel.redivelocity.libs.json.JSONObject;
import dev.bypixel.redivelocity.libs.lettucewrapper.LettuceRedisClient;
import dev.bypixel.redivelocity.libs.lettucewrapper.listener.RedisListener;
import dev.bypixel.redivelocity.pubsub.KickListener;
import dev.bypixel.redivelocity.pubsub.LeaderElectionListener;
import dev.bypixel.redivelocity.util.CloudUtil;
import dev.bypixel.redivelocity.util.ProxyIdGenerator;
import dev.bypixel.redivelocity.util.RediVelocityLogger;
import dev.bypixel.redivelocity.util.UpdateUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.bxteam.quark.velocity.VelocityLibraryManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 .2\u00020\u0001:\u0001.B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0007J\u0010\u0010,\u001a\u00020)2\u0006\u0010*\u001a\u00020-H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u001a\u0010\u001d\u001a\u00020\u001eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0016\u0010#\u001a\n %*\u0004\u0018\u00010$0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Ldev/bypixel/redivelocity/RediVelocity;", "", "proxy", "Lcom/velocitypowered/api/proxy/ProxyServer;", "<init>", "(Lcom/velocitypowered/api/proxy/ProxyServer;)V", "getProxy", "()Lcom/velocitypowered/api/proxy/ProxyServer;", "libraryManager", "Lorg/bxteam/quark/velocity/VelocityLibraryManager;", "getLibraryManager", "()Lorg/bxteam/quark/velocity/VelocityLibraryManager;", "setLibraryManager", "(Lorg/bxteam/quark/velocity/VelocityLibraryManager;)V", "lettuceClient", "Ldev/bypixel/redivelocity/libs/lettucewrapper/LettuceRedisClient;", "getLettuceClient", "()Ldev/bypixel/redivelocity/libs/lettucewrapper/LettuceRedisClient;", "setLettuceClient", "(Ldev/bypixel/redivelocity/libs/lettucewrapper/LettuceRedisClient;)V", "config", "Ldev/bypixel/redivelocity/libs/boostedyaml/YamlDocument;", "getConfig", "()Ldev/bypixel/redivelocity/libs/boostedyaml/YamlDocument;", "setConfig", "(Ldev/bypixel/redivelocity/libs/boostedyaml/YamlDocument;)V", "messageConfig", "getMessageConfig", "setMessageConfig", "proxyId", "", "getProxyId", "()Ljava/lang/String;", "setProxyId", "(Ljava/lang/String;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "wasFirstProxy", "", "onProxyInitialize", "", "event", "Lcom/velocitypowered/api/event/proxy/ProxyInitializeEvent;", "onProxyShutdown", "Lcom/velocitypowered/api/event/proxy/ProxyShutdownEvent;", "Companion", "RediVelocity"})
public final class RediVelocity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProxyServer proxy;
    public VelocityLibraryManager<RediVelocity> libraryManager;
    public LettuceRedisClient lettuceClient;
    public YamlDocument config;
    public YamlDocument messageConfig;
    public String proxyId;
    private final Logger logger;
    private boolean wasFirstProxy;
    private static RediVelocity instance;
    private static ProxyServer server;

    @Inject
    public RediVelocity(@NotNull ProxyServer proxy) {
        Intrinsics.checkNotNullParameter(proxy, "proxy");
        this.proxy = proxy;
        this.logger = LoggerFactory.getLogger(RediVelocity.class);
        CommandAPI.onLoad(((CommandAPIVelocityConfig)((CommandAPIVelocityConfig)new CommandAPIVelocityConfig(this.proxy, this).silentLogs(true)).verboseOutput(true)).setNamespace("redivelocity"));
    }

    @NotNull
    public final ProxyServer getProxy() {
        return this.proxy;
    }

    @NotNull
    public final VelocityLibraryManager<RediVelocity> getLibraryManager() {
        VelocityLibraryManager<RediVelocity> velocityLibraryManager = this.libraryManager;
        if (velocityLibraryManager != null) {
            return velocityLibraryManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException("libraryManager");
        return null;
    }

    public final void setLibraryManager(@NotNull VelocityLibraryManager<RediVelocity> velocityLibraryManager) {
        Intrinsics.checkNotNullParameter(velocityLibraryManager, "<set-?>");
        this.libraryManager = velocityLibraryManager;
    }

    @NotNull
    public final LettuceRedisClient getLettuceClient() {
        LettuceRedisClient lettuceRedisClient = this.lettuceClient;
        if (lettuceRedisClient != null) {
            return lettuceRedisClient;
        }
        Intrinsics.throwUninitializedPropertyAccessException("lettuceClient");
        return null;
    }

    public final void setLettuceClient(@NotNull LettuceRedisClient lettuceRedisClient) {
        Intrinsics.checkNotNullParameter(lettuceRedisClient, "<set-?>");
        this.lettuceClient = lettuceRedisClient;
    }

    @NotNull
    public final YamlDocument getConfig() {
        YamlDocument yamlDocument = this.config;
        if (yamlDocument != null) {
            return yamlDocument;
        }
        Intrinsics.throwUninitializedPropertyAccessException("config");
        return null;
    }

    public final void setConfig(@NotNull YamlDocument yamlDocument) {
        Intrinsics.checkNotNullParameter(yamlDocument, "<set-?>");
        this.config = yamlDocument;
    }

    @NotNull
    public final YamlDocument getMessageConfig() {
        YamlDocument yamlDocument = this.messageConfig;
        if (yamlDocument != null) {
            return yamlDocument;
        }
        Intrinsics.throwUninitializedPropertyAccessException("messageConfig");
        return null;
    }

    public final void setMessageConfig(@NotNull YamlDocument yamlDocument) {
        Intrinsics.checkNotNullParameter(yamlDocument, "<set-?>");
        this.messageConfig = yamlDocument;
    }

    @NotNull
    public final String getProxyId() {
        String string = this.proxyId;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException("proxyId");
        return null;
    }

    public final void setProxyId(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.proxyId = string;
    }

    @Subscribe
    public final void onProxyInitialize(@NotNull ProxyInitializeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        instance = this;
        server = this.proxy;
        CommandAPI.onEnable();
        Path path = Paths.get("plugins/redivelocity", new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
        this.setLibraryManager(new VelocityLibraryManager<RediVelocity>(this, this.logger, path, this.proxy.getPluginManager()));
        this.getLibraryManager().loadFromGradle();
        InputStream configInputStream2 = new Object(){}.getClass().getResourceAsStream("/config.yml");
        InputStream messagesInputStream2 = new Object(){}.getClass().getResourceAsStream("/messages.yml");
        File file = new File("plugins/redivelocity/config.yml");
        InputStream inputStream = configInputStream2;
        Intrinsics.checkNotNull(inputStream);
        Settings[] settingsArray = new Settings[]{GeneralSettings.builder().setKeyFormat(GeneralSettings.KeyFormat.OBJECT).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("config-version")).build()};
        YamlDocument yamlDocument = YamlDocument.create(file, inputStream, settingsArray);
        Intrinsics.checkNotNullExpressionValue(yamlDocument, "create(...)");
        this.setConfig(yamlDocument);
        File file2 = new File("plugins/redivelocity/messages.yml");
        InputStream inputStream2 = messagesInputStream2;
        Intrinsics.checkNotNull(inputStream2);
        settingsArray = new Settings[]{GeneralSettings.builder().setKeyFormat(GeneralSettings.KeyFormat.OBJECT).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("config-version")).build()};
        YamlDocument yamlDocument2 = YamlDocument.create(file2, inputStream2, settingsArray);
        Intrinsics.checkNotNullExpressionValue(yamlDocument2, "create(...)");
        this.setMessageConfig(yamlDocument2);
        String redisHost = this.getConfig().getString(Route.fromString("redis.host"));
        Integer redisPort = this.getConfig().getInt(Route.fromString("redis.port"));
        String redisPassword = this.getConfig().getString(Route.fromString("redis.password"), null);
        Integer redisDatabase = this.getConfig().getInt(Route.fromString("redis.database"), (Integer)0);
        String redisUser = this.getConfig().getString(Route.fromString("redis.username"), null);
        Intrinsics.checkNotNull(redisHost);
        Intrinsics.checkNotNull(redisPort);
        this.setLettuceClient(new LettuceRedisClient(redisHost, redisPort, redisPassword, RediVelocityCoroutineScope.INSTANCE, redisUser, redisDatabase));
        RedisListener.Companion.setLettuceClient(this.getLettuceClient());
        if (!this.getLettuceClient().getConnection().isOpen()) {
            RediVelocityLogger.INSTANCE.error("Failed to connect to Redis at " + redisHost + ":" + redisPort + ".");
            return;
        }
        RediVelocityLogger.INSTANCE.success("Connected to Redis at " + redisHost + ":" + redisPort);
        BuildersKt.launch$default((CoroutineScope)RediVelocityCoroutineScope.INSTANCE, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int I$0;
            int label;
            final /* synthetic */ RediVelocity this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        if (!this.this$0.getConfig().getBoolean(Route.fromString("cloud-support.enabled")).booleanValue()) ** GOTO lbl11
                        v0 = this.this$0.getConfig().getString(Route.fromString("cloud-support.cloud-system"));
                        Intrinsics.checkNotNullExpressionValue(v0, "getString(...)");
                        this.this$0.setProxyId(CloudUtil.INSTANCE.getServiceName(v0));
                        RediVelocityLogger.INSTANCE.success("Using cloud service name as proxy ID: " + this.this$0.getProxyId());
                        ** GOTO lbl73
lbl11:
                        // 1 sources

                        if (!Intrinsics.areEqual(this.this$0.getConfig().getBoolean(Route.fromString("proxy-id.auto-generate")), Boxing.boxBoolean(false))) break;
                        configId = this.this$0.getConfig().getString(Route.fromString("proxy-id.id"));
                        var3_6 /* !! */  = configId;
                        if (!(var3_6 /* !! */  == null || StringsKt.isBlank((CharSequence)var3_6 /* !! */ ) != false)) ** GOTO lbl30
                        RediVelocityLogger.INSTANCE.error("The configured proxy ID is blank! Please choose a unique ID. Will generate a random ID instead.");
                        var7_7 = this.this$0;
                        this.L$0 = configId;
                        this.L$1 = var7_7;
                        this.label = 1;
                        v1 = ProxyIdGenerator.INSTANCE.generate(this);
                        if (v1 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl29
                    }
                    case 1: {
                        var7_7 = (RediVelocity)this.L$1;
                        configId = (String)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl29:
                        // 2 sources

                        var7_7.setProxyId((String)v1);
lbl30:
                        // 2 sources

                        this.L$0 = configId;
                        this.L$1 = null;
                        this.label = 2;
                        v2 = ProxyIdGenerator.INSTANCE.getExistingIds(this);
                        if (v2 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl41
                    }
                    case 2: {
                        configId = (String)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
lbl41:
                        // 2 sources

                        if (!((List)v2).contains(configId)) ** GOTO lbl57
                        RediVelocityLogger.INSTANCE.error("The configured proxy ID '" + configId + "' is already in use by another proxy! Please choose a unique ID. Will generate a random ID instead.");
                        var7_7 = this.this$0;
                        this.L$0 = configId;
                        this.L$1 = var7_7;
                        this.label = 3;
                        v3 = ProxyIdGenerator.INSTANCE.generate(this);
                        if (v3 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl56
                    }
                    case 3: {
                        var7_7 = (RediVelocity)this.L$1;
                        configId = (String)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v3 = $result;
lbl56:
                        // 2 sources

                        var7_7.setProxyId((String)v3);
lbl57:
                        // 2 sources

                        Intrinsics.checkNotNull(configId);
                        this.this$0.setProxyId(configId);
                        RediVelocityLogger.INSTANCE.success("Using configured proxy ID: " + this.this$0.getProxyId());
                        ** GOTO lbl73
                    }
                }
                this.L$0 = var7_7 = this.this$0;
                this.label = 4;
                v4 = ProxyIdGenerator.INSTANCE.generate(this);
                if (v4 == var8_2) {
                    return var8_2;
                }
                ** GOTO lbl71
                {
                    case 4: {
                        var7_7 = (RediVelocity)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v4 = $result;
lbl71:
                        // 2 sources

                        var7_7.setProxyId((String)v4);
                        RediVelocityLogger.INSTANCE.success("Generated random proxy ID: " + this.this$0.getProxyId());
lbl73:
                        // 3 sources

                        this.L$0 = null;
                        this.L$1 = null;
                        this.label = 5;
                        v5 = DelayKt.delay((long)500L, (Continuation)this);
                        if (v5 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl83
                    }
                    case 5: {
                        ResultKt.throwOnFailure($result);
                        v5 = $result;
lbl83:
                        // 2 sources

                        this.label = 6;
                        v6 = this.this$0.getLettuceClient().getCommands().hset((Object)"redivelocity:proxies", (Object)this.this$0.getProxyId(), (Object)this.this$0.getProxyId(), (Continuation)this);
                        if (v6 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl91
                    }
                    case 6: {
                        ResultKt.throwOnFailure($result);
                        v6 = $result;
lbl91:
                        // 2 sources

                        this.label = 7;
                        v7 = ProxyIdGenerator.INSTANCE.getExistingIds(this);
                        if (v7 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl99
                    }
                    case 7: {
                        ResultKt.throwOnFailure($result);
                        v7 = $result;
lbl99:
                        // 2 sources

                        RediVelocity.access$setWasFirstProxy$p(this.this$0, (proxyIdsSize = ((List)v7).size()) == 1 || proxyIdsSize == 0);
                        if (!RediVelocity.access$getWasFirstProxy$p(this.this$0)) ** GOTO lbl133
                        RediVelocityLogger.INSTANCE.info("This proxy is the first one to connect to Redis, clearing old data...");
                        this.I$0 = proxyIdsSize;
                        this.label = 8;
                        v8 = this.this$0.getLettuceClient().getCommands().set((Object)"redivelocity:leader", (Object)this.this$0.getProxyId(), (Continuation)this);
                        if (v8 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl112
                    }
                    case 8: {
                        proxyIdsSize = this.I$0;
                        ResultKt.throwOnFailure($result);
                        v8 = $result;
lbl112:
                        // 2 sources

                        var3_6 /* !! */  = new JSONObject[]{"redivelocity:proxy:players", "redivelocity:proxy:player-counts", "redivelocity:proxy:heartbeats", "redivelocity:player:servers", "redivelocity:proxies", "redivelocity:global:playercount", "redivelocity:player:names", "redivelocity:leader"};
                        this.I$0 = proxyIdsSize;
                        this.label = 9;
                        v9 = this.this$0.getLettuceClient().getCommands().del((Object[])var3_6 /* !! */ , (Continuation)this);
                        if (v9 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl123
                    }
                    case 9: {
                        proxyIdsSize = this.I$0;
                        ResultKt.throwOnFailure($result);
                        v9 = $result;
lbl123:
                        // 2 sources

                        this.I$0 = proxyIdsSize;
                        this.label = 10;
                        v10 = this.this$0.getLettuceClient().getCommands().hset((Object)"redivelocity:proxies", (Object)this.this$0.getProxyId(), (Object)this.this$0.getProxyId(), (Continuation)this);
                        if (v10 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl133
                    }
                    case 10: {
                        proxyIdsSize = this.I$0;
                        ResultKt.throwOnFailure($result);
                        v10 = $result;
lbl133:
                        // 3 sources

                        var3_6 /* !! */  = new JSONObject();
                        var4_8 = this.this$0;
                        var5_9 = var3_6 /* !! */ ;
                        var7_7 = this.this$0.getLettuceClient();
                        $i$a$-apply-RediVelocity$onProxyInitialize$1$1 = false;
                        $this$invokeSuspend_u24lambda_u240.put("action", (Object)"ADD");
                        $this$invokeSuspend_u24lambda_u240.put("id", (Object)var4_8.getProxyId());
                        var7_7.sendMessage(var3_6 /* !! */ , "redivelocity:proxy-events");
                        HeartbeatScheduler.INSTANCE.getJob().start();
                        ElectionScheduler.INSTANCE.getJob().start();
                        PlayercountScheduler.INSTANCE.getProxyPlayerCountUpdateScheduler().start();
                        PlayercountScheduler.INSTANCE.getGlobalPlayerCountCalcScheduler().start();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, (int)2, null);
        RediVelocityLogger.INSTANCE.success("RediVelocity v" + ((PluginContainer)this.proxy.getPluginManager().getPlugin("redivelocity").get()).getDescription().getVersion().orElse("unknown") + " has been enabled!");
        this.proxy.getScheduler().buildTask((Object)this, () -> RediVelocity.onProxyInitialize$lambda$0(this)).delay(500L, TimeUnit.MILLISECONDS).schedule();
    }

    @Subscribe
    public final void onProxyShutdown(@NotNull ProxyShutdownEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        BuildersKt.launch$default((CoroutineScope)RediVelocityCoroutineScope.INSTANCE, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ RediVelocity this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        var2_3 = new JSONObject();
                        var3_4 = this.this$0;
                        var4_5 = var2_3;
                        var6_6 = this.this$0.getLettuceClient();
                        $i$a$-apply-RediVelocity$onProxyShutdown$1$1 = false;
                        $this$invokeSuspend_u24lambda_u240.put("action", (Object)"REMOVE");
                        $this$invokeSuspend_u24lambda_u240.put("id", (Object)var3_4.getProxyId());
                        var6_6.sendMessage((JSONObject)var2_3, "redivelocity:proxy-events");
                        var2_3 = new String[]{this.this$0.getProxyId()};
                        this.label = 1;
                        v0 = this.this$0.getLettuceClient().getCommands().hdel((Object)"redivelocity:proxies", var2_3, (Continuation)this);
                        if (v0 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl25
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl25:
                        // 2 sources

                        var2_3 = new String[]{this.this$0.getProxyId()};
                        this.label = 2;
                        v1 = this.this$0.getLettuceClient().getCommands().hdel((Object)"redivelocity:heartbeats", var2_3, (Continuation)this);
                        if (v1 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl34
                    }
                    case 2: {
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl34:
                        // 2 sources

                        this.label = 3;
                        v2 = this.this$0.getLettuceClient().deleteHashFieldByValueAsync("redivelocity:proxy:players", this.this$0.getProxyId(), this);
                        if (v2 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl42
                    }
                    case 3: {
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
lbl42:
                        // 2 sources

                        var2_3 = new String[]{this.this$0.getProxyId()};
                        this.label = 4;
                        v3 = this.this$0.getLettuceClient().getCommands().hdel((Object)"redivelocity:proxy:player-counts", var2_3, (Continuation)this);
                        if (v3 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl51
                    }
                    case 4: {
                        ResultKt.throwOnFailure($result);
                        v3 = $result;
lbl51:
                        // 2 sources

                        this.label = 5;
                        v4 = this.this$0.getLettuceClient().getCommands().get((Object)"redivelocity:leader", (Continuation)this);
                        if (v4 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl59
                    }
                    case 5: {
                        ResultKt.throwOnFailure($result);
                        v4 = $result;
lbl59:
                        // 2 sources

                        if (Intrinsics.areEqual(v4, this.this$0.getProxyId())) {
                            var2_3 = new String[]{"redivelocity:leader"};
                            this.label = 6;
                            v5 = this.this$0.getLettuceClient().getCommands().del(var2_3, (Continuation)this);
                            if (v5 == var7_2) {
                                return var7_2;
                            }
                        }
                        ** GOTO lbl69
                    }
                    case 6: {
                        ResultKt.throwOnFailure($result);
                        v5 = $result;
lbl69:
                        // 2 sources

                        this.label = 7;
                        v6 = FlowKt.toList$default((Flow)this.this$0.getLettuceClient().getCommands().hvals((Object)"redivelocity:proxies"), null, (Continuation)this, (int)1, null);
                        if (v6 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl77
                    }
                    case 7: {
                        ResultKt.throwOnFailure($result);
                        v6 = $result;
lbl77:
                        // 2 sources

                        if (((List)v6).isEmpty()) {
                            RediVelocityLogger.INSTANCE.info("Last proxy shutting down, clearing all RediVelocity data...");
                            var2_3 = new String[]{"redivelocity:proxy:players", "redivelocity:proxy:player-counts", "redivelocity:proxy:heartbeats", "redivelocity:player:servers", "redivelocity:proxies", "redivelocity:global:playercount", "redivelocity:player:names", "redivelocity:leader"};
                            this.label = 8;
                            v7 = this.this$0.getLettuceClient().getCommands().del(var2_3, (Continuation)this);
                            if (v7 == var7_2) {
                                return var7_2;
                            }
                        }
                        ** GOTO lbl88
                    }
                    case 8: {
                        ResultKt.throwOnFailure($result);
                        v7 = $result;
lbl88:
                        // 2 sources

                        CommandAPI.onDisable();
                        RedisListener.Companion.unregisterListener(KickListener.INSTANCE);
                        RedisListener.Companion.unregisterListener(LeaderElectionListener.INSTANCE);
                        this.label = 9;
                        v8 = JobKt.cancelAndJoin((Job)ElectionScheduler.INSTANCE.getJob(), (Continuation)this);
                        if (v8 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl99
                    }
                    case 9: {
                        ResultKt.throwOnFailure($result);
                        v8 = $result;
lbl99:
                        // 2 sources

                        this.label = 10;
                        v9 = JobKt.cancelAndJoin((Job)HeartbeatScheduler.INSTANCE.getJob(), (Continuation)this);
                        if (v9 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl107
                    }
                    case 10: {
                        ResultKt.throwOnFailure($result);
                        v9 = $result;
lbl107:
                        // 2 sources

                        if (this.this$0.getConfig().getBoolean(Route.fromString("update-check.enabled")).booleanValue()) {
                            this.label = 11;
                            v10 = JobKt.cancelAndJoin((Job)UpdateUtil.INSTANCE.getUpdateJob(), (Continuation)this);
                            if (v10 == var7_2) {
                                return var7_2;
                            }
                        }
                        ** GOTO lbl116
                    }
                    case 11: {
                        ResultKt.throwOnFailure($result);
                        v10 = $result;
lbl116:
                        // 2 sources

                        this.label = 12;
                        v11 = JobKt.cancelAndJoin((Job)PlayercountScheduler.INSTANCE.getProxyPlayerCountUpdateScheduler(), (Continuation)this);
                        if (v11 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl124
                    }
                    case 12: {
                        ResultKt.throwOnFailure($result);
                        v11 = $result;
lbl124:
                        // 2 sources

                        this.label = 13;
                        v12 = JobKt.cancelAndJoin((Job)PlayercountScheduler.INSTANCE.getGlobalPlayerCountCalcScheduler(), (Continuation)this);
                        if (v12 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl132
                    }
                    case 13: {
                        ResultKt.throwOnFailure($result);
                        v12 = $result;
lbl132:
                        // 2 sources

                        this.label = 14;
                        v13 = PlayerCache.INSTANCE.unregister(this);
                        if (v13 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl140
                    }
                    case 14: {
                        ResultKt.throwOnFailure($result);
                        v13 = $result;
lbl140:
                        // 2 sources

                        this.label = 15;
                        v14 = ProxyCache.INSTANCE.unregister(this);
                        if (v14 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl148
                    }
                    case 15: {
                        ResultKt.throwOnFailure($result);
                        v14 = $result;
lbl148:
                        // 2 sources

                        this.label = 16;
                        v15 = this.this$0.getLettuceClient().close(this);
                        if (v15 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl156
                    }
                    case 16: {
                        ResultKt.throwOnFailure($result);
                        v15 = $result;
lbl156:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, (int)2, null);
    }

    private static final void onProxyInitialize$lambda$0(RediVelocity this$0) {
        if (this$0.getConfig().getBoolean(Route.fromString("update-check.enabled")).booleanValue()) {
            BuildersKt.launch$default((CoroutineScope)RediVelocityCoroutineScope.INSTANCE, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                int label;

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            UpdateUtil.INSTANCE.getUpdateJob().start();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, (int)2, null);
        }
        new RediVelocityCommand().register();
        new FindCommand().register();
        PlayerCache.INSTANCE.register();
        ProxyCache.INSTANCE.register();
        if (this$0.getConfig().getBoolean(Route.fromString("playercount-sync.enabled")).booleanValue()) {
            this$0.proxy.getEventManager().register((Object)this$0, (Object)ProxyPingListener.INSTANCE);
        }
        this$0.proxy.getEventManager().register((Object)this$0, (Object)PostLoginListener.INSTANCE);
        this$0.proxy.getEventManager().register((Object)this$0, (Object)ServerSwitchListener.INSTANCE);
        this$0.proxy.getEventManager().register((Object)this$0, (Object)DisconnectListener.INSTANCE);
    }

    public static final /* synthetic */ void access$setWasFirstProxy$p(RediVelocity $this, boolean bl) {
        $this.wasFirstProxy = bl;
    }

    public static final /* synthetic */ boolean access$getWasFirstProxy$p(RediVelocity $this) {
        return $this.wasFirstProxy;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\t@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ldev/bypixel/redivelocity/RediVelocity$Companion;", "", "<init>", "()V", "value", "Ldev/bypixel/redivelocity/RediVelocity;", "instance", "getInstance", "()Ldev/bypixel/redivelocity/RediVelocity;", "Lcom/velocitypowered/api/proxy/ProxyServer;", "server", "getServer", "()Lcom/velocitypowered/api/proxy/ProxyServer;", "RediVelocity"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RediVelocity getInstance() {
            RediVelocity rediVelocity = instance;
            if (rediVelocity != null) {
                return rediVelocity;
            }
            Intrinsics.throwUninitializedPropertyAccessException("instance");
            return null;
        }

        @NotNull
        public final ProxyServer getServer() {
            ProxyServer proxyServer = server;
            if (proxyServer != null) {
                return proxyServer;
            }
            Intrinsics.throwUninitializedPropertyAccessException("server");
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

