/*
 * Decompiled with CFR 0.152.
 */
package dev.bypixel.redivelocity.libs.commandapi.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.bypixel.redivelocity.libs.commandapi.SuggestionInfo;
import dev.bypixel.redivelocity.libs.commandapi.arguments.ArgumentSuggestions;
import dev.bypixel.redivelocity.libs.commandapi.executors.CommandArguments;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;

public class SuggestionsBranch<CommandSender> {
    private final List<ArgumentSuggestions<CommandSender>> suggestions;
    private final List<SuggestionsBranch<CommandSender>> branches = new ArrayList<SuggestionsBranch<CommandSender>>();

    private SuggestionsBranch(List<ArgumentSuggestions<CommandSender>> suggestions) {
        this.suggestions = suggestions;
    }

    @SafeVarargs
    public static <CommandSender> SuggestionsBranch<CommandSender> suggest(ArgumentSuggestions<CommandSender> ... suggestions) {
        return new SuggestionsBranch<CommandSender>(Arrays.asList(suggestions));
    }

    @SafeVarargs
    public final SuggestionsBranch<CommandSender> branch(SuggestionsBranch<CommandSender> ... branches) {
        this.branches.addAll(List.of(branches));
        return this;
    }

    public ArgumentSuggestions<CommandSender> getNextSuggestion(CommandSender sender, String ... previousArguments) throws CommandSyntaxException {
        return this.getNextSuggestion(sender, previousArguments, new StringReader(String.join((CharSequence)" ", previousArguments)), new ArrayList<String>(), new StringBuilder());
    }

    private ArgumentSuggestions<CommandSender> getNextSuggestion(CommandSender sender, String[] previousArguments, StringReader errorContext, List<String> processedArguments, StringBuilder currentInput) throws CommandSyntaxException {
        if (this.branches.isEmpty() && this.suggestions.isEmpty()) {
            return null;
        }
        for (ArgumentSuggestions<CommandSender> currentSuggestion : this.suggestions) {
            if (processedArguments.size() == previousArguments.length) {
                return currentSuggestion;
            }
            String currentArgument = previousArguments[processedArguments.size()];
            errorContext.setCursor(currentInput.length());
            if (currentSuggestion != null) {
                SuggestionInfo<CommandSender> info = new SuggestionInfo<CommandSender>(sender, new CommandArguments(processedArguments.toArray(), new LinkedHashMap<String, Object>(), processedArguments.toArray(new String[0]), new LinkedHashMap<String, String>(), currentInput.toString()), currentInput.toString(), "");
                SuggestionsBuilder builder = new SuggestionsBuilder(currentInput.toString(), currentInput.length());
                currentSuggestion.suggest(info, builder);
                if (builder.build().getList().stream().map(Suggestion::getText).noneMatch(currentArgument::equals)) {
                    if (processedArguments.isEmpty()) {
                        throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext((ImmutableStringReader)errorContext);
                    }
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext((ImmutableStringReader)errorContext);
                }
            }
            currentInput.append(currentArgument).append(" ");
            processedArguments.add(currentArgument);
        }
        ArrayList<ArgumentSuggestions<CommandSender>> mergedBranches = new ArrayList<ArgumentSuggestions<CommandSender>>();
        for (SuggestionsBranch<CommandSender> branch : this.branches) {
            try {
                mergedBranches.add(branch.getNextSuggestion(sender, previousArguments, errorContext, new ArrayList<String>(processedArguments), new StringBuilder(currentInput)));
            }
            catch (CommandSyntaxException commandSyntaxException) {}
        }
        if (mergedBranches.isEmpty()) {
            if (processedArguments.isEmpty()) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext((ImmutableStringReader)errorContext);
            }
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext((ImmutableStringReader)errorContext);
        }
        if (mergedBranches.size() == 1) {
            return (ArgumentSuggestions)mergedBranches.get(0);
        }
        if (mergedBranches.contains(null)) {
            if (mergedBranches.stream().allMatch(Objects::isNull)) {
                return null;
            }
            throw new SimpleCommandExceptionType((Message)new LiteralMessage("Multiple paths for a SuggestionsBranch must either be all null or all non-null")).createWithContext((ImmutableStringReader)errorContext);
        }
        return ArgumentSuggestions.merge((ArgumentSuggestions[])mergedBranches.toArray(ArgumentSuggestions[]::new));
    }

    public void enforceReplacements(CommandSender sender, String ... arguments) throws CommandSyntaxException {
        EnforceReplacementsResult result = this.enforceReplacements(sender, arguments, new StringReader(String.join((CharSequence)" ", arguments)), new ArrayList<String>(), new StringBuilder());
        if (result.type != ExceptionType.NO_ERROR) {
            throw result.exception;
        }
    }

    private EnforceReplacementsResult enforceReplacements(CommandSender sender, String[] arguments, StringReader errorContext, List<String> processedArguments, StringBuilder currentInput) {
        if (this.branches.isEmpty() && this.suggestions.isEmpty()) {
            return new EnforceReplacementsResult(ExceptionType.NO_ERROR, null);
        }
        for (ArgumentSuggestions<CommandSender> currentSuggestion : this.suggestions) {
            String currentArgument = processedArguments.size() >= arguments.length ? "" : arguments[processedArguments.size()];
            errorContext.setCursor(currentInput.length());
            if (currentSuggestion != null) {
                SuggestionInfo<CommandSender> info = new SuggestionInfo<CommandSender>(sender, new CommandArguments(processedArguments.toArray(), new LinkedHashMap<String, Object>(), processedArguments.toArray(new String[0]), new LinkedHashMap<String, String>(), currentInput.toString()), currentInput.toString(), "");
                SuggestionsBuilder builder = new SuggestionsBuilder(currentInput.toString(), currentInput.length());
                try {
                    currentSuggestion.suggest(info, builder);
                }
                catch (CommandSyntaxException exception) {
                    return new EnforceReplacementsResult(ExceptionType.UNKNOWN, exception);
                }
                List<String> results = builder.build().getList().stream().map(Suggestion::getText).toList();
                if (currentArgument.isEmpty()) {
                    if (results.isEmpty()) {
                        return EnforceReplacementsResult.withContext(ExceptionType.NO_ERROR, errorContext);
                    }
                    return EnforceReplacementsResult.withContext(ExceptionType.NOT_ENOUGH_ARGUMENTS, errorContext);
                }
                if (!results.contains(currentArgument)) {
                    if (processedArguments.isEmpty()) {
                        return EnforceReplacementsResult.withContext(ExceptionType.UNKNOWN_COMMAND, errorContext);
                    }
                    return EnforceReplacementsResult.withContext(ExceptionType.UNKNOWN_ARGUMENT, errorContext);
                }
            }
            currentInput.append(currentArgument).append(" ");
            processedArguments.add(currentArgument);
        }
        if (this.branches.isEmpty()) {
            return new EnforceReplacementsResult(ExceptionType.NO_ERROR, null);
        }
        EnforceReplacementsResult finalResult = EnforceReplacementsResult.withContext(ExceptionType.UNKNOWN, errorContext);
        for (SuggestionsBranch<CommandSender> branch : this.branches) {
            EnforceReplacementsResult result = branch.enforceReplacements(sender, arguments, errorContext, new ArrayList<String>(processedArguments), new StringBuilder(currentInput));
            if (!result.isHigherPriority(finalResult)) continue;
            finalResult = result;
        }
        return finalResult;
    }

    private record EnforceReplacementsResult(ExceptionType type, CommandSyntaxException exception) {
        public static EnforceReplacementsResult withContext(ExceptionType type, StringReader errorContext) {
            return new EnforceReplacementsResult(type, switch (type.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> null;
                case 1 -> new SimpleCommandExceptionType((Message)new LiteralMessage("Expected more arguments")).createWithContext((ImmutableStringReader)errorContext);
                case 2 -> CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext((ImmutableStringReader)errorContext);
                case 3 -> CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext((ImmutableStringReader)errorContext);
                case 4 -> new SimpleCommandExceptionType((Message)new LiteralMessage("Unknown syntax exception while parsing argument")).createWithContext((ImmutableStringReader)errorContext);
            });
        }

        public boolean isHigherPriority(EnforceReplacementsResult other) {
            return this.type.ordinal() < other.type.ordinal();
        }
    }

    private static enum ExceptionType {
        NO_ERROR,
        NOT_ENOUGH_ARGUMENTS,
        UNKNOWN_ARGUMENT,
        UNKNOWN_COMMAND,
        UNKNOWN;

    }
}

