/*
 * Decompiled with CFR 0.152.
 */
package dev.bypixel.redivelocity.libs.commandapi.network;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.ChannelMessageSink;
import com.velocitypowered.api.proxy.messages.ChannelMessageSource;
import com.velocitypowered.api.proxy.messages.ChannelRegistrar;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import dev.bypixel.redivelocity.libs.commandapi.network.CommandAPIMessenger;
import dev.bypixel.redivelocity.libs.commandapi.network.CommandAPIProtocol;
import dev.bypixel.redivelocity.libs.commandapi.network.VelocityPacketHandlerProvider;
import dev.bypixel.redivelocity.libs.commandapi.network.packets.SetVersionPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class VelocityCommandAPIMessenger
extends CommandAPIMessenger<ChannelMessageSource, ChannelMessageSink> {
    private final Object plugin;
    private final ProxyServer proxy;
    private final Map<ChannelMessageSink, Integer> protocolVersionPerOutgoingChannel;
    private final Map<Player, ServerConnection> previousServerConnectionPerPlayer;

    public VelocityCommandAPIMessenger(Object plugin, ProxyServer proxy) {
        super(new VelocityPacketHandlerProvider());
        this.plugin = plugin;
        this.proxy = proxy;
        this.protocolVersionPerOutgoingChannel = new HashMap<ChannelMessageSink, Integer>();
        this.previousServerConnectionPerPlayer = new HashMap<Player, ServerConnection>();
        ChannelRegistrar registrar = this.proxy.getChannelRegistrar();
        for (String channelIdentifier : CommandAPIProtocol.getAllChannelIdentifiers()) {
            registrar.register(new ChannelIdentifier[]{MinecraftChannelIdentifier.from((String)channelIdentifier)});
        }
        this.proxy.getEventManager().register(this.plugin, (Object)this);
    }

    @Subscribe
    public void onServerConnected(ServerPostConnectEvent event) {
        Player player = event.getPlayer();
        this.protocolVersionPerOutgoingChannel.remove(this.previousServerConnectionPerPlayer.get(player));
        SetVersionPacket packet = new SetVersionPacket(1);
        this.sendPacket(player, packet);
        Optional wrappedServer = player.getCurrentServer();
        assert (wrappedServer.isPresent());
        ServerConnection newServer = (ServerConnection)wrappedServer.get();
        this.sendPacket(newServer, packet);
        this.previousServerConnectionPerPlayer.put(player, newServer);
    }

    @Subscribe
    public void onPlayerLeave(DisconnectEvent event) {
        Player player = event.getPlayer();
        this.protocolVersionPerOutgoingChannel.remove(player);
        player.getCurrentServer().ifPresent(this.protocolVersionPerOutgoingChannel::remove);
        this.previousServerConnectionPerPlayer.remove(player);
    }

    @Override
    public void close() {
        ChannelRegistrar registrar = this.proxy.getChannelRegistrar();
        for (String channelIdentifier : CommandAPIProtocol.getAllChannelIdentifiers()) {
            registrar.unregister(new ChannelIdentifier[]{MinecraftChannelIdentifier.from((String)channelIdentifier)});
        }
        this.proxy.getEventManager().unregisterListener(this.plugin, (Object)this);
    }

    public void setServerProtocolVersion(ServerConnection server, int protocolVersion) {
        this.protocolVersionPerOutgoingChannel.put((ChannelMessageSink)server, protocolVersion);
    }

    public void setPlayerProtocolVersion(Player player, int protocolVersion) {
        this.protocolVersionPerOutgoingChannel.put((ChannelMessageSink)player, protocolVersion);
    }

    @Override
    public int getConnectionProtocolVersion(ChannelMessageSink target) {
        return this.protocolVersionPerOutgoingChannel.getOrDefault(target, 0);
    }

    @Subscribe
    public void onPluginMessageEvent(PluginMessageEvent event) {
        String channel = event.getIdentifier().getId();
        CommandAPIProtocol protocol = CommandAPIProtocol.getProtocolForChannel(channel);
        if (protocol == null) {
            return;
        }
        event.setResult(PluginMessageEvent.ForwardResult.handled());
        this.messageReceived(protocol, event.getSource(), event.getData());
    }

    @Override
    public void sendRawBytes(CommandAPIProtocol protocol, ChannelMessageSink target, byte[] bytes) {
        target.sendPluginMessage((ChannelIdentifier)MinecraftChannelIdentifier.from((String)protocol.getChannelIdentifier()), bytes);
    }
}

