/*
 * Decompiled with CFR 0.152.
 */
package dev.bypixel.redivelocity.util;

import app.simplecloud.controller.api.ControllerApi;
import app.simplecloud.controller.api.ServerApi;
import app.simplecloud.controller.shared.server.Server;
import de.vulpescloud.api.services.Service;
import de.vulpescloud.bridge.BridgeAPI;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import eu.cloudnetservice.wrapper.configuration.WrapperConfiguration;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"Ldev/bypixel/redivelocity/util/CloudUtil;", "", "<init>", "()V", "getServiceName", "", "cloud", "RediVelocity"})
public final class CloudUtil {
    @NotNull
    public static final CloudUtil INSTANCE = new CloudUtil();

    private CloudUtil() {
    }

    @NotNull
    public final String getServiceName(@NotNull String cloud) {
        int serverId;
        String group;
        Intrinsics.checkNotNullParameter(cloud, "cloud");
        String string = cloud.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        switch (string) {
            case "simplecloud": {
                ControllerApi.Future controllerApi = ControllerApi.Companion.createFutureApi();
                ServerApi.Future future = controllerApi.getServers();
                String string2 = System.getenv("SIMPLECLOUD_UNIQUE_ID");
                Intrinsics.checkNotNullExpressionValue(string2, "getenv(...)");
                group = ((Server)future.getServerById(string2).join()).getGroup();
                ServerApi.Future future2 = controllerApi.getServers();
                String string3 = System.getenv("SIMPLECLOUD_UNIQUE_ID");
                Intrinsics.checkNotNullExpressionValue(string3, "getenv(...)");
                serverId = ((Server)future2.getServerById(string3).join()).getNumericalId();
                break;
            }
            case "vulpescloud": {
                Service service = (Service)BridgeAPI.Companion.getFutureAPI().getServicesAPI().getLocalService().join();
                if (service == null) {
                    throw new IllegalStateException("VulpesCloud service is null! Please report this to the VulpesCloud team. https://github.com/VulpesCloud/VulpesCloud/issues");
                }
                Service service2 = service;
                return service2.getTask().getName() + "-" + service2.getOrderedId();
            }
            case "cloudnet": {
                WrapperConfiguration wrapperConfiguration = (WrapperConfiguration)InjectionLayer.ext().instance(WrapperConfiguration.class);
                String string4 = wrapperConfiguration.serviceInfoSnapshot().name();
                Intrinsics.checkNotNullExpressionValue(string4, "name(...)");
                return string4;
            }
            default: {
                throw new IllegalArgumentException("Unsupported cloud system: " + cloud);
            }
        }
        return group + "-" + serverId;
    }
}

