/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.quark.pom;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.bxteam.quark.pom.exception.MetadataParsingException;
import org.bxteam.quark.pom.model.MavenMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MetadataReader {
    private final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private final XPathFactory xPathFactory;

    public MetadataReader() {
        this.documentBuilderFactory.setNamespaceAware(false);
        this.documentBuilderFactory.setValidating(false);
        this.xPathFactory = XPathFactory.newInstance();
    }

    @NotNull
    public MavenMetadata readMetadata(@NotNull InputStream inputStream, @NotNull String source) throws MetadataParsingException {
        Objects.requireNonNull(inputStream, "Input stream cannot be null");
        Objects.requireNonNull(source, "Source cannot be null");
        try {
            DocumentBuilder builder = this.documentBuilderFactory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            return this.parseMetadataDocument(document, source);
        }
        catch (ParserConfigurationException e) {
            throw new MetadataParsingException("Failed to create XML parser", e);
        }
        catch (SAXException e) {
            throw new MetadataParsingException("Failed to parse metadata XML from " + source, e);
        }
        catch (IOException e) {
            throw new MetadataParsingException("Failed to read metadata from " + source, e);
        }
    }

    @NotNull
    private MavenMetadata parseMetadataDocument(@NotNull Document document, @NotNull String source) throws MetadataParsingException {
        XPath xpath = this.xPathFactory.newXPath();
        try {
            String groupId = this.getTextContent(xpath, document, "/metadata/groupId");
            String artifactId = this.getTextContent(xpath, document, "/metadata/artifactId");
            String latest = this.getTextContent(xpath, document, "/metadata/versioning/latest");
            String release = this.getTextContent(xpath, document, "/metadata/versioning/release");
            List<String> versions = this.extractVersions(xpath, document);
            return new MavenMetadata(groupId, artifactId, latest, release, versions);
        }
        catch (XPathExpressionException e) {
            throw new MetadataParsingException("Failed to evaluate XPath expression", e);
        }
    }

    @NotNull
    private List<String> extractVersions(@NotNull XPath xpath, @NotNull Document document) throws XPathExpressionException {
        ArrayList<String> versions = new ArrayList<String>();
        NodeList versionNodes = (NodeList)xpath.evaluate("/metadata/versioning/versions/version", document, XPathConstants.NODESET);
        for (int i = 0; i < versionNodes.getLength(); ++i) {
            Node versionNode = versionNodes.item(i);
            String version = versionNode.getTextContent();
            if (version == null || version.trim().isEmpty()) continue;
            versions.add(version.trim());
        }
        return versions;
    }

    @Nullable
    private String getTextContent(@NotNull XPath xpath, @NotNull Document document, @NotNull String expression) throws XPathExpressionException {
        Node node = (Node)xpath.evaluate(expression, document, XPathConstants.NODE);
        return node != null ? node.getTextContent().trim() : null;
    }
}

