/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.quark.pom;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.bxteam.quark.dependency.Dependency;
import org.bxteam.quark.pom.exception.PomParsingException;
import org.bxteam.quark.pom.model.ParentInfo;
import org.bxteam.quark.pom.model.PomInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PomReader {
    private final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private final XPathFactory xPathFactory;

    public PomReader() {
        this.documentBuilderFactory.setNamespaceAware(false);
        this.documentBuilderFactory.setValidating(false);
        this.xPathFactory = XPathFactory.newInstance();
    }

    @NotNull
    public PomInfo readPom(@NotNull Path pomFile) throws PomParsingException {
        PomInfo pomInfo;
        block9: {
            Objects.requireNonNull(pomFile, "POM file cannot be null");
            if (!Files.exists(pomFile, new LinkOption[0])) {
                throw new PomParsingException("POM file does not exist: " + String.valueOf(pomFile));
            }
            InputStream inputStream = Files.newInputStream(pomFile, new OpenOption[0]);
            try {
                pomInfo = this.readPom(inputStream, pomFile.toString());
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new PomParsingException("Failed to read POM file: " + String.valueOf(pomFile), e);
                }
            }
            inputStream.close();
        }
        return pomInfo;
    }

    @NotNull
    public PomInfo readPom(@NotNull InputStream inputStream, @NotNull String source) throws PomParsingException {
        Objects.requireNonNull(inputStream, "Input stream cannot be null");
        Objects.requireNonNull(source, "Source cannot be null");
        try {
            DocumentBuilder builder = this.documentBuilderFactory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            return this.parsePomDocument(document, source);
        }
        catch (ParserConfigurationException e) {
            throw new PomParsingException("Failed to create XML parser", e);
        }
        catch (SAXException e) {
            throw new PomParsingException("Failed to parse POM XML from " + source, e);
        }
        catch (IOException e) {
            throw new PomParsingException("Failed to read POM from " + source, e);
        }
    }

    @NotNull
    private PomInfo parsePomDocument(@NotNull Document document, @NotNull String source) throws PomParsingException {
        XPath xpath = this.xPathFactory.newXPath();
        try {
            String groupId = this.getTextContent(xpath, document, "/project/groupId");
            String artifactId = this.getTextContent(xpath, document, "/project/artifactId");
            String version = this.getTextContent(xpath, document, "/project/version");
            ParentInfo parentInfo = this.extractParentInfo(xpath, document);
            if (groupId == null && parentInfo != null) {
                groupId = parentInfo.groupId();
            }
            if (version == null && parentInfo != null) {
                version = parentInfo.version();
            }
            if (artifactId == null) {
                throw new PomParsingException("No artifactId found in POM: " + source);
            }
            Map<String, String> properties = this.extractProperties(xpath, document);
            if (groupId != null) {
                properties.put("project.groupId", groupId);
            }
            if (artifactId != null) {
                properties.put("project.artifactId", artifactId);
            }
            if (version != null) {
                properties.put("project.version", version);
            }
            Map<String, String> dependencyManagement = this.extractDependencyManagement(xpath, document, properties);
            List<Dependency> dependencies = this.extractDependencies(xpath, document, properties, dependencyManagement);
            return new PomInfo(groupId, artifactId, version, dependencies, properties, dependencyManagement, parentInfo);
        }
        catch (XPathExpressionException e) {
            throw new PomParsingException("Failed to evaluate XPath expression", e);
        }
    }

    @Nullable
    private ParentInfo extractParentInfo(@NotNull XPath xpath, @NotNull Document document) throws XPathExpressionException {
        String parentGroupId = this.getTextContent(xpath, document, "/project/parent/groupId");
        String parentArtifactId = this.getTextContent(xpath, document, "/project/parent/artifactId");
        String parentVersion = this.getTextContent(xpath, document, "/project/parent/version");
        if (parentGroupId != null && parentArtifactId != null && parentVersion != null) {
            return new ParentInfo(parentGroupId, parentArtifactId, parentVersion);
        }
        return null;
    }

    @NotNull
    private Map<String, String> extractProperties(@NotNull XPath xpath, @NotNull Document document) throws XPathExpressionException {
        HashMap<String, String> properties = new HashMap<String, String>();
        NodeList propertyNodes = (NodeList)xpath.evaluate("//properties/*", document, XPathConstants.NODESET);
        for (int i = 0; i < propertyNodes.getLength(); ++i) {
            Node propertyNode = propertyNodes.item(i);
            String name = propertyNode.getNodeName();
            String value = propertyNode.getTextContent();
            if (name == null || value == null) continue;
            properties.put(name.trim(), value.trim());
        }
        return properties;
    }

    @NotNull
    private Map<String, String> extractDependencyManagement(@NotNull XPath xpath, @NotNull Document document, @NotNull Map<String, String> properties) throws XPathExpressionException {
        HashMap<String, String> managedVersions = new HashMap<String, String>();
        NodeList dependencyNodes = (NodeList)xpath.evaluate("//dependencyManagement/dependencies/dependency", document, XPathConstants.NODESET);
        for (int i = 0; i < dependencyNodes.getLength(); ++i) {
            Node dependencyNode = dependencyNodes.item(i);
            String groupId = this.getChildNodeText(dependencyNode, "groupId");
            String artifactId = this.getChildNodeText(dependencyNode, "artifactId");
            String version = this.getChildNodeText(dependencyNode, "version");
            if (groupId == null || artifactId == null || version == null) continue;
            groupId = this.resolveProperties(groupId, properties);
            artifactId = this.resolveProperties(artifactId, properties);
            version = this.resolveProperties(version, properties);
            managedVersions.put(groupId + ":" + artifactId, version);
        }
        return managedVersions;
    }

    @NotNull
    private List<Dependency> extractDependencies(@NotNull XPath xpath, @NotNull Document document, @NotNull Map<String, String> properties, @NotNull Map<String, String> dependencyManagement) throws XPathExpressionException {
        String expression;
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        String[] xpathExpressions = new String[]{"//dependencies/dependency", "//project/dependencies/dependency", "/project/dependencies/dependency"};
        NodeList dependencyNodes = null;
        String[] stringArray = xpathExpressions;
        int n = stringArray.length;
        for (int i = 0; i < n && (dependencyNodes = (NodeList)xpath.evaluate(expression = stringArray[i], document, XPathConstants.NODESET)).getLength() <= 0; ++i) {
        }
        if (dependencyNodes == null || dependencyNodes.getLength() == 0) {
            return dependencies;
        }
        for (int i = 0; i < dependencyNodes.getLength(); ++i) {
            Node dependencyNode = dependencyNodes.item(i);
            try {
                Dependency dependency = this.parseDependencyNode(dependencyNode, properties, dependencyManagement);
                if (dependency == null || !this.shouldIncludeDependency(dependencyNode)) continue;
                dependencies.add(dependency);
                continue;
            }
            catch (Exception e) {
                System.err.println("Skipping invalid dependency entry: " + e.getMessage());
            }
        }
        return dependencies;
    }

    @Nullable
    private Dependency parseDependencyNode(@NotNull Node dependencyNode, @NotNull Map<String, String> properties, @NotNull Map<String, String> dependencyManagement) {
        String groupId = this.getChildNodeText(dependencyNode, "groupId");
        String artifactId = this.getChildNodeText(dependencyNode, "artifactId");
        String version = this.getChildNodeText(dependencyNode, "version");
        String classifier = this.getChildNodeText(dependencyNode, "classifier");
        if (groupId == null || artifactId == null) {
            return null;
        }
        groupId = this.resolveProperties(groupId, properties);
        artifactId = this.resolveProperties(artifactId, properties);
        if (version == null || version.trim().isEmpty()) {
            version = dependencyManagement.get(groupId + ":" + artifactId);
        }
        if (version != null) {
            version = this.resolveProperties(version, properties);
        }
        if (version == null || version.trim().isEmpty()) {
            return null;
        }
        if (classifier != null) {
            classifier = this.resolveProperties(classifier, properties);
        }
        return Dependency.builder().groupId(groupId).artifactId(artifactId).version(version).classifier(classifier).build();
    }

    private boolean shouldIncludeDependency(@NotNull Node dependencyNode) {
        String scope = Optional.ofNullable(this.getChildNodeText(dependencyNode, "scope")).filter(s -> !s.trim().isEmpty()).orElse("compile");
        String optional = this.getChildNodeText(dependencyNode, "optional");
        return ("compile".equals(scope) || "runtime".equals(scope)) && !"true".equals(optional);
    }

    @NotNull
    private String resolveProperties(@NotNull String value, @NotNull Map<String, String> properties) {
        String propertyName;
        String propertyValue;
        int start;
        int end;
        Object resolved = value;
        int maxIterations = 10;
        for (int iteration = 0; ((String)resolved).contains("${") && iteration < maxIterations && (end = ((String)resolved).indexOf("}", start = ((String)resolved).indexOf("${"))) != -1 && (propertyValue = properties.get(propertyName = ((String)resolved).substring(start + 2, end))) != null; ++iteration) {
            resolved = ((String)resolved).substring(0, start) + propertyValue + ((String)resolved).substring(end + 1);
        }
        return resolved;
    }

    @Nullable
    private String getTextContent(@NotNull XPath xpath, @NotNull Document document, @NotNull String expression) throws XPathExpressionException {
        Node node = (Node)xpath.evaluate(expression, document, XPathConstants.NODE);
        return node != null ? node.getTextContent().trim() : null;
    }

    @Nullable
    private String getChildNodeText(@NotNull Node parentNode, @NotNull String childName) {
        NodeList childNodes = parentNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1 || !childName.equals(childNode.getNodeName())) continue;
            String text = childNode.getTextContent();
            return text != null ? text.trim() : null;
        }
        return null;
    }
}

