/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.quark.pom.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.bxteam.quark.dependency.Dependency;
import org.bxteam.quark.pom.model.ParentInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PomInfo {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final List<Dependency> dependencies;
    private final Map<String, String> properties;
    private final Map<String, String> dependencyManagement;
    private final ParentInfo parentInfo;

    public PomInfo(@Nullable String groupId, @NotNull String artifactId, @Nullable String version, @NotNull List<Dependency> dependencies, @NotNull Map<String, String> properties, @NotNull Map<String, String> dependencyManagement, @Nullable ParentInfo parentInfo) {
        this.groupId = groupId;
        this.artifactId = Objects.requireNonNull(artifactId, "Artifact ID cannot be null");
        this.version = version;
        this.dependencies = List.copyOf(dependencies);
        this.properties = Map.copyOf(properties);
        this.dependencyManagement = Map.copyOf(dependencyManagement);
        this.parentInfo = parentInfo;
    }

    @NotNull
    public List<Dependency> getRuntimeDependencies() {
        return this.dependencies;
    }

    public boolean hasParent() {
        return this.parentInfo != null;
    }

    @Nullable
    public Dependency getProjectDependency() {
        if (this.groupId != null && this.version != null) {
            return Dependency.of(this.groupId, this.artifactId, this.version);
        }
        return null;
    }

    @Generated
    public String groupId() {
        return this.groupId;
    }

    @Generated
    public String artifactId() {
        return this.artifactId;
    }

    @Generated
    public String version() {
        return this.version;
    }

    @Generated
    public List<Dependency> dependencies() {
        return this.dependencies;
    }

    @Generated
    public Map<String, String> properties() {
        return this.properties;
    }

    @Generated
    public Map<String, String> dependencyManagement() {
        return this.dependencyManagement;
    }

    @Generated
    public ParentInfo parentInfo() {
        return this.parentInfo;
    }
}

