/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.quark.relocation;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bxteam.quark.dependency.Dependency;
import org.bxteam.quark.relocation.Relocation;
import org.bxteam.quark.repository.LocalRepository;
import org.jetbrains.annotations.NotNull;

public class RelocationCacheResolver {
    private static final String RELOCATIONS_CACHE_FILE = "relocations.txt";
    private final LocalRepository localRepository;

    public RelocationCacheResolver(@NotNull LocalRepository localRepository) {
        this.localRepository = Objects.requireNonNull(localRepository, "Local repository cannot be null");
    }

    public boolean shouldForceRelocate(@NotNull Dependency dependency, @NotNull List<Relocation> relocations) {
        Objects.requireNonNull(dependency, "Dependency cannot be null");
        Objects.requireNonNull(relocations, "Relocations cannot be null");
        return this.getSavedRelocations(dependency).map(savedRelocations -> !savedRelocations.equals(this.relocationsToString(relocations))).orElse(true);
    }

    public void markAsRelocated(@NotNull Dependency dependency, @NotNull List<Relocation> relocations) {
        Objects.requireNonNull(dependency, "Dependency cannot be null");
        Objects.requireNonNull(relocations, "Relocations cannot be null");
        try {
            Path cacheFile = this.getRelocationsCacheFile(dependency);
            String relocationsString = this.relocationsToString(relocations);
            Path parentDir = cacheFile.getParent();
            if (parentDir != null) {
                Files.createDirectories(parentDir, new FileAttribute[0]);
            }
            Files.writeString(cacheFile, (CharSequence)relocationsString, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save relocation cache for dependency: " + String.valueOf(dependency), e);
        }
    }

    @NotNull
    private String relocationsToString(@NotNull List<Relocation> relocations) {
        return relocations.stream().map(relocation -> relocation.pattern() + " -> " + relocation.relocatedPattern()).collect(Collectors.joining("\n"));
    }

    @NotNull
    private Optional<String> getSavedRelocations(@NotNull Dependency dependency) {
        try {
            Path cacheFile = this.getRelocationsCacheFile(dependency);
            if (!Files.exists(cacheFile, new LinkOption[0])) {
                return Optional.empty();
            }
            String content = Files.readString(cacheFile, StandardCharsets.UTF_8);
            return Optional.of(content.trim());
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    @NotNull
    private Path getRelocationsCacheFile(@NotNull Dependency dependency) {
        String relativePath = dependency.getGroupId().replace('.', '/') + "/" + dependency.getArtifactId() + "/" + dependency.getVersion() + "/relocations.txt";
        return this.localRepository.resolve(relativePath);
    }

    public void clearCache(@NotNull Dependency dependency) {
        Objects.requireNonNull(dependency, "Dependency cannot be null");
        try {
            Path cacheFile = this.getRelocationsCacheFile(dependency);
            Files.deleteIfExists(cacheFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to clear relocation cache for dependency: " + String.valueOf(dependency), e);
        }
    }

    public String toString() {
        return "RelocationCacheResolver{localRepository=" + String.valueOf(this.localRepository) + "}";
    }
}

