/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.quark.repository;

import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.bxteam.quark.repository.Repository;
import org.jetbrains.annotations.NotNull;

public class LocalRepository
extends Repository {
    private final Path repositoryPath;

    public LocalRepository(@NotNull Path repositoryFolder) {
        super(LocalRepository.convertPathToUrl(repositoryFolder));
        this.repositoryPath = Objects.requireNonNull(repositoryFolder, "Repository folder cannot be null");
    }

    @NotNull
    public Path getPath() {
        return this.repositoryPath;
    }

    public boolean exists() {
        return Files.exists(this.repositoryPath, new LinkOption[0]);
    }

    public boolean isReadable() {
        return Files.isReadable(this.repositoryPath);
    }

    public boolean isDirectory() {
        return Files.isDirectory(this.repositoryPath, new LinkOption[0]);
    }

    public void ensureExists() {
        if (!this.exists()) {
            try {
                Files.createDirectories(this.repositoryPath, new FileAttribute[0]);
            }
            catch (Exception e) {
                throw new RepositoryException("Failed to create repository directory: " + String.valueOf(this.repositoryPath), e);
            }
        }
    }

    @NotNull
    public Path resolve(@NotNull String relativePath) {
        Objects.requireNonNull(relativePath, "Relative path cannot be null");
        return this.repositoryPath.resolve(relativePath);
    }

    @NotNull
    public static LocalRepository of(@NotNull String repositoryPath) {
        Objects.requireNonNull(repositoryPath, "Repository path cannot be null");
        return new LocalRepository(Path.of(repositoryPath, new String[0]));
    }

    @NotNull
    public static LocalRepository mavenLocal() {
        String userHome = System.getProperty("user.home");
        Path mavenLocalPath = Path.of(userHome, ".m2", "repository");
        return new LocalRepository(mavenLocalPath);
    }

    @NotNull
    private static String convertPathToUrl(@NotNull Path path) {
        Objects.requireNonNull(path, "Path cannot be null");
        try {
            return path.toUri().toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new RepositoryException("Failed to convert path to URL: " + String.valueOf(path), e);
        }
    }

    @Override
    public String toString() {
        return "LocalRepository{path=" + String.valueOf(this.repositoryPath) + ", url=" + this.baseUrl + "}";
    }

    public static class RepositoryException
    extends RuntimeException {
        public RepositoryException(String message2) {
            super(message2);
        }

        public RepositoryException(String message2, Throwable cause) {
            super(message2, cause);
        }
    }
}

