/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.quark.velocity;

import com.velocitypowered.api.plugin.PluginManager;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bxteam.quark.LibraryManager;
import org.bxteam.quark.classloader.IsolatedClassLoader;
import org.bxteam.quark.dependency.Dependency;
import org.bxteam.quark.logger.LogAdapter;
import org.bxteam.quark.relocation.Relocation;
import org.bxteam.quark.velocity.logger.adapters.VelocityLogAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class VelocityLibraryManager<T>
extends LibraryManager {
    private final PluginManager pluginManager;
    private final T plugin;

    public VelocityLibraryManager(@NotNull T plugin, @NotNull Logger logger, @NotNull Path dataDirectory, @NotNull PluginManager pluginManager) {
        this(plugin, logger, dataDirectory, pluginManager, "libs");
    }

    public VelocityLibraryManager(@NotNull T plugin, @NotNull Logger logger, @NotNull Path dataDirectory, @NotNull PluginManager pluginManager, @NotNull String librariesDirectoryName) {
        this(plugin, new VelocityLogAdapter(logger), dataDirectory, pluginManager, librariesDirectoryName);
    }

    public VelocityLibraryManager(@NotNull T plugin, @NotNull LogAdapter logAdapter, @NotNull Path dataDirectory, @NotNull PluginManager pluginManager, @NotNull String librariesDirectoryName) {
        super(logAdapter, dataDirectory, librariesDirectoryName);
        this.plugin = Objects.requireNonNull(plugin, "Plugin cannot be null");
        this.pluginManager = Objects.requireNonNull(pluginManager, "Plugin manager cannot be null");
        this.logger.debug("Initialized VelocityLibraryManager for plugin: " + plugin.getClass().getSimpleName());
    }

    @Override
    protected void addToClasspath(@NotNull Path jarPath) {
        Objects.requireNonNull(jarPath, "JAR path cannot be null");
        try {
            this.pluginManager.addToClasspath(this.plugin, jarPath);
            this.logger.debug("Added to Velocity classpath: " + String.valueOf(jarPath));
        }
        catch (Exception e) {
            throw new LibraryManager.LibraryLoadException("Failed to add JAR to Velocity plugin classpath: " + String.valueOf(jarPath), e);
        }
    }

    @Override
    @Nullable
    protected InputStream getResourceAsStream(@NotNull String resourcePath) {
        Objects.requireNonNull(resourcePath, "Resource path cannot be null");
        ClassLoader pluginClassLoader = this.plugin.getClass().getClassLoader();
        InputStream stream = pluginClassLoader.getResourceAsStream(resourcePath);
        if (stream == null) {
            stream = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
        }
        return stream;
    }

    @Override
    public void loadDependency(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        Objects.requireNonNull(groupId, "Group ID cannot be null");
        Objects.requireNonNull(artifactId, "Artifact ID cannot be null");
        Objects.requireNonNull(version, "Version cannot be null");
        this.loadDependency(Dependency.of(groupId, artifactId, version));
    }

    @Override
    public void loadDependency(@NotNull Dependency dependency) {
        Objects.requireNonNull(dependency, "Dependency cannot be null");
        this.loadDependencies(Collections.singletonList(dependency));
    }

    @Override
    public void loadDependencies(@NotNull List<Dependency> dependencies) {
        this.loadDependencies(dependencies, Collections.emptyList());
    }

    @Override
    public void loadDependencies(@NotNull List<Dependency> dependencies, @NotNull List<Relocation> relocations) {
        Objects.requireNonNull(dependencies, "Dependencies cannot be null");
        Objects.requireNonNull(relocations, "Relocations cannot be null");
        super.loadDependencies(dependencies, relocations);
    }

    public void loadDependenciesIsolated(@NotNull IsolatedClassLoader isolatedClassLoader, @NotNull List<Dependency> dependencies, @NotNull List<Relocation> relocations) {
        super.loadDependencies(isolatedClassLoader, dependencies, relocations);
    }

    @Override
    public void loadFromGradle() {
        super.loadFromGradle();
    }

    public void loadFromGradleIsolated(@NotNull IsolatedClassLoader isolatedClassLoader) {
        super.loadFromGradle(isolatedClassLoader);
    }

    @Override
    public void loadFromGradleIsolated(@NotNull String loaderId) {
        super.loadFromGradleIsolated(loaderId);
    }
}

