/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.quark.logger;

import java.util.Objects;
import org.bxteam.quark.logger.LogAdapter;
import org.bxteam.quark.logger.LogLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Logger {
    private final LogAdapter adapter;
    private volatile LogLevel level = LogLevel.INFO;

    public Logger(@NotNull LogAdapter adapter) {
        this.adapter = Objects.requireNonNull(adapter, "Log adapter cannot be null");
    }

    public void setLevel(@NotNull LogLevel level) {
        this.level = Objects.requireNonNull(level, "Log level cannot be null");
    }

    @NotNull
    public LogLevel getLevel() {
        return this.level;
    }

    public boolean isDebugEnabled() {
        return LogLevel.DEBUG.isEnabled(this.level);
    }

    public boolean isInfoEnabled() {
        return LogLevel.INFO.isEnabled(this.level);
    }

    public boolean isWarnEnabled() {
        return LogLevel.WARN.isEnabled(this.level);
    }

    public boolean isErrorEnabled() {
        return LogLevel.ERROR.isEnabled(this.level);
    }

    public void debug(@NotNull String message2) {
        if (this.isDebugEnabled()) {
            this.adapter.log(LogLevel.DEBUG, message2);
        }
    }

    public void debug(@NotNull String message2, @Nullable Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.adapter.log(LogLevel.DEBUG, message2, throwable);
        }
    }

    public void info(@NotNull String message2) {
        if (this.isInfoEnabled()) {
            this.adapter.log(LogLevel.INFO, message2);
        }
    }

    public void info(@NotNull String message2, @Nullable Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.adapter.log(LogLevel.INFO, message2, throwable);
        }
    }

    public void warn(@NotNull String message2) {
        if (this.isWarnEnabled()) {
            this.adapter.log(LogLevel.WARN, message2);
        }
    }

    public void warn(@NotNull String message2, @Nullable Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.adapter.log(LogLevel.WARN, message2, throwable);
        }
    }

    public void error(@NotNull String message2) {
        if (this.isErrorEnabled()) {
            this.adapter.log(LogLevel.ERROR, message2);
        }
    }

    public void error(@NotNull String message2, @Nullable Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.adapter.log(LogLevel.ERROR, message2, throwable);
        }
    }
}

