/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.quark.dependency;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Dependency {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;
    private final String fallbackRepository;
    private final boolean optional;
    private final String scope;

    private Dependency(Builder builder) {
        this.groupId = Objects.requireNonNull(builder.groupId, "Group ID cannot be null").trim();
        this.artifactId = Objects.requireNonNull(builder.artifactId, "Artifact ID cannot be null").trim();
        this.version = Objects.requireNonNull(builder.version, "Version cannot be null").trim();
        this.classifier = builder.classifier != null ? builder.classifier.trim() : null;
        this.fallbackRepository = builder.fallbackRepository;
        this.optional = builder.optional;
        String string = this.scope = builder.scope != null ? builder.scope.trim() : "compile";
        if (this.groupId.isEmpty()) {
            throw new IllegalArgumentException("Group ID cannot be empty");
        }
        if (this.artifactId.isEmpty()) {
            throw new IllegalArgumentException("Artifact ID cannot be empty");
        }
        if (this.version.isEmpty()) {
            throw new IllegalArgumentException("Version cannot be empty");
        }
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public static Dependency of(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        return Dependency.builder().groupId(groupId).artifactId(artifactId).version(version).build();
    }

    @NotNull
    public static Dependency fromCoordinates(@NotNull String coordinates) {
        Objects.requireNonNull(coordinates, "Coordinates cannot be null");
        String[] parts = coordinates.split(":");
        if (parts.length < 3) {
            throw new IllegalArgumentException("Invalid coordinates format. Expected: groupId:artifactId:version[:classifier]");
        }
        Builder builder = Dependency.builder().groupId(parts[0]).artifactId(parts[1]).version(parts[2]);
        if (parts.length > 3 && !parts[3].trim().isEmpty()) {
            builder.classifier(parts[3]);
        }
        return builder.build();
    }

    @NotNull
    public String getGroupId() {
        return this.groupId;
    }

    @NotNull
    public String getArtifactId() {
        return this.artifactId;
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    @Nullable
    public String getFallbackRepository() {
        return this.fallbackRepository;
    }

    public boolean isOptional() {
        return this.optional;
    }

    @NotNull
    public String getScope() {
        return this.scope;
    }

    @NotNull
    public String getGroupArtifactId() {
        return this.groupId + ":" + this.artifactId;
    }

    @NotNull
    public String getCoordinates() {
        StringBuilder coords = new StringBuilder().append(this.groupId).append(":").append(this.artifactId).append(":").append(this.version);
        if (this.classifier != null && !this.classifier.isEmpty()) {
            coords.append(":").append(this.classifier);
        }
        return coords.toString();
    }

    @NotNull
    public String getRepositoryPath() {
        String groupPath = this.groupId.replace('.', '/');
        return groupPath + "/" + this.artifactId + "/" + this.version;
    }

    @NotNull
    public String getJarFileName() {
        StringBuilder fileName = new StringBuilder().append(this.artifactId).append("-").append(this.version);
        if (this.classifier != null && !this.classifier.isEmpty()) {
            fileName.append("-").append(this.classifier);
        }
        fileName.append(".jar");
        return fileName.toString();
    }

    @NotNull
    public String getPomFileName() {
        return this.artifactId + "-" + this.version + ".pom";
    }

    @NotNull
    public Path getJarPath(@NotNull Path repositoryRoot) {
        return repositoryRoot.resolve(this.getRepositoryPath()).resolve(this.getJarFileName());
    }

    @NotNull
    public Path getPomPath(@NotNull Path repositoryRoot) {
        return repositoryRoot.resolve(this.getRepositoryPath()).resolve(this.getPomFileName());
    }

    @NotNull
    public URI getJarUri(@NotNull String repositoryUrl) throws URISyntaxException {
        Object cleanUrl = repositoryUrl.endsWith("/") ? repositoryUrl : repositoryUrl + "/";
        String jarPath = this.getRepositoryPath() + "/" + this.getJarFileName();
        return new URI((String)cleanUrl + jarPath);
    }

    @NotNull
    public URI getPomUri(@NotNull String repositoryUrl) throws URISyntaxException {
        Object cleanUrl = repositoryUrl.endsWith("/") ? repositoryUrl : repositoryUrl + "/";
        String pomPath = this.getRepositoryPath() + "/" + this.getPomFileName();
        return new URI((String)cleanUrl + pomPath);
    }

    @NotNull
    public URI getMetadataUri(@NotNull String repositoryUrl) throws URISyntaxException {
        Object cleanUrl = repositoryUrl.endsWith("/") ? repositoryUrl : repositoryUrl + "/";
        String groupPath = this.groupId.replace('.', '/');
        String metadataPath = groupPath + "/" + this.artifactId + "/maven-metadata.xml";
        return new URI((String)cleanUrl + metadataPath);
    }

    @NotNull
    public Dependency withVersion(@NotNull String newVersion) {
        return Dependency.builder().groupId(this.groupId).artifactId(this.artifactId).version(newVersion).classifier(this.classifier).fallbackRepository(this.fallbackRepository).optional(this.optional).scope(this.scope).build();
    }

    @NotNull
    public Dependency withClassifier(@Nullable String newClassifier) {
        return Dependency.builder().groupId(this.groupId).artifactId(this.artifactId).version(this.version).classifier(newClassifier).fallbackRepository(this.fallbackRepository).optional(this.optional).scope(this.scope).build();
    }

    @NotNull
    public Dependency withFallbackRepository(@Nullable String newFallbackRepository) {
        return Dependency.builder().groupId(this.groupId).artifactId(this.artifactId).version(this.version).classifier(this.classifier).fallbackRepository(newFallbackRepository).optional(this.optional).scope(this.scope).build();
    }

    @NotNull
    public Dependency withOptional(boolean newOptional) {
        return Dependency.builder().groupId(this.groupId).artifactId(this.artifactId).version(this.version).classifier(this.classifier).fallbackRepository(this.fallbackRepository).optional(newOptional).scope(this.scope).build();
    }

    @NotNull
    public Dependency withScope(@Nullable String newScope) {
        return Dependency.builder().groupId(this.groupId).artifactId(this.artifactId).version(this.version).classifier(this.classifier).fallbackRepository(this.fallbackRepository).optional(this.optional).scope(newScope).build();
    }

    public boolean isSameArtifact(@NotNull Dependency other) {
        return Objects.equals(this.groupId, other.groupId) && Objects.equals(this.artifactId, other.artifactId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Dependency that = (Dependency)obj;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.version, that.version) && Objects.equals(this.classifier, that.classifier) && this.optional == that.optional && Objects.equals(this.scope, that.scope);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version, this.classifier, this.optional, this.scope);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getCoordinates());
        if (this.optional) {
            result.append(" (optional)");
        }
        if (!"compile".equals(this.scope)) {
            result.append(" (").append(this.scope).append(")");
        }
        if (this.fallbackRepository != null) {
            result.append(" (fallback: ").append(this.fallbackRepository).append(")");
        }
        return result.toString();
    }

    @NotNull
    public String toShortString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public static final class Builder {
        private String groupId;
        private String artifactId;
        private String version;
        private String classifier;
        private String fallbackRepository;
        private boolean optional;
        private String scope;

        private Builder() {
        }

        @NotNull
        public Builder groupId(@NotNull String groupId) {
            this.groupId = Objects.requireNonNull(groupId, "Group ID cannot be null");
            return this;
        }

        @NotNull
        public Builder artifactId(@NotNull String artifactId) {
            this.artifactId = Objects.requireNonNull(artifactId, "Artifact ID cannot be null");
            return this;
        }

        @NotNull
        public Builder version(@NotNull String version) {
            this.version = Objects.requireNonNull(version, "Version cannot be null");
            return this;
        }

        @NotNull
        public Builder classifier(@Nullable String classifier) {
            this.classifier = classifier;
            return this;
        }

        @NotNull
        public Builder fallbackRepository(@Nullable String fallbackRepository) {
            this.fallbackRepository = fallbackRepository;
            return this;
        }

        @NotNull
        public Builder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        @NotNull
        public Builder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        @NotNull
        public Dependency build() {
            return new Dependency(this);
        }
    }
}

