/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.quark.gradle;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.bxteam.quark.dependency.Dependency;
import org.bxteam.quark.relocation.Relocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleMetadataLoader {
    private static final String DEPENDENCIES_FILE = "quark/dependencies.txt";
    private static final String REPOSITORIES_FILE = "quark/repositories.txt";
    private static final String RELOCATIONS_FILE = "quark/relocations.txt";
    private static final String PROPERTIES_FILE = "quark/quark.properties";
    private final List<Dependency> dependencies;
    private final List<String> repositories;
    private final List<Relocation> relocations;
    private final Properties properties;

    public GradleMetadataLoader(@NotNull ResourceProvider resourceProvider) {
        Objects.requireNonNull(resourceProvider, "Resource provider cannot be null");
        this.dependencies = this.loadDependencies(resourceProvider);
        this.repositories = this.loadRepositories(resourceProvider);
        this.relocations = this.loadRelocations(resourceProvider);
        this.properties = this.loadProperties(resourceProvider);
    }

    @NotNull
    public List<Dependency> getDependencies() {
        return Collections.unmodifiableList(this.dependencies);
    }

    @NotNull
    public List<String> getRepositories() {
        return Collections.unmodifiableList(this.repositories);
    }

    @NotNull
    public List<Relocation> getRelocations() {
        return Collections.unmodifiableList(this.relocations);
    }

    @NotNull
    public String getLibsFolder() {
        return this.properties.getProperty("libs-folder", "libs");
    }

    public boolean hasRelocations() {
        return !this.relocations.isEmpty();
    }

    public boolean hasDependencies() {
        return !this.dependencies.isEmpty();
    }

    public boolean hasRepositories() {
        return !this.repositories.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private List<Dependency> loadDependencies(@NotNull ResourceProvider resourceProvider) {
        InputStream stream = resourceProvider.getResourceAsStream(DEPENDENCIES_FILE);
        if (stream == null) {
            return Collections.emptyList();
        }
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                try {
                    deps.add(Dependency.fromCoordinates(line));
                }
                catch (IllegalArgumentException e) {
                    throw new GradleMetadataException("Invalid dependency format: " + line, e);
                    return deps;
                }
            }
        }
        catch (IOException e) {
            throw new GradleMetadataException("Failed to read dependencies metadata", e);
        }
    }

    @NotNull
    private List<String> loadRepositories(@NotNull ResourceProvider resourceProvider) {
        InputStream stream = resourceProvider.getResourceAsStream(REPOSITORIES_FILE);
        if (stream == null) {
            return Collections.emptyList();
        }
        ArrayList<String> repos = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                repos.add(line);
            }
        }
        catch (IOException e) {
            throw new GradleMetadataException("Failed to read repositories metadata", e);
        }
        return repos;
    }

    @NotNull
    private List<Relocation> loadRelocations(@NotNull ResourceProvider resourceProvider) {
        InputStream stream = resourceProvider.getResourceAsStream(RELOCATIONS_FILE);
        if (stream == null) {
            return Collections.emptyList();
        }
        ArrayList<Relocation> relocs = new ArrayList<Relocation>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                String[] parts = line.split(":", 2);
                if (parts.length == 2) {
                    relocs.add(Relocation.of(parts[0], parts[1]));
                    continue;
                }
                throw new GradleMetadataException("Invalid relocation format: " + line);
            }
        }
        catch (IOException e) {
            throw new GradleMetadataException("Failed to read relocations metadata", e);
        }
        return relocs;
    }

    @NotNull
    private Properties loadProperties(@NotNull ResourceProvider resourceProvider) {
        Properties props = new Properties();
        InputStream stream = resourceProvider.getResourceAsStream(PROPERTIES_FILE);
        if (stream == null) {
            return props;
        }
        try {
            props.load(stream);
        }
        catch (IOException e) {
            throw new GradleMetadataException("Failed to read properties metadata", e);
        }
        return props;
    }

    public static class GradleMetadataException
    extends RuntimeException {
        public GradleMetadataException(String message2) {
            super(message2);
        }

        public GradleMetadataException(String message2, Throwable cause) {
            super(message2, cause);
        }
    }

    public static interface ResourceProvider {
        @Nullable
        public InputStream getResourceAsStream(@NotNull String var1);
    }
}

