/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.quark.logger.adapters;

import java.io.PrintStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.bxteam.quark.logger.LogAdapter;
import org.bxteam.quark.logger.LogLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleLogAdapter
implements LogAdapter {
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss");

    @Override
    public void log(@NotNull LogLevel level, @NotNull String message2) {
        this.log(level, message2, null);
    }

    @Override
    public void log(@NotNull LogLevel level, @NotNull String message2, @Nullable Throwable throwable) {
        String timestamp = LocalDateTime.now().format(TIME_FORMAT);
        String logMessage = String.format("[%s] [%s] %s", timestamp, level.name(), message2);
        PrintStream stream = level == LogLevel.ERROR ? System.err : System.out;
        stream.println(logMessage);
        if (throwable != null) {
            throwable.printStackTrace(stream);
        }
    }
}

