/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.quark.logger.adapters;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bxteam.quark.logger.LogAdapter;
import org.bxteam.quark.logger.LogLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLogAdapter
implements LogAdapter {
    private final Logger logger;

    public JavaLogAdapter(@NotNull Logger logger) {
        this.logger = Objects.requireNonNull(logger, "logger");
    }

    @Override
    public void log(@NotNull LogLevel level, @NotNull String message2) {
        this.logger.log(this.convertLevel(level), message2);
    }

    @Override
    public void log(@NotNull LogLevel level, @NotNull String message2, @Nullable Throwable throwable) {
        this.logger.log(this.convertLevel(level), message2, throwable);
    }

    private Level convertLevel(LogLevel level) {
        switch (level) {
            case DEBUG: {
                return Level.FINE;
            }
            case WARN: {
                return Level.WARNING;
            }
            case ERROR: {
                return Level.SEVERE;
            }
        }
        return Level.INFO;
    }
}

