/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.quark.pom.model;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MavenMetadata {
    @Nullable
    private final String groupId;
    @Nullable
    private final String artifactId;
    @Nullable
    private final String latest;
    @Nullable
    private final String release;
    @NotNull
    private final List<String> versions;

    public MavenMetadata(@Nullable String groupId, @Nullable String artifactId, @Nullable String latest, @Nullable String release, @NotNull List<String> versions) {
        versions = List.copyOf(versions);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.latest = latest;
        this.release = release;
        this.versions = versions;
    }

    @Nullable
    public String getBestVersion() {
        if (this.release != null && !this.release.trim().isEmpty()) {
            return this.release;
        }
        if (this.latest != null && !this.latest.trim().isEmpty()) {
            return this.latest;
        }
        if (!this.versions.isEmpty()) {
            return this.versions.get(this.versions.size() - 1);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MavenMetadata that = (MavenMetadata)obj;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.latest, that.latest) && Objects.equals(this.release, that.release) && Objects.equals(this.versions, that.versions);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.latest, this.release, this.versions);
    }

    public String toString() {
        return "MavenMetadata[groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", latest=" + this.latest + ", release=" + this.release + ", versions=" + String.valueOf(this.versions) + "]";
    }

    @Nullable
    @Generated
    public String groupId() {
        return this.groupId;
    }

    @Nullable
    @Generated
    public String artifactId() {
        return this.artifactId;
    }

    @Nullable
    @Generated
    public String latest() {
        return this.latest;
    }

    @Nullable
    @Generated
    public String release() {
        return this.release;
    }

    @NotNull
    @Generated
    public List<String> versions() {
        return this.versions;
    }
}

