/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.quark.velocity.logger.adapters;

import java.util.Objects;
import org.bxteam.quark.logger.LogAdapter;
import org.bxteam.quark.logger.LogLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class VelocityLogAdapter
implements LogAdapter {
    private final Logger logger;

    public VelocityLogAdapter(@NotNull Logger logger) {
        this.logger = Objects.requireNonNull(logger, "Logger cannot be null");
    }

    @Override
    public void log(@NotNull LogLevel level, @NotNull String message2) {
        switch (Objects.requireNonNull(level, "level")) {
            case DEBUG: {
                this.logger.debug(message2);
                break;
            }
            case INFO: {
                this.logger.info(message2);
                break;
            }
            case WARN: {
                this.logger.warn(message2);
                break;
            }
            case ERROR: {
                this.logger.error(message2);
            }
        }
    }

    @Override
    public void log(@NotNull LogLevel level, @NotNull String message2, @Nullable Throwable throwable) {
        switch (Objects.requireNonNull(level, "level")) {
            case DEBUG: {
                this.logger.debug(message2, throwable);
                break;
            }
            case INFO: {
                this.logger.info(message2, throwable);
                break;
            }
            case WARN: {
                this.logger.warn(message2, throwable);
                break;
            }
            case ERROR: {
                this.logger.error(message2, throwable);
            }
        }
    }
}

