/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers;

import cn.aurorian.ers.client.ErsDataTickets;
import cn.aurorian.ers.client.gui.VehicleStaminaRenderer;
import cn.aurorian.ers.config.ErsServerConfig;
import cn.aurorian.ers.init.ErsBiomeModifierSerializers;
import cn.aurorian.ers.init.ErsBlockEntities;
import cn.aurorian.ers.init.ErsBlocks;
import cn.aurorian.ers.init.ErsContainers;
import cn.aurorian.ers.init.ErsCreativeTab;
import cn.aurorian.ers.init.ErsEntities;
import cn.aurorian.ers.init.ErsItems;
import cn.aurorian.ers.init.ErsMobEffects;
import cn.aurorian.ers.init.ErsNetwork;
import cn.aurorian.ers.init.ErsParticleType;
import cn.aurorian.ers.init.ErsSerializers;
import cn.aurorian.ers.init.ErsSounds;
import cn.aurorian.oasis.init.OasisContainers;
import cn.aurorian.oasis.init.OasisCreativeTab;
import cn.aurorian.oasis.init.OasisEntities;
import cn.aurorian.oasis.init.OasisItems;
import cn.aurorian.oasis.init.OasisMobEffects;
import cn.aurorian.oasis.init.OasisPotion;
import cn.aurorian.oasis.init.OasisPotionRecipe;
import cn.aurorian.oasis.init.OasisSounds;
import java.util.Locale;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import software.bernie.geckolib.GeckoLib;

@Mod.EventBusSubscriber
@Mod(value="ers")
public class EcologicalReplenishmentStation {
    public static final String MODID = "ers";
    public static boolean AlexsMobsLoaded;
    public static boolean PrehistoricFaunaLoaded;

    public EcologicalReplenishmentStation(FMLJavaModLoadingContext context) {
        GeckoLib.initialize();
        this.initRegister(context.getModEventBus());
        context.getModEventBus().addListener(this::commonSetup);
        context.getModEventBus().addListener(this::setupClient);
        ErsServerConfig.register(context);
        if (FMLEnvironment.dist.isClient()) {
            context.getModEventBus().addListener(VehicleStaminaRenderer::registerStaminaOverlay);
        }
    }

    private void initRegister(IEventBus eventBus) {
        ErsEntities.register(eventBus);
        ErsContainers.register(eventBus);
        ErsBlocks.register(eventBus);
        ErsBlockEntities.register(eventBus);
        ErsItems.register(eventBus);
        ErsMobEffects.register(eventBus);
        ErsCreativeTab.register(eventBus);
        ErsNetwork.register();
        ErsSerializers.register(eventBus);
        ErsDataTickets.register();
        ErsSounds.SOUND_EVENTS.register(eventBus);
        ErsParticleType.PARTICLE_TYPES.register(eventBus);
        ErsBiomeModifierSerializers.register(eventBus);
        OasisEntities.register(eventBus);
        OasisContainers.register(eventBus);
        OasisItems.register(eventBus);
        OasisCreativeTab.register(eventBus);
        OasisMobEffects.register(eventBus);
        OasisPotion.register(eventBus);
        OasisSounds.SOUND_EVENTS.register(eventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        AlexsMobsLoaded = ModList.get().isLoaded("alexsmobs");
        PrehistoricFaunaLoaded = ModList.get().isLoaded("prehistoricfauna");
        ErsItems.registerComposterBlock();
        OasisPotionRecipe.registerRecipes();
    }

    public void setupClient(FMLClientSetupEvent event) {
        ItemProperties.register((Item)((Item)ErsItems.DRAGON_CLAW_HARPOON.get()), (ResourceLocation)EcologicalReplenishmentStation.prefix("throwing"), (stack, level, entity, p) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
    }

    public static ResourceLocation prefix(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name.toLowerCase(Locale.ROOT));
    }
}

