/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers;

import cn.aurorian.ers.EcologicalReplenishmentStation;
import cn.aurorian.ers.block.ArtificialNestBlock;
import cn.aurorian.ers.block.be.ArtificialNestBlockEntity;
import cn.aurorian.ers.entity.ErsTamable;
import cn.aurorian.ers.item.egg.ErsEgg;
import cn.aurorian.oasis.Oasis;
import cn.aurorian.oasis.entity.HasGender;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin(value="ers")
public class ErsJadePlugin
implements IWailaPlugin {
    public static final ResourceLocation AGE = EcologicalReplenishmentStation.prefix("age");
    public static final ResourceLocation FOOD = EcologicalReplenishmentStation.prefix("food");
    public static final ResourceLocation HATCH = EcologicalReplenishmentStation.prefix("hatch");
    public static final ResourceLocation GENDER = Oasis.prefix("gender");

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerEntityComponent((IEntityComponentProvider)AgeProvider.INSTANCE, ErsTamable.class);
        registration.registerEntityComponent((IEntityComponentProvider)FoodProvider.INSTANCE, ErsTamable.class);
        registration.registerEntityComponent((IEntityComponentProvider)GenderProvider.INSTANCE, ErsTamable.class);
        registration.registerBlockComponent((IBlockComponentProvider)HatchProvider.INSTANCE, ArtificialNestBlock.class);
    }

    private static enum AgeProvider implements IEntityComponentProvider
    {
        INSTANCE;


        public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
            ErsTamable entity;
            Entity entity2 = accessor.getEntity();
            if (entity2 instanceof ErsTamable && (entity = (ErsTamable)entity2).doAgeTick()) {
                int ageInDays = entity.getAgeInDays();
                tooltip.add((Component)Component.m_237110_((String)"tooltip.ers.age", (Object[])new Object[]{ageInDays}));
            }
        }

        public ResourceLocation getUid() {
            return AGE;
        }
    }

    private static enum FoodProvider implements IEntityComponentProvider
    {
        INSTANCE;


        public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
            ErsTamable entity;
            Entity entity2 = accessor.getEntity();
            if (entity2 instanceof ErsTamable && (entity = (ErsTamable)entity2).doHunger()) {
                float hunger = entity.getHunger();
                tooltip.add((Component)Component.m_237110_((String)"tooltip.ers.food", (Object[])new Object[]{Float.valueOf(hunger)}));
            }
        }

        public ResourceLocation getUid() {
            return FOOD;
        }
    }

    private static enum GenderProvider implements IEntityComponentProvider
    {
        INSTANCE;


        public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
            Entity entity = accessor.getEntity();
            if (entity instanceof HasGender) {
                HasGender hasGender = (HasGender)entity;
                if (hasGender.getGender()) {
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.oasis.gender.male"));
                } else {
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.oasis.gender.female"));
                }
            }
        }

        public ResourceLocation getUid() {
            return GENDER;
        }
    }

    private static enum HatchProvider implements IBlockComponentProvider
    {
        INSTANCE;


        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            BlockEntity blockEntity = accessor.getBlockEntity();
            if (blockEntity instanceof ArtificialNestBlockEntity) {
                ArtificialNestBlockEntity entity = (ArtificialNestBlockEntity)blockEntity;
                if (entity.getEgg().m_41619_()) {
                    return;
                }
                ErsEgg eggItem = (ErsEgg)entity.getEgg().m_41720_();
                int timer = entity.getHatchingTime() * 100 / eggItem.getHatchTime();
                tooltip.add((Component)Component.m_237110_((String)"tooltip.ers.hatch", (Object[])new Object[]{"\u00a7a" + timer}));
            }
        }

        public ResourceLocation getUid() {
            return HATCH;
        }
    }
}

