/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.block.plant;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import org.jetbrains.annotations.NotNull;

public class EquisetumBlock
extends Block
implements IPlantable {
    public static final IntegerProperty AGE = BlockStateProperties.f_61410_;
    public static final IntegerProperty FLOWER = IntegerProperty.m_61631_((String)"flower", (int)0, (int)3);

    public EquisetumBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)FLOWER, (Comparable)Integer.valueOf(0)));
    }

    public void m_213897_(BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        if (!pState.m_60710_((LevelReader)pLevel, pPos)) {
            pLevel.m_46961_(pPos, true);
        }
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    }

    @NotNull
    public BlockState m_7417_(BlockState pState, @NotNull Direction pFacing, @NotNull BlockState pFacingState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pFacingPos) {
        if (!pState.m_60710_((LevelReader)pLevel, pCurrentPos)) {
            pLevel.m_186460_(pCurrentPos, (Block)this, 1);
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public boolean m_7898_(@NotNull BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState soil = pLevel.m_8055_(pPos.m_7495_());
        if (soil.canSustainPlant((BlockGetter)pLevel, pPos.m_7495_(), Direction.UP, (IPlantable)this)) {
            return true;
        }
        BlockState blockstate = pLevel.m_8055_(pPos.m_7495_());
        if (blockstate.m_60713_((Block)this)) {
            return true;
        }
        if (blockstate.m_204336_(BlockTags.f_144274_) || blockstate.m_204336_(BlockTags.f_13029_)) {
            BlockPos blockpos = pPos.m_7495_();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState blockstate1 = pLevel.m_8055_(blockpos.m_121945_(direction));
                FluidState fluidstate = pLevel.m_6425_(blockpos.m_121945_(direction));
                if (!pState.canBeHydrated((BlockGetter)pLevel, pPos, fluidstate, blockpos.m_121945_(direction)) && !blockstate1.m_60713_(Blocks.f_50449_)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasNearbyWaterSource(LevelReader level, BlockPos pos) {
        BlockPos soilPos = pos.m_7495_();
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    BlockPos checkPos = soilPos.m_7918_(x, y, z);
                    FluidState fluidState = level.m_6425_(checkPos);
                    if (!fluidState.m_205070_(FluidTags.f_13131_) && !level.m_8055_(checkPos).m_60713_(Blocks.f_50449_)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void m_213898_(@NotNull BlockState pState, ServerLevel pLevel, BlockPos pPos, @NotNull RandomSource pRandom) {
        if (pLevel.m_46859_(pPos.m_7494_()) && (Integer)pState.m_61143_((Property)FLOWER) <= 1) {
            int i = 1;
            while (pLevel.m_8055_(pPos.m_6625_(i)).m_60713_((Block)this)) {
                ++i;
            }
            if (i < 8) {
                int j = (Integer)pState.m_61143_((Property)AGE);
                if (ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (boolean)true)) {
                    if (j == 15) {
                        BlockState growing = this.m_49966_();
                        if (pRandom.m_188501_() < 0.5f) {
                            growing = (BlockState)this.m_49966_().m_61124_((Property)FLOWER, (Comparable)Integer.valueOf(1));
                        }
                        if (i > 5 && pRandom.m_188501_() < 0.33f * (float)(i - 5)) {
                            growing = pRandom.m_188501_() < 0.5f ? (BlockState)this.m_49966_().m_61124_((Property)FLOWER, (Comparable)Integer.valueOf(2)) : (BlockState)this.m_49966_().m_61124_((Property)FLOWER, (Comparable)Integer.valueOf(3));
                        }
                        pLevel.m_46597_(pPos.m_7494_(), growing);
                        ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos.m_7494_(), (BlockState)growing);
                        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)), 4);
                    } else {
                        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(j + 1)), 4);
                    }
                }
            }
        }
    }

    public BlockState getPlant(BlockGetter blockGetter, BlockPos blockPos) {
        return this.m_49966_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{AGE}).m_61104_(new Property[]{FLOWER});
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.BEACH;
    }
}

