/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.entity;

import cn.aurorian.ers.config.ErsServerConfig;
import cn.aurorian.ers.entity.ErsEntity;
import cn.aurorian.ers.init.ErsItems;
import cn.aurorian.ers.item.FilledGildedHorn;
import cn.aurorian.ers.util.ErsUtils;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class ErsTamable<T extends ErsTamable<?>>
extends TamableAnimal
implements GeoEntity,
ErsEntity<T> {
    private static final EntityDataAccessor<Boolean> ENABLE = SynchedEntityData.m_135353_(ErsTamable.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> DIMENSION = SynchedEntityData.m_135353_(ErsTamable.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> X = SynchedEntityData.m_135353_(ErsTamable.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> Y = SynchedEntityData.m_135353_(ErsTamable.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> Z = SynchedEntityData.m_135353_(ErsTamable.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AGE_TICKS = SynchedEntityData.m_135353_(ErsTamable.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> HUNGER = SynchedEntityData.m_135353_(ErsTamable.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.m_135353_(ErsTamable.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected boolean doHunger = false;
    protected boolean doAgeTick = false;

    protected ErsTamable(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_264410_() {
        return true;
    }

    public boolean isRespawnEnable() {
        return (Boolean)this.f_19804_.m_135370_(ENABLE);
    }

    public void setEnable(boolean enable) {
        this.f_19804_.m_135381_(ENABLE, (Object)enable);
    }

    public BlockPos getRespawnPos() {
        return new BlockPos(((Integer)this.f_19804_.m_135370_(X)).intValue(), ((Integer)this.f_19804_.m_135370_(Y)).intValue(), ((Integer)this.f_19804_.m_135370_(Z)).intValue());
    }

    public void setRespawnPos(BlockPos pos) {
        this.f_19804_.m_135381_(X, (Object)pos.m_123341_());
        this.f_19804_.m_135381_(Y, (Object)pos.m_123342_());
        this.f_19804_.m_135381_(Z, (Object)pos.m_123343_());
    }

    public void setDimension(String dimension) {
        this.f_19804_.m_135381_(DIMENSION, (Object)dimension);
    }

    public String getDimension() {
        return (String)this.f_19804_.m_135370_(DIMENSION);
    }

    public int getAgeInDays() {
        return (Integer)this.f_19804_.m_135370_(AGE_TICKS) / 24000;
    }

    public void setAgeInDays(int age) {
        this.f_19804_.m_135381_(AGE_TICKS, (Object)(age * 24000));
    }

    public int getAgeInTicks() {
        return (Integer)this.f_19804_.m_135370_(AGE_TICKS);
    }

    public void setAgeInTicks(int age) {
        this.f_19804_.m_135381_(AGE_TICKS, (Object)age);
    }

    public float getHunger() {
        return ((Float)this.f_19804_.m_135370_(HUNGER)).floatValue();
    }

    public void setHunger(float hunger) {
        this.f_19804_.m_135381_(HUNGER, (Object)Float.valueOf(Math.max(Math.min(hunger, 100.0f), 0.0f)));
    }

    public int getCommand() {
        return (Integer)this.f_19804_.m_135370_(COMMAND);
    }

    public void setCommand(int command) {
        this.f_19804_.m_135381_(COMMAND, (Object)command);
    }

    public void feed(int foodAmount) {
        this.setHunger(this.getHunger() + (float)foodAmount);
    }

    public boolean doHunger() {
        return this.doHunger;
    }

    public boolean doAgeTick() {
        return this.doAgeTick;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ENABLE, (Object)false);
        this.f_19804_.m_135372_(DIMENSION, (Object)"");
        this.f_19804_.m_135372_(X, (Object)0);
        this.f_19804_.m_135372_(Y, (Object)0);
        this.f_19804_.m_135372_(Z, (Object)0);
        this.f_19804_.m_135372_(AGE_TICKS, (Object)0);
        this.f_19804_.m_135372_(HUNGER, (Object)Float.valueOf(100.0f));
        this.f_19804_.m_135372_(COMMAND, (Object)0);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Enable", this.isRespawnEnable());
        if (this.isRespawnEnable()) {
            compound.m_128359_("RespawnDimension", this.getDimension());
            BlockPos pos = this.getRespawnPos();
            compound.m_128405_("RespawnX", pos.m_123341_());
            compound.m_128405_("RespawnY", pos.m_123342_());
            compound.m_128405_("RespawnZ", pos.m_123343_());
        }
        if (this.doHunger) {
            compound.m_128350_("Hunger", this.getHunger());
        }
        if (this.doAgeTick) {
            compound.m_128405_("AgeTicks", this.getAgeInTicks());
        }
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        boolean enable = pCompound.m_128471_("Enable");
        this.setEnable(enable);
        if (enable) {
            this.setDimension(pCompound.m_128461_("RespawnDimension"));
            int x = pCompound.m_128451_("RespawnX");
            int y = pCompound.m_128451_("RespawnY");
            int z = pCompound.m_128451_("RespawnZ");
            this.setRespawnPos(new BlockPos(x, y, z));
        }
        if (this.doHunger) {
            this.setHunger(pCompound.m_128457_("Hunger"));
        }
        if (this.doAgeTick) {
            this.setAgeInTicks(pCompound.m_128451_("AgeTicks"));
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.f_19797_ % 20 == 0) {
            float hunger = this.getHunger();
            if (this.doAgeTick && hunger > 0.0f) {
                this.setAgeInTicks(this.getAgeInTicks() + 20 * (Integer)ErsServerConfig.MATURE_RATE.get());
            }
        }
    }

    public ErsTamable<?> getBreedOffspring(@Nonnull ServerLevel level, @Nonnull AgeableMob otherParent) {
        return null;
    }

    public boolean m_7307_(@NotNull Entity pEntity) {
        TamableAnimal tamableAnimal;
        return super.m_7307_(pEntity) || pEntity instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)pEntity).m_269323_() == this.m_269323_();
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand pHand) {
        if (player.m_21205_().m_41720_() == ErsItems.GILDED_HORN.get() && this.m_21824_() && this.m_21830_((LivingEntity)player) && !this.m_6040_()) {
            return FilledGildedHorn.hornPickup(player, pHand, this).orElse(InteractionResult.PASS);
        }
        return super.m_6071_(player, pHand);
    }

    public void updateFromAgeServer() {
    }

    public boolean isMoving() {
        return ErsUtils.isMoving((Mob)this);
    }
}

