/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.entity;

import cn.aurorian.ers.EcologicalReplenishmentStation;
import cn.aurorian.ers.client.ErsDataTickets;
import cn.aurorian.ers.client.MountCameraManager;
import cn.aurorian.ers.entity.AttackType;
import cn.aurorian.ers.entity.ErsTamable;
import cn.aurorian.ers.entity.MobAttack;
import cn.aurorian.ers.entity.MobRotDirection;
import cn.aurorian.ers.init.ErsNetwork;
import cn.aurorian.ers.init.ErsSerializers;
import cn.aurorian.ers.item.equipment.MountEquipment;
import cn.aurorian.ers.packet.MobTurnPacket;
import cn.aurorian.ers.util.ErsUtils;
import cn.aurorian.ers.util.TickHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3f;
import superlord.prehistoricfauna.init.PFBlocks;

public abstract class ErsTamableVehicle<T extends ErsTamableVehicle<?>>
extends ErsTamable<T>
implements ContainerListener {
    private static final EntityDataAccessor<MobRotDirection> ROT_DIRECTION = SynchedEntityData.m_135353_(ErsTamableVehicle.class, (EntityDataSerializer)((EntityDataSerializer)ErsSerializers.MOB_ROTATION_SERIALIZER.get()));
    public static final EntityDataAccessor<Boolean> IS_DIVING = SynchedEntityData.m_135353_(ErsTamableVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SWIM_STATE = SynchedEntityData.m_135353_(ErsTamableVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<MobAttack> ATTACK_STATE = SynchedEntityData.m_135353_(ErsTamableVehicle.class, (EntityDataSerializer)((EntityDataSerializer)ErsSerializers.MOB_ATTACK_SERIALIZER.get()));
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.m_135353_(ErsTamableVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> STAMINA = SynchedEntityData.m_135353_(ErsTamableVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> DATA_SADDLED = SynchedEntityData.m_135353_(ErsTamableVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ELITE = SynchedEntityData.m_135353_(ErsTamableVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CAN_BE_ELITE = SynchedEntityData.m_135353_(ErsTamableVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> MATURE = SynchedEntityData.m_135353_(ErsTamableVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> RENDER_SIZE = SynchedEntityData.m_135353_(ErsTamableVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> BLOODY = SynchedEntityData.m_135353_(ErsTamableVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Vector3f> FOOD_POSITION = SynchedEntityData.m_135353_(ErsTamableVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    protected float rideSpeed;
    public ErsTamableVehicle<?> leader;
    protected SimpleContainer inventory;
    protected boolean stableHead = false;
    public int staminaCount = 0;
    public float SWIM_COST = 0.1f;
    public float SPRINT_COST = 0.15f;
    public float RECOVER = 0.075f;
    public boolean WATER_ANIMAL = false;
    public boolean RECOVER_WHEN_WALK = true;

    protected ErsTamableVehicle(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public MobRotDirection getRotDirection() {
        return (MobRotDirection)this.f_19804_.m_135370_(ROT_DIRECTION);
    }

    public void setRotDirection(MobRotDirection rotDirection) {
        this.setRotDirection(rotDirection, false);
    }

    public void setRotDirection(MobRotDirection rotDirection, boolean sync) {
        this.f_19804_.m_135381_(ROT_DIRECTION, (Object)rotDirection);
        if (sync) {
            ErsNetwork.INSTANCE.sendToServer((Object)new MobTurnPacket(this.m_19879_(), rotDirection));
        }
    }

    public void onDiveKeyUpdate(boolean pressed) {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(IS_DIVING, (Object)pressed);
        }
    }

    public int getSwimState() {
        return (Integer)this.f_19804_.m_135370_(SWIM_STATE);
    }

    public void setSwimState(int state) {
        this.f_19804_.m_135381_(SWIM_STATE, (Object)state);
    }

    public void setAttackState(MobAttack mobAttack) {
        this.f_19804_.m_135381_(ATTACK_STATE, (Object)mobAttack);
    }

    public MobAttack getAttackState() {
        return (MobAttack)this.f_19804_.m_135370_(ATTACK_STATE);
    }

    public float getStamina() {
        return ((Float)this.f_19804_.m_135370_(STAMINA)).floatValue();
    }

    public void setStamina(float i) {
        this.f_19804_.m_135381_(STAMINA, (Object)Float.valueOf(org.joml.Math.min((float)100.0f, (float)i)));
    }

    public boolean getStableHead() {
        return this.stableHead;
    }

    public void setStableHead(boolean stableHead) {
        this.stableHead = stableHead;
    }

    public boolean canBeElite() {
        return (Boolean)this.f_19804_.m_135370_(CAN_BE_ELITE);
    }

    public void setCanBeElite(boolean canBeElite) {
        this.f_19804_.m_135381_(CAN_BE_ELITE, (Object)canBeElite);
    }

    public boolean isElite() {
        return (Boolean)this.f_19804_.m_135370_(ELITE);
    }

    public void setElite(boolean elite) {
        this.f_19804_.m_135381_(ELITE, (Object)elite);
    }

    public boolean isMature() {
        return (Boolean)this.f_19804_.m_135370_(MATURE);
    }

    public void setMature(boolean mature) {
        this.f_19804_.m_135381_(MATURE, (Object)mature);
    }

    public float getRenderSize() {
        return ((Float)this.f_19804_.m_135370_(RENDER_SIZE)).floatValue();
    }

    public void setRenderSize(float renderSize) {
        this.f_19804_.m_135381_(RENDER_SIZE, (Object)Float.valueOf(renderSize));
    }

    public void setBloody(boolean bloody) {
        this.f_19804_.m_135381_(BLOODY, (Object)bloody);
    }

    public boolean isBloody() {
        return (Boolean)this.f_19804_.m_135370_(BLOODY);
    }

    public void setFoodPosition(Vector3f foodPosition) {
        this.f_19804_.m_135381_(FOOD_POSITION, (Object)foodPosition);
    }

    public Vector3f getFoodPosition() {
        return (Vector3f)this.f_19804_.m_135370_(FOOD_POSITION);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ROT_DIRECTION, (Object)MobRotDirection.of(MobRotDirection.RotDirection.NONE, false));
        this.f_19804_.m_135372_(IS_DIVING, (Object)false);
        this.f_19804_.m_135372_(SWIM_STATE, (Object)0);
        this.f_19804_.m_135372_(ATTACK_STATE, (Object)new MobAttack(AttackType.EMPTY, this));
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)0);
        this.f_19804_.m_135372_(STAMINA, (Object)Float.valueOf(100.0f));
        this.f_19804_.m_135372_(DATA_SADDLED, (Object)false);
        this.f_19804_.m_135372_(CAN_BE_ELITE, (Object)false);
        this.f_19804_.m_135372_(ELITE, (Object)false);
        this.f_19804_.m_135372_(MATURE, (Object)false);
        this.f_19804_.m_135372_(RENDER_SIZE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(BLOODY, (Object)false);
        this.f_19804_.m_135372_(FOOD_POSITION, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.getAttackState().tick();
            this.tickStamina(this.WATER_ANIMAL, this.RECOVER_WHEN_WALK);
            if (this.isBloody() && (this.f_19797_ - this.m_21215_() > 2400 || this.m_20069_())) {
                this.setBloody(false);
            }
            for (int i = 1; i <= 3; ++i) {
                Item item;
                ItemStack itemStack = this.inventory.m_8020_(i);
                if (itemStack.m_41619_() || !((item = itemStack.m_41720_()) instanceof MountEquipment)) continue;
                MountEquipment equipment = (MountEquipment)item;
                equipment.tickEquip(itemStack, this);
            }
        } else {
            this.getAnimator().tick();
        }
    }

    public void executeDefaultAttackType() {
    }

    public void executeSpecialAttackType() {
    }

    public void executeJudgementAttackType() {
    }

    public void executeTurnAttackType() {
    }

    public void tickStamina(boolean waterAnimal, boolean recoverWhenWalk) {
        if (this.m_6688_() instanceof Player) {
            if (this.m_20142_()) {
                this.staminaCount = 0;
                if (this.m_20069_()) {
                    this.setStamina(this.getStamina() - this.SWIM_COST);
                } else {
                    this.setStamina(this.getStamina() - this.SPRINT_COST);
                }
            } else {
                if (!waterAnimal && this.m_20069_()) {
                    return;
                }
                if (!recoverWhenWalk && this.rideSpeed != 0.0f) {
                    return;
                }
                ++this.staminaCount;
                if (this.staminaCount > 40) {
                    this.setStamina(this.getStamina() + this.RECOVER);
                }
            }
        } else {
            ++this.staminaCount;
            if (this.staminaCount > 40) {
                this.setStamina(this.getStamina() + this.RECOVER);
                if (this.getCommand() == 1) {
                    this.setStamina(this.getStamina() + 0.4f);
                }
            }
        }
        if (this.getStamina() <= 0.0f) {
            this.setStamina(0.0f);
        }
    }

    public void startAttack(AttackType type) {
        if ((float)type.getStaminaCost() > this.getStamina()) {
            return;
        }
        if (type.getStaminaCost() != 0) {
            this.setStamina(this.getStamina() - (float)type.getStaminaCost());
        }
        this.setAttackState(new MobAttack(type, this));
        this.triggerAnim("attack", type.getAnimName());
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariantId());
        compound.m_128350_("Stamina", this.getStamina());
        compound.m_128379_("saddled", this.isSaddled());
        if (this.doAgeTick()) {
            compound.m_128379_("Elite", this.isElite());
            compound.m_128379_("CanBeElite", this.canBeElite());
            compound.m_128379_("Mature", this.isMature());
            compound.m_128350_("RenderSize", this.getRenderSize());
        }
        if (this.inventory != null) {
            ListTag itemsList = new ListTag();
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack stack = this.inventory.m_8020_(i);
                if (stack.m_41619_()) continue;
                CompoundTag itemTag = new CompoundTag();
                itemTag.m_128405_("Slot", i);
                stack.m_41739_(itemTag);
                itemsList.add((Object)itemTag);
            }
            compound.m_128365_("Items", (Tag)itemsList);
        }
        if (this.m_8077_()) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.m_7770_()));
        }
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariantId(compound.m_128451_("Variant"));
        this.setStamina(compound.m_128457_("Stamina"));
        this.setSaddled(compound.m_128471_("saddled"));
        if (this.doAgeTick()) {
            this.setElite(compound.m_128471_("Elite"));
            this.setCanBeElite(compound.m_128471_("CanBeElite"));
            this.setMature(compound.m_128471_("Mature"));
            this.setRenderSize(compound.m_128457_("RenderSize"));
        }
        if (this.inventory != null) {
            this.inventory.m_6211_();
            ListTag itemsList = compound.m_128437_("Items", 10);
            for (int i = 0; i < itemsList.size(); ++i) {
                CompoundTag itemTag = itemsList.m_128728_(i);
                int slot = itemTag.m_128451_("Slot");
                ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag);
                if (stack.m_41619_() || slot < 0 || slot >= this.inventory.m_6643_()) continue;
                this.inventory.m_6836_(slot, stack);
            }
        }
        if (compound.m_128441_("CustomName")) {
            this.m_6593_((Component)Component.Serializer.m_130701_((String)compound.m_128461_("CustomName")));
        }
    }

    public int getVariantId() {
        return (Integer)this.f_19804_.m_135370_(DATA_VARIANT);
    }

    public void setVariantId(int i) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)i);
    }

    public abstract void updateMount();

    public void updateLeader() {
        double followDistance = this.m_21133_(Attributes.f_22277_);
        AABB followArea = AABB.m_82333_((Vec3)this.m_20182_()).m_82377_(followDistance, 10.0, followDistance);
        List nearbyMobs = this.m_9236_().m_6443_(this.getClass(), followArea, EntitySelector.f_20408_);
        ErsTamableVehicle currentLeader = null;
        float largestScale = -1.0f;
        for (Mob candidate : nearbyMobs) {
            float scale;
            ErsTamableVehicle tamable;
            if (!(candidate instanceof ErsTamableVehicle) || (tamable = (ErsTamableVehicle)candidate).m_6095_() != this.m_6095_() || !tamable.m_6084_() || tamable.m_6162_() || this.m_21824_() && !tamable.m_21824_() || !((scale = tamable.m_6134_()) > largestScale)) continue;
            largestScale = scale;
            currentLeader = tamable;
        }
        if (currentLeader != null) {
            this.leader = currentLeader;
        }
    }

    public boolean m_20142_() {
        Player player;
        LivingEntity livingEntity;
        return (super.m_20142_() || (livingEntity = this.m_6688_()) instanceof Player && (player = (Player)livingEntity).m_20142_()) && this.getStamina() > 0.0f;
    }

    public int getInventorySize() {
        return 7;
    }

    protected void createInventory() {
        this.inventory = new SimpleContainer(this.getInventorySize());
        this.inventory.m_19164_((ContainerListener)this);
    }

    @Nullable
    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public boolean isSaddled() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.f_19804_.m_135381_(DATA_SADDLED, (Object)saddled);
    }

    public abstract void equipSaddle();

    public boolean isSaddleable() {
        return this.m_6084_() && this.m_21824_();
    }

    protected void m_20348_(@NotNull Entity passenger) {
        Player player;
        super.m_20348_(passenger);
        if (passenger instanceof Player && (player = (Player)passenger).m_7578_()) {
            MountCameraManager.onDragonMount();
        }
    }

    protected void m_20351_(@NotNull Entity passenger) {
        Player player;
        super.m_20351_(passenger);
        if (!this.m_9236_().f_46443_) {
            TickHelper.tickLater(this.m_9236_(), 2, () -> this.setRotDirection(MobRotDirection.of(MobRotDirection.RotDirection.NONE, false)));
        }
        this.m_6858_(false);
        if (passenger instanceof Player && (player = (Player)passenger).m_7578_()) {
            MountCameraManager.onDragonDismount();
        }
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity passenger = this.m_146895_();
        return passenger instanceof LivingEntity ? (LivingEntity)passenger : null;
    }

    protected void m_19956_(@NotNull Entity pPassenger, @NotNull Entity.MoveFunction pCallback) {
        if (this.m_9236_().f_46443_) {
            Vector3d vector3d = (Vector3d)this.getAnimData(ErsDataTickets.SADDLE_POS);
            if (vector3d != null) {
                pCallback.m_20372_(pPassenger, this.m_20185_() + vector3d.x, this.m_20186_() + vector3d.y - 0.5, this.m_20189_() + vector3d.z);
            }
        } else {
            super.m_19956_(pPassenger, pCallback);
        }
    }

    private int calculateDownY() {
        if (this.m_21573_().m_26570_() != null) {
            Path path = this.m_21573_().m_26570_();
            Vec3 p = path.m_77382_((Entity)this, org.joml.Math.min((int)(path.m_77398_() - 1), (int)(path.m_77399_() + 1)));
            if (p.f_82480_ < this.m_20186_() - 1.0) {
                return -1;
            }
        }
        return 1;
    }

    protected void breakBlock() {
        if (ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            boolean bounds = true;
            int yMinus = this.calculateDownY();
            BlockPos.m_121886_((int)((int)org.joml.Math.floor((double)this.m_20191_().f_82288_) - 1), (int)((int)org.joml.Math.floor((double)this.m_20191_().f_82289_) + yMinus), (int)((int)org.joml.Math.floor((double)this.m_20191_().f_82290_) - 1), (int)((int)org.joml.Math.floor((double)this.m_20191_().f_82291_) + 1), (int)((int)org.joml.Math.floor((double)this.m_20191_().f_82292_) + 1), (int)((int)org.joml.Math.floor((double)this.m_20191_().f_82293_) + 1)).forEach(pos -> {
                boolean prehistoricCompat;
                BlockState state = this.m_9236_().m_8055_(pos);
                boolean bl = prehistoricCompat = EcologicalReplenishmentStation.PrehistoricFaunaLoaded && state.m_60713_((Block)PFBlocks.NELUMBO_STEM.get());
                if (state.m_60713_(Blocks.f_50196_) || state.m_204336_(BlockTags.f_13035_) || state.m_60713_(Blocks.f_220833_) || state.m_60713_(Blocks.f_50033_) || prehistoricCompat) {
                    this.m_20256_(this.m_20184_().m_82542_((double)0.6f, 1.0, (double)0.6f));
                    if (!this.m_9236_().f_46443_) {
                        this.m_9236_().m_46961_(pos, false);
                    }
                }
            });
        }
    }

    protected void stompEffect(float hurtSize, float forwards, float damage) {
        Vec3 center = this.m_20182_().m_82549_(new Vec3(0.0, 0.0, (double)forwards).m_82524_(-this.f_20883_ * ((float)Math.PI / 180)));
        AABB aabb = new AABB(center.m_82492_((double)hurtSize, 1.0, (double)hurtSize), center.m_82520_((double)hurtSize, 1.0, (double)hurtSize));
        for (LivingEntity living : this.m_9236_().m_6443_(LivingEntity.class, aabb, EntitySelector.f_20406_)) {
            if (living.m_7306_((Entity)this) || this.m_7307_((Entity)living) || living.m_6095_() == this.m_6095_() || !(living.m_20238_(center) <= (double)(hurtSize * hurtSize))) continue;
            this.stompDamage(damage, living);
        }
    }

    protected void stompDamage(float damage, LivingEntity living) {
        if (living.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), damage)) {
            Vec3 vec31 = new Vec3(this.m_20185_() - living.m_20185_(), 0.0, this.m_20189_() - living.m_20189_()).m_82541_().m_82490_(0.5);
            living.m_20334_(living.m_20184_().f_82479_ / 2.0 - vec31.f_82479_, living.m_20096_() ? org.joml.Math.min((double)0.4, (double)(living.m_20184_().f_82480_ / 2.0 + 0.5)) : living.m_20184_().f_82480_, living.m_20184_().f_82481_ / 2.0 - vec31.f_82481_);
        }
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        float[] ret = ForgeHooks.onLivingFall((LivingEntity)this, (float)pFallDistance, (float)pMultiplier);
        if (ret == null) {
            return false;
        }
        pFallDistance = ret[0];
        pMultiplier = ret[1];
        int i = this.m_5639_(pFallDistance, pMultiplier);
        if (i > 0) {
            this.m_5496_(this.m_196493_().f_196627_(), 1.0f, 1.0f);
            this.m_21229_();
            this.m_6469_(pSource, i);
            return true;
        }
        return false;
    }

    protected void m_7472_(@NotNull DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack stack = this.inventory.m_8020_(i);
                this.m_19983_(stack);
                this.inventory.m_6836_(i, ItemStack.f_41583_);
            }
        }
    }

    protected void waterAiStep(float waterHeight) {
        if (this.m_20069_()) {
            this.m_20242_(true);
            if (this.m_9236_().m_8055_(this.m_20097_()).m_60804_((BlockGetter)this.m_9236_(), this.m_20097_())) {
                this.m_20242_(false);
            }
            if (!this.m_20096_() && this.getSwimState() == 0) {
                if (this.f_19800_) {
                    this.setSwimState(2);
                } else {
                    this.setSwimState(1);
                }
            }
            if (this.f_19800_ && this.getSwimState() == 1 && !this.m_9236_().m_8055_(this.m_20097_()).m_60804_((BlockGetter)this.m_9236_(), this.m_20097_())) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.01, 0.0));
            } else if (this.getFluidTypeHeight((FluidType)ForgeMod.WATER_TYPE.get()) < (double)waterHeight && this.getSwimState() != 3) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
            }
        } else {
            this.m_20242_(false);
            if (this.getSwimState() != 3) {
                this.setSwimState(0);
            } else {
                if (this.m_9236_().f_46443_) {
                    return;
                }
                TickHelper.tickLater(this.m_9236_(), 40, () -> this.setSwimState(0));
            }
        }
    }

    protected float calculateScale() {
        int age = this.getAgeInDays();
        if (this.isMature()) {
            age -= 20;
        }
        return ErsUtils.calculateRenderSize(age);
    }

    public boolean checkEquipment(Item equipment) {
        for (int i = 1; i <= 3; ++i) {
            ItemStack itemStack = this.getInventory().m_8020_(i);
            if (itemStack.m_41619_() || !itemStack.m_150930_(equipment)) continue;
            return true;
        }
        return false;
    }
}

