/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.entity.creatures.dentisauruslongirostris;

import cn.aurorian.ers.client.animator.GeneralAnimator;
import cn.aurorian.ers.client.animator.SwampDragonAnimator;
import cn.aurorian.ers.entity.AttackType;
import cn.aurorian.ers.entity.ErsTamableVehicle;
import cn.aurorian.ers.entity.MobAttack;
import cn.aurorian.ers.entity.ai.goal.ErsTamableHurtByTargetGoal;
import cn.aurorian.ers.entity.ai.goal.ErsTamableOwnerHurtByTargetGoal;
import cn.aurorian.ers.entity.ai.goal.ErsTamableOwnerHurtTargetGoal;
import cn.aurorian.ers.entity.ai.goal.MobFollowOwnerGoal;
import cn.aurorian.ers.entity.ai.goal.MobWanderGoal;
import cn.aurorian.ers.entity.ai.movecontrol.AquaticMoveControl;
import cn.aurorian.ers.entity.ai.movecontrol.LimitedMoveControl;
import cn.aurorian.ers.entity.ai.navigation.MMGroundPathNavigation;
import cn.aurorian.ers.entity.creatures.dentisauruslongirostris.DentisaurusLongirostrisBodyControl;
import cn.aurorian.ers.entity.creatures.dentisauruslongirostris.ai.AttackFishGoal;
import cn.aurorian.ers.entity.creatures.dentisauruslongirostris.ai.DentisaurusLongirostrisLookAtPlayerGoal;
import cn.aurorian.ers.entity.creatures.dentisauruslongirostris.ai.DentisaurusLongirostrisMeleeAttackGoal;
import cn.aurorian.ers.entity.creatures.dentisauruslongirostris.ai.DentisaurusLongirostrisRandomSwimGoal;
import cn.aurorian.ers.entity.creatures.dentisauruslongirostris.invertory.DentisaurusLongirostrisMenuProvider;
import cn.aurorian.ers.init.ErsBlocks;
import cn.aurorian.ers.init.ErsItems;
import cn.aurorian.ers.init.ErsNetwork;
import cn.aurorian.ers.item.ErsMobLargeBucket;
import cn.aurorian.ers.packet.MobSyncDimPacket;
import cn.aurorian.ers.packet.MobTurnPacket;
import cn.aurorian.ers.packet.VehicleJumpPacket;
import cn.aurorian.ers.util.ErsUtils;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class DentisaurusLongirostrisEntity
extends ErsTamableVehicle<DentisaurusLongirostrisEntity>
implements ContainerListener,
HasCustomInventoryScreen,
Bucketable,
VariantHolder<Variant> {
    private final GeneralAnimator<DentisaurusLongirostrisEntity> animator = new SwampDragonAnimator(this);
    private static final float BASE_MOVE_SPEED = 0.25f;
    private static final float BASE_HEALTH = 150.0f;
    private static final float BASE_ATTACK_DAMAGE = 15.0f;
    public static final float BASE_BOUNDING_BOX_WIDTH = 3.5f;
    public static final float BASE_BOUNDING_BOX_HEIGHT = 2.75f;
    private static final float ACCELERATION = 0.08f;
    private boolean init = false;
    private static final EntityDataAccessor<Integer> NEXT_POOP_TIME = SynchedEntityData.m_135353_(DentisaurusLongirostrisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(DentisaurusLongirostrisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> NEXT_CHANGE_TIME = SynchedEntityData.m_135353_(DentisaurusLongirostrisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> ARMORED = SynchedEntityData.m_135353_(DentisaurusLongirostrisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> FILLED_FISH = SynchedEntityData.m_135353_(DentisaurusLongirostrisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public DentisaurusLongirostrisEntity(EntityType<? extends DentisaurusLongirostrisEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.createInventory();
        this.switchNavigator(true);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_274367_(2.0f);
        this.SWIM_COST = 0.1f;
        this.SPRINT_COST = 0.15f;
        this.RECOVER = 0.25f;
        this.WATER_ANIMAL = true;
        this.doAgeTick = true;
        this.doHunger = true;
    }

    protected void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new LimitedMoveControl((Mob)this);
            this.f_21344_ = new MMGroundPathNavigation((Mob)this, this.m_9236_());
        } else {
            this.f_21342_ = new AquaticMoveControl((PathfinderMob)this, 1.2f);
            this.f_21344_ = this.m_6037_(this.m_9236_());
        }
    }

    @Override
    public void executeDefaultAttackType() {
        if (!this.m_20069_() || this.m_20096_()) {
            if (this.isMoving()) {
                if (this.m_20142_()) {
                    this.startAttack(AttackType.SWAMP_DRAGON_ATTACK_RUN);
                } else {
                    this.startAttack(AttackType.SWAMP_DRAGON_ATTACK_WALK);
                }
            } else {
                this.startAttack(AttackType.SWAMP_DRAGON_ATTACK);
            }
        } else if (this.m_20142_()) {
            this.startAttack(AttackType.SWAMP_DRAGON_ATTACK_QUICK_SWIMMING);
        } else if (this.getWaterDepth() >= 3 || !this.m_20096_()) {
            this.startAttack(AttackType.SWAMP_DRAGON_ATTACK_SWIM_MID);
        } else {
            this.startAttack(AttackType.SWAMP_DRAGON_ATTACK_SWIM_SHALLOW);
        }
    }

    @Override
    public void executeSpecialAttackType() {
        if (this.m_20069_() && !this.m_20096_()) {
            this.startAttack(AttackType.SWAMP_DRAGON_SWIM_JUDGEMENT);
        } else {
            this.startAttack(AttackType.SWAMP_DRAGON_JUDGEMENT);
        }
    }

    @Override
    public void executeJudgementAttackType() {
        if (this.m_20069_() && !this.m_20096_()) {
            this.startAttack(AttackType.SWAMP_DRAGON_SWIM_SPECIAL_ATTACK);
        } else {
            this.startAttack(AttackType.SWAMP_DRAGON_SPECIAL_ATTACK);
        }
    }

    @Override
    public void executeTurnAttackType() {
        if (this.m_20142_()) {
            return;
        }
        if (this.m_20069_() && !this.m_20096_()) {
            this.startAttack(AttackType.SWAMP_DRAGON_ATTACK_SWIM_TURN);
        } else {
            this.startAttack(AttackType.SWAMP_DRAGON_ATTACK_TURN);
        }
    }

    public boolean m_6094_() {
        boolean mightBeSleeping = this.updateSkyBrightness() < 4 && this.m_6688_() == null && this.getCommand() == 0 && this.getAttackState().getType() == AttackType.EMPTY && this.m_5448_() == null && !this.m_20069_();
        return !this.m_20160_() && !mightBeSleeping && this.getCommand() != 1 && this.getAttackState().getType().canMove();
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new DentisaurusLongirostrisBodyControl(this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new DentisaurusLongirostrisMeleeAttackGoal(this, 2.0, false));
        this.f_21345_.m_25352_(2, (Goal)new MobFollowOwnerGoal(this, 2.2, 7.0f, 4.0f, 64.0f, false));
        this.f_21345_.m_25352_(5, (Goal)new DentisaurusLongirostrisRandomSwimGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new MobWanderGoal(this, 1.2){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && ((DentisaurusLongirostrisEntity)this.f_25725_).updateSkyBrightness() > 4;
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new DentisaurusLongirostrisLookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new ErsTamableHurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean m_8036_() {
                return super.m_8036_() && !DentisaurusLongirostrisEntity.this.m_21824_() && DentisaurusLongirostrisEntity.this.isMature();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new ErsTamableOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new ErsTamableOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(4, (Goal)new AttackFishGoal((Mob)this, AbstractFish.class, Boolean.TRUE));
    }

    public int m_5792_() {
        return 1;
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new AmphibiousPathNavigation((Mob)this, level){

            public boolean m_6342_(@NotNull BlockPos p_217799_) {
                return true;
            }
        };
    }

    @Override
    public void m_8119_() {
        boolean flag2;
        super.m_8119_();
        if (this.isClientSide()) {
            boolean bl = flag2 = this.m_20096_() && !this.isMoving() && this.getAttackState().getType() == AttackType.EMPTY;
            if (this.f_19797_ > (Integer)this.f_19804_.m_135370_(NEXT_CHANGE_TIME) && this.isMature()) {
                this.f_19804_.m_135381_(NEXT_CHANGE_TIME, (Object)(this.f_19797_ + RandomSource.m_216327_().m_216332_(200, 400)));
                int newState = RandomSource.m_216327_().m_188503_(4);
                if (newState != 0 && flag2) {
                    if (this.getCommand() == 1) {
                        if (newState == 1) {
                            this.triggerAnim("extra", "idle_yawn");
                        } else if (newState == 2) {
                            this.triggerAnim("extra", "idle_sit2");
                        } else {
                            this.triggerAnim("extra", "idle_sit3");
                        }
                    } else if (this.updateSkyBrightness() > 4) {
                        if (newState == 1) {
                            this.triggerAnim("extra", "idle2");
                        } else {
                            this.triggerAnim("extra", "idle3");
                        }
                    }
                }
            }
            if (this.isMoving()) {
                this.updateMount();
            }
        }
        if (!this.isClientSide()) {
            ErsNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this), (Object)new MobTurnPacket(this.m_19879_(), this.getRotDirection()));
            if (this.f_19797_ > (Integer)this.f_19804_.m_135370_(NEXT_CHANGE_TIME) && this.isMature()) {
                boolean bl = flag2 = this.m_20096_() && !this.isMoving() && this.getAttackState().getType() == AttackType.EMPTY && this.m_5448_() == null;
                if (flag2 && this.getCommand() == 0 && this.m_20069_() && this.m_20096_() && this.getWaterDepth() < 3) {
                    if (this.m_9236_().f_46441_.m_188501_() < 0.25f) {
                        this.f_21344_.m_26573_();
                        this.f_19804_.m_135381_(NEXT_CHANGE_TIME, (Object)(this.f_19797_ + RandomSource.m_216327_().m_216332_(1200, 1600)));
                        this.startAttack(AttackType.SWAMP_DRAGON_CATCH_FISH_SMALL);
                    } else if (this.m_9236_().f_46441_.m_188501_() < 0.5f) {
                        this.f_21344_.m_26573_();
                        this.f_19804_.m_135381_(NEXT_CHANGE_TIME, (Object)(this.f_19797_ + RandomSource.m_216327_().m_216332_(1200, 1600)));
                        this.startAttack(AttackType.SWAMP_DRAGON_CATCH_FISH_MIDDLE);
                    }
                }
            }
            if (this.f_19797_ % 20 == 0) {
                if (this.f_19797_ % 400 == 0) {
                    this.m_5634_(1.0f);
                }
                float hunger = this.getHunger();
                if (this.f_19797_ % 100 == 0) {
                    if (this.isElite()) {
                        hunger -= 0.1f;
                    }
                    if (this.isMature()) {
                        hunger -= 0.1f;
                    }
                    this.setHunger(hunger - 0.1f);
                }
                if ((hunger < 50.0f || this.m_21223_() < this.m_21233_()) && this.f_19797_ % 200 == 0) {
                    for (int slot = 5; slot <= 7; ++slot) {
                        if (this.getInventory().m_8020_(slot).m_41619_()) continue;
                        this.getInventory().m_8020_(slot).m_41774_(1);
                        this.feed(3);
                        this.m_5634_(5.0f);
                        break;
                    }
                }
                if (this.getAgeInTicks() % 24000 == 0 || !this.init) {
                    this.updateFromAgeServer();
                    ErsNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new MobSyncDimPacket(this.m_19879_()));
                    this.init = true;
                }
                int filledSlots = 0;
                for (int slot = 1; slot <= 3; ++slot) {
                    if (this.getInventory().m_8020_(slot).m_41619_()) continue;
                    ++filledSlots;
                }
                this.setFilledFish(filledSlots);
                int nextPoopTime = this.getNextPoopTime();
                if (nextPoopTime > 0) {
                    this.setNextPoopTime(nextPoopTime - 20);
                } else {
                    this.generateFeces();
                    this.setNextPoopTime(10000 + RandomSource.m_216327_().m_188503_(14000));
                }
            }
            for (int i = 1; i <= 3; ++i) {
                ItemStack itemStack = this.inventory.m_8020_(i);
                if (itemStack.m_41619_() || !itemStack.m_150930_(Items.f_42354_) || this.m_6688_() == null) continue;
                this.turtleHelmetTick();
            }
            if (this.m_20142_()) {
                this.stompEffect(3.0f, 3.0f, this.checkEquipment((Item)ErsItems.SCRATCHING_BOARD.get()) ? 4.0f : 2.0f);
            }
        }
    }

    private void turtleHelmetTick() {
        if (!this.m_6688_().m_204029_(FluidTags.f_13131_)) {
            this.m_6688_().m_7292_(new MobEffectInstance(MobEffects.f_19608_, 200, 0, false, false, true));
        }
    }

    @Override
    public void updateFromAgeServer() {
        if (this.getAgeInDays() >= 20 && !this.isMature()) {
            this.setMature(true);
        }
        if (this.getAgeInDays() >= 38 && this.canBeElite()) {
            this.setElite(true);
        }
        float scale = this.calculateScale();
        if (this.isMature()) {
            this.setRenderSize(scale);
        } else {
            this.setRenderSize(ErsUtils.calculateBabyRenderSize(this.getAgeInDays()));
        }
        this.m_6210_();
        if (!this.isElite()) {
            scale *= 0.7f;
        }
        if (!this.isMature()) {
            scale *= 0.4f;
        }
        this.m_21051_(Attributes.f_22276_).m_22100_((double)(150.0f * scale));
        this.m_21051_(Attributes.f_22281_).m_22100_((double)(15.0f * scale));
        if (!this.isMature()) {
            scale *= 2.1f;
        } else if (!this.isElite()) {
            scale *= 1.3f;
        }
        this.m_21051_(Attributes.f_22279_).m_22100_((double)(0.25f * scale));
        this.m_5757_((Container)this.getInventory());
        this.getAnimatableInstanceCache().getManagerForId((long)this.m_19879_()).clearSnapshotCache();
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        int age = this.getAgeInDays();
        if (this.isElite()) {
            age -= 18;
        }
        if (this.isMature()) {
            age -= 20;
        }
        float scale = ErsUtils.calculateRenderSize(age);
        if (!this.isMature()) {
            scale *= 0.4f;
        }
        return this.m_6095_().m_20680_().m_20388_(scale);
    }

    public boolean m_6898_(@NotNull ItemStack itemStack) {
        return itemStack.m_204117_(ItemTags.f_13156_);
    }

    public void setFilledFish(int count) {
        this.f_19804_.m_135381_(FILLED_FISH, (Object)count);
    }

    public int getFilledFish() {
        return (Integer)this.f_19804_.m_135370_(FILLED_FISH);
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand pHand) {
        if (player.m_21205_().m_41720_() == ErsItems.LARGE_WATER_BUCKET.get() && this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            return ErsMobLargeBucket.bucketMobPickup(player, pHand, this).orElse(InteractionResult.PASS);
        }
        if (this.isMature() && this.m_21824_() && !this.m_20160_() && this.m_21830_((LivingEntity)player) && !player.m_6047_() && !player.m_21205_().m_204117_(ItemTags.f_13156_)) {
            player.m_146922_(this.m_146908_());
            player.m_146926_(this.m_146909_());
            player.m_20329_((Entity)this);
        }
        if (pHand == InteractionHand.MAIN_HAND && player.m_6047_() && this.m_21824_() && this.m_21830_((LivingEntity)player) && !player.m_21205_().m_204117_(ItemTags.f_13156_)) {
            this.f_21344_.m_26573_();
            if (!this.m_9236_().f_46443_) {
                this.setCommand(this.getCommand() + 1);
                if (this.getCommand() > 2) {
                    this.setCommand(0);
                }
            }
            String commandText = "stand";
            if (this.getCommand() == 1) {
                commandText = "sit";
                this.m_6710_(null);
            } else if (this.getCommand() == 2) {
                commandText = "follow";
                this.m_6710_(null);
            }
            player.m_5661_((Component)Component.m_237115_((String)("ers.command." + commandText)), true);
        }
        if (!this.isClientSide() && (player.m_21205_().m_204117_(ItemTags.f_13156_) || player.m_21205_().m_150930_((Item)ErsItems.PISCIVORES_FEED.get()))) {
            if (!this.m_21824_() && this.getAgeInDays() < 1 && player.m_21205_().m_150930_((Item)ErsItems.PISCIVORES_FEED.get())) {
                if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                    this.m_21828_(player);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            } else if (this.m_21824_()) {
                this.feed(player.m_21205_().m_204117_(ItemTags.f_13156_) ? 1 : 3);
                this.m_5634_(player.m_21205_().m_204117_(ItemTags.f_13156_) ? 3.0f : 5.0f);
                player.m_21205_().m_41774_(1);
            }
        }
        return super.m_6071_(player, pHand);
    }

    private void generateFeces() {
        int offsetZ;
        double yRot;
        int offsetX;
        BlockPos targetPos;
        if (this.m_9236_().f_46443_) {
            return;
        }
        List<BlockState> fecesBlocks = List.of(((Block)ErsBlocks.BONE_FECES.get()).m_49966_(), ((Block)ErsBlocks.SMALL_FECES.get()).m_49966_(), ((Block)ErsBlocks.LARGE_FECES.get()).m_49966_(), ((Block)ErsBlocks.GLASSES_FECES.get()).m_49966_(), ((Block)ErsBlocks.TEL_FECES.get()).m_49966_());
        BlockPos pos = this.m_20183_();
        Level level = this.m_9236_();
        if (level.m_8055_(targetPos = pos.m_7918_(offsetX = (int)(-org.joml.Math.sin((double)(yRot = (double)org.joml.Math.toRadians((float)this.m_146908_()))) * 1.5), 0, offsetZ = (int)(org.joml.Math.cos((double)yRot) * 1.5))).m_60795_() && level.m_8055_(targetPos.m_7495_()).m_60804_((BlockGetter)level, targetPos.m_7495_())) {
            BlockState state = fecesBlocks.get(this.m_9236_().f_46441_.m_188503_(fecesBlocks.size()));
            if (state.m_60713_((Block)ErsBlocks.TEL_FECES.get()) && this.m_9236_().f_46441_.m_188501_() < 0.1f) {
                return;
            }
            level.m_7731_(targetPos, state, 3);
            level.m_6263_(null, (double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 0.5, (double)targetPos.m_123343_() + 0.5, SoundEvents.f_12392_, SoundSource.BLOCKS, 0.5f, 1.0f);
        }
    }

    private void placeNest() {
        int offsetZ;
        double yRot;
        int offsetX;
        BlockPos targetPos;
        if (this.m_9236_().f_46443_) {
            return;
        }
        BlockState state = ((Block)ErsBlocks.SWAMP_DRAGON_NEST.get()).m_49966_();
        BlockPos pos = this.m_20183_();
        Level level = this.m_9236_();
        if (level.m_8055_(targetPos = pos.m_7918_(offsetX = (int)(-org.joml.Math.sin((double)(yRot = (double)org.joml.Math.toRadians((float)this.m_146908_()))) * 1.5), 0, offsetZ = (int)(org.joml.Math.cos((double)yRot) * 1.5))).m_60795_() && level.m_8055_(targetPos.m_7495_()).m_60804_((BlockGetter)level, targetPos.m_7495_())) {
            level.m_7731_(targetPos, state, 3);
        }
    }

    public void m_6858_(boolean pSprinting) {
        this.m_20115_(3, pSprinting);
    }

    @NotNull
    protected Vec3 m_274312_(@NotNull Player pPlayer, @NotNull Vec3 pTravelVector) {
        if (this.rideSpeed != 0.0f || pPlayer.f_20899_) {
            this.updateMount();
            if (this.getCommand() == 1) {
                this.setCommand(0);
            }
        }
        if (this.isInFluidType()) {
            if (this.m_20142_()) {
                this.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22100_(12.0);
            } else {
                this.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22100_(8.0);
            }
            float y = 0.0f;
            if (pPlayer.f_20899_ && this.getSwimState() != 1) {
                y = 0.4f;
                if (!this.f_19800_ && this.getSwimState() != 3) {
                    this.setSwimState(1);
                }
            } else if (((Boolean)this.f_19804_.m_135370_(IS_DIVING)).booleanValue() && this.getSwimState() != 1) {
                y = -0.4f;
            }
            if ((double)this.rideSpeed > 0.1 && this.getSwimState() == 1 && this.f_19862_ && !this.m_20096_()) {
                y = 0.8f;
            }
            if (!this.getAttackState().getType().canMove()) {
                y = 0.0f;
            }
            return new Vec3(0.0, (double)y, (double)this.rideSpeed);
        }
        return new Vec3(0.0, 0.0, (double)this.rideSpeed);
    }

    protected float m_245547_(@NotNull Player pPlayer) {
        return this.rideSpeed + 0.2f;
    }

    protected void m_274498_(@NotNull Player driver, @NotNull Vec3 move) {
        float pitch = this.getAnimator().getModelPitch(this.getAnimator().getPartialTick());
        this.tickStableHead();
        if (this.isInFluidType() && pitch > 20.0f && this.m_20142_() && this.getWaterDepth() >= 4) {
            this.m_6135_();
        }
        if (this.getAttackState().getType().canMove() && this.isSaddled()) {
            if ((!this.getRotDirection().isLargeTurn() || this.m_20142_()) && (org.joml.Math.abs((float)driver.f_20902_) > 0.0f || org.joml.Math.abs((float)driver.f_20900_) > 0.0f)) {
                float baseSpeed = (float)this.m_21051_(Attributes.f_22279_).m_22135_();
                this.rideSpeed = Mth.m_14121_((float)this.rideSpeed, (float)(this.m_20142_() ? baseSpeed * 2.2f : baseSpeed), (float)0.08f);
            } else {
                this.rideSpeed = Mth.m_14121_((float)this.rideSpeed, (float)0.0f, (float)0.16f);
            }
        } else {
            this.rideSpeed = Mth.m_14121_((float)this.rideSpeed, (float)0.0f, (float)0.24f);
        }
    }

    protected void m_6135_() {
        double jumpVelocity = 0.2;
        this.m_20256_(this.m_20184_().m_82520_(0.0, jumpVelocity, 0.0));
        this.f_19812_ = true;
        ForgeHooks.onLivingJump((LivingEntity)this);
        if (this.m_9236_().f_46443_) {
            ErsNetwork.INSTANCE.sendToServer((Object)new VehicleJumpPacket(this.m_19879_()));
        }
    }

    public int updateSkyBrightness() {
        return ErsUtils.updateSkyBrightness(this.m_9236_());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController main = new AnimationController((GeoAnimatable)this, "main", 5, state -> {
            RawAnimation builder = RawAnimation.begin();
            boolean flag1 = false;
            for (int y = 1; y <= 8; ++y) {
                BlockPos checkPos = new BlockPos((Vec3i)this.m_20183_().m_6625_(y));
                BlockState blockstate = this.m_9236_().m_8055_(checkPos);
                if (blockstate.m_60795_()) {
                    continue;
                }
                flag1 = DentisaurusLongirostrisEntity.isWaterBlock(this.m_9236_(), this.m_20183_().m_6625_(y));
                break;
            }
            if (this.isFalling() && !flag1) {
                builder.thenLoop("animation.fall");
            }
            if (this.m_20069_() && !this.m_20096_()) {
                if (this.isMoving() && this.m_20142_()) {
                    builder.thenLoop("animation.quickly_swimming");
                    return state.setAndContinue(builder);
                }
                if (this.isMoving() && !this.m_20142_() && (this.getWaterDepth() <= 3 || this.m_20096_() || !this.isMature())) {
                    builder.thenLoop("animation.swim_shallow");
                    return state.setAndContinue(builder);
                }
                if (this.isMoving() && !this.m_20142_()) {
                    builder.thenLoop("animation.swim_mid");
                    return state.setAndContinue(builder);
                }
                if (!this.getRotDirection().isNone() && this.isMature()) {
                    if (this.getRotDirection().isLeft()) {
                        builder.thenLoop("animation.+w_left");
                        return state.setAndContinue(builder);
                    }
                    builder.thenLoop("animation.-w_right");
                    return state.setAndContinue(builder);
                }
                LivingEntity patt27646$temp = this.m_6688_();
                if (patt27646$temp instanceof Player) {
                    Player player = (Player)patt27646$temp;
                    Vec3 vec3 = new Vec3(0.0, 0.0, 0.0);
                    if (this.m_274312_((Player)player, (Vec3)vec3).f_82480_ < 0.0) {
                        builder.thenLoop("animation.swim_down");
                        return state.setAndContinue(builder);
                    }
                }
                if (this.m_6688_() != null && this.m_6688_().f_20899_) {
                    builder.thenLoop("animation.swim_up");
                    return state.setAndContinue(builder);
                }
                builder.thenLoop("animation.idle_shallow");
                return state.setAndContinue(builder);
            }
            if (!this.m_20096_() && flag1) {
                builder.thenLoop("animation.swim_shallow");
            }
            if (this.isMoving() && this.m_20142_()) {
                builder.thenLoop("animation.run");
                return state.setAndContinue(builder);
            }
            if (this.isMoving()) {
                builder.thenLoop("animation.walk");
                return state.setAndContinue(builder);
            }
            if (!this.getRotDirection().isNone()) {
                if (this.getRotDirection().isLeft()) {
                    if (this.m_20160_()) {
                        builder.thenLoop("animation.+left");
                        return state.setAndContinue(builder);
                    }
                    builder.thenLoop("animation.+left_ai");
                    return state.setAndContinue(builder);
                }
                if (this.m_20160_()) {
                    builder.thenLoop("animation.-right");
                    return state.setAndContinue(builder);
                }
                builder.thenLoop("animation.-right_ai");
                return state.setAndContinue(builder);
            }
            if (this.getCommand() == 1) {
                builder.thenLoop("animation.idle_sit");
                return state.setAndContinue(builder);
            }
            if (this.updateSkyBrightness() < 4 && this.m_6688_() == null && this.getCommand() == 0 && this.getAttackState().getType() == AttackType.EMPTY && this.m_5448_() == null && !this.m_20069_()) {
                if (this.isMature() && this.m_9236_().m_45524_(this.m_20183_(), 0) > 8) {
                    builder.thenLoop("animation.sleep-sunlight");
                    return state.setAndContinue(builder);
                }
                builder.thenLoop("animation.sleep");
                return state.setAndContinue(builder);
            }
            builder.thenLoop("animation.idle");
            return state.setAndContinue(builder);
        });
        AnimationController attack = new AnimationController((GeoAnimatable)this, "attack", 5, state -> PlayState.STOP).triggerableAnim("attack", RawAnimation.begin().thenPlay("animation.attack-idle")).triggerableAnim("attack-walk", RawAnimation.begin().thenPlay("animation.attack-walk")).triggerableAnim("attack-run", RawAnimation.begin().thenPlay("animation.attack-run")).triggerableAnim("attack_swim_shallow", RawAnimation.begin().thenPlay("animation.attack_swim_shallow")).triggerableAnim("attack_swim_mid", RawAnimation.begin().thenPlay("animation.attack_swim_mid")).triggerableAnim("attack_quickly_swimming", RawAnimation.begin().thenPlay("animation.attack_quickly_swimming")).triggerableAnim("attack_turn", RawAnimation.begin().thenPlay("animation.attack_turn")).triggerableAnim("attack_swim_turn", RawAnimation.begin().thenPlay("animation.attack_swim_turn")).triggerableAnim("attack2-small", RawAnimation.begin().thenPlay("animation.attack2-small")).triggerableAnim("attack2-middle", RawAnimation.begin().thenPlay("animation.attack2-middle")).triggerableAnim("attack2-miss", RawAnimation.begin().thenPlay("animation.attack2-miss")).triggerableAnim("attack3", RawAnimation.begin().thenPlay("animation.attack3")).triggerableAnim("swim_attack", RawAnimation.begin().thenPlay("animation.swim_attack")).triggerableAnim("swim_attack-miss", RawAnimation.begin().thenPlay("animation.swim_attack-miss")).triggerableAnim("swim_attack2", RawAnimation.begin().thenPlay("animation.swim_attack2")).triggerableAnim("catch_fish-small", RawAnimation.begin().thenPlay("animation.catch_fish-small")).triggerableAnim("catch_fish-middle", RawAnimation.begin().thenPlay("animation.catch_fish-middle")).triggerableAnim("knockdown_left", RawAnimation.begin().thenPlay("animation.knockdown_left")).triggerableAnim("knockdown_right", RawAnimation.begin().thenPlay("animation.knockdown_right"));
        AnimationController extra = new AnimationController((GeoAnimatable)this, "extra", 0, state -> PlayState.STOP).triggerableAnim("idle2", RawAnimation.begin().thenPlay("animation.idle2")).triggerableAnim("idle3", RawAnimation.begin().thenPlay("animation.idle3")).triggerableAnim("idle_sit2", RawAnimation.begin().thenPlay("animation.idle_sit2")).triggerableAnim("idle_sit3", RawAnimation.begin().thenPlay("animation.idle_sit3")).triggerableAnim("idle_yawn", RawAnimation.begin().thenPlay("animation.idle_yawn"));
        controllers.add(new AnimationController[]{main, attack, extra});
    }

    public int getWaterDepth() {
        BlockPos checkPos;
        if (!this.m_20069_()) {
            return 0;
        }
        Level level = this.m_9236_();
        BlockPos entityPos = this.m_20183_();
        double entityYInBlock = this.m_20186_() - org.joml.Math.floor((double)this.m_20186_());
        if (entityYInBlock > 0.5 && !DentisaurusLongirostrisEntity.isWaterBlock(level, entityPos)) {
            entityPos = entityPos.m_7494_();
        }
        int depth = 0;
        int maxCheckHeight = 12;
        for (int i = 0; i < maxCheckHeight && (checkPos = entityPos.m_6630_(i)).m_123342_() <= level.m_151558_() && checkPos.m_123342_() >= level.m_141937_() && DentisaurusLongirostrisEntity.isWaterBlock(level, checkPos); ++i) {
            ++depth;
        }
        return depth;
    }

    public void tickStableHead() {
        float pitch = this.getAnimator().getModelPitch(this.getAnimator().getPartialTick());
        if (this.m_20069_()) {
            this.setStableHead(pitch < 20.0f);
        } else if (this.m_20096_()) {
            this.setStableHead(true);
        } else if (this.isFalling()) {
            this.setStableHead(false);
        }
    }

    protected boolean m_7310_(@NotNull Entity pPassenger) {
        return this.m_20197_().size() <= 3;
    }

    @Override
    protected void m_7472_(@NotNull DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        if (this.isMature() && this.f_19796_.m_188501_() < 0.15f) {
            ItemStack stack = new ItemStack((ItemLike)ErsItems.SWAMP_DRAGON_EGG.get());
            this.m_19983_(stack);
        }
    }

    public void m_5757_(@NotNull Container pContainer) {
        this.setSaddled(!this.inventory.m_8020_(0).m_41619_());
        this.f_19804_.m_135381_(ARMORED, (Object)(!this.getInventory().m_8020_(4).m_41619_() ? 1 : 0));
        boolean healthBoost = false;
        boolean armorBoost = false;
        for (int i = 1; i <= 3; ++i) {
            ItemStack itemStack = this.inventory.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            if (itemStack.m_150930_(Items.f_42437_)) {
                healthBoost = true;
            }
            if (!itemStack.m_150930_(Items.f_42740_)) continue;
            armorBoost = true;
        }
        float scale = this.calculateScale();
        if (!this.isElite()) {
            scale *= 0.7f;
        }
        if (!this.isMature()) {
            scale *= 0.4f;
        }
        if (healthBoost) {
            this.m_21051_(Attributes.f_22276_).m_22100_((double)(150.0f * scale + 20.0f));
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_((double)(150.0f * scale));
        }
        if (armorBoost) {
            this.m_21051_(Attributes.f_22284_).m_22100_(16.0);
        } else {
            this.m_21051_(Attributes.f_22284_).m_22100_(12.0);
        }
    }

    public void m_213583_(@NotNull Player player) {
        if (!this.isClientSide()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new DentisaurusLongirostrisMenuProvider(this), buf -> buf.writeInt(this.m_19879_()));
        }
    }

    @Override
    public void startAttack(AttackType type) {
        super.startAttack(type);
        if (type != AttackType.SWAMP_DRAGON_CATCH_FISH_SMALL && type != AttackType.SWAMP_DRAGON_CATCH_FISH_MIDDLE && this.getCommand() == 1) {
            this.setCommand(0);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(NEXT_POOP_TIME, (Object)RandomSource.m_216327_().m_188503_(24000));
        this.f_19804_.m_135372_(NEXT_CHANGE_TIME, (Object)(this.f_19797_ + this.f_19796_.m_216332_(200, 400)));
        this.f_19804_.m_135372_(ARMORED, (Object)false);
        this.f_19804_.m_135372_(FILLED_FISH, (Object)0);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Command", this.getCommand());
        compound.m_128379_("Armored", ((Boolean)this.f_19804_.m_135370_(ARMORED)).booleanValue());
        compound.m_128405_("FilledFish", this.getFilledFish());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setCommand(compound.m_128451_("Command"));
        this.f_19804_.m_135381_(ARMORED, (Object)compound.m_128471_("Armored"));
        this.setFilledFish(compound.m_128451_("FilledFish"));
    }

    @Override
    public void updateMount() {
        this.m_20088_().m_135381_(NEXT_CHANGE_TIME, (Object)(this.f_19797_ + RandomSource.m_216327_().m_216332_(200, 400)));
        this.getAnimatableInstanceCache().getManagerForId((long)this.m_19879_()).stopTriggeredAnimation("idle2");
        this.getAnimatableInstanceCache().getManagerForId((long)this.m_19879_()).stopTriggeredAnimation("idle3");
        this.getAnimatableInstanceCache().getManagerForId((long)this.m_19879_()).stopTriggeredAnimation("idle_yawn");
        this.getAnimatableInstanceCache().getManagerForId((long)this.m_19879_()).stopTriggeredAnimation("idle_sit2");
        this.getAnimatableInstanceCache().getManagerForId((long)this.m_19879_()).stopTriggeredAnimation("idle_sit3");
        this.getAnimatableInstanceCache().getManagerForId((long)this.m_19879_()).stopTriggeredAnimation("catch_fish-small");
        this.getAnimatableInstanceCache().getManagerForId((long)this.m_19879_()).stopTriggeredAnimation("catch_fish-middle");
        if (this.getAttackState().isEmpty()) {
            this.getAnimatableInstanceCache().getManagerForId((long)this.m_19879_()).stopTriggeredAnimation("knockdown_left");
            this.getAnimatableInstanceCache().getManagerForId((long)this.m_19879_()).stopTriggeredAnimation("knockdown_right");
        }
        if (this.getAttackState().getType() == AttackType.SWAMP_DRAGON_CATCH_FISH_SMALL || this.getAttackState().getType() == AttackType.SWAMP_DRAGON_CATCH_FISH_MIDDLE) {
            this.getAttackState().isSyncInstance = true;
            this.setAttackState(new MobAttack(AttackType.EMPTY, this));
        }
    }

    public boolean m_6040_() {
        return true;
    }

    @Override
    public boolean m_142535_(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return false;
    }

    public boolean m_6914_(@NotNull LevelReader pLevel) {
        return pLevel.m_45784_((Entity)this);
    }

    @Override
    public GeneralAnimator<DentisaurusLongirostrisEntity> getAnimator() {
        return this.animator;
    }

    @Override
    public int getInventorySize() {
        return 8;
    }

    public int getNextPoopTime() {
        return (Integer)this.f_19804_.m_135370_(NEXT_POOP_TIME);
    }

    public void setNextPoopTime(int time) {
        this.f_19804_.m_135381_(NEXT_POOP_TIME, (Object)time);
    }

    @Override
    public boolean isSaddleable() {
        return super.isSaddleable() && this.isMature();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 105.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 10.5).m_22268_(Attributes.f_22284_, 12.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 8.0);
    }

    @Override
    public void equipSaddle() {
        this.inventory.m_6836_(0, new ItemStack((ItemLike)ErsItems.SWAMP_DRAGON_SADDLE.get()));
        this.setSaddled(true);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12034_, this.m_5720_(), 1.0f, 1.0f);
    }

    public boolean isClientSide() {
        return this.m_9236_().f_46443_;
    }

    private static boolean isWaterBlock(Level level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        return blockState.m_60819_().m_205070_(FluidTags.f_13131_) && !blockState.m_60819_().m_76178_();
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean pFromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)pFromBucket);
    }

    public void m_6872_(ItemStack pStack) {
        this.m_7380_(pStack.m_41784_());
    }

    public void m_142278_(@NotNull CompoundTag pTag) {
        this.m_7378_(pTag);
    }

    @NotNull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11781_;
    }

    @NotNull
    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)ErsItems.DENTISARUS_LONGIROSTRIS_LARGE_BUCKET.get());
    }

    public boolean isFalling() {
        return !this.m_20096_() && !this.m_20069_() && !this.m_20077_() && this.m_20184_().f_82480_ < -0.8;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.m_20069_() && !(this.f_21342_ instanceof AquaticMoveControl)) {
            this.switchNavigator(false);
        } else if (!this.m_20069_() && this.f_21342_ instanceof AquaticMoveControl) {
            this.switchNavigator(true);
        }
        this.breakBlock();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6688_() != null) {
            float i = 1.7f;
            if (this.getAgeInDays() > 50) {
                i = 1.8f;
            }
            this.waterAiStep(i);
        } else {
            this.m_20242_(false);
        }
    }

    @NotNull
    public Vec3 m_20994_(double pGravity, boolean pIsFalling, @NotNull Vec3 pDeltaMovement) {
        if (!this.m_20068_()) {
            double d0 = pIsFalling && Math.abs(pDeltaMovement.f_82480_ - 0.005) >= 0.003 && Math.abs(pDeltaMovement.f_82480_ - pGravity / 16.0) < 0.003 ? -0.003 : pDeltaMovement.f_82480_ - pGravity / 16.0;
            return new Vec3(pDeltaMovement.f_82479_, d0, pDeltaMovement.f_82481_);
        }
        return pDeltaMovement;
    }

    public boolean m_6673_(DamageSource source) {
        if (source.m_269415_().f_268677_().equals("sweetBerryBush") || source.m_7639_() instanceof Pufferfish || source.m_269415_().f_268677_().equals("cactus")) {
            return true;
        }
        return super.m_6673_(source);
    }

    public void m_20321_(boolean pDownwards) {
    }

    public void m_7601_(@NotNull BlockState pState, @NotNull Vec3 pMotionMultiplier) {
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason == MobSpawnType.BUCKET) {
            return pSpawnData;
        }
        RandomSource $$6 = pLevel.m_213780_();
        if (pSpawnData == null) {
            pSpawnData = $$6.m_188501_() < 0.1f ? new SwampDragonGroupData(Variant.getRareSpawnVariant($$6)) : new SwampDragonGroupData(Variant.getCommonSpawnVariant($$6), Variant.getCommonSpawnVariant($$6), Variant.getCommonSpawnVariant($$6), Variant.getCommonSpawnVariant($$6));
        }
        this.setVariant(((SwampDragonGroupData)((Object)pSpawnData)).getVariant($$6));
        if (this.f_19796_.m_188501_() < 0.25f) {
            this.setCanBeElite(true);
        }
        this.setAgeInDays(this.f_19796_.m_216332_(15, 50));
        this.updateFromAgeServer();
        this.m_21153_(this.m_21233_());
        if (this.isMature() && this.f_19796_.m_188501_() < 0.15f) {
            this.placeNest();
        }
        if (this.f_19796_.m_188501_() < 0.004f) {
            String[] customNameList = new String[]{"Ladon", "Forsaken", "Acheron_Pollux", "profound"};
            this.m_6593_((Component)Component.m_237113_((String)customNameList[this.f_19796_.m_188503_(customNameList.length)]));
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @NotNull
    public Variant getVariant() {
        return Variant.byId(this.getVariantId());
    }

    public void setVariant(Variant pVariant) {
        this.setVariantId(pVariant.getId());
    }

    public static class SwampDragonGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final Variant[] types;

        public SwampDragonGroupData(Variant ... pTypes) {
            super(false);
            this.types = pTypes;
        }

        public Variant getVariant(RandomSource pRandom) {
            return this.types[pRandom.m_188503_(this.types.length)];
        }
    }

    public static enum Variant implements StringRepresentable
    {
        ORIGINAL(0, "original", true),
        ORIGINAL_LIGHT(1, "original_light", true),
        ORIGINAL_DEEP(2, "original_deep", true),
        LACK_YELLOW(3, "lack_yellow", false),
        LACK_YELLOW_LIGHT(4, "lack_yellow_light", false),
        LACK_YELLOW_DEEP(5, "lack_yellow_deep", false),
        BLACK(6, "black", false),
        BLACK_LIGHT(7, "black_light", false),
        BLACK_DEEP(8, "black_deep", false),
        WHITE(9, "white", false),
        WHITE_LIGHT(10, "white_light", false),
        WHITE_DEEP(11, "white_deep", false);

        private static final IntFunction<Variant> BY_ID;
        public static final Codec<Variant> CODEC;
        private final int id;
        private final String name;
        private final boolean common;

        private Variant(int pId, String pName, boolean pCommon) {
            this.id = pId;
            this.name = pName;
            this.common = pCommon;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public static Variant byId(int pId) {
            return BY_ID.apply(pId);
        }

        public static Variant getCommonSpawnVariant(RandomSource pRandom) {
            return Variant.getSpawnVariant(pRandom, true);
        }

        public static Variant getRareSpawnVariant(RandomSource pRandom) {
            return Variant.getSpawnVariant(pRandom, false);
        }

        private static Variant getSpawnVariant(RandomSource pRandom, boolean pCommon) {
            Variant[] $$2 = (Variant[])Arrays.stream(Variant.values()).filter(p_149252_ -> p_149252_.common == pCommon).toArray(Variant[]::new);
            return (Variant)((Object)Util.m_214670_((Object[])$$2, (RandomSource)pRandom));
        }

        static {
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            CODEC = StringRepresentable.m_216439_(Variant::values);
        }
    }
}

