/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.entity.creatures.tachypleusgladius;

import cn.aurorian.ers.client.animator.GeneralAnimator;
import cn.aurorian.ers.client.animator.KnifeHorseshoeCrabAnimator;
import cn.aurorian.ers.entity.ErsEntity;
import cn.aurorian.ers.entity.GeneralBodyControl;
import cn.aurorian.ers.entity.creatures.tachypleusgladius.ai.CrabAmbushGoal;
import cn.aurorian.ers.entity.creatures.tachypleusgladius.ai.CrabAttackGoal;
import cn.aurorian.ers.init.ErsItems;
import cn.aurorian.ers.util.ErsUtils;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TachypleusGladiusEntity
extends WaterAnimal
implements GeoEntity,
Bucketable,
ErsEntity<TachypleusGladiusEntity> {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final KnifeHorseshoeCrabAnimator animator = new KnifeHorseshoeCrabAnimator(this);
    private static final EntityDataAccessor<Boolean> IS_WAITING = SynchedEntityData.m_135353_(TachypleusGladiusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COOLDOWN = SynchedEntityData.m_135353_(TachypleusGladiusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(TachypleusGladiusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public TachypleusGladiusEntity(EntityType<? extends WaterAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public boolean isWaiting() {
        return (Boolean)this.f_19804_.m_135370_(IS_WAITING);
    }

    public void setWaiting(boolean waiting) {
        this.f_19804_.m_135381_(IS_WAITING, (Object)waiting);
    }

    public int getCooldown() {
        return (Integer)this.f_19804_.m_135370_(COOLDOWN);
    }

    public void setCooldown(int cooldown) {
        this.f_19804_.m_135381_(COOLDOWN, (Object)cooldown);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_WAITING, (Object)false);
        this.f_19804_.m_135372_(COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        AnimationController main = new AnimationController((GeoAnimatable)this, "main", 4, state -> {
            RawAnimation builder = RawAnimation.begin();
            if (ErsUtils.isMoving((Mob)this)) {
                builder.thenLoop("animation.walk");
            } else if (state.animationTick >= 60.0 && this.isWaiting()) {
                builder.thenLoop("animation.wait");
            } else {
                builder.thenLoop("animation.idle");
            }
            return state.setAndContinue(builder);
        });
        AnimationController extra = new AnimationController((GeoAnimatable)this, "extra", 4, state -> PlayState.STOP).triggerableAnim("attack", RawAnimation.begin().thenPlay("animation.attack")).triggerableAnim("ambush", RawAnimation.begin().thenPlay("animation.ambush")).triggerableAnim("dodge", RawAnimation.begin().thenPlay("animation.dodge"));
        controllerRegistrar.add(new AnimationController[]{main, extra});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22277_, 6.0);
    }

    public boolean m_6094_() {
        return !this.isWaiting();
    }

    public void m_147240_(double pStrength, double pX, double pZ) {
        if (this.isWaiting()) {
            return;
        }
        super.m_147240_(pStrength, pX, pZ);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new CrabAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.0){

            public boolean m_8036_() {
                return super.m_8036_() && !TachypleusGladiusEntity.this.isWaiting();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40){

            public boolean m_8036_() {
                return super.m_8036_() && !TachypleusGladiusEntity.this.isWaiting();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new CrabAmbushGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Mob>((Mob)this, Mob.class, true, entity -> !(entity instanceof TachypleusGladiusEntity)){

            public boolean m_8036_() {
                return super.m_8036_() && TachypleusGladiusEntity.this.isWaiting();
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean m_8036_() {
                return super.m_8036_() && TachypleusGladiusEntity.this.isWaiting();
            }
        });
    }

    public void m_8119_() {
        super.m_8119_();
        this.animator.tick();
        if (this.getCooldown() > 0) {
            this.setCooldown(this.getCooldown() - 1);
        }
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new GeneralBodyControl((Mob)this, 20);
    }

    public void crabAttack() {
        this.setCooldown(200);
        Vec3 targetTo = new Vec3(this.m_5448_().m_20185_() - this.m_20185_(), this.m_5448_().m_20186_() - this.m_20186_(), this.m_5448_().m_20189_() - this.m_20189_()).m_82541_();
        float f = (float)(Mth.m_14136_((double)targetTo.f_82481_, (double)targetTo.f_82479_) * 57.2957763671875) - 90.0f;
        this.m_146922_(ErsUtils.rotlerp(this.m_146908_(), f, 360.0f));
        this.f_20883_ = this.m_146908_();
        this.m_20334_(targetTo.f_82479_ * 1.6, targetTo.f_82480_ * 1.6, targetTo.f_82481_ * 1.6);
        Vec3 pos = this.m_20182_();
        double range = 3.0;
        double startX = pos.f_82479_ + targetTo.f_82479_ * range;
        double startY = pos.f_82480_ + targetTo.f_82480_ * range;
        double startZ = pos.f_82481_ + targetTo.f_82481_ * range;
        this.triggerAnim("extra", "attack");
        AABB attackBox = new AABB(startX - range, startY - range, startZ - range, startX + range, startY + range, startZ + range);
        List entities = this.m_9236_().m_6249_((Entity)this, attackBox, entity -> entity instanceof LivingEntity);
        double damage = this.m_21133_(Attributes.f_22281_);
        boolean shouldEscape = false;
        for (Entity target : entities) {
            target.m_20301_(target.m_20146_() - 150);
            target.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), (float)damage);
            if (target.m_6084_()) {
                shouldEscape = true;
                continue;
            }
            this.setCooldown(1200);
        }
        if (shouldEscape) {
            this.crabEscape((Entity)this.m_5448_());
        }
    }

    public void crabEscape(Entity target) {
        this.setCooldown(400);
        this.setWaiting(false);
        this.triggerAnim("extra", "dodge");
        Vec3 targetTo = new Vec3(target.m_20185_() - this.m_20185_(), target.m_20186_() - this.m_20186_(), target.m_20189_() - this.m_20189_()).m_82541_();
        float f = (float)(Mth.m_14136_((double)targetTo.f_82481_, (double)targetTo.f_82479_) * 57.2957763671875) - 90.0f;
        this.m_146922_(ErsUtils.rotlerp(this.m_146908_(), f, 360.0f));
        this.f_20883_ = this.m_146908_();
        this.m_20334_(-targetTo.f_82479_ * 2.0, 0.0, -targetTo.f_82481_ * 2.0);
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        if (pSource.m_276093_(DamageTypes.f_268566_) || pSource.m_276093_(DamageTypes.f_268464_)) {
            Entity entity;
            if (!this.isWaiting()) {
                if (this.m_21188_() != null) {
                    this.crabEscape((Entity)this.m_21188_());
                } else if (pSource.m_276093_(DamageTypes.f_268464_)) {
                    this.crabEscape(pSource.m_7639_());
                }
            }
            if ((entity = pSource.m_7639_()) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.m_6469_(this.m_9236_().m_269111_().m_269374_((Entity)this), 4.0f);
            }
        }
        return super.m_6469_(pSource, pAmount);
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    @Override
    public GeneralAnimator<TachypleusGladiusEntity> getAnimator() {
        return this.animator;
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean pFromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)pFromBucket);
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        return Bucketable.m_148828_((Player)pPlayer, (InteractionHand)pHand, (LivingEntity)this).orElse(super.m_6071_(pPlayer, pHand));
    }

    public void m_6872_(@NotNull ItemStack pStack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)pStack);
    }

    public void m_142278_(@NotNull CompoundTag pTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)pTag);
    }

    @NotNull
    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)ErsItems.TACHYPLEUS_GLADIUS_BUCKET.get());
    }

    @NotNull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }
}

