/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.entity.creatures.terridensaurussaevus;

import cn.aurorian.ers.effect.ErsBleedingEffect;
import cn.aurorian.ers.entity.AttackType;
import cn.aurorian.ers.entity.ErsTamableVehicle;
import cn.aurorian.ers.entity.MobAttack;
import cn.aurorian.ers.entity.creatures.terridensaurussaevus.TerridensaurusSaevusEntity;
import cn.aurorian.ers.init.ErsItems;
import cn.aurorian.ers.init.ErsMobEffects;
import cn.aurorian.ers.util.ErsUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class SaevusAttackExecutor {
    private static final SaevusAttackExecutor INSTANCE = new SaevusAttackExecutor();

    public static SaevusAttackExecutor getInstance() {
        return INSTANCE;
    }

    public void executeSaevusAttack(MobAttack attack, TerridensaurusSaevusEntity mount) {
        if (!mount.m_20160_()) {
            return;
        }
        if (attack.animatorTick == AttackType.SAEVUS_ATTACK.getAnimationLength() - 18) {
            double damage = mount.m_21133_(Attributes.f_22281_);
            damage = mount.checkEquipment((Item)ErsItems.BULLY_STICK.get()) ? damage * (double)1.4f : damage;
            Player player = (Player)mount.m_6688_();
            if (player == null) {
                return;
            }
            double range = 3.0f * mount.getRenderSize();
            Vector3f foodPos = mount.getFoodPosition();
            double x = mount.m_20185_() + (double)foodPos.x;
            double y = mount.m_20186_() + (double)foodPos.y;
            double z = mount.m_20189_() + (double)foodPos.z;
            List entities = mount.m_9236_().m_6249_((Entity)mount, new AABB(x - range, y - range, z - range, x + range, y + range, z + range), entity -> entity instanceof LivingEntity && entity != mount && entity != player);
            for (Entity entity2 : entities) {
                if (!(entity2 instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity2;
                if (mount.m_217043_().m_188501_() < 0.33f) {
                    living.m_7292_(new MobEffectInstance((MobEffect)ErsMobEffects.FRACTURE.get(), 600));
                }
                ErsBleedingEffect.giveBleedingEffect(living, 2);
                living.m_6469_(mount.m_9236_().m_269111_().m_269333_((LivingEntity)mount), (float)damage);
                mount.setBloody(true);
            }
        }
    }

    public void executeSaevusRoar(MobAttack attack, TerridensaurusSaevusEntity mount) {
        if (attack.animatorTick == AttackType.SAEVUS_ROAR.getAnimationLength() - 1) {
            mount.setRoarTime(30);
        }
    }

    public void executeSaevusStrike(MobAttack attack, TerridensaurusSaevusEntity mount) {
        if (attack.animatorTick == AttackType.SAEVUS_STRIKE.getAnimationLength() - 29) {
            double damage = mount.m_21133_(Attributes.f_22281_) * (double)1.48f;
            damage = mount.checkEquipment((Item)ErsItems.BULLY_STICK.get()) ? damage * (double)1.4f : damage;
            Player player = (Player)mount.m_6688_();
            if (player == null) {
                return;
            }
            double range = 5.0f * mount.getRenderSize();
            Vector3f foodPos = mount.getFoodPosition();
            double x = mount.m_20185_() + (double)foodPos.x;
            double y = mount.m_20186_() + (double)foodPos.y;
            double z = mount.m_20189_() + (double)foodPos.z;
            List entities = mount.m_9236_().m_6249_((Entity)mount, new AABB(x - range, y - range, z - range, x + range, y + range, z + range), entity -> entity instanceof LivingEntity && entity != mount && entity != player);
            for (Entity entity2 : entities) {
                if (!(entity2 instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity2;
                if (mount.m_217043_().m_188501_() < 0.33f) {
                    living.m_7292_(new MobEffectInstance((MobEffect)ErsMobEffects.FRACTURE.get(), 600));
                }
                ErsBleedingEffect.giveBleedingEffect(living, 2);
                living.m_6469_(mount.m_9236_().m_269111_().m_269333_((LivingEntity)mount), (float)damage);
                mount.setBloody(true);
            }
        }
        if (attack.animatorTick == AttackType.SAEVUS_STRIKE.getAnimationLength()) {
            attack.turningAttackDirection = mount.m_20154_().m_82541_();
        }
        if (attack.animatorTick < AttackType.SAEVUS_STRIKE.getAnimationLength() - 6 && attack.animatorTick > AttackType.SAEVUS_STRIKE.getAnimationLength() - 30) {
            mount.setRiddenSpeed((float)(mount.m_21133_(Attributes.f_22279_) * 3.0));
            mount.m_6858_(true);
        } else {
            mount.m_6858_(false);
        }
    }

    public void executeSaevusTurningAttack(MobAttack attack, TerridensaurusSaevusEntity mount) {
        Player player;
        if (attack.animatorTick == AttackType.SAEVUS_ATTACK_TURN.getAnimationLength() - 14) {
            player = (Player)mount.m_6688_();
            Vec3 lookVec = ((LivingEntity)Objects.requireNonNullElse(player, mount)).m_20154_();
            Vec3 pos = mount.m_20182_();
            double range = 3.6 * (double)mount.m_6134_();
            double startX = pos.f_82479_ + lookVec.f_82479_ * range;
            double startY = pos.f_82480_ + lookVec.f_82480_;
            double startZ = pos.f_82481_ + lookVec.f_82481_ * range;
            AABB attackBox = new AABB(startX - range, startY - range, startZ - range, startX + range, startY + range, startZ + range);
            List entities = mount.m_9236_().m_6249_((Entity)mount, attackBox, entity -> entity instanceof LivingEntity);
            double damage = mount.m_21133_(Attributes.f_22281_) * 0.37;
            for (Entity target : entities) {
                if (target.equals((Object)mount.m_6688_()) || !(target instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)target;
                livingEntity.m_6469_(mount.m_9236_().m_269111_().m_269333_((LivingEntity)mount), (float)damage);
                livingEntity.m_246865_(livingEntity.m_20184_().m_82520_(lookVec.f_82479_ * 2.0, 0.5, lookVec.f_82481_ * 2.0));
                if (!(livingEntity instanceof ErsTamableVehicle)) continue;
                ErsTamableVehicle tamable = (ErsTamableVehicle)livingEntity;
                if (!tamable.m_6084_()) {
                    return;
                }
                if (tamable.m_6162_() || tamable.doAgeTick() && tamable.getAgeInDays() < 20) {
                    livingEntity.m_246865_(livingEntity.m_20184_().m_82520_(lookVec.f_82479_ * 2.0, 1.0, lookVec.f_82481_ * 2.0));
                    return;
                }
                double volume = mount.m_20191_().m_82362_() * mount.m_20191_().m_82376_() * mount.m_20191_().m_82385_();
                double targetVolume = tamable.m_20191_().m_82362_() * tamable.m_20191_().m_82376_() * tamable.m_20191_().m_82385_();
                if (!(targetVolume < volume * 1.3)) continue;
                if (ErsUtils.calculateFallDirection((LivingEntity)mount, (LivingEntity)tamable)) {
                    tamable.startAttack(AttackType.KNOCK_DOWN_RIGHT);
                    continue;
                }
                tamable.startAttack(AttackType.KNOCK_DOWN_LEFT);
            }
        }
        if (attack.animatorTick == AttackType.SAEVUS_ATTACK_TURN.getAnimationLength()) {
            player = (Player)mount.m_6688_();
            attack.turningAttackDirection = ((LivingEntity)Objects.requireNonNullElse(player, mount)).m_20154_().m_82541_();
            if (((LivingEntity)Objects.requireNonNullElse(player, mount)).m_6080_() > mount.f_20883_) {
                mount.triggerAnim("attack", "right_attack_turn");
            } else {
                mount.triggerAnim("attack", "left_attack_turn");
            }
        }
        if (attack.animatorTick == 1) {
            mount.m_5618_(ErsUtils.yRotationFromDirection(attack.turningAttackDirection));
        }
    }
}

