/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.entity.creatures.terridensaurussaevus;

import cn.aurorian.ers.client.animator.GeneralAnimator;
import cn.aurorian.ers.client.animator.TerridensaurusSaevusAnimator;
import cn.aurorian.ers.entity.AttackType;
import cn.aurorian.ers.entity.ErsTamableVehicle;
import cn.aurorian.ers.entity.ai.goal.ErsTamableHurtByTargetGoal;
import cn.aurorian.ers.entity.ai.goal.ErsTamableOwnerHurtByTargetGoal;
import cn.aurorian.ers.entity.ai.goal.ErsTamableOwnerHurtTargetGoal;
import cn.aurorian.ers.entity.ai.goal.MobFollowOwnerGoal;
import cn.aurorian.ers.entity.ai.movecontrol.AquaticMoveControl;
import cn.aurorian.ers.entity.ai.movecontrol.LimitedMoveControl;
import cn.aurorian.ers.entity.ai.navigation.MMGroundPathNavigation;
import cn.aurorian.ers.entity.creatures.terridensaurussaevus.TerridensaurusSaevusBodyControl;
import cn.aurorian.ers.entity.creatures.terridensaurussaevus.ai.TerridensaurusSaevusAttackGoal;
import cn.aurorian.ers.entity.creatures.terridensaurussaevus.invertory.TerridensaurusSaevusMenuProvider;
import cn.aurorian.ers.init.ErsBlocks;
import cn.aurorian.ers.init.ErsItems;
import cn.aurorian.ers.init.ErsNetwork;
import cn.aurorian.ers.packet.MobSyncDimPacket;
import cn.aurorian.ers.util.ErsUtils;
import cn.aurorian.ers.util.SimpleAutoPlayingSoundKeyFrameHandler;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class TerridensaurusSaevusEntity
extends ErsTamableVehicle<TerridensaurusSaevusEntity>
implements ContainerListener,
HasCustomInventoryScreen,
VariantHolder<Variant> {
    private final GeneralAnimator<TerridensaurusSaevusEntity> animator;
    private boolean init = false;
    private static final EntityDataAccessor<Integer> NEXT_POOP_TIME = SynchedEntityData.m_135353_(TerridensaurusSaevusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int roarTime = 0;

    public TerridensaurusSaevusEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.switchNavigator(true);
        this.animator = new TerridensaurusSaevusAnimator(this);
        this.m_274367_(2.0f);
        this.createInventory();
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.SWIM_COST = 0.15f;
        this.SPRINT_COST = 0.1f;
        this.RECOVER = 0.35f;
        this.RECOVER_WHEN_WALK = false;
        this.doAgeTick = true;
        this.doHunger = true;
    }

    protected void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new LimitedMoveControl((Mob)this);
            this.f_21344_ = new MMGroundPathNavigation((Mob)this, this.m_9236_());
        } else {
            this.f_21342_ = new AquaticMoveControl((PathfinderMob)this, 1.0f).applyGravity(false);
            this.f_21344_ = new AmphibiousPathNavigation((Mob)this, this.m_9236_());
        }
    }

    public int getNextPoopTime() {
        return (Integer)this.f_19804_.m_135370_(NEXT_POOP_TIME);
    }

    public void setNextPoopTime(int time) {
        this.f_19804_.m_135381_(NEXT_POOP_TIME, (Object)time);
    }

    public void setRoarTime(int time) {
        this.roarTime = time;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(NEXT_POOP_TIME, (Object)RandomSource.m_216327_().m_188503_(24000));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.18).m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 27.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 4.0);
    }

    @Override
    public GeneralAnimator<TerridensaurusSaevusEntity> getAnimator() {
        return this.animator;
    }

    @Override
    public void updateMount() {
    }

    public int m_5792_() {
        return 1;
    }

    @Override
    public void executeDefaultAttackType() {
        this.startAttack(AttackType.SAEVUS_ATTACK);
    }

    @Override
    public void executeSpecialAttackType() {
        if (this.m_20096_()) {
            this.startAttack(AttackType.SAEVUS_STRIKE);
        }
    }

    @Override
    public void executeJudgementAttackType() {
        this.startAttack(AttackType.SAEVUS_ROAR);
    }

    @Override
    public void executeTurnAttackType() {
        if (this.m_20096_()) {
            this.startAttack(AttackType.SAEVUS_ATTACK_TURN);
        }
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        int age = this.getAgeInDays();
        if (this.isMature()) {
            age -= 20;
        }
        float scale = ErsUtils.calculateRenderSize(age);
        if (!this.isMature()) {
            scale *= 0.4f;
        }
        return this.m_6095_().m_20680_().m_20388_(scale);
    }

    public boolean m_6898_(@NotNull ItemStack pStack) {
        return pStack.m_150930_((Item)ErsItems.CARNIVORE_FEED.get()) || pStack.getFoodProperties((LivingEntity)this) != null && pStack.getFoodProperties((LivingEntity)this).m_38746_();
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand pHand) {
        FoodProperties foodProperties;
        if (this.m_21824_() && !this.m_20160_() && this.m_21830_((LivingEntity)player) && this.isMature() && !player.m_6047_() && !this.m_6898_(player.m_21205_()) && !player.m_21205_().m_150930_((Item)ErsItems.GILDED_HORN.get())) {
            player.m_146922_(this.m_146908_());
            player.m_146926_(this.m_146909_());
            player.m_20329_((Entity)this);
        }
        if (pHand == InteractionHand.MAIN_HAND && player.m_6047_() && this.m_21824_() && this.m_21830_((LivingEntity)player) && !player.m_21205_().m_150930_((Item)ErsItems.CARNIVORE_FEED.get())) {
            this.f_21344_.m_26573_();
            if (!this.m_9236_().f_46443_) {
                this.setCommand(this.getCommand() + 1);
                if (this.getCommand() > 2) {
                    this.setCommand(0);
                }
            }
            String commandText = "stand";
            if (this.getCommand() == 1) {
                commandText = "sit";
                this.m_6710_(null);
            } else if (this.getCommand() == 2) {
                commandText = "follow";
                this.m_6710_(null);
            }
            player.m_5661_((Component)Component.m_237115_((String)("ers.command." + commandText)), true);
            if (this.m_21827_()) {
                this.m_6710_(null);
            }
        }
        if (!this.m_9236_().f_46443_ && player.m_21205_().m_150930_((Item)ErsItems.CARNIVORE_FEED.get())) {
            if (!this.m_21824_() && this.getAgeInDays() < 1) {
                if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                    this.m_21828_(player);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            } else if (this.m_21824_()) {
                this.feed(5);
                this.m_5634_(5.0f);
                player.m_21205_().m_41774_(1);
            }
        }
        if (!this.m_9236_().f_46443_ && (foodProperties = player.m_21205_().getFoodProperties((LivingEntity)this)) != null && foodProperties.m_38746_()) {
            this.feed(1);
            this.m_5634_(1.0f);
            player.m_21205_().m_41774_(1);
        }
        return super.m_6071_(player, pHand);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new TerridensaurusSaevusAttackGoal(this, 2.0, false));
        this.f_21345_.m_25352_(2, (Goal)new MobFollowOwnerGoal(this, 2.2, 7.0f, 4.0f, 64.0f, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2){

            public boolean m_8036_() {
                if (!((TerridensaurusSaevusEntity)this.f_25725_).getAttackState().getType().canMove()) {
                    return false;
                }
                return super.m_8036_() && ((TerridensaurusSaevusEntity)this.f_25725_).getCommand() != 1;
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f){

            public boolean m_8036_() {
                if (this.f_25512_.m_20160_()) {
                    return false;
                }
                return super.m_8036_();
            }

            public boolean m_8045_() {
                if (this.f_25512_.m_20160_()) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new ErsTamableHurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean m_8036_() {
                return super.m_8036_() && !TerridensaurusSaevusEntity.this.m_21824_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new ErsTamableOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new ErsTamableOwnerHurtTargetGoal(this));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        AnimationController main = new AnimationController((GeoAnimatable)this, "main", 2, state -> {
            RawAnimation builder = RawAnimation.begin();
            if (this.m_20069_() && !this.m_20096_()) {
                if (this.isMoving() && this.m_20142_()) {
                    builder.thenLoop("animation.quickly_swimming");
                } else if (this.isMoving() && !this.m_20142_()) {
                    builder.thenLoop("animation.swim");
                } else {
                    builder.thenLoop("animation.swim_idle");
                }
            } else if (this.isMoving() && this.m_20142_()) {
                builder.thenLoop("animation.run");
            } else if (this.isMoving()) {
                builder.thenLoop("animation.walk");
            } else if (!this.getRotDirection().isNone()) {
                if (this.getRotDirection().isLeft()) {
                    if (this.m_20160_()) {
                        builder.thenLoop("animation.-left");
                    } else {
                        builder.thenLoop("animation.-left_ai");
                    }
                } else if (this.m_20160_()) {
                    builder.thenLoop("animation.+right");
                } else {
                    builder.thenLoop("animation.+right_ai");
                }
            } else if (this.getCommand() == 1) {
                builder.thenLoop("animation.idle_sit");
            } else {
                builder.thenLoop("animation.idle");
            }
            return state.setAndContinue(builder);
        }).setSoundKeyframeHandler(new SimpleAutoPlayingSoundKeyFrameHandler());
        AnimationController attack = new AnimationController((GeoAnimatable)this, "attack", 10, state -> PlayState.STOP).triggerableAnim("attack", RawAnimation.begin().thenPlay("animation.attack")).triggerableAnim("roar", RawAnimation.begin().thenPlay("animation.roar")).triggerableAnim("strike", RawAnimation.begin().thenPlay("animation.strike")).triggerableAnim("left_attack_turn", RawAnimation.begin().thenPlay("animation.left_attack")).triggerableAnim("right_attack_turn", RawAnimation.begin().thenPlay("animation.right_attack")).setSoundKeyframeHandler(new SimpleAutoPlayingSoundKeyFrameHandler());
        controllerRegistrar.add(new AnimationController[]{main, attack});
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new TerridensaurusSaevusBodyControl(this);
    }

    @NotNull
    protected Vec3 m_274312_(@NotNull Player pPlayer, @NotNull Vec3 pTravelVector) {
        if (this.rideSpeed != 0.0f || pPlayer.f_20899_) {
            this.updateMount();
            if (this.getCommand() == 1) {
                this.setCommand(0);
            }
        }
        if (this.isInFluidType() && !this.m_20096_()) {
            float y = 0.0f;
            if (pPlayer.f_20899_ && this.getSwimState() == 2) {
                y = 0.4f;
                if (!this.f_19800_) {
                    this.setSwimState(1);
                }
            }
            if (this.rideSpeed != 0.0f && this.getSwimState() == 1 && this.f_19862_) {
                y = 0.6f;
            }
            return new Vec3(0.0, (double)y, (double)this.rideSpeed);
        }
        return new Vec3(0.0, 0.0, (double)this.rideSpeed);
    }

    protected void m_274498_(@NotNull Player driver, @NotNull Vec3 move) {
        this.tickStableHead();
        if (this.getAttackState().getType().canMove() && this.isSaddled()) {
            if ((!this.getRotDirection().isLargeTurn() || this.m_20069_()) && (Math.abs((float)driver.f_20902_) > 0.0f || Math.abs((float)driver.f_20900_) > 0.0f) || this.m_20142_()) {
                float baseSpeed = (float)this.m_21051_(Attributes.f_22279_).m_22135_();
                this.rideSpeed = Mth.m_14121_((float)this.rideSpeed, (float)(this.m_20142_() ? baseSpeed * 3.0f : baseSpeed), (float)0.08f);
            } else {
                this.rideSpeed = Mth.m_14121_((float)this.rideSpeed, (float)0.0f, (float)0.16f);
            }
        }
    }

    protected float m_245547_(@NotNull Player pPlayer) {
        return this.rideSpeed + 0.2f;
    }

    public void setRiddenSpeed(float speed) {
        this.rideSpeed = speed;
    }

    public void tickStableHead() {
        float pitch = this.getAnimator().getModelPitch(this.getAnimator().getPartialTick());
        if (this.m_20069_()) {
            this.setStableHead(pitch < 20.0f);
        } else if (this.m_20096_()) {
            this.setStableHead(true);
        }
    }

    @Override
    public void equipSaddle() {
        this.inventory.m_6836_(0, new ItemStack((ItemLike)ErsItems.SAEVUS_SADDLE.get()));
        this.setSaddled(true);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12034_, this.m_5720_(), 1.0f, 1.0f);
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_5757_(@NotNull Container container) {
        this.setSaddled(!this.inventory.m_8020_(0).m_41619_());
        boolean healthBoost = false;
        boolean armorBoost = false;
        for (int i = 1; i <= 3; ++i) {
            ItemStack itemStack = this.inventory.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            if (itemStack.m_150930_(Items.f_42437_)) {
                healthBoost = true;
            }
            if (!itemStack.m_150930_(Items.f_42740_)) continue;
            armorBoost = true;
        }
        float scale = this.calculateScale();
        if (!this.isElite()) {
            scale *= 0.7f;
        }
        if (!this.isMature()) {
            scale *= 0.4f;
        }
        if (healthBoost) {
            this.m_21051_(Attributes.f_22276_).m_22100_((double)(200.0f * scale + 20.0f));
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_((double)(200.0f * scale));
        }
        if (armorBoost) {
            this.m_21051_(Attributes.f_22284_).m_22100_(10.0);
        } else {
            this.m_21051_(Attributes.f_22284_).m_22100_(6.0);
        }
    }

    public void m_213583_(@NotNull Player player) {
        if (!this.m_9236_().m_5776_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new TerridensaurusSaevusMenuProvider(this), buf -> buf.writeInt(this.m_19879_()));
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Command", this.getCommand());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setCommand(compound.m_128451_("Command"));
    }

    @Override
    public int getInventorySize() {
        return 8;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            if (this.f_19797_ % 20 == 0) {
                int nextPoopTime;
                if (this.f_19797_ % 200 == 0) {
                    this.m_5634_(1.0f);
                }
                float hunger = this.getHunger();
                if (this.f_19797_ % 100 == 0) {
                    if (this.isElite()) {
                        hunger -= 0.1f;
                    }
                    if (this.isMature()) {
                        hunger -= 0.1f;
                    }
                    this.setHunger(hunger - 0.1f);
                }
                if ((hunger < 50.0f || this.m_21223_() < this.m_21233_()) && this.f_19797_ % 200 == 0) {
                    for (int slot = 5; slot <= 7; ++slot) {
                        if (this.getInventory().m_8020_(slot).m_41619_()) continue;
                        this.getInventory().m_8020_(slot).m_41774_(1);
                        this.feed(3);
                        this.m_5634_(5.0f);
                        break;
                    }
                }
                if (this.getAgeInTicks() % 24000 == 0 || !this.init) {
                    this.updateFromAgeServer();
                    ErsNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new MobSyncDimPacket(this.m_19879_()));
                    this.init = true;
                }
                if ((nextPoopTime = this.getNextPoopTime()) > 0) {
                    this.setNextPoopTime(nextPoopTime - 20);
                } else {
                    this.generateFeces();
                    this.setNextPoopTime(10000 + RandomSource.m_216327_().m_188503_(14000));
                }
                if (this.roarTime > 0) {
                    --this.roarTime;
                }
            }
            if (this.m_20142_() && this.isMature()) {
                this.stompEffect(3.0f, 3.0f, this.checkEquipment((Item)ErsItems.SCRATCHING_BOARD.get()) ? 6.0f : 4.0f);
            }
        }
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        if (this.roarTime > 0) {
            pAmount *= 0.9f;
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.m_20069_() && !(this.f_21342_ instanceof AquaticMoveControl)) {
            this.switchNavigator(false);
        } else if (!this.m_20069_() && this.f_21342_ instanceof AquaticMoveControl) {
            this.switchNavigator(true);
        }
        this.breakBlock();
    }

    public boolean m_6673_(DamageSource source) {
        if (source.m_269415_().f_268677_().equals("sweetBerryBush") || source.m_7639_() instanceof Pufferfish || source.m_269415_().f_268677_().equals("cactus")) {
            return true;
        }
        return super.m_6673_(source);
    }

    public void m_7601_(@NotNull BlockState pState, @NotNull Vec3 pMotionMultiplier) {
    }

    public void m_8107_() {
        super.m_8107_();
        this.waterAiStep(2.7f * this.getRenderSize());
        if (this.m_20069_()) {
            if (this.m_20096_()) {
                this.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22100_(8.0);
            } else {
                this.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22100_(4.0);
            }
        }
    }

    @Override
    public void updateFromAgeServer() {
        if (this.getAgeInDays() >= 20 && !this.isMature()) {
            this.setMature(true);
        }
        if (this.getAgeInDays() >= 38 && this.canBeElite()) {
            this.setElite(true);
        }
        float scale = this.calculateScale();
        if (this.isMature()) {
            this.setRenderSize(scale);
        } else {
            this.setRenderSize(ErsUtils.calculateBabyRenderSize(this.getAgeInDays()));
        }
        this.m_6210_();
        if (!this.isElite()) {
            scale *= 0.7f;
        }
        if (!this.isMature()) {
            scale *= 0.4f;
        }
        this.m_21051_(Attributes.f_22276_).m_22100_((double)(200.0f * scale));
        this.m_21051_(Attributes.f_22281_).m_22100_((double)(35.0f * scale));
        if (!this.isMature()) {
            scale *= 2.2f;
        }
        if (!this.isElite() && this.isMature()) {
            scale /= 0.7f;
        }
        this.m_21051_(Attributes.f_22279_).m_22100_(0.18 * (double)scale);
        this.m_5757_((Container)this.getInventory());
        this.getAnimatableInstanceCache().getManagerForId((long)this.m_19879_()).clearSnapshotCache();
    }

    private void placeNest() {
        int offsetZ;
        double yRot;
        int offsetX;
        BlockPos targetPos;
        if (this.m_9236_().f_46443_) {
            return;
        }
        BlockState state = ((Block)ErsBlocks.SAEVUS_NEST.get()).m_49966_();
        BlockPos pos = this.m_20183_();
        Level level = this.m_9236_();
        if (level.m_8055_(targetPos = pos.m_7918_(offsetX = (int)(-Math.sin((double)(yRot = (double)Math.toRadians((float)this.m_146908_()))) * 1.5), 0, offsetZ = (int)(Math.cos((double)yRot) * 1.5))).m_60795_() && level.m_8055_(targetPos.m_7495_()).m_60804_((BlockGetter)level, targetPos.m_7495_())) {
            level.m_7731_(targetPos, state, 3);
        }
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason == MobSpawnType.BUCKET) {
            return pSpawnData;
        }
        RandomSource $$6 = pLevel.m_213780_();
        if (pSpawnData == null) {
            pSpawnData = $$6.m_188501_() < 0.1f ? new TerridensaurusSaevusGroupData(Variant.getRareSpawnVariant($$6)) : new TerridensaurusSaevusGroupData(Variant.getCommonSpawnVariant($$6), Variant.getCommonSpawnVariant($$6), Variant.getCommonSpawnVariant($$6), Variant.getCommonSpawnVariant($$6));
        }
        this.setVariant(((TerridensaurusSaevusGroupData)((Object)pSpawnData)).getVariant($$6));
        this.setAgeInDays(this.f_19796_.m_216332_(15, 50));
        if (this.f_19796_.m_188501_() < 0.3f) {
            this.setCanBeElite(true);
        }
        this.updateFromAgeServer();
        this.m_21153_(this.m_21233_());
        if (this.isMature() && this.f_19796_.m_188501_() < 0.15f) {
            this.placeNest();
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @NotNull
    public Variant getVariant() {
        return Variant.byId(this.getVariantId());
    }

    public void setVariant(Variant pVariant) {
        this.setVariantId(pVariant.getId());
    }

    @Override
    protected void m_7472_(@NotNull DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        if (this.isMature() && this.f_19796_.m_188501_() < 0.3f) {
            ItemStack stack = new ItemStack((ItemLike)ErsItems.SAEVUS_EGG.get());
            this.m_19983_(stack);
        }
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
    }

    private void generateFeces() {
        int offsetZ;
        double yRot;
        int offsetX;
        BlockPos targetPos;
        if (this.m_9236_().f_46443_) {
            return;
        }
        List<BlockState> fecesBlocks = List.of(((Block)ErsBlocks.BONE_FECES.get()).m_49966_(), ((Block)ErsBlocks.SMALL_FECES.get()).m_49966_(), ((Block)ErsBlocks.LARGE_FECES.get()).m_49966_(), ((Block)ErsBlocks.GLASSES_FECES.get()).m_49966_());
        BlockPos pos = this.m_20183_();
        Level level = this.m_9236_();
        if (level.m_8055_(targetPos = pos.m_7918_(offsetX = (int)(-Math.sin((double)(yRot = (double)Math.toRadians((float)this.m_146908_()))) * 1.5), 0, offsetZ = (int)(Math.cos((double)yRot) * 1.5))).m_60795_() && level.m_8055_(targetPos.m_7495_()).m_60804_((BlockGetter)level, targetPos.m_7495_())) {
            BlockState state = fecesBlocks.get(this.m_9236_().f_46441_.m_188503_(fecesBlocks.size()));
            if (state.m_60713_((Block)ErsBlocks.TEL_FECES.get()) && this.m_9236_().f_46441_.m_188501_() < 0.1f) {
                return;
            }
            level.m_7731_(targetPos, state, 3);
            level.m_6263_(null, (double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 0.5, (double)targetPos.m_123343_() + 0.5, SoundEvents.f_12392_, SoundSource.BLOCKS, 0.5f, 1.0f);
        }
    }

    public static class TerridensaurusSaevusGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final Variant[] types;

        public TerridensaurusSaevusGroupData(Variant ... pTypes) {
            super(1.0f);
            this.types = pTypes;
        }

        public Variant getVariant(RandomSource pRandom) {
            return this.types[pRandom.m_188503_(this.types.length)];
        }
    }

    public static enum Variant implements StringRepresentable
    {
        ORIGINAL(0, "original", true),
        BLACK(1, "black", false),
        LACK_YELLOW(2, "lack_yellow", false),
        WHITE(3, "white", false);

        private static final IntFunction<Variant> BY_ID;
        public static final Codec<Variant> CODEC;
        private final int id;
        private final String name;
        private final boolean common;

        private Variant(int pId, String pName, boolean pCommon) {
            this.id = pId;
            this.name = pName;
            this.common = pCommon;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public static Variant byId(int pId) {
            return BY_ID.apply(pId);
        }

        public static Variant getCommonSpawnVariant(RandomSource pRandom) {
            return Variant.getSpawnVariant(pRandom, true);
        }

        public static Variant getRareSpawnVariant(RandomSource pRandom) {
            return Variant.getSpawnVariant(pRandom, false);
        }

        private static Variant getSpawnVariant(RandomSource pRandom, boolean pCommon) {
            Variant[] $$2 = (Variant[])Arrays.stream(Variant.values()).filter(p_149252_ -> p_149252_.common == pCommon).toArray(Variant[]::new);
            return (Variant)((Object)Util.m_214670_((Object[])$$2, (RandomSource)pRandom));
        }

        static {
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            CODEC = StringRepresentable.m_216439_(Variant::values);
        }
    }
}

