/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.event;

import cn.aurorian.ers.entity.creatures.acanthodeschlamydoselachoides.AcanthodesChlamydoselachoidesEntity;
import cn.aurorian.ers.entity.creatures.dentisauruslongirostris.DentisaurusLongirostrisEntity;
import cn.aurorian.ers.entity.creatures.latimeriapercoides.LatimeriaPercoidesEntity;
import cn.aurorian.ers.entity.creatures.latimeriasuchomimus.LatimeriaSuchomimusEntity;
import cn.aurorian.ers.entity.creatures.magnidiscumyzonsarcopterus.MagnidiscumyzonSarcopterusEntity;
import cn.aurorian.ers.entity.creatures.tachypleusgladius.TachypleusGladiusEntity;
import cn.aurorian.ers.entity.creatures.terridensaurussaevus.TerridensaurusSaevusEntity;
import cn.aurorian.ers.init.ErsEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ers", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EntityAttributeHandler {
    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)ErsEntities.DENTISAURUS_LONGIROSTRIS.get(), DentisaurusLongirostrisEntity.createAttributes().m_22265_());
        event.put((EntityType)ErsEntities.LATIMERIA_PERCOIDES.get(), LatimeriaPercoidesEntity.m_27495_().m_22265_());
        event.put((EntityType)ErsEntities.LATIMERIA_SUCHOMIMUS.get(), LatimeriaSuchomimusEntity.createAttributes().m_22265_());
        event.put((EntityType)ErsEntities.ACANTHODES_CHLAMYDOSELACHOIDES.get(), AcanthodesChlamydoselachoidesEntity.createAttributes().m_22265_());
        event.put((EntityType)ErsEntities.TACHYPLEUS_GLADIUS.get(), TachypleusGladiusEntity.createAttributes().m_22265_());
        event.put((EntityType)ErsEntities.TERRIDENSAURUS_SAEVUS.get(), TerridensaurusSaevusEntity.createAttributes().m_22265_());
        event.put((EntityType)ErsEntities.MAGNIDISCUMYZON_SARCOPTERUS.get(), MagnidiscumyzonSarcopterusEntity.m_27495_().m_22265_());
    }

    @SubscribeEvent
    public static void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)ErsEntities.LATIMERIA_PERCOIDES.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityAttributeHandler::checkCustomWaterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ErsEntities.TACHYPLEUS_GLADIUS.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityAttributeHandler::checkSurfaceWaterAnimalSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ErsEntities.ACANTHODES_CHLAMYDOSELACHOIDES.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityAttributeHandler::checkCustomWaterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ErsEntities.LATIMERIA_SUCHOMIMUS.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityAttributeHandler::checkCustomWaterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ErsEntities.MAGNIDISCUMYZON_SARCOPTERUS.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityAttributeHandler::checkSurfaceWaterAnimalSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static boolean checkCustomWaterSpawnRules(EntityType<? extends LivingEntity> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (EntityAttributeHandler.rollSpawn(3, random, spawnType)) {
            return EntityAttributeHandler.checkSurfaceWaterAnimalSpawnRules(type, level, spawnType, pos, random);
        }
        return false;
    }

    public static boolean checkSurfaceWaterAnimalSpawnRules(EntityType<? extends LivingEntity> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        int $$5 = level.m_5736_();
        int $$6 = $$5 - 13;
        return pos.m_123342_() >= $$6 && pos.m_123342_() <= $$5 && level.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_) && level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_);
    }

    public static boolean rollSpawn(int rolls, RandomSource random, MobSpawnType reason) {
        if (reason == MobSpawnType.SPAWNER) {
            return true;
        }
        return rolls <= 0 || random.m_188503_(rolls) == 0;
    }
}

