/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.event;

import cn.aurorian.ers.effect.ErsBleedingEffect;
import cn.aurorian.ers.entity.ErsTamable;
import cn.aurorian.ers.entity.ErsTamableVehicle;
import cn.aurorian.ers.entity.MobRotDirection;
import cn.aurorian.ers.entity.creatures.dentisauruslongirostris.DentisaurusLongirostrisEntity;
import cn.aurorian.ers.init.ErsBlocks;
import cn.aurorian.ers.init.ErsItems;
import cn.aurorian.ers.init.ErsMobEffects;
import cn.aurorian.ers.init.ErsParticleType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ers")
public class EntityEventHandler {
    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        EntityHitResult entityHit;
        Projectile projectile = event.getProjectile();
        if (!(projectile instanceof AbstractArrow)) {
            return;
        }
        AbstractArrow arrow = (AbstractArrow)projectile;
        HitResult hitResult = event.getRayTraceResult();
        if (hitResult instanceof EntityHitResult && (hitResult = (entityHit = (EntityHitResult)hitResult).m_82443_()) instanceof DentisaurusLongirostrisEntity) {
            DentisaurusLongirostrisEntity sotek = (DentisaurusLongirostrisEntity)hitResult;
            if (!sotek.m_9236_().f_46443_) {
                event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
                arrow.m_20256_(arrow.m_20184_().m_82542_(-0.2 + Mth.m_216263_((RandomSource)arrow.m_9236_().f_46441_, (double)-0.2, (double)0.2), -0.3, -0.2 + Mth.m_216263_((RandomSource)arrow.m_9236_().f_46441_, (double)-0.2, (double)0.2)));
                ((ServerLevel)sotek.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123797_, entityHit.m_82450_().f_82479_, entityHit.m_82450_().f_82480_, entityHit.m_82450_().f_82481_, 10, 0.2, 0.2, 0.2, 0.1);
                sotek.m_9236_().m_6263_(null, sotek.m_20185_(), sotek.m_20186_(), sotek.m_20189_(), SoundEvents.f_12346_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        ErsTamable pet;
        LivingEntity i3;
        ErsTamableVehicle vehicle;
        Object tamable;
        SimpleContainer inventory;
        ServerPlayer player;
        Entity entity;
        LivingEntity livingEntity;
        if (event.getSource().m_276093_(DamageTypes.f_268566_) && (livingEntity = event.getEntity()) instanceof ServerPlayer && (entity = (player = (ServerPlayer)livingEntity).m_20202_()) instanceof ErsTamableVehicle && (inventory = ((ErsTamableVehicle)(tamable = (ErsTamableVehicle)entity)).getInventory()) != null) {
            for (int i2 = 1; i2 <= 3; ++i2) {
                ItemStack itemStack = inventory.m_8020_(i2);
                if (itemStack.m_41619_() || !itemStack.m_150930_((Item)ErsItems.RIDING_GUIDE.get())) continue;
                event.setCanceled(true);
                return;
            }
        }
        if (event.getEntity().m_21223_() - event.getAmount() > 0.0f) {
            return;
        }
        tamable = event.getEntity();
        if (tamable instanceof ErsTamableVehicle && (vehicle = (ErsTamableVehicle)tamable).getInventory() != null) {
            for (int i3 = 1; i3 <= 3; ++i3) {
                ItemStack itemStack = vehicle.getInventory().m_8020_(i3);
                if (itemStack.m_41619_() || !itemStack.m_150930_(Items.f_42747_)) continue;
                itemStack.m_41774_(1);
                vehicle.m_21153_(vehicle.m_21233_());
                vehicle.m_9236_().m_245803_((Entity)vehicle, vehicle.m_20097_(), SoundEvents.f_12513_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                return;
            }
        }
        if ((i3 = event.getEntity()) instanceof ErsTamable && (pet = (ErsTamable)i3).isRespawnEnable()) {
            BlockPos pos = pet.getRespawnPos();
            ServerLevel respawnlevel = null;
            for (ServerLevel level : pet.m_20194_().m_129785_()) {
                if (!level.m_46472_().toString().equals(pet.getDimension())) continue;
                respawnlevel = level;
                break;
            }
            if (respawnlevel == null) {
                return;
            }
            if (respawnlevel.m_8055_(pos).m_60713_((Block)ErsBlocks.SOUL_CUBE.get())) {
                pet.m_9236_().m_245803_((Entity)pet, pet.m_20097_(), SoundEvents.f_12513_, SoundSource.NEUTRAL, 0.8f, 1.0f);
                pet.m_20153_();
                pet.m_20095_();
                pet.m_264318_(respawnlevel, pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_(), null, pet.m_146908_(), pet.m_146909_());
                pet.m_21153_(1.0f);
                pet.m_21219_();
                if (pet.doAgeTick()) {
                    pet.setCommand(1);
                    pet.setAgeInTicks(pet.getAgeInTicks() / 2);
                    if (pet instanceof ErsTamableVehicle) {
                        ErsTamableVehicle vehicle2 = (ErsTamableVehicle)pet;
                        vehicle2.setRotDirection(MobRotDirection.of(MobRotDirection.RotDirection.NONE, false));
                        if (pet.getAgeInDays() < 38) {
                            vehicle2.setElite(false);
                            if (pet.getAgeInDays() < 20) {
                                vehicle2.setMature(false);
                            }
                        }
                        vehicle2.updateFromAgeServer();
                    }
                } else {
                    pet.m_6863_(true);
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onFishDie(LivingDeathEvent event) {
        Entity entity;
        if (event.getEntity() instanceof AbstractFish && (entity = event.getSource().m_7639_()) instanceof DentisaurusLongirostrisEntity) {
            DentisaurusLongirostrisEntity swampDragon = (DentisaurusLongirostrisEntity)entity;
            if (!swampDragon.m_21824_()) {
                swampDragon.feed(8);
            }
            swampDragon.feed(2);
        }
    }

    @SubscribeEvent
    public static void onPlayerUse(PlayerInteractEvent.EntityInteract event) {
        LivingEntity living;
        Entity entity;
        ItemStack itemStack = event.getItemStack();
        if (itemStack.m_150930_((Item)ErsItems.SOUL_CUBE_GIFT.get()) && (entity = event.getTarget()) instanceof ErsTamable) {
            ErsTamable pet = (ErsTamable)entity;
            if (!pet.m_21824_()) {
                return;
            }
            if (!pet.m_21830_((LivingEntity)event.getEntity())) {
                return;
            }
            pet.setEnable(true);
            CompoundTag tag = itemStack.m_41784_();
            pet.setDimension(event.getLevel().m_46472_().toString());
            pet.setRespawnPos(new BlockPos(tag.m_128451_("X"), tag.m_128451_("Y"), tag.m_128451_("Z")));
            itemStack.m_41774_(1);
            event.getLevel().m_5594_(event.getEntity(), event.getTarget().m_20097_(), SoundEvents.f_12326_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        if (itemStack.m_150930_((Item)ErsItems.TOURNIQUET.get()) && (entity = event.getTarget()) instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_((MobEffect)ErsMobEffects.BLEEDING.get())) {
            ErsBleedingEffect.removeBleedingEffect(living);
            itemStack.m_41774_(1);
        }
    }

    @SubscribeEvent
    public static void onLivingEntityTick(LivingEvent.LivingTickEvent event) {
        Level level;
        if (event.getEntity().m_21023_((MobEffect)ErsMobEffects.BLEEDING.get()) && (level = event.getEntity().m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SimpleParticleType type = event.getEntity().m_20069_() ? (SimpleParticleType)ErsParticleType.BLOOD.get() : (SimpleParticleType)ErsParticleType.DRIPPING_BLOOD.get();
            serverLevel.m_8767_((ParticleOptions)type, event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), 1, 0.8, 0.8, 0.8, 0.0);
        }
    }
}

