/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.item;

import cn.aurorian.ers.entity.ErsTamable;
import cn.aurorian.ers.init.ErsItems;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class FilledGildedHorn
extends Item {
    public FilledGildedHorn(Item.Properties pProperties) {
        super(pProperties);
    }

    public void checkExtraContent(@Nullable Player pPlayer, Level pLevel, ItemStack pContainerStack, BlockPos pPos) {
        if (pLevel instanceof ServerLevel) {
            this.spawn((ServerLevel)pLevel, pContainerStack, pPos);
            pLevel.m_142346_((Entity)pPlayer, GameEvent.f_157810_, pPos);
        }
    }

    private void spawn(ServerLevel pServerLevel, ItemStack gildedStack, BlockPos pPos) {
        EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(ResourceLocation.parse((String)gildedStack.m_41783_().m_128461_("EntityType")));
        Entity entity = type.m_20592_(pServerLevel, gildedStack, null, pPos, MobSpawnType.BUCKET, true, false);
        if (entity instanceof ErsTamable) {
            ErsTamable tamable = (ErsTamable)entity;
            tamable.m_7378_(gildedStack.m_41784_());
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (!itemstack.m_41782_() || !itemstack.m_41784_().m_128441_("EntityType")) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        BlockHitResult blockhitresult = FilledGildedHorn.m_41435_((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)pPlayer, (Level)pLevel, (ItemStack)itemstack, (HitResult)blockhitresult);
        if (ret != null) {
            return ret;
        }
        if (blockhitresult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (blockhitresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        BlockPos blockpos = blockhitresult.m_82425_();
        Direction direction = blockhitresult.m_82434_();
        BlockPos blockpos1 = blockpos.m_121945_(direction);
        if (pLevel.m_7966_(pPlayer, blockpos) && pPlayer.m_36204_(blockpos1, direction, itemstack)) {
            this.checkExtraContent(pPlayer, pLevel, itemstack, blockpos);
            pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)FilledGildedHorn.getEmptySuccessItem(itemstack, pPlayer), (boolean)pLevel.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public static ItemStack getEmptySuccessItem(ItemStack pBucketStack, Player pPlayer) {
        return !pPlayer.m_150110_().f_35937_ ? new ItemStack((ItemLike)ErsItems.GILDED_HORN.get()) : pBucketStack;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack pStack) {
        return UseAnim.TOOT_HORN;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        if (!pStack.m_41782_() || !pStack.m_41784_().m_128441_("EntityType")) {
            return;
        }
        MutableComponent entityType = Component.m_237115_((String)((EntityType)BuiltInRegistries.f_256780_.m_7745_(ResourceLocation.parse((String)pStack.m_41784_().m_128461_("EntityType")))).m_20675_());
        pTooltipComponents.add((Component)entityType.m_130940_(ChatFormatting.GRAY));
        int ageInDays = pStack.m_41784_().m_128451_("AgeTicks") / 24000;
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.ers.age", (Object[])new Object[]{ageInDays}));
    }

    public static <T extends LivingEntity> Optional<InteractionResult> hornPickup(Player pPlayer, InteractionHand pHand, T pEntity) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_41720_() == ErsItems.GILDED_HORN.get() && pEntity.m_6084_()) {
            ItemStack itemstack1 = new ItemStack((ItemLike)ErsItems.FILLED_GILDED_HORN.get());
            pEntity.m_7380_(itemstack1.m_41784_());
            itemstack1.m_41784_().m_128359_("EntityType", BuiltInRegistries.f_256780_.m_7981_((Object)pEntity.m_6095_()).toString());
            ItemStack itemstack2 = ItemUtils.m_41817_((ItemStack)itemstack, (Player)pPlayer, (ItemStack)itemstack1, (boolean)false);
            pPlayer.m_21008_(pHand, itemstack2);
            Level level = pEntity.m_9236_();
            pEntity.m_146870_();
            return Optional.of(InteractionResult.m_19078_((boolean)level.f_46443_));
        }
        return Optional.empty();
    }
}

