/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.util;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ErsUtils {
    public static float calculateRenderSize(int ageInDays) {
        if (ageInDays < 20) {
            return 0.8f + 0.2f * (float)ageInDays / 20.0f;
        }
        return (float)(Math.log(ageInDays + 350) / Math.log(300.0));
    }

    public static float calculateBabyRenderSize(int ageInDays) {
        return 0.7f + 0.4f * (float)ageInDays / 20.0f;
    }

    public static Vec3 directionVecTo(Entity start, Entity end) {
        return end.m_20182_().m_82546_(start.m_20182_());
    }

    public static boolean isMoving(Mob mob) {
        return mob.m_20185_() != mob.f_19790_ || mob.m_20189_() != mob.f_19792_;
    }

    public static float rotlerp(float pSourceAngle, float pTargetAngle, float pMaximumChange) {
        float f1;
        float f = Mth.m_14177_((float)(pTargetAngle - pSourceAngle));
        if (f > pMaximumChange) {
            f = pMaximumChange;
        }
        if (f < -pMaximumChange) {
            f = -pMaximumChange;
        }
        if ((f1 = pSourceAngle + f) < 0.0f) {
            f1 += 360.0f;
        } else if (f1 > 360.0f) {
            f1 -= 360.0f;
        }
        return f1;
    }

    public static float getDirectionAngle(float x, float z) {
        double angle = (90.0 - Math.toDegrees(Math.atan2(z, x))) % 360.0;
        if (angle < 0.0) {
            angle += 360.0;
        }
        return (float)angle;
    }

    public static int updateSkyBrightness(Level level) {
        double d0 = 1.0 - (double)(level.m_46722_(1.0f) * 5.0f) / 16.0;
        double d1 = 1.0 - (double)(level.m_46661_(1.0f) * 5.0f) / 16.0;
        double d2 = 0.5 + 2.0 * Mth.m_14008_((double)Mth.m_14089_((float)(level.m_46942_(1.0f) * ((float)Math.PI * 2))), (double)-0.25, (double)0.25);
        return (int)((1.0 - d2 * d0 * d1) * 11.0);
    }

    public static boolean calculateFallDirection(LivingEntity attacker, LivingEntity target) {
        Vec3 attackerPos = attacker.m_20182_();
        Vec3 targetPos = target.m_20182_();
        float targetYaw = target.m_146908_();
        Vec3 targetForward = Vec3.m_82498_((float)0.0f, (float)targetYaw);
        Vec3 toAttacker = attackerPos.m_82546_(targetPos).m_82541_();
        double crossY = targetForward.f_82479_ * toAttacker.f_82481_ - targetForward.f_82481_ * toAttacker.f_82479_;
        if (toAttacker.f_82479_ * targetForward.f_82479_ < 0.0 && toAttacker.f_82481_ * targetForward.f_82481_ < 0.0) {
            return crossY > 0.0;
        }
        return crossY < 0.0;
    }

    public static float yRotationFromDirection(Vec3 direction) {
        Vec3 normalized = direction.m_82541_();
        double x = normalized.f_82479_;
        double z = normalized.f_82481_;
        float yaw = (float)Math.atan2(-x, z);
        yaw = (float)Math.toDegrees(yaw);
        return ErsUtils.normalizeAngle(yaw);
    }

    public static float normalizeAngle(float angle) {
        if ((angle %= 360.0f) > 180.0f) {
            angle -= 360.0f;
        } else if (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }
}

